/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import unbbayes.controller.exception.InconsistentArgumentException;
import unbbayes.controller.exception.InvalidOperationException;
import unbbayes.controller.mebn.MEBNFactory;
import unbbayes.controller.mebn.MEBNFactoryImpl;
import unbbayes.gui.GraphAction;
import unbbayes.gui.MEBNEditionPane;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.WarningPanel;
import unbbayes.gui.mebn.OVariableEditionPane;
import unbbayes.gui.mebn.cpt.CPTFrame;
import unbbayes.io.exception.UBIOException;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.mebn.Argument;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.RandomVariableFinding;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.CategoricalStateEntity;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.ObjectEntityInstanceOrdereable;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.entity.TypeContainer;
import unbbayes.prs.mebn.entity.exception.CategoricalStateDoesNotExistException;
import unbbayes.prs.mebn.entity.exception.EntityInstanceAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.ObjectEntityHasInstancesException;
import unbbayes.prs.mebn.entity.exception.TypeAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeException;
import unbbayes.prs.mebn.exception.ArgumentNodeAlreadySetException;
import unbbayes.prs.mebn.exception.CycleFoundException;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.MEBNConstructionException;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.prs.mebn.exception.MFragDoesNotExistException;
import unbbayes.prs.mebn.exception.OVariableAlreadyExistsInArgumentList;
import unbbayes.prs.mebn.exception.ReservedWordException;
import unbbayes.prs.mebn.kb.KnowledgeBase;
import unbbayes.prs.mebn.kb.powerloom.PowerLoomKB;
import unbbayes.prs.mebn.ssbn.ExplosiveSSBNGenerator;
import unbbayes.prs.mebn.ssbn.Query;
import unbbayes.prs.mebn.ssbn.SSBNNode;
import unbbayes.prs.mebn.ssbn.SSBNWarning;
import unbbayes.prs.mebn.ssbn.SituationSpecificBayesianNetwork;
import unbbayes.prs.mebn.ssbn.exception.ImplementationRestrictionException;
import unbbayes.prs.mebn.ssbn.exception.OVInstanceFaultException;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;
import unbbayes.prs.mebn.ssbn.util.PositionAdjustmentUtils;
import unbbayes.util.Debug;
import unbbayes.util.ResourceController;

public class MEBNController {
    private KnowledgeBase knowledgeBase;
    private MEBNFactory mebnFactory;
    private NetworkWindow screen;
    private MEBNEditionPane mebnEditionPane;
    private MultiEntityBayesianNetwork multiEntityBayesianNetwork;
    private ProbabilisticNetwork specificSituationBayesianNetwork;
    private ResidentNode residentNodeActive;
    private InputNode inputNodeActive;
    private ContextNode contextNodeActive;
    private OrdinaryVariable ovNodeActive;
    private MFrag mFragActive;
    private TypeElementSelected typeElementSelected;
    private Node nodeActive;
    private JDialog warningDialog;
    private boolean showSSBNGraph = false;
    private Dimension dimensionSSBNGraph = new Dimension(1500, 1500);
    private boolean baseCreated = false;
    private boolean findingCreated = false;
    private boolean generativeCreated = false;
    private HashMap<ResidentNode, CPTFrame> mapCpt = new HashMap();
    private boolean saveDebugFiles = true;
    private static final String NAME_GENERATIVE_FILE = "generative.plm";
    private static final String NAME_FINDING_FILE = "findings.plm";
    private static ResourceBundle resource = ResourceController.RS_CONTROLLER;
    private NumberFormat df;
    private SituationSpecificBayesianNetwork ssbn = null;
    private static ResourceBundle resourcePN = ResourceBundle.getBundle("unbbayes.controller.resources.ControllerResources");

    public MEBNController(MultiEntityBayesianNetwork multiEntityBayesianNetwork, NetworkWindow screen) {
        this.multiEntityBayesianNetwork = multiEntityBayesianNetwork;
        this.screen = screen;
        this.mebnEditionPane = new MEBNEditionPane(screen, this);
        this.mebnFactory = new MEBNFactoryImpl();
        this.df = NumberFormat.getInstance(Locale.getDefault());
        this.df.setMaximumFractionDigits(4);
        this.enableMTheoryEdition();
    }

    public void openPanel(ResidentNode node) {
        this.setCurrentMFrag(node.getMFrag());
        this.selectNode(node);
        this.setResidentNodeActive(node);
        this.screen.getGraphPane().selectObject(node);
    }

    public void setResetButtonActive() {
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnResetCursor();
        }
    }

    public ResidentNode getResidentNodeActive() {
        return this.residentNodeActive;
    }

    public InputNode getInputNodeActive() {
        return this.inputNodeActive;
    }

    public ContextNode getContextNodeActive() {
        return this.contextNodeActive;
    }

    public Node getNodeActive() {
        return this.nodeActive;
    }

    public void enableMTheoryEdition() {
        this.mebnEditionPane.setMTheoryBarActive();
        this.mebnEditionPane.setNameMTheory(this.multiEntityBayesianNetwork.getName());
        this.mebnEditionPane.setMTheoryTreeActive();
        this.typeElementSelected = TypeElementSelected.MTHEORY;
        this.mebnEditionPane.setDescriptionText(this.multiEntityBayesianNetwork.getDescription(), 6);
    }

    public void renameMTheory(String name) throws DuplicatedNameException, ReservedWordException {
        this.checkName(name);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(this.multiEntityBayesianNetwork.getName());
        this.multiEntityBayesianNetwork.setName(name);
        this.mebnEditionPane.setNameMTheory(name);
        this.mebnEditionPane.getMTheoryTree().renameMTheory(name);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
    }

    private void checkName(String name) throws DuplicatedNameException, ReservedWordException {
        if (this.multiEntityBayesianNetwork.getNamesUsed().contains(name)) {
            throw new DuplicatedNameException(name);
        }
        if (this.mebnFactory.getReservedWords().contains(name)) {
            throw new ReservedWordException(name);
        }
    }

    public void setDescriptionTextForSelectedObject(String text) {
        this.saveDescriptionTextOfPreviousElement(text);
    }

    public void insertEdge(Edge edge) throws MEBNConstructionException, CycleFoundException, Exception {
        MFrag mFragCurrent = this.multiEntityBayesianNetwork.getCurrentMFrag();
        mFragCurrent.addEdge(edge);
    }

    public void insertDomainMFrag() {
        String name = null;
        int domainMFragNum = this.multiEntityBayesianNetwork.getDomainMFragNum();
        while (name == null) {
            name = String.valueOf(resource.getString("domainMFragName")) + this.multiEntityBayesianNetwork.getDomainMFragNum();
            if (!this.multiEntityBayesianNetwork.getNamesUsed().contains(name)) continue;
            name = null;
            this.multiEntityBayesianNetwork.setDomainMFragNum(++domainMFragNum);
        }
        MFrag mFrag = new MFrag(name, this.multiEntityBayesianNetwork);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        this.multiEntityBayesianNetwork.addDomainMFrag(mFrag);
        this.mebnEditionPane.getMTheoryTree().addMFrag(mFrag);
        this.showGraphMFrag(mFrag);
        this.mebnEditionPane.setMFragBarActive();
        this.mebnEditionPane.setTxtNameMFrag(mFrag.getName());
        this.mebnEditionPane.setMTheoryTreeActive();
        this.typeElementSelected = TypeElementSelected.MFRAG;
        this.mebnEditionPane.setDescriptionText(mFrag.getDescription(), 5);
    }

    public void removeDomainMFrag(MFrag domainMFrag) {
        this.multiEntityBayesianNetwork.removeDomainMFrag(domainMFrag);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(domainMFrag.getName());
        this.mebnEditionPane.getMTheoryTree().removeMFrag(domainMFrag);
        if (this.mFragActive != domainMFrag) {
            this.multiEntityBayesianNetwork.setCurrentMFrag(this.mFragActive);
        } else if (this.multiEntityBayesianNetwork.getDomainMFragList().size() != 0) {
            this.mFragActive = this.multiEntityBayesianNetwork.getDomainMFragList().get(0);
            this.showGraphMFrag(this.mFragActive);
        } else {
            this.showGraphMFrag();
        }
    }

    public void setCurrentMFrag(MFrag mFrag) {
        this.showGraphMFrag(mFrag);
        this.mebnEditionPane.setMFragBarActive();
        this.mebnEditionPane.setTxtNameMFrag(mFrag.getName());
        this.mebnEditionPane.setMTheoryTreeActive();
        this.mebnEditionPane.showTitleGraph(mFrag.getName());
        this.typeElementSelected = TypeElementSelected.MFRAG;
        this.mebnEditionPane.setDescriptionText(mFrag.getDescription(), 5);
        this.setActionGraphNone();
    }

    private void showGraphMFrag(MFrag mFrag) {
        this.multiEntityBayesianNetwork.setCurrentMFrag(mFrag);
        this.screen.getGraphPane().resetGraph();
        this.mebnEditionPane.showTitleGraph(mFrag.getName());
        this.mFragActive = mFrag;
    }

    private void showGraphMFrag() {
        this.multiEntityBayesianNetwork.setCurrentMFrag(null);
        this.screen.getGraphPane().showEmptyGraph();
        this.mebnEditionPane.hideTopComponent();
        this.mebnEditionPane.setEmptyBarActive();
        this.mFragActive = null;
    }

    public void renameMFrag(MFrag mFrag, String name) throws DuplicatedNameException, ReservedWordException {
        this.checkName(name);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(mFrag.getName());
        mFrag.setName(name);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        if (this.getCurrentMFrag() == mFrag) {
            this.mebnEditionPane.showTitleGraph(name);
        }
        this.mebnEditionPane.getMTheoryTree().renameMFrag(mFrag);
    }

    public MFrag getCurrentMFrag() {
        return this.multiEntityBayesianNetwork.getCurrentMFrag();
    }

    public ResidentNode insertDomainResidentNode(double x, double y) throws MFragDoesNotExistException {
        MFrag currentMFrag = this.multiEntityBayesianNetwork.getCurrentMFrag();
        if (currentMFrag == null) {
            throw new MFragDoesNotExistException();
        }
        MFrag domainMFrag = currentMFrag;
        String name = null;
        int residentNodeNum = domainMFrag.getDomainResidentNodeNum();
        while (name == null) {
            name = String.valueOf(resource.getString("residentNodeName")) + this.multiEntityBayesianNetwork.getDomainResidentNodeNum();
            if (!this.multiEntityBayesianNetwork.getNamesUsed().contains(name)) continue;
            name = null;
            this.multiEntityBayesianNetwork.plusDomainResidentNodeNum();
        }
        ResidentNode node = new ResidentNode(name, domainMFrag);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        node.setPosition(x, y);
        node.setDescription(node.getName());
        domainMFrag.addResidentNode(node);
        this.typeElementSelected = TypeElementSelected.NODE;
        this.residentNodeActive = node;
        this.nodeActive = node;
        this.mebnEditionPane.setEditArgumentsTabActive(node);
        this.mebnEditionPane.setResidentNodeTabActive(node);
        this.mebnEditionPane.setArgumentTabActive();
        this.mebnEditionPane.setResidentBarActive();
        this.mebnEditionPane.setTxtNameResident(node.getName());
        this.mebnEditionPane.setDescriptionText(node.getDescription(), 1);
        this.mebnEditionPane.getMTheoryTree().addNode(domainMFrag, node);
        return node;
    }

    public void renameDomainResidentNode(ResidentNode resident, String newName) throws DuplicatedNameException, ReservedWordException {
        this.checkName(newName);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(resident.getName());
        resident.setName(newName);
        this.multiEntityBayesianNetwork.getNamesUsed().add(newName);
        this.mebnEditionPane.repaint();
    }

    public StateLink addPossibleValue(ResidentNode resident, String nameValue) throws DuplicatedNameException, ReservedWordException {
        this.checkName(nameValue);
        CategoricalStateEntity value = this.multiEntityBayesianNetwork.getCategoricalStatesEntityContainer().createCategoricalEntity(nameValue);
        this.multiEntityBayesianNetwork.getNamesUsed().add(nameValue);
        StateLink link = resident.addPossibleValueLink(value);
        value.addNodeToListIsPossibleValueOf(resident);
        return link;
    }

    public StateLink addPossibleValue(ResidentNode resident, CategoricalStateEntity state) {
        StateLink link = null;
        if (!resident.hasPossibleValue(state)) {
            link = resident.addPossibleValueLink(state);
            state.addNodeToListIsPossibleValueOf(resident);
        }
        return link;
    }

    public StateLink addObjectEntityAsPossibleValue(ResidentNode resident, ObjectEntity state) {
        StateLink stateLink = null;
        if (!resident.hasPossibleValue(state)) {
            stateLink = resident.addPossibleValueLink(state);
            state.addNodeToListIsPossibleValueOf(resident);
        }
        return stateLink;
    }

    public boolean existPossibleValue(String name) {
        try {
            this.multiEntityBayesianNetwork.getCategoricalStatesEntityContainer().getCategoricalState(name);
            return true;
        }
        catch (CategoricalStateDoesNotExistException e) {
            return false;
        }
    }

    public void setGloballyExclusiveProperty(StateLink state, boolean value) {
        state.setGloballyExclusive(value);
    }

    public void addBooleanAsPossibleValue(ResidentNode resident) {
        resident.addPossibleValueLink(this.multiEntityBayesianNetwork.getBooleanStatesEntityContainer().getTrueStateEntity());
        resident.addPossibleValueLink(this.multiEntityBayesianNetwork.getBooleanStatesEntityContainer().getFalseStateEntity());
        resident.addPossibleValueLink(this.multiEntityBayesianNetwork.getBooleanStatesEntityContainer().getAbsurdStateEntity());
    }

    public void removePossibleValue(ResidentNode resident, String nameValue) {
        resident.removePossibleValueByName(nameValue);
    }

    public void removeAllPossibleValues(ResidentNode resident) {
        resident.removeAllPossibleValues();
    }

    public boolean existsPossibleValue(ResidentNode resident, String nameValue) {
        return resident.existsPossibleValueByName(nameValue);
    }

    public void setEnableTableEditionView() {
        this.mebnEditionPane.showTableEditionPane(this.getResidentNodeActive());
    }

    public void setUnableTableEditionView() {
        this.mebnEditionPane.hideTopComponent();
    }

    public InputNode insertGenerativeInputNode(double x, double y) throws MFragDoesNotExistException {
        MFrag currentMFrag = this.multiEntityBayesianNetwork.getCurrentMFrag();
        if (currentMFrag == null) {
            throw new MFragDoesNotExistException();
        }
        MFrag domainMFrag = currentMFrag;
        String name = null;
        while (name == null) {
            name = String.valueOf(resource.getString("inputNodeName")) + this.multiEntityBayesianNetwork.getGenerativeInputNodeNum();
            if (!this.multiEntityBayesianNetwork.getNamesUsed().contains(name)) continue;
            name = null;
            this.multiEntityBayesianNetwork.plusGenerativeInputNodeNum();
        }
        InputNode node = new InputNode(name, domainMFrag);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        node.setPosition(x, y);
        node.setDescription(node.getName());
        domainMFrag.addInputNode(node);
        this.inputNodeActive = node;
        this.nodeActive = node;
        this.mebnEditionPane.setInputBarActive();
        this.mebnEditionPane.setTxtNameInput(node.getName());
        this.mebnEditionPane.setInputNodeActive(node);
        this.mebnEditionPane.setTxtInputOf("");
        this.mebnEditionPane.getMTheoryTree().addNode(domainMFrag, node);
        this.mebnEditionPane.setDescriptionText(node.getDescription(), 2);
        this.typeElementSelected = TypeElementSelected.NODE;
        return node;
    }

    public void setInputInstanceOf(InputNode input, ResidentNode resident) throws CycleFoundException {
        input.setInputInstanceOf(resident);
        this.mebnEditionPane.getInputNodePane().updateArgumentPane();
        this.mebnEditionPane.setTxtInputOf(resident.getName());
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
    }

    public void updateArgumentsOfObject(Object node) {
        if (node instanceof InputNode) {
            ((InputNode)node).updateLabel();
        } else if (node instanceof ContextNode) {
            ((ContextNode)node).updateLabel();
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
    }

    public void updateInputInstanceOf(InputNode input) {
        Object target = input.getInputInstanceOf();
        if (target == null) {
            this.mebnEditionPane.setTxtInputOf("");
        } else if (target instanceof ResidentNode) {
            this.mebnEditionPane.setTxtInputOf(((ResidentNode)target).getName());
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
    }

    public ContextNode insertContextNode(double x, double y) throws MFragDoesNotExistException {
        MFrag currentMFrag = this.multiEntityBayesianNetwork.getCurrentMFrag();
        if (currentMFrag == null) {
            throw new MFragDoesNotExistException(resource.getString("withoutMFrag"));
        }
        MFrag domainMFrag = currentMFrag;
        String name = null;
        while (name == null) {
            name = String.valueOf(resource.getString("contextNodeName")) + this.multiEntityBayesianNetwork.getContextNodeNum();
            if (!this.multiEntityBayesianNetwork.getNamesUsed().contains(name)) continue;
            name = null;
            this.multiEntityBayesianNetwork.plusContextNodeNul();
        }
        ContextNode node = new ContextNode(name, domainMFrag);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        node.setPosition(x, y);
        node.setDescription(node.getName());
        domainMFrag.addContextNode(node);
        this.typeElementSelected = TypeElementSelected.NODE;
        this.contextNodeActive = node;
        this.nodeActive = node;
        this.setContextNodeActive(node);
        this.mebnEditionPane.getMTheoryTree().addNode(domainMFrag, node);
        this.mebnEditionPane.setDescriptionText(node.getDescription(), 3);
        return node;
    }

    public void setActionGraphNone() {
        this.mebnEditionPane.getNetworkWindow().getGraphPane().setAction(GraphAction.NONE);
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnResetCursor();
        }
    }

    public void setActionGraphCreateEdge() {
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnAddEdge();
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().setAction(GraphAction.CREATE_EDGE);
    }

    public void setActionGraphCreateContextNode() {
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnAddContextNode();
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().setAction(GraphAction.CREATE_CONTEXT_NODE);
    }

    public void setActionGraphCreateInputNode() {
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnAddInputNode();
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().setAction(GraphAction.CREATE_INPUT_NODE);
    }

    public void setActionGraphCreateResidentNode() {
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnAddResidentNode();
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().setAction(GraphAction.CREATE_RESIDENT_NODE);
    }

    public void setActionGraphCreateOrdinaryVariableNode() {
        if (this.mebnEditionPane.getJtbEdition() != null) {
            this.mebnEditionPane.getJtbEdition().selectBtnAddOrdinaryVariable();
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().setAction(GraphAction.CREATE_ORDINARYVARIABLE_NODE);
    }

    public void deleteSelectedItem() {
        Object selected = this.mebnEditionPane.getNetworkWindow().getGraphPane().getSelected();
        if (selected != null) {
            this.deleteSelected(selected);
        }
    }

    public void deleteSelected(Object selected) {
        if (selected instanceof ContextNode) {
            ((ContextNode)selected).delete();
            this.multiEntityBayesianNetwork.getNamesUsed().remove(((ContextNode)selected).getName());
            this.mebnEditionPane.getMTheoryTree().removeNode((Node)selected);
            this.mebnEditionPane.setMTheoryTreeActive();
        } else if (selected instanceof ResidentNode) {
            ((ResidentNode)selected).delete();
            this.multiEntityBayesianNetwork.getNamesUsed().remove(((ResidentNode)selected).getName());
            this.mebnEditionPane.getMTheoryTree().removeNode((Node)selected);
            this.mebnEditionPane.setMTheoryTreeActive();
            this.setUnableTableEditionView();
        } else if (selected instanceof InputNode) {
            ((InputNode)selected).delete();
            this.multiEntityBayesianNetwork.getNamesUsed().remove(((InputNode)selected).getName());
            this.mebnEditionPane.getMTheoryTree().removeNode((Node)selected);
            this.mebnEditionPane.setMTheoryTreeActive();
        } else if (selected instanceof OrdinaryVariable) {
            ((OrdinaryVariable)selected).delete();
            this.multiEntityBayesianNetwork.getNamesUsed().remove(((OrdinaryVariable)selected).getName());
            this.screen.getGraphPane().update();
            this.mebnEditionPane.setMTheoryTreeActive();
        } else if (selected instanceof Edge) {
            MFrag mFragCurrent = this.multiEntityBayesianNetwork.getCurrentMFrag();
            mFragCurrent.removeEdge((Edge)selected);
        }
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
    }

    public void selectNode(Node node) {
        this.saveDescriptionTextOfPreviousElement(this.mebnEditionPane.getDescriptionText());
        this.typeElementSelected = TypeElementSelected.NODE;
        if (node instanceof ResidentNode) {
            this.residentNodeActive = (ResidentNode)node;
            this.setResidentNodeActive(this.residentNodeActive);
            this.mebnEditionPane.setDescriptionText(node.getDescription(), 1);
        } else if (node instanceof InputNode) {
            this.inputNodeActive = (InputNode)node;
            this.setInputNodeActive(this.inputNodeActive);
            this.mebnEditionPane.setDescriptionText(node.getDescription(), 2);
        } else if (node instanceof ContextNode) {
            this.contextNodeActive = (ContextNode)node;
            this.setContextNodeActive(this.contextNodeActive);
            this.mebnEditionPane.setDescriptionText(node.getDescription(), 3);
        } else if (node instanceof OrdinaryVariable) {
            this.ovNodeActive = (OrdinaryVariable)node;
            this.setOrdVariableNodeActive((OrdinaryVariable)node);
            this.mebnEditionPane.setDescriptionText(node.getDescription(), 4);
        }
        this.mebnEditionPane.showTitleGraph(this.multiEntityBayesianNetwork.getCurrentMFrag().getName());
    }

    private void saveDescriptionTextOfPreviousElement(String text) {
        if (this.typeElementSelected != null) {
            switch (this.typeElementSelected) {
                case MFRAG: {
                    this.mFragActive.setDescription(text);
                    break;
                }
                case MTHEORY: {
                    this.multiEntityBayesianNetwork.setDescription(text);
                    break;
                }
                case NODE: {
                    if (this.nodeActive == null) break;
                    this.nodeActive.setDescription(text);
                }
            }
        }
    }

    public void unselectNodes() {
        if (this.multiEntityBayesianNetwork.getCurrentMFrag() != null) {
            this.mebnEditionPane.setMFragBarActive();
            this.mebnEditionPane.setTxtNameMFrag(this.multiEntityBayesianNetwork.getCurrentMFrag().getName());
            this.mebnEditionPane.setMTheoryTreeActive();
        }
    }

    public void updateFormulaActiveContextNode() {
        String formula = this.contextNodeActive.updateLabel();
        this.mebnEditionPane.setFormula(formula);
    }

    private void setResidentNodeActive(ResidentNode residentNodeActive) {
        this.nodeActive = residentNodeActive;
        this.mebnEditionPane.setResidentBarActive();
        this.mebnEditionPane.setEditArgumentsTabActive(residentNodeActive);
        this.mebnEditionPane.setResidentNodeTabActive(residentNodeActive);
        this.mebnEditionPane.setTxtNameResident(residentNodeActive.getName());
        this.mebnEditionPane.setArgumentTabActive();
        if (this.mebnEditionPane.isTableEditionPaneShow()) {
            this.mebnEditionPane.showTableEditionPane(residentNodeActive);
        }
    }

    private void setInputNodeActive(InputNode inputNodeActive) {
        this.nodeActive = inputNodeActive;
        this.mebnEditionPane.setInputBarActive();
        this.mebnEditionPane.setTxtNameInput(inputNodeActive.getName());
        this.mebnEditionPane.setInputNodeActive(inputNodeActive);
        this.updateInputInstanceOf(inputNodeActive);
        this.setUnableTableEditionView();
    }

    private void setContextNodeActive(ContextNode contextNodeActive) {
        this.nodeActive = contextNodeActive;
        this.mebnEditionPane.setContextBarActive();
        this.mebnEditionPane.setFormulaEdtionActive(contextNodeActive);
        this.mebnEditionPane.setTxtNameContext(contextNodeActive.getName());
        this.setUnableTableEditionView();
    }

    private void setOrdVariableNodeActive(OrdinaryVariable ov) {
        this.nodeActive = ov;
        this.mebnEditionPane.setOrdVariableBarActive(ov);
        this.mebnEditionPane.setEditOVariableTabActive();
    }

    public OrdinaryVariable insertOrdinaryVariable(double x, double y) throws MFragDoesNotExistException {
        MFrag currentMFrag = this.multiEntityBayesianNetwork.getCurrentMFrag();
        if (currentMFrag == null) {
            throw new MFragDoesNotExistException();
        }
        MFrag domainMFrag = currentMFrag;
        String name = null;
        while (name == null) {
            name = String.valueOf(resource.getString("ordinaryVariableName")) + domainMFrag.getOrdinaryVariableNum();
            if (domainMFrag.getOrdinaryVariableByName(name) == null) continue;
            name = null;
            domainMFrag.plusOrdinaryVariableNum();
        }
        Type type = TypeContainer.getDefaultType();
        OrdinaryVariable ov = new OrdinaryVariable(name, type, domainMFrag);
        ov.setPosition(x, y);
        ov.setDescription(ov.getName());
        domainMFrag.addOrdinaryVariable(ov);
        this.ovNodeActive = ov;
        this.setOrdVariableNodeActive(ov);
        this.mebnEditionPane.setEditOVariableTabActive();
        this.mebnEditionPane.setDescriptionText(ov.getDescription(), 4);
        this.typeElementSelected = TypeElementSelected.NODE;
        this.mebnEditionPane.getEditOVariableTab().update();
        return ov;
    }

    public void renameOrdinaryVariable(OrdinaryVariable ov, String name) throws DuplicatedNameException, ReservedWordException {
        this.checkName(name);
        ov.setName(name);
        ov.updateLabel();
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
        this.mebnEditionPane.getEditOVariableTab().update();
    }

    public void setOrdinaryVariableType(OrdinaryVariable ov, Type type) {
        ov.setValueType(type);
        ov.updateLabel();
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
        this.mebnEditionPane.getEditOVariableTab().update();
    }

    public OrdinaryVariable addNewOrdinaryVariableInMFrag() {
        MFrag domainMFrag = this.multiEntityBayesianNetwork.getCurrentMFrag();
        String name = null;
        int ordinaryVariableNum = domainMFrag.getOrdinaryVariableNum();
        while (name == null) {
            name = String.valueOf(resource.getString("ordinaryVariableName")) + domainMFrag.getOrdinaryVariableNum();
            if (domainMFrag.getOrdinaryVariableByName(name) == null) continue;
            name = null;
            domainMFrag.plusOrdinaryVariableNum();
        }
        this.multiEntityBayesianNetwork.getTypeContainer();
        Type type = TypeContainer.getDefaultType();
        OrdinaryVariable ov = new OrdinaryVariable(name, type, domainMFrag);
        domainMFrag.addOrdinaryVariable(ov);
        this.mebnEditionPane.getEditOVariableTab().update();
        return ov;
    }

    public OrdinaryVariable addNewOrdinaryVariableInResident() throws OVariableAlreadyExistsInArgumentList, ArgumentNodeAlreadySetException {
        OrdinaryVariable ov = this.addNewOrdinaryVariableInMFrag();
        this.addOrdinaryVariableInResident(ov);
        return ov;
    }

    public void removeOrdinaryVariableOfMFrag(OrdinaryVariable ov) {
        MFrag currentMFrag = this.multiEntityBayesianNetwork.getCurrentMFrag();
        currentMFrag.removeOrdinaryVariable(ov);
    }

    public void addOrdinaryVariableInResident(OrdinaryVariable ordinaryVariable) throws ArgumentNodeAlreadySetException, OVariableAlreadyExistsInArgumentList {
        this.residentNodeActive.addArgument(ordinaryVariable, true);
        this.mebnEditionPane.getEditArgumentsTab().update();
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
    }

    public void removeOrdinaryVariableInResident(OrdinaryVariable ordinaryVariable) {
        ResidentNode resident = (ResidentNode)this.screen.getGraphPane().getSelected();
        resident.removeArgument(ordinaryVariable);
        ordinaryVariable.removeIsOVariableOfList(resident);
        this.mebnEditionPane.getEditArgumentsTab().update();
        this.mebnEditionPane.getNetworkWindow().getGraphPane().update();
    }

    public void setOVariableSelectedInResidentTree(OrdinaryVariable oVariableSelected) {
        this.mebnEditionPane.getEditArgumentsTab().setTxtName(oVariableSelected.getName());
        this.mebnEditionPane.getEditArgumentsTab().setTreeResidentActive();
    }

    public void setOVariableSelectedInMFragTree(OrdinaryVariable oVariableSelected) {
        this.mebnEditionPane.getEditArgumentsTab().setTxtName(oVariableSelected.getName());
        this.mebnEditionPane.getEditArgumentsTab().setTreeMFragActive();
    }

    @Deprecated
    public void renameOVariableOfResidentTree(String name) throws DuplicatedNameException, ReservedWordException {
        OrdinaryVariable ov = this.mebnEditionPane.getEditArgumentsTab().getResidentOVariableTree().getOVariableSelected();
        this.checkName(name);
        ov.setName(name);
        ov.updateLabel();
        this.mebnEditionPane.getEditArgumentsTab().setTxtName(ov.getName());
        this.mebnEditionPane.getEditArgumentsTab().update();
    }

    @Deprecated
    public void renameOVariableOfMFragTree(String name) throws DuplicatedNameException, ReservedWordException {
        OrdinaryVariable ov = this.mebnEditionPane.getEditArgumentsTab().getMFragOVariableTree().getOVariableSelected();
        this.checkName(name);
        ov.setName(name);
        ov.updateLabel();
        this.mebnEditionPane.getEditArgumentsTab().setTxtName(ov.getName());
        this.mebnEditionPane.getEditArgumentsTab().update();
    }

    @Deprecated
    public void renameOVariableInArgumentEditionPane(String name) throws DuplicatedNameException, ReservedWordException {
        if (this.mebnEditionPane.getEditArgumentsTab().isTreeResidentActive()) {
            this.renameOVariableOfResidentTree(name);
        } else {
            this.renameOVariableOfMFragTree(name);
        }
    }

    public void selectOVariableInEdit(OrdinaryVariable ov) {
        OVariableEditionPane editionPane = this.mebnEditionPane.getEditOVariableTab();
        editionPane.setNameOVariableSelected(ov.getName());
    }

    public ObjectEntity createObjectEntity() throws TypeException {
        String name = null;
        int entityNum = this.multiEntityBayesianNetwork.getObjectEntityContainer().getEntityNum();
        while (name == null) {
            name = String.valueOf(resource.getString("entityName")) + this.multiEntityBayesianNetwork.getObjectEntityContainer().getEntityNum();
            if (!this.multiEntityBayesianNetwork.getNamesUsed().contains(name)) continue;
            name = null;
            this.multiEntityBayesianNetwork.getObjectEntityContainer().setEntityNum(++entityNum);
        }
        ObjectEntity objectEntity = this.multiEntityBayesianNetwork.getObjectEntityContainer().createObjectEntity(name);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        this.mebnEditionPane.getToolBarOVariable().updateListOfTypes();
        return objectEntity;
    }

    public void renameObjectEntity(ObjectEntity entity, String name) throws TypeAlreadyExistsException, DuplicatedNameException, ReservedWordException {
        this.checkName(name);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(name);
        entity.setName(name);
        this.multiEntityBayesianNetwork.getNamesUsed().add(name);
        this.mebnEditionPane.getToolBarOVariable().updateListOfTypes();
    }

    public void removeObjectEntity(ObjectEntity entity) throws Exception {
        this.multiEntityBayesianNetwork.getObjectEntityContainer().removeEntity(entity);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(entity.getName());
        try {
            this.multiEntityBayesianNetwork.getTypeContainer().removeType(entity.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mebnEditionPane.getToolBarOVariable().updateListOfTypes();
    }

    public void setIsOrdereableObjectEntityProperty(ObjectEntity entity, boolean isOrdereable) throws ObjectEntityHasInstancesException {
        entity.setOrdereable(isOrdereable);
    }

    public void createEntityIntance(ObjectEntity entity, String nameInstance) throws EntityInstanceAlreadyExistsException, InvalidOperationException, DuplicatedNameException, ReservedWordException {
        if (entity.isOrdereable()) {
            throw new InvalidOperationException();
        }
        this.checkName(nameInstance);
        if (this.multiEntityBayesianNetwork.getObjectEntityContainer().getEntityInstanceByName(nameInstance) != null) {
            throw new EntityInstanceAlreadyExistsException();
        }
        try {
            ObjectEntityInstance instance = entity.addInstance(nameInstance);
            this.multiEntityBayesianNetwork.getObjectEntityContainer().addEntityInstance(instance);
            this.multiEntityBayesianNetwork.getNamesUsed().add(nameInstance);
        }
        catch (TypeException e1) {
            e1.printStackTrace();
        }
        catch (EntityInstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    public void createEntityIntanceOrdereable(ObjectEntity entity, String nameInstance, ObjectEntityInstanceOrdereable previous) throws EntityInstanceAlreadyExistsException, InvalidOperationException, DuplicatedNameException, ReservedWordException {
        if (!entity.isOrdereable()) {
            throw new InvalidOperationException();
        }
        this.checkName(nameInstance);
        if (this.multiEntityBayesianNetwork.getObjectEntityContainer().getEntityInstanceByName(nameInstance) != null) {
            throw new EntityInstanceAlreadyExistsException();
        }
        try {
            ObjectEntityInstanceOrdereable instance = (ObjectEntityInstanceOrdereable)entity.addInstance(nameInstance);
            instance.setPrev(previous);
            if (previous != null) {
                previous.setProc(instance);
            }
            this.multiEntityBayesianNetwork.getObjectEntityContainer().addEntityInstance(instance);
            this.multiEntityBayesianNetwork.getNamesUsed().add(nameInstance);
        }
        catch (TypeException e1) {
            e1.printStackTrace();
        }
        catch (EntityInstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    public void renameEntityIntance(ObjectEntityInstance entity, String newName) throws EntityInstanceAlreadyExistsException, DuplicatedNameException, ReservedWordException {
        this.checkName(newName);
        if (this.multiEntityBayesianNetwork.getObjectEntityContainer().getEntityInstanceByName(newName) != null) {
            throw new EntityInstanceAlreadyExistsException();
        }
        this.multiEntityBayesianNetwork.getNamesUsed().remove(entity.getName());
        entity.setName(newName);
        this.multiEntityBayesianNetwork.getNamesUsed().add(newName);
    }

    public void removeEntityInstance(ObjectEntityInstance entity) {
        this.multiEntityBayesianNetwork.getObjectEntityContainer().removeEntityInstance(entity);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(entity.getName());
    }

    public void removeEntityInstanceOrdereable(ObjectEntityInstanceOrdereable entity) {
        ObjectEntityInstanceOrdereable.removeEntityInstanceOrdereableReferences(entity);
        this.multiEntityBayesianNetwork.getObjectEntityContainer().removeEntityInstance(entity);
        this.multiEntityBayesianNetwork.getNamesUsed().remove(entity.getName());
    }

    public void upEntityInstance(ObjectEntityInstanceOrdereable entity) {
        ObjectEntityInstanceOrdereable.upEntityInstance(entity);
    }

    public void downEntityInstance(ObjectEntityInstanceOrdereable entity) {
        ObjectEntityInstanceOrdereable.downEntityInstance(entity);
    }

    public void createRandomVariableFinding(ResidentNode residentNode, ObjectEntityInstance[] arguments, Entity state) {
        RandomVariableFinding finding = new RandomVariableFinding(residentNode, arguments, state, this.multiEntityBayesianNetwork);
        residentNode.addRandomVariableFinding(finding);
    }

    public void saveCPT(ResidentNode residentNode, String cpt) {
        residentNode.setTableFunction(cpt);
    }

    public void openCPTDialog(ResidentNode residentNode) {
        CPTFrame cptEditionPane = this.mapCpt.get(residentNode);
        if (cptEditionPane == null) {
            cptEditionPane = new CPTFrame(this, residentNode);
            this.mapCpt.put(residentNode, cptEditionPane);
        } else {
            cptEditionPane.setVisible(true);
        }
    }

    public void closeCPTDialog(ResidentNode residentNode) {
        CPTFrame cptEditionPane = this.mapCpt.get(residentNode);
        if (cptEditionPane != null) {
            cptEditionPane.dispose();
            this.mapCpt.remove(residentNode);
        }
    }

    public CPTFrame getCPTDialog(ResidentNode residentNode) {
        return this.mapCpt.get(residentNode);
    }

    private KnowledgeBase getKnowledgeBase() {
        if (this.knowledgeBase == null) {
            this.mebnEditionPane.getGraphPanel().setCursor(new Cursor(3));
            this.knowledgeBase = PowerLoomKB.getNewInstanceKB();
            this.mebnEditionPane.getGraphPanel().setCursor(new Cursor(0));
        }
        return this.knowledgeBase;
    }

    private void loadGenerativeMEBNIntoKB() {
        KnowledgeBase knowledgeBase = this.getKnowledgeBase();
        for (ObjectEntity entity : this.multiEntityBayesianNetwork.getObjectEntityContainer().getListEntity()) {
            knowledgeBase.createEntityDefinition(entity);
        }
        for (MFrag mfrag : this.multiEntityBayesianNetwork.getDomainMFragList()) {
            for (ResidentNode resident : mfrag.getResidentNodeList()) {
                knowledgeBase.createRandomVariableDefinition(resident);
            }
        }
        if (this.saveDebugFiles) {
            this.saveGenerativeMTheory(new File(NAME_GENERATIVE_FILE));
        }
    }

    private void loadFindingsIntoKB() {
        KnowledgeBase knowledgeBase = this.getKnowledgeBase();
        for (ObjectEntityInstance instance : this.multiEntityBayesianNetwork.getObjectEntityContainer().getListEntityInstances()) {
            knowledgeBase.insertEntityInstance(instance);
        }
        for (MFrag mfrag : this.multiEntityBayesianNetwork.getDomainMFragList()) {
            for (ResidentNode residentNode : mfrag.getResidentNodeList()) {
                for (RandomVariableFinding finding : residentNode.getRandomVariableFindingList()) {
                    knowledgeBase.insertRandomVariableFinding(finding);
                }
            }
        }
        if (this.saveDebugFiles) {
            this.saveDefaultTemporaryFindingsFile();
        }
    }

    public void clearFindingsIntoGUI() {
        for (MFrag mfrag : this.multiEntityBayesianNetwork.getDomainMFragList()) {
            for (ResidentNode residentNode : mfrag.getResidentNodeList()) {
                residentNode.cleanRandomVariableFindingList();
            }
        }
    }

    public void clearKnowledgeBase() {
        this.getKnowledgeBase().clearKnowledgeBase();
    }

    public void saveGenerativeMTheory(File file) {
        this.getKnowledgeBase().saveGenerativeMTheory(this.getMultiEntityBayesianNetwork(), file);
    }

    public void saveFindingsFile(File file) {
        this.mebnEditionPane.setStatus(resource.getString("statusSavingKB"));
        this.screen.setCursor(new Cursor(3));
        this.createKnowledgeBase();
        this.getKnowledgeBase().saveFindings(this.getMultiEntityBayesianNetwork(), file);
        this.mebnEditionPane.setStatus(resource.getString("statusReady"));
        this.screen.setCursor(new Cursor(0));
    }

    private void saveDefaultTemporaryFindingsFile() {
        this.getKnowledgeBase().saveFindings(this.getMultiEntityBayesianNetwork(), new File(NAME_FINDING_FILE));
    }

    public void loadFindingsFile(File file) throws UBIOException, MEBNException {
        this.mebnEditionPane.setCursor(new Cursor(3));
        this.mebnEditionPane.setStatus(resource.getString("statusLoadingKB"));
        Exception lastException = null;
        this.createKnowledgeBase();
        this.getKnowledgeBase().loadModule(file, true);
        for (ResidentNode resident : this.multiEntityBayesianNetwork.getDomainResidentNodes()) {
            try {
                this.knowledgeBase.fillFindings(resident);
            }
            catch (Exception e) {
                e.printStackTrace();
                lastException = e;
            }
        }
        this.mebnEditionPane.setStatus(resource.getString("statusReady"));
        this.mebnEditionPane.setCursor(new Cursor(0));
        if (lastException != null) {
            throw new MEBNException(resourcePN.getString("loadHasError"));
        }
    }

    private void createKnowledgeBase() {
        this.getKnowledgeBase().clearKnowledgeBase();
        this.loadGenerativeMEBNIntoKB();
        this.loadFindingsIntoKB();
    }

    public ProbabilisticNetwork executeQuery(ResidentNode residentNode, ObjectEntityInstance[] arguments) throws InconsistentArgumentException, SSBNNodeGeneralException, ImplementationRestrictionException, MEBNException, OVInstanceFaultException, InvalidParentException {
        this.mebnEditionPane.setStatus(resource.getString("statusGeneratingSSBN"));
        this.screen.setCursor(new Cursor(3));
        ProbabilisticNetwork probabilisticNetwork = null;
        SSBNNode queryNode = SSBNNode.getInstance(null, residentNode);
        List<Argument> arglist = residentNode.getArgumentList();
        if (arglist.size() != arguments.length) {
            throw new InconsistentArgumentException();
        }
        int i = 1;
        while (i <= arguments.length) {
            try {
                for (Argument argument : arglist) {
                    if (argument.getArgNumber() != i) continue;
                    queryNode.addArgument(argument.getOVariable(), arguments[i - 1].getName());
                    break;
                }
            }
            catch (SSBNNodeGeneralException e) {
                this.mebnEditionPane.setStatus(resource.getString("statusReady"));
                this.screen.setCursor(new Cursor(0));
                throw new InconsistentArgumentException(e);
            }
            ++i;
        }
        this.createKnowledgeBase();
        Query query = new Query(this.getKnowledgeBase(), queryNode, this.multiEntityBayesianNetwork);
        ExplosiveSSBNGenerator ssbngenerator = new ExplosiveSSBNGenerator();
        this.ssbn = ssbngenerator.generateSSBN(query);
        probabilisticNetwork = this.ssbn.getPn();
        if (!query.getQueryNode().isFinding()) {
            this.showSSBNGraph = true;
            this.specificSituationBayesianNetwork = probabilisticNetwork;
            try {
                this.ssbn.compileAndInitializeSSBN();
                if (this.ssbn.getWarningList().size() > 0) {
                    this.openWarningDialog();
                }
                this.getMebnEditionPane().getNetworkWindow().changeToSSBNCompilationPane(this.specificSituationBayesianNetwork);
                Dimension sizeOfGraph = PositionAdjustmentUtils.adjustPositionProbabilisticNetwork(this.specificSituationBayesianNetwork);
                Dimension originalDimension = this.getMebnEditionPane().getNetworkWindow().getGraphPane().getGraphDimension();
                if (originalDimension.getHeight() < sizeOfGraph.getHeight() || originalDimension.getWidth() < sizeOfGraph.getWidth()) {
                    this.dimensionSSBNGraph = sizeOfGraph;
                    this.getMebnEditionPane().getNetworkWindow().getGraphPane().setGraphDimension(sizeOfGraph);
                    this.getMebnEditionPane().getNetworkWindow().getGraphPane().update();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.screen.setCursor(new Cursor(0));
                JOptionPane.showMessageDialog(this.getScreen(), e.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this.getScreen(), String.valueOf(query.getQueryNode().getName()) + " = " + query.getQueryNode().getValue());
        }
        this.mebnEditionPane.setStatus(resource.getString("statusReady"));
        this.screen.setCursor(new Cursor(0));
        return this.specificSituationBayesianNetwork;
    }

    public void openWarningDialog() {
        if (this.ssbn != null) {
            if (this.warningDialog != null) {
                this.warningDialog.setVisible(false);
                this.warningDialog.dispose();
            }
            List<SSBNWarning> listWarnings = this.ssbn.getWarningList();
            this.warningDialog = new JDialog();
            this.warningDialog.setTitle(resource.getString("ResultDialog"));
            WarningPanel warningPanel = new WarningPanel(this);
            warningPanel.setListWarningAndUpdateText(listWarnings);
            this.warningDialog.setContentPane(warningPanel);
            this.warningDialog.setMinimumSize(new Dimension(600, 400));
            this.warningDialog.setPreferredSize(new Dimension(600, 400));
            this.warningDialog.setMaximumSize(new Dimension(600, 400));
            this.warningDialog.pack();
            this.warningDialog.setLocationRelativeTo(this.getMebnEditionPane().getNetworkWindow());
            this.warningDialog.setVisible(true);
        }
    }

    public void closeWarningDialog() {
        if (this.warningDialog != null) {
            this.warningDialog.dispose();
            this.warningDialog = null;
        }
    }

    public boolean compileNetwork(ProbabilisticNetwork network) {
        long ini = System.currentTimeMillis();
        this.screen.setCursor(new Cursor(3));
        try {
            network.compile();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), resourcePN.getString("statusError"), 0);
            this.screen.setCursor(new Cursor(0));
            return false;
        }
        this.screen.setCursor(new Cursor(0));
        return true;
    }

    public void initialize() {
        try {
            this.ssbn.reinitializeSSBN();
            this.screen.getEvidenceTree().updateTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void propagate() {
        this.screen.setCursor(new Cursor(3));
        boolean temLikeliHood = false;
        try {
            this.specificSituationBayesianNetwork.updateEvidences();
            if (!temLikeliHood) {
                this.screen.setStatus(String.valueOf(resourcePN.getString("statusEvidenceProbabilistic")) + this.df.format((double)this.specificSituationBayesianNetwork.PET() * 100.0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.ssbn.reinitializeSSBN();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.screen, e.getMessage(), resourcePN.getString("statusError"), 0);
        }
        this.screen.getEvidenceTree().updateTree();
        this.screen.setCursor(new Cursor(0));
    }

    public boolean turnToSSBNMode() {
        if (this.specificSituationBayesianNetwork != null) {
            this.showSSBNGraph = true;
            this.getMebnEditionPane().getNetworkWindow().changeToSSBNCompilationPane(this.specificSituationBayesianNetwork);
            this.getMebnEditionPane().getNetworkWindow().getGraphPane().setGraphDimension(this.dimensionSSBNGraph);
            this.getMebnEditionPane().getNetworkWindow().getGraphPane().update();
            return true;
        }
        return false;
    }

    public MultiEntityBayesianNetwork getMultiEntityBayesianNetwork() {
        return this.multiEntityBayesianNetwork;
    }

    public void setMultiEntityBayesianNetwork(MultiEntityBayesianNetwork multiEntityBayesianNetwork) {
        this.multiEntityBayesianNetwork = multiEntityBayesianNetwork;
    }

    public MEBNEditionPane getMebnEditionPane() {
        return this.mebnEditionPane;
    }

    public void setMebnEditionPane(MEBNEditionPane mebnEditionPane) {
        this.mebnEditionPane = mebnEditionPane;
    }

    public NetworkWindow getScreen() {
        return this.screen;
    }

    public void setScreen(NetworkWindow screen) {
        this.screen = screen;
    }

    public ProbabilisticNetwork getSpecificSituationBayesianNetwork() {
        return this.specificSituationBayesianNetwork;
    }

    public void setSpecificSituationBayesianNetwork(ProbabilisticNetwork specificSituationBayesianNetwork) {
        this.specificSituationBayesianNetwork = specificSituationBayesianNetwork;
    }

    public boolean isShowSSBNGraph() {
        return this.showSSBNGraph;
    }

    public void setShowSSBNGraph(boolean showSSBNGraph) {
        this.showSSBNGraph = showSSBNGraph;
    }

    public void setEditionMode() {
        this.showSSBNGraph = false;
    }

    private void printArgumentsOfResidentNode(ResidentNode resident) {
        Debug.println("Resident: " + resident);
        for (Argument arg : resident.getArgumentList()) {
            Debug.println(" [" + arg.getArgNumber() + "]:" + arg.getOVariable());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeElementSelected {
        NODE,
        MFRAG,
        MTHEORY;

    }
}

