/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import unbbayes.controller.ProgressDialog;
import unbbayes.datamining.datamanipulation.ArffSaver;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Loader;
import unbbayes.datamining.datamanipulation.Saver;
import unbbayes.datamining.datamanipulation.TxtSaver;
import unbbayes.datamining.gui.datamanipulation.AttributeTypeChooserController;

public class FileController {
    private static FileController singleton;
    private JFileChooser fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private ResourceBundle resourceNaiveBayesian = ResourceBundle.getBundle("unbbayes.datamining.gui.naivebayes.resources.NaiveBayesResource");

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    protected FileController() {
    }

    public static FileController getInstance() {
        if (singleton == null) {
            singleton = new FileController();
        }
        return singleton;
    }

    public InstanceSet getInstanceSet(File file, Component component) throws Exception {
        AttributeTypeChooserController attributeTypeChooser = new AttributeTypeChooserController(file, component);
        Loader loader = attributeTypeChooser.getLoader();
        if (loader == null) {
            return null;
        }
        String fileName = file.getName();
        ProgressDialog progressDialog = new ProgressDialog(fileName, loader);
        boolean successStatus = progressDialog.load();
        InstanceSet inst = loader.getInstanceSet();
        if (successStatus) {
            return inst;
        }
        return null;
    }

    public void saveInstanceSet(File output, InstanceSet instanceSet, int[] selectedAttributes) throws IOException {
        Saver saver;
        String fileName = output.getName();
        boolean compacted = instanceSet.counterIndex != -1;
        if (fileName.regionMatches(true, fileName.length() - 5, ".arff", 0, 5)) {
            saver = new ArffSaver(output, instanceSet, selectedAttributes, compacted);
        } else if (fileName.regionMatches(true, fileName.length() - 4, ".txt", 0, 4)) {
            saver = new TxtSaver(output, instanceSet, selectedAttributes, compacted);
        } else {
            throw new IOException(this.resourceNaiveBayesian.getString("fileExtensionException"));
        }
        ProgressDialog progressDialog = new ProgressDialog(output.getName(), saver);
        progressDialog.load();
    }
}

