/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem.incrementalLearning.controller;

import java.util.ArrayList;
import java.util.List;
import unbbayes.aprendizagem.incrementalLearning.util.ILToolkit;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;
import unbbayes.prs.bn.ProbabilisticNetwork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ILController
extends ILToolkit {
    private ProbabilisticNetwork pn;
    private List<Object> ssList = new ArrayList<Object>();
    private ArrayList<Node> variables;

    public ILController(ProbabilisticNetwork pn, List<Object> ssList, ArrayList<Node> variables) {
        this.pn = pn;
        this.ssList = ssList;
        this.variables = variables;
        this.chooseBetterNet();
    }

    public ArrayList<Node> getListaVariaveis() {
        ArrayList<Node> listaVariaveis = new ArrayList<Node>();
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            listaVariaveis.add(this.getTVariavel(this.pn.getNodeAt(i), true));
            ++i;
        }
        return listaVariaveis;
    }

    private void getFrontier() {
        this.ssList.removeAll(this.ssList);
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            Node node = this.pn.getNodeAt(i);
            this.makeNodeFrontier(node);
            ++i;
        }
    }

    private void makeNodeFrontier(Node node) {
        ArrayList<Object[]> lista = new ArrayList<Object[]>();
        this.makeNullFrontier(node, lista);
        this.makeAddFrontier(node, lista);
        this.makeRemoveFrontier(node, lista);
        this.ssList.add(lista);
    }

    private void makeNullFrontier(Node node, List<Object[]> lista) {
        Object[] frontier = new Object[]{node.getName(), this.makeAddParentsStructure(node, null), this.makeAddNijksStructure(node, null)};
        lista.add(frontier);
    }

    private void makeAddFrontier(Node node, List<Object[]> lista) {
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            if (!(node.getDescription().equals(this.pn.getNodeAt(i).getDescription()) || this.isParent(node, this.pn.getNodeAt(i)) || this.isDescendent(node, this.pn.getNodeAt(i)))) {
                Object[] frontier = new Object[]{node.getName(), this.makeAddParentsStructure(node, this.pn.getNodeAt(i)), this.makeAddNijksStructure(node, this.pn.getNodeAt(i))};
                lista.add(frontier);
            }
            ++i;
        }
    }

    private void makeRemoveFrontier(Node node, List<Object[]> lista) {
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            if (this.isParent(node, this.pn.getNodeAt(i))) {
                Object[] frontier = new Object[]{node.getName(), this.makeRemoveParentsStructure(node, this.pn.getNodeAt(i)), this.makeRemoveNijksStructure(node, this.pn.getNodeAt(i))};
                lista.add(frontier);
            }
            ++i;
        }
    }

    private List<String> makeRemoveParentsStructure(Node node, Node lastParent) {
        ArrayList<String> parentsName = new ArrayList<String>();
        int i = 0;
        while (i < node.getParents().size()) {
            String parentName = node.getParents().get(i).getDescription();
            if (!parentName.equals(lastParent.getDescription())) {
                parentsName.add(parentName);
            }
            ++i;
        }
        return parentsName;
    }

    private int[][] makeRemoveNijksStructure(Node node, Node lastParent) {
        LearningNode v = this.getTVariavel(node, true);
        ArrayList<Node> parents = v.getPais();
        int i = 0;
        while (i < parents.size()) {
            Node parent = node.getParents().get(i);
            if (parent.getDescription().equals(lastParent.getDescription())) {
                parents.remove(lastParent);
                break;
            }
            ++i;
        }
        int[][] nijk = this.getFrequencies(v, parents);
        parents.add(this.getTVariavel(lastParent, true));
        return nijk;
    }

    private List<String> makeAddParentsStructure(Node node, Node lastParent) {
        ArrayList<String> parentsName = new ArrayList<String>();
        int i = 0;
        while (i < node.getParents().size()) {
            String parentName = node.getParents().get(i).getDescription();
            parentsName.add(parentName);
            ++i;
        }
        if (lastParent != null) {
            parentsName.add(lastParent.getDescription());
        }
        return parentsName;
    }

    private int[][] makeAddNijksStructure(Node node, Node lastParent) {
        LearningNode v = this.getTVariavel(node, true);
        ArrayList<Node> parents = v.getPais();
        if (lastParent != null) {
            parents.add(this.getTVariavel(lastParent, true));
        }
        int[][] nijk = this.getFrequencies(v, parents);
        if (lastParent != null) {
            parents.remove(parents.size() - 1);
        }
        return nijk;
    }

    private LearningNode getTVariavel(Node node, boolean pais) {
        int i = 0;
        while (i < this.variables.size()) {
            LearningNode v = (LearningNode)this.variables.get(i);
            if (v.getName().equals(node.getName())) {
                ArrayList<Node> listaPais = node.getParents();
                ArrayList<Node> listaPaisAtual = new ArrayList<Node>();
                int j = 0;
                while (j < node.getParents().size() && pais) {
                    listaPaisAtual.add(this.getTVariavel(node.getParents().get(j), false));
                    ++j;
                }
                if (listaPaisAtual.size() > 0) {
                    v.setParents(listaPaisAtual);
                }
                return v;
            }
            ++i;
        }
        return null;
    }

    private void chooseBetterNet() {
        this.findBestFrontier();
        this.getFrontier();
    }

    private void findBestFrontier() {
        float betterValue = Float.MIN_VALUE;
        Object[] frontierObject = null;
        Object[] betterFrontier = null;
        double g = -1.7976931348623157E308;
        int i = 0;
        while (i < this.ssList.size()) {
            List lista = (List)this.ssList.get(i);
            int j = 0;
            while (j < lista.size()) {
                frontierObject = (Object[])lista.get(j);
                Node node = this.getNode((String)frontierObject[0]);
                if (j == 0) {
                    if (this.isEquivalente(frontierObject, node)) {
                        System.out.println("Equivalente - > " + frontierObject[0]);
                        break;
                    }
                    System.out.println("N\u00e3o Equivalente - > " + frontierObject[0]);
                    g = this.g(this.getTVariavel(node, true), this.getParents(node, (ArrayList)frontierObject[1]), (int[][])frontierObject[2]);
                } else {
                    double gAux = this.g(this.getTVariavel(node, true), this.getParents(node, (ArrayList)frontierObject[1]), (int[][])frontierObject[2]);
                    if (gAux > g) {
                        betterFrontier = frontierObject;
                        g = gAux;
                    }
                }
                ++j;
            }
            this.makeBetterNetwork(betterFrontier);
            betterFrontier = null;
            ++i;
        }
    }

    private boolean isEquivalente(Object[] fronteira, Node node) {
        int[][] novo = this.getFrequencies(this.getTVariavel(node, true), this.getParents(node, (ArrayList)fronteira[1]));
        int[][] velho = (int[][])fronteira[2];
        int numeroCelulas = 0;
        double valorQuiQuadrado = 0.0;
        double numeroCasos = this.getTotalCases(novo);
        double fator = numeroCasos / (double)this.getTotalCases(velho);
        System.out.println("Numero de caso = " + numeroCasos);
        System.out.println("Numero de caso Antigo = " + this.getTotalCases(velho));
        System.out.println("N\u00f3 " + node.getName());
        double[] intervalosNovos = null;
        double[] intervalosAntigos = null;
        double maiorDiferenca = Double.MIN_VALUE;
        int i = 0;
        while (i < velho.length) {
            if (i == 0) {
                numeroCelulas = velho.length * velho[i].length;
                intervalosNovos = new double[numeroCelulas];
                intervalosAntigos = new double[numeroCelulas];
            }
            int j = 0;
            while (j < velho[i].length && velho[i][j] > 0) {
                int indice = i * velho[i].length + j;
                if (i >= novo.length) {
                    intervalosNovos[indice] = 0.0;
                    intervalosAntigos[indice] = (double)velho[i][j] * fator / numeroCasos;
                } else if (j >= novo[i].length) {
                    intervalosNovos[indice] = 0.0;
                    intervalosAntigos[indice] = (double)velho[i][j] * fator / numeroCasos;
                } else {
                    intervalosNovos[indice] = (double)novo[i][j] / numeroCasos;
                    intervalosAntigos[indice] = (double)velho[i][j] * fator / numeroCasos;
                }
                if (i != 0 || j != 0) {
                    int n = indice;
                    intervalosNovos[n] = intervalosNovos[n] + intervalosNovos[indice - 1];
                    int n2 = indice;
                    intervalosAntigos[n2] = intervalosAntigos[n2] + intervalosAntigos[indice - 1];
                }
                if (Math.abs(intervalosNovos[indice] - intervalosAntigos[indice]) > maiorDiferenca) {
                    maiorDiferenca = Math.abs(intervalosNovos[indice] - intervalosAntigos[indice]);
                }
                ++j;
            }
            ++i;
        }
        double tabela = 1.92 / Math.sqrt(numeroCasos);
        System.out.println("Numero de caso = " + numeroCasos);
        System.out.println("Valor da tabela = " + tabela);
        System.out.println("Valor da maior diferenca = " + maiorDiferenca);
        return maiorDiferenca < tabela;
    }

    private double calcularConfianca(double nivelConfianca, int grausLiberdade) {
        double confianca = 1.0 / (Math.pow(2.0, (double)grausLiberdade / 2.0) * this.fat(grausLiberdade / 2 - 1)) * Math.pow(nivelConfianca, grausLiberdade / 2 - 1) * Math.exp(-nivelConfianca / 2.0);
        return confianca;
    }

    private double fat(int n) {
        if (n <= 100) {
            return this.fatorial(n);
        }
        return this.stirling(n);
    }

    private double fatorial(int n) {
        double f = 1.0;
        int i = 1;
        while (i <= n) {
            f *= (double)i;
            ++i;
        }
        return f;
    }

    private double stirling(int n) {
        return Math.sqrt(Math.PI * 2 * (double)n) * Math.pow(n, n) * Math.exp(-n);
    }

    private ArrayList<Node> getParents(Node node, ArrayList parents) {
        ArrayList<Node> parentsAux = new ArrayList<Node>();
        LearningNode v = this.getTVariavel(node, true);
        int i = 0;
        while (i < parents.size()) {
            String parent = (String)parents.get(i);
            int j = 0;
            while (j < this.pn.getNodeCount()) {
                if (this.pn.getNodeAt(j).getName().equals(parent)) {
                    parentsAux.add(this.getTVariavel(this.pn.getNodeAt(j), true));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return parentsAux;
    }

    private Node getNode(String nodeName) {
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            if (this.pn.getNodeAt(i).getDescription().equals(nodeName)) {
                return this.pn.getNodeAt(i);
            }
            ++i;
        }
        return null;
    }

    private void makeBetterNetwork(Object[] betterNet) {
        if (betterNet != null) {
            System.out.println("Mudou Familia do N\u00f3 " + betterNet[0]);
            Node node = this.getNode((String)betterNet[0]);
            ArrayList<Node> parents = this.getParents(node, (ArrayList)betterNet[1]);
            node.getParents().removeAll(node.getParents());
            node.getParents().addAll(parents);
        }
    }

    private void hillClibing(Object[] frontierObject) {
        Node node = this.getNode((String)frontierObject[0]);
        Node pai = null;
        int[][] news = null;
        double g = this.g(this.getTVariavel(node, true), this.getParents(node, (ArrayList)frontierObject[1]), (int[][])frontierObject[2]);
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            Node nodeAux;
            if (!(this.pn.getNodeAt(i).getName().equals(node.getName()) || this.isParent(node, nodeAux = this.pn.getNodeAt(i)) || this.isDescendent(node, nodeAux))) {
                node.getParents().add(nodeAux);
                ((ArrayList)frontierObject[1]).add(nodeAux.getName());
                int[][] aux = this.factoreJ(frontierObject);
                double gAux = this.g(this.getTVariavel(node, true), this.getParents(node, (ArrayList)frontierObject[1]), aux);
                if (gAux > g) {
                    pai = nodeAux;
                    news = aux;
                    g = gAux;
                }
                node.getParents().remove(node.getParents().size() - 1);
                ((ArrayList)frontierObject[1]).remove(((ArrayList)frontierObject[1]).size() - 1);
            }
            ++i;
        }
        if (pai != null) {
            node.getParents().add(pai);
            ((ArrayList)frontierObject[1]).add(node.getName());
            frontierObject[2] = news;
        }
    }

    private boolean isDescendent(Node node, Node nodeTest) {
        ArrayList<Node> filhos = node.getChildren();
        int i = 0;
        while (i < filhos.size()) {
            if (filhos.get(i).getName().equalsIgnoreCase(nodeTest.getName()) || this.isDescendent(filhos.get(i), nodeTest)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int[][] factoreJ(Object[] frontierObject) {
        ArrayList parents = (ArrayList)frontierObject[1];
        int[][] matrix = (int[][])frontierObject[2];
        int[][] cloneMatrix = new int[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                cloneMatrix[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        Node node = this.getNode((String)parents.get(parents.size() - 1));
        int[][] old = new int[matrix.length][matrix[0].length * node.getStatesSize()];
        long jota = 0L;
        int i2 = 0;
        while (i2 < this.ssList.size()) {
            Object[] fronteira = (Object[])this.ssList.get(i2);
            long[] marginalVector = this.makeMarginal((int[][])fronteira[2]);
            if (fronteira[0].equals(parents.get(parents.size() - 1))) {
                long totalCases;
                long caseNumber = totalCases = this.getTotalCases((int[][])fronteira[2]);
                int j = 0;
                while ((long)j < totalCases) {
                    int estado;
                    double[] marginal = this.getMarginal(marginalVector, caseNumber);
                    int n = estado = this.getEstado(marginal);
                    marginalVector[n] = marginalVector[n] - 1L;
                    double[] distribution = this.makeDistribution(cloneMatrix, caseNumber);
                    int acumulado = this.getEstado(distribution);
                    jota = acumulado * node.getStatesSize() + estado;
                    int[] nArray = old[(int)jota / old[0].length];
                    int n2 = (int)jota % old[0].length;
                    nArray[n2] = nArray[n2] + 1;
                    int[] nArray2 = cloneMatrix[acumulado / cloneMatrix[0].length];
                    int n3 = acumulado % cloneMatrix[0].length;
                    nArray2[n3] = nArray2[n3] - 1;
                    --caseNumber;
                    ++j;
                }
                break;
            }
            ++i2;
        }
        return old;
    }

    private long[] makeMarginal(int[][] matrix) {
        long[] marginalVector = new long[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                int n = i;
                marginalVector[n] = marginalVector[n] + (long)matrix[i][j];
                ++j;
            }
            ++i;
        }
        return marginalVector;
    }

    private double[] makeDistribution(int[][] matrix, long totalCases) {
        if (matrix.length > 0) {
            int k = 0;
            double[] distribution = new double[matrix.length * matrix[0].length];
            int i = 0;
            while (i < matrix.length) {
                int j = 0;
                while (j < matrix[i].length) {
                    distribution[k] = (double)matrix[i][j] / (double)totalCases;
                    ++j;
                    ++k;
                }
                ++i;
            }
            return distribution;
        }
        return null;
    }

    private long getTotalCases(int[][] array) {
        long totalCases = 0L;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                totalCases += (long)array[i][j];
                ++j;
            }
            ++i;
        }
        return totalCases;
    }

    private double[] getMarginal(long[] array, long totalCases) {
        double[] marginais = new double[array.length];
        int i = 0;
        while (i < array.length) {
            marginais[i] = (double)array[i] / (double)totalCases;
            ++i;
        }
        return marginais;
    }

    private int getEstado(double[] coluna) {
        double numero = Math.random();
        double[][] faixa = this.criarFaixasIntervalo(coluna);
        int i = 0;
        while (i < faixa.length) {
            if (i == 0 ? numero <= faixa[i][1] || faixa[i][1] == 0.0 : numero <= faixa[i][1] && numero > faixa[i][0]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private double[][] criarFaixasIntervalo(double[] coluna) {
        double[][] faixa = new double[coluna.length][2];
        double atual = 0.0;
        int i = 0;
        while (i < coluna.length) {
            faixa[i][0] = atual;
            faixa[i][1] = coluna[i] + atual;
            atual = faixa[i][1];
            ++i;
        }
        return faixa;
    }

    private boolean isParent(Node node, Node nodeAux) {
        int numberParents = node.getParents().size();
        int i = 0;
        while (i < numberParents) {
            Node parentNode = node.getParents().get(i);
            if (parentNode.getDescription().equals(nodeAux.getDescription())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void paramRecalc() {
        int i = 0;
        while (i < this.pn.getNodeCount()) {
            LearningNode node = this.getTVariavel(this.pn.getNodeAt(i), true);
            int[][] news = this.getFrequencies(node, node.getPais());
            this.getProbability(news, node);
            ++i;
        }
    }
}

