/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.util.ArrayList;
import unbbayes.aprendizagem.CBLToolkit;
import unbbayes.aprendizagem.ConstructionController;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CL
extends CBLToolkit {
    public ArrayList<Node> variaveis;
    public int classe;
    public int caseNumber;
    public int raiz;
    protected int[][] dataBase;
    protected int[] vector;
    protected boolean compacted;
    protected double[][] matrizinfo;
    public int[] arvore;
    public int[] ramo;
    public int[] enderecos;
    public int[] melhorarvore;
    public double melhorinfo;
    protected int notestado;
    protected int posicao;
    protected int nvar;
    protected boolean houveciclo;
    public ConstructionController controller;

    public void preparar(ArrayList<Node> vetordevariaveis, int classei, int numerodecasos, int[] vetor, boolean comp, int[][] dados) {
        this.nvar = vetordevariaveis.size();
        this.ramo = new int[this.nvar];
        this.variaveis = new ArrayList();
        this.variaveis.ensureCapacity(this.nvar);
        int i = 0;
        while (i < this.nvar) {
            this.variaveis.add(vetordevariaveis.get(i));
            ++i;
        }
        this.classe = classei;
        this.caseNumber = numerodecasos;
        this.vector = vetor;
        this.dataBase = dados;
        this.compacted = comp;
        this.prepara_memoria();
        this.detecta_arvore();
        this.desenharede();
    }

    @Override
    public double log2(double numero) {
        return Math.log(numero) / Math.log(2.0);
    }

    @Override
    public double mutualInformation(LearningNode xi, LearningNode xk) {
        int nt = 0;
        int il = 0;
        int kl = 0;
        double im = 0.0;
        double pik = 0.0;
        int ri = xi.getEstadoTamanho();
        int rk = xk.getEstadoTamanho();
        int[][] nik = new int[ri][rk];
        int[] ni = new int[ri];
        int[] nk = new int[rk];
        int f = 0;
        int ic = 0;
        while (ic < this.caseNumber) {
            f = this.compacted ? this.vector[ic] : 1;
            il = this.dataBase[ic][xi.getPos()];
            kl = this.dataBase[ic][xk.getPos()];
            int[] nArray = nik[il];
            int n = kl;
            nArray[n] = nArray[n] + f;
            int n2 = il;
            ni[n2] = ni[n2] + f;
            int n3 = kl;
            nk[n3] = nk[n3] + f;
            nt += f;
            ++ic;
        }
        il = 0;
        while (il < ri) {
            double pi = (double)(1 + ni[il]) / ((double)ri + (double)nt);
            kl = 0;
            while (kl < rk) {
                double pk = (double)(1 + nk[kl]) / ((double)rk + (double)nt);
                pik = (double)(1 + nik[il][kl]) / ((double)(ri * rk) + (double)nt);
                im += pik * (this.log2(pik) - this.log2(pi) - this.log2(pk));
                ++kl;
            }
            ++il;
        }
        return im;
    }

    protected double conditionalMutualInformation(int v1, int v2, int classe) {
        int kl;
        int il;
        int ri = ((LearningNode)this.variaveis.get(v1)).getEstadoTamanho();
        int rk = ((LearningNode)this.variaveis.get(v2)).getEstadoTamanho();
        int rj = ((LearningNode)this.variaveis.get(classe)).getEstadoTamanho();
        double im = 0.0;
        int[] nj = new int[rj];
        int[][][] njik = new int[rj][ri][rk];
        int[][] nji = new int[rj][ri];
        int[][] njk = new int[rj][rk];
        double[][] pji = new double[rj][ri];
        double[][] pjk = new double[rj][rk];
        int j = 0;
        int nt = 0;
        int id = 0;
        while (id < this.caseNumber) {
            int f = this.compacted ? this.vector[id] : 1;
            il = this.dataBase[id][v1];
            kl = this.dataBase[id][v2];
            j = this.dataBase[id][classe];
            int[] nArray = njik[j][il];
            int n = kl;
            nArray[n] = nArray[n] + f;
            int[] nArray2 = nji[j];
            int n2 = il;
            nArray2[n2] = nArray2[n2] + f;
            int[] nArray3 = njk[j];
            int n3 = kl;
            nArray3[n3] = nArray3[n3] + f;
            int n4 = j;
            nj[n4] = nj[n4] + f;
            nt += f;
            ++id;
        }
        j = 0;
        while (j < rj) {
            il = 0;
            while (il < ri) {
                pji[j][il] = (double)(1 + nji[j][il]) / (double)(ri + nj[j]);
                ++il;
            }
            kl = 0;
            while (kl < rk) {
                pjk[j][kl] = (double)(1 + njk[j][kl]) / (double)(rk + nj[j]);
                ++kl;
            }
            il = 0;
            while (il < ri) {
                kl = 0;
                while (kl < rk) {
                    double pjik = (double)(1 + njik[j][il][kl]) / (double)(ri * rk * rj + nt);
                    double cpjik = (double)(1 + njik[j][il][kl]) / (double)(ri * rk + nj[j]);
                    im += pjik * (this.log2(cpjik) - this.log2(pji[j][il]) - this.log2(pjk[j][kl]));
                    ++kl;
                }
                ++il;
            }
            ++j;
        }
        nj = null;
        njk = null;
        nji = null;
        njik = null;
        pji = null;
        pjk = null;
        return im;
    }

    public void calculainformacoes() {
        int i = 0;
        while (i < this.nvar) {
            int j = 0;
            while (j < this.nvar) {
                if (i != j) {
                    this.matrizinfo[i][j] = this.conditionalMutualInformation(i, j, this.classe);
                }
                ++j;
            }
            ++i;
        }
    }

    public void calculaRaiz() {
        double maiorResultadoAtual = 0.0;
        double resultado = 0.0;
        int posicao = 0;
        int i = 0;
        while (i < this.nvar) {
            if (i != this.classe && (resultado = this.matrizinfo[this.classe][i]) > maiorResultadoAtual) {
                maiorResultadoAtual = resultado;
                posicao = i;
            }
            this.raiz = posicao;
            ++i;
        }
    }

    protected boolean proxima() {
        int l = 0;
        int k = 0;
        int i = 0;
        while (i < this.nvar - 3) {
            if (this.arvore[i] == this.nvar - 2) {
                ++l;
            }
            ++i;
        }
        i = 0;
        while (i < this.nvar - 3) {
            if (this.arvore[i] == this.nvar - 2 && k == 0) {
                this.arvore[i] = 0;
            } else if (this.arvore[i] != this.nvar - 2 && k == 0) {
                ++k;
                int n = i;
                this.arvore[n] = this.arvore[n] + 1;
            }
            ++i;
        }
        this.valida_arvore();
        return l != this.nvar - 3;
    }

    protected boolean valida_arvore() {
        this.houveciclo = true;
        int i = 0;
        while (i < this.nvar - 3) {
            this.posicao = 0;
            this.ramo[0] = i;
            this.houveciclo = this.houveciclo && this.valida_ramo(i);
            ++i;
        }
        return !this.houveciclo;
    }

    protected double infoatual() {
        double resultado = 0.0;
        int j = 0;
        int i = 0;
        while (i < this.nvar - 3) {
            try {
                resultado += this.matrizinfo[this.enderecos[this.arvore[i]]][this.enderecos[i]];
            }
            catch (ArrayIndexOutOfBoundsException ee) {
                --j;
                ++j;
            }
            ++i;
        }
        return resultado;
    }

    protected boolean valida_ramo(int no) {
        boolean fim = false;
        ++this.posicao;
        boolean naoteveciclo = true;
        try {
            this.ramo[this.posicao] = this.arvore[no];
            if (this.arvore[no] != this.nvar - 2) {
                int i = 0;
                while (i < this.posicao) {
                    int j = i + 1;
                    while (j < this.posicao) {
                        naoteveciclo = naoteveciclo && this.ramo[i] != this.ramo[j];
                        ++j;
                    }
                    ++i;
                }
            } else {
                fim = true;
            }
            if (!fim && naoteveciclo) {
                this.valida_ramo(this.arvore[no]);
            }
        }
        catch (Exception ee) {
            System.out.println("");
        }
        return naoteveciclo;
    }

    private void desenharede() {
        int i = 0;
        while (i < this.nvar) {
            this.variaveis.remove(i);
            ++i;
        }
        int aux = 0;
        int i2 = 0;
        while (i2 < this.nvar) {
            if (i2 != this.classe && i2 != this.raiz) {
                this.variaveis.add(this.enderecos[++aux], this.variaveis.get(this.enderecos[this.melhorarvore[aux]]));
                this.variaveis.add(this.enderecos[this.melhorarvore[aux]], this.variaveis.get(this.enderecos[aux]));
            }
            ++i2;
        }
    }

    private void detecta_arvore() {
        this.melhorinfo = 0.0;
        int i = 0;
        while (i < this.nvar - 2) {
            this.arvore[i] = 0;
            ++i;
        }
        while (this.proxima()) {
            double ii = this.infoatual();
            if (!(ii > this.melhorinfo)) continue;
            this.melhorinfo = ii;
            int d = 0;
            while (d < this.nvar - 2) {
                this.melhorarvore[d] = this.arvore[d];
                ++d;
            }
        }
        double ii = this.infoatual();
    }

    private void prepara_memoria() {
        int h = 0;
        this.enderecos = new int[this.nvar - 1];
        this.matrizinfo = new double[this.nvar][this.nvar];
        this.calculainformacoes();
        this.calculaRaiz();
        this.arvore = new int[this.nvar - 1];
        this.melhorarvore = new int[this.nvar - 1];
        this.melhorinfo = 0.0;
        int i = 0;
        while (i < this.nvar) {
            if (i == this.classe || i == this.raiz) {
                if (i == this.raiz) {
                    this.enderecos[this.nvar - 2] = i;
                }
            } else {
                this.enderecos[h] = i;
                ++h;
            }
            ++i;
        }
    }
}

