/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella.utilities;

import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.KvListIterator;
import edu.isi.stella.List;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.utilities.IncompatibleUnitsException;
import edu.isi.stella.utilities.Ratio;
import edu.isi.stella.utilities.Utilities;
import java.io.PrintStream;

public class Measure
extends StandardObject {
    public String baseUnit;
    public KeyValueList scale;
    public Ratio primeId;
    public String name;

    public static Measure lookupMeasure(String string) {
        return (Measure)Utilities.$NAME_TO_MEASURE_TABLE$.lookup(string);
    }

    public static Measure defineDimensionlessMeasure() {
        Measure measure = Measure.newMeasure();
        measure.name = "Dimensionless";
        measure.baseUnit = "";
        measure.primeId = Utilities.$RATIO_ONE$;
        Measure measure2 = measure;
        measure2.scale.insertAt((Stella_Object)StringWrapper.wrapString((String)""), (Stella_Object)FloatWrapper.wrapFloat((double)1.0));
        Utilities.$BASE_MEASURES$ = Utilities.$BASE_MEASURES$.memberP((Stella_Object)measure2) ? Utilities.$BASE_MEASURES$ : Stella_Object.cons((Stella_Object)measure2, (Cons)Utilities.$BASE_MEASURES$);
        measure2.setupIndices();
        return measure2;
    }

    public static Measure defineDerivedMeasure(String string, String string2, String string3) {
        double d = Double.NEGATIVE_INFINITY;
        Ratio ratio = null;
        Object object = new Object[1];
        d = Utilities.unitToScaleFactorAndId(string3, (Object[])object);
        ratio = (Ratio)((Object)object[0]);
        object = Measure.newMeasure();
        ((Measure)((Object)object)).name = string;
        ((Measure)((Object)object)).baseUnit = string2;
        ((Measure)((Object)object)).primeId = ratio;
        Object object2 = object;
        ((Measure)((Object)object2)).scale.insertAt((Stella_Object)StringWrapper.wrapString((String)string2), (Stella_Object)FloatWrapper.wrapFloat((double)d));
        ((Measure)((Object)object2)).setupIndices();
        return object2;
    }

    public static Measure defineBaseMeasure(String string, String string2) {
        int n = Utilities.nextPrimeId();
        Measure measure = Measure.newMeasure();
        measure.name = string;
        measure.baseUnit = string2;
        measure.primeId = Ratio.makeRatio(n, 1);
        Measure measure2 = measure;
        measure2.scale.insertAt((Stella_Object)StringWrapper.wrapString((String)string2), (Stella_Object)FloatWrapper.wrapFloat((double)1.0));
        Utilities.$PRIME_TO_BASE_MEASURE_TABLE$.insertAt(n, (Stella_Object)measure2);
        Utilities.$BASE_MEASURES$ = Utilities.$BASE_MEASURES$.memberP((Stella_Object)measure2) ? Utilities.$BASE_MEASURES$ : Stella_Object.cons((Stella_Object)measure2, (Cons)Utilities.$BASE_MEASURES$);
        measure2.setupIndices();
        return measure2;
    }

    public static Measure newMeasure() {
        Measure measure = null;
        measure = new Measure();
        measure.name = null;
        measure.primeId = null;
        measure.scale = KeyValueList.newKeyValueList();
        measure.baseUnit = null;
        return measure;
    }

    public List getUnits() {
        Measure measure = this;
        List list = List.newList();
        StringWrapper stringWrapper = null;
        FloatWrapper floatWrapper = null;
        KvListIterator kvListIterator = (KvListIterator)measure.scale.allocateIterator();
        Cons cons = null;
        while (kvListIterator.nextP()) {
            stringWrapper = (StringWrapper)kvListIterator.key;
            floatWrapper = (FloatWrapper)kvListIterator.value;
            if (cons == null) {
                cons = Stella_Object.cons((Stella_Object)stringWrapper, (Cons)Stella.NIL);
                if (list.theConsList == Stella.NIL) {
                    list.theConsList = cons;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)list.theConsList, (Cons)cons);
                continue;
            }
            cons = cons.rest = Stella_Object.cons((Stella_Object)stringWrapper, (Cons)Stella.NIL);
        }
        return list;
    }

    public void addUnit(String string, double d, String string2) {
        Measure measure = this;
        double d2 = Double.NEGATIVE_INFINITY;
        Ratio ratio = null;
        OutputStringStream outputStringStream = new Object[1];
        d2 = Utilities.unitToScaleFactorAndId(string2, (Object[])outputStringStream);
        ratio = (Ratio)((Object)outputStringStream[0]);
        if (!Stella_Object.eqlP((Stella_Object)ratio, (Stella_Object)measure.primeId)) {
            outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("Unit `" + string + "' has a definition `" + string2 + "' that is not compatible with Measure `" + measure.name + "'");
            throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
        }
        measure.scale.insertAt((Stella_Object)StringWrapper.wrapString((String)string), (Stella_Object)FloatWrapper.wrapFloat((double)(d * d2)));
        Utilities.$UNIT_TO_MEASURE_TABLE$.insertAt(string, (Stella_Object)measure);
    }

    public boolean baseMeasureP() {
        Measure measure = this;
        return Utilities.$BASE_MEASURES$.memberP((Stella_Object)measure);
    }

    public void setupIndices() {
        Measure measure = this;
        Utilities.$ALL_MEASURES$ = Utilities.$ALL_MEASURES$.memberP((Stella_Object)measure) ? Utilities.$ALL_MEASURES$ : Stella_Object.cons((Stella_Object)measure, (Cons)Utilities.$ALL_MEASURES$);
        Utilities.$PRIME_TO_MEASURE_TABLE$.insertAt((Stella_Object)measure.primeId, (Stella_Object)measure);
        Utilities.$NAME_TO_MEASURE_TABLE$.insertAt(measure.name, (Stella_Object)measure);
        Utilities.$UNIT_TO_MEASURE_TABLE$.insertAt(measure.baseUnit, (Stella_Object)measure);
    }

    public void printObject(PrintStream printStream) {
        Measure measure = this;
        printStream.print("<Measure " + measure.name + "(" + measure.baseUnit + ")>");
    }

    public static Stella_Object accessMeasureSlotValue(Measure measure, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Utilities.SYM_UTILITIES_BASE_UNIT) {
            if (bl) {
                measure.baseUnit = ((StringWrapper)object).wrapperValue;
            } else {
                object = StringWrapper.wrapString((String)measure.baseUnit);
            }
        } else if (symbol == Utilities.SYM_UTILITIES_SCALE) {
            if (bl) {
                measure.scale = (KeyValueList)object;
            } else {
                object = measure.scale;
            }
        } else if (symbol == Utilities.SYM_UTILITIES_PRIME_ID) {
            if (bl) {
                measure.primeId = (Ratio)((Object)object);
            } else {
                object = measure.primeId;
            }
        } else if (symbol == Utilities.SYM_STELLA_NAME) {
            if (bl) {
                measure.name = ((StringWrapper)object).wrapperValue;
            } else {
                object = StringWrapper.wrapString((String)measure.name);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        Measure measure = this;
        return Utilities.SGT_UTILITIES_MEASURE;
    }
}

