/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStream;
import edu.isi.stella.Stella;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;

public class TruthValue
extends LogicObject {
    public Keyword polarity;
    public Keyword strength;
    public double positiveScore;

    public static TruthValue newTruthValue() {
        TruthValue truthValue = null;
        truthValue = new TruthValue();
        truthValue.dependentPropositionsIndex = null;
        truthValue.dynamicSlots = KeyValueList.newKeyValueList();
        truthValue.surrogateValueInverse = null;
        truthValue.variableValueInverse = null;
        truthValue.homeContext = (Module)Stella.$MODULE$.get();
        truthValue.positiveScore = 0.0;
        truthValue.strength = null;
        truthValue.polarity = Logic.KWD_UNKNOWN;
        LogicObject.logLogicObject(truthValue);
        return truthValue;
    }

    public static void printTruthValue(TruthValue truthValue, OutputStream outputStream) {
        if (truthValue == Logic.TRUE_TRUTH_VALUE) {
            outputStream.nativeStream.print("TRUE");
        } else if (truthValue == Logic.FALSE_TRUTH_VALUE) {
            outputStream.nativeStream.print("FALSE");
        } else if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            outputStream.nativeStream.print("DEFAULT-TRUE");
        } else if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            outputStream.nativeStream.print("DEFAULT-FALSE");
        } else if (truthValue == Logic.UNKNOWN_TRUTH_VALUE) {
            outputStream.nativeStream.print("UNKNOWN");
        } else if (truthValue == Logic.INCONSISTENT_TRUTH_VALUE) {
            outputStream.nativeStream.print("INCONSISTENT");
        } else {
            outputStream.nativeStream.print("|i|" + truthValue.primaryType());
        }
    }

    public static boolean inconsistentTruthValueP(TruthValue truthValue) {
        return truthValue == Logic.INCONSISTENT_TRUTH_VALUE;
    }

    public static boolean unknownTruthValueP(TruthValue truthValue) {
        return truthValue == Logic.UNKNOWN_TRUTH_VALUE || truthValue == null;
    }

    public static boolean defaultTruthValueP(TruthValue truthValue) {
        return truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE;
    }

    public static boolean strictTruthValueP(TruthValue truthValue) {
        return truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.FALSE_TRUTH_VALUE;
    }

    public static boolean falseTruthValueP(TruthValue truthValue) {
        return truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE;
    }

    public static boolean trueTruthValueP(TruthValue truthValue) {
        return truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE;
    }

    public static TruthValue strengthenTruthValue(TruthValue truthValue, TruthValue truthValue2) {
        if (!(truthValue2 != Logic.TRUE_TRUTH_VALUE && truthValue2 != Logic.FALSE_TRUTH_VALUE || truthValue != Logic.DEFAULT_TRUE_TRUTH_VALUE && truthValue != Logic.DEFAULT_FALSE_TRUTH_VALUE)) {
            if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                return Logic.TRUE_TRUTH_VALUE;
            }
            if (truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                return Logic.FALSE_TRUTH_VALUE;
            }
        }
        return truthValue;
    }

    public static TruthValue weakenTruthValue(TruthValue truthValue, TruthValue truthValue2) {
        if (truthValue2 == Logic.UNKNOWN_TRUTH_VALUE || truthValue2 == null) {
            return Logic.UNKNOWN_TRUTH_VALUE;
        }
        if (truthValue2 == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue2 == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                return Logic.DEFAULT_TRUE_TRUTH_VALUE;
            }
            if (truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                return Logic.DEFAULT_FALSE_TRUTH_VALUE;
            }
        }
        return truthValue;
    }

    public static TruthValue invertTruthValue(TruthValue truthValue) {
        if (truthValue == Logic.TRUE_TRUTH_VALUE) {
            return Logic.FALSE_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            return Logic.DEFAULT_FALSE_TRUTH_VALUE;
        }
        if (truthValue == Logic.FALSE_TRUTH_VALUE) {
            return Logic.TRUE_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            return Logic.DEFAULT_TRUE_TRUTH_VALUE;
        }
        if (truthValue == Logic.INCONSISTENT_TRUTH_VALUE) {
            return Logic.INCONSISTENT_TRUTH_VALUE;
        }
        return Logic.UNKNOWN_TRUTH_VALUE;
    }

    public static TruthValue disjoinTruthValues(TruthValue truthValue, TruthValue truthValue2) {
        if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue2 == Logic.TRUE_TRUTH_VALUE) {
            return Logic.TRUE_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue2 == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            return Logic.DEFAULT_TRUE_TRUTH_VALUE;
        }
        if (truthValue == null || truthValue == Logic.UNKNOWN_TRUTH_VALUE || truthValue2 == null || truthValue2 == Logic.UNKNOWN_TRUTH_VALUE) {
            return Logic.UNKNOWN_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE || truthValue2 == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            return Logic.DEFAULT_FALSE_TRUTH_VALUE;
        }
        return Logic.FALSE_TRUTH_VALUE;
    }

    public static TruthValue conjoinTruthValues(TruthValue truthValue, TruthValue truthValue2) {
        if (truthValue == Logic.INCONSISTENT_TRUTH_VALUE || truthValue2 == Logic.INCONSISTENT_TRUTH_VALUE) {
            return Logic.INCONSISTENT_TRUTH_VALUE;
        }
        if (truthValue == Logic.FALSE_TRUTH_VALUE || truthValue2 == Logic.FALSE_TRUTH_VALUE) {
            return Logic.FALSE_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE && truthValue2 == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            return Logic.UNKNOWN_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE && truthValue2 == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            return Logic.UNKNOWN_TRUTH_VALUE;
        }
        if (truthValue == null || truthValue == Logic.UNKNOWN_TRUTH_VALUE || truthValue2 == null || truthValue2 == Logic.UNKNOWN_TRUTH_VALUE) {
            return Logic.UNKNOWN_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE || truthValue2 == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            return Logic.DEFAULT_FALSE_TRUTH_VALUE;
        }
        if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue2 == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            return Logic.DEFAULT_TRUE_TRUTH_VALUE;
        }
        return Logic.TRUE_TRUTH_VALUE;
    }

    public static Stella_Object accessTruthValueSlotValue(TruthValue truthValue, Symbol symbol, Stella_Object stella_Object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_POLARITY) {
            if (bl) {
                truthValue.polarity = (Keyword)stella_Object;
            } else {
                stella_Object = truthValue.polarity;
            }
        } else if (symbol == Logic.SYM_LOGIC_STRENGTH) {
            if (bl) {
                truthValue.strength = (Keyword)stella_Object;
            } else {
                stella_Object = truthValue.strength;
            }
        } else if (symbol == Logic.SYM_LOGIC_POSITIVE_SCORE) {
            if (bl) {
                truthValue.positiveScore = ((FloatWrapper)stella_Object).wrapperValue;
            } else {
                stella_Object = FloatWrapper.wrapFloat((double)truthValue.positiveScore);
            }
        } else if (bl) {
            KeyValueList.setDynamicSlotValue((KeyValueList)truthValue.dynamicSlots, (Symbol)symbol, (Stella_Object)stella_Object, null);
        } else {
            stella_Object = truthValue.dynamicSlots.lookup((Stella_Object)symbol);
        }
        return stella_Object;
    }

    public Surrogate primaryType() {
        TruthValue truthValue = this;
        return Logic.SGT_LOGIC_TRUTH_VALUE;
    }
}

