/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.AtomicGoalCache;
import edu.isi.powerloom.logic.CheckTypesRecord;
import edu.isi.powerloom.logic.Clash;
import edu.isi.powerloom.logic.ClashingPropositionsIterator;
import edu.isi.powerloom.logic.ClassificationCache;
import edu.isi.powerloom.logic.ClassificationSession;
import edu.isi.powerloom.logic.Description;
import edu.isi.powerloom.logic.DescriptionExtensionIterator;
import edu.isi.powerloom.logic.ForwardChainingIndex;
import edu.isi.powerloom.logic.ForwardGoalRecord;
import edu.isi.powerloom.logic.ForwardJustification;
import edu.isi.powerloom.logic.Justification;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.powerloom.logic.NamedDescription;
import edu.isi.powerloom.logic.NonPagingIndex;
import edu.isi.powerloom.logic.ObjectStore;
import edu.isi.powerloom.logic.ParsingError;
import edu.isi.powerloom.logic.PartialSupport;
import edu.isi.powerloom.logic.PatternRecord;
import edu.isi.powerloom.logic.PatternVariable;
import edu.isi.powerloom.logic.PropositionError;
import edu.isi.powerloom.logic.PropositionNeuralNetwork;
import edu.isi.powerloom.logic.QueryIterator;
import edu.isi.powerloom.logic.SequenceIndex;
import edu.isi.powerloom.logic.Skolem;
import edu.isi.powerloom.logic.SpecializingPropositionsIterator;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.BooleanVector;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Collection;
import edu.isi.stella.Cons;
import edu.isi.stella.Context;
import edu.isi.stella.ContextSensitiveObject;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.GeneralizedSymbol;
import edu.isi.stella.HashTable;
import edu.isi.stella.IntegerIntervalIterator;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.ListIterator;
import edu.isi.stella.LiteralWrapper;
import edu.isi.stella.MemoizationTable;
import edu.isi.stella.Module;
import edu.isi.stella.MruMemoizationTable;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.PropertyList;
import edu.isi.stella.Relation;
import edu.isi.stella.Slot;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StorageSlot;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Thing;
import edu.isi.stella.Vector;
import edu.isi.stella.World;
import edu.isi.stella.Wrapper;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;
import java.lang.reflect.Method;

public class Proposition
extends ContextSensitiveObject {
    public Keyword kind;
    public Stella_Object truthValue;
    public Vector arguments;
    public GeneralizedSymbol operator;
    public NonPagingIndex dependentPropositions;
    public KeyValueList dynamicSlots;

    public static Proposition newProposition() {
        Proposition proposition = null;
        proposition = new Proposition();
        proposition.dynamicSlots = KeyValueList.newKeyValueList();
        proposition.dependentPropositions = Logic.NIL_NON_PAGING_INDEX;
        proposition.operator = null;
        proposition.arguments = null;
        proposition.truthValue = null;
        proposition.kind = null;
        proposition.homeContext = (Module)Stella.$MODULE$.get();
        return proposition;
    }

    public void processDefinitionOptions(Stella_Object stella_Object) {
        Proposition proposition = this;
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        Logic.axiomsSetter((Stella_Object)proposition, null);
        Stella_Object stella_Object2 = null;
        Stella_Object stella_Object3 = null;
        Cons cons = Stella_Object.vetOptions((Stella_Object)stella_Object, null).thePlist;
        while (cons != Stella.NIL) {
            stella_Object2 = cons.value;
            stella_Object3 = cons.rest.value;
            if (!Stella_Object.runOptionHandlerP((Stella_Object)proposition, (Keyword)((Keyword)stella_Object2), (Stella_Object)stella_Object3)) {
                Logic.definitionKeywordAxiomsHandler((Stella_Object)proposition, Logic.objectName((Stella_Object)proposition), (Keyword)stella_Object2, stella_Object3);
            }
            cons = cons.rest.rest;
        }
    }

    public static void flushInferableDirectSubdescriptionsCache(Proposition proposition) {
        if ((ClassificationSession)((Object)Logic.$CLASSIFICATIONSESSION$.get()) == null) {
            return;
        }
        ClassificationCache classificationCache = Logic.getClassificationCache(proposition.arguments.theArray[1]);
        if (classificationCache != null) {
            classificationCache.inferableDirectSubdescriptions = null;
        }
    }

    public static boolean mapFunctionalValueP(Proposition proposition, KeyValueList keyValueList, List list) {
        Proposition proposition2 = Proposition.findSimilarProposition(proposition, keyValueList);
        if (proposition2 == null && proposition.kind == Logic.KWD_FUNCTION) {
            proposition2 = Proposition.inheritFunctionProposition(proposition, keyValueList);
        }
        if (proposition2 != null) {
            Stella_Object stella_Object = Logic.valueOf(proposition2.arguments.theArray[proposition2.arguments.length() - 1]);
            return Logic.mapAndEnqueueVariableP(proposition.arguments.theArray[proposition.arguments.length() - 1], stella_Object, keyValueList, list);
        }
        return true;
    }

    public static void collectStructuralFunctions(Proposition proposition, List list) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FUNCTION) {
            list.insert((Stella_Object)proposition);
        } else if (keyword == Logic.KWD_PREDICATE) {
            if (Proposition.singleValuedPredicateP(proposition)) {
                list.insert((Stella_Object)proposition);
            }
        } else if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.collectStructuralFunctions((Proposition)stella_Object, list);
            }
        } else if (keyword == Logic.KWD_EXISTS) {
            Proposition.collectStructuralFunctions((Proposition)proposition.arguments.theArray[0], list);
        }
    }

    public static Cons inheritAsTopLevelProposition(Proposition proposition, KeyValueList keyValueList) {
        int n;
        int n2;
        Vector vector;
        Object object;
        Keyword keyword;
        Cons cons = Stella.NIL;
        if (keyValueList == null) {
            keyValueList = KeyValueList.newKeyValueList();
        }
        if ((keyword = proposition.kind) == Logic.KWD_AND) {
            object = null;
            vector = proposition.arguments;
            n2 = vector.length();
            for (n = 0; n < n2; ++n) {
                object = vector.theArray[n];
                cons = Stella_Object.cons((Stella_Object)Proposition.inheritProposition((Proposition)((Object)object), keyValueList), (Cons)cons);
            }
        } else if (keyword == Logic.KWD_EXISTS) {
            object = null;
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            n2 = vector.length();
            for (n = 0; n < n2; ++n) {
                object = (PatternVariable)vector.theArray[n];
                PatternVariable.createSkolemForUnmappedVariable((PatternVariable)((Object)object), keyValueList);
            }
            cons = Stella_Object.cons((Stella_Object)Proposition.inheritProposition((Proposition)proposition.arguments.theArray[0], keyValueList), (Cons)cons);
        } else {
            cons = Stella_Object.cons((Stella_Object)Proposition.inheritProposition(proposition, keyValueList), (Cons)cons);
        }
        keyValueList.free();
        keyword = null;
        object = cons;
        while (object != Stella.NIL) {
            keyword = object.value;
            Proposition.normalizeTopLevelProposition((Proposition)keyword, null);
            object = object.rest;
        }
        return cons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proposition inheritProposition(Proposition proposition, KeyValueList keyValueList) {
        List list;
        Object object = proposition.kind;
        if (object == Logic.KWD_FORALL || object == Logic.KWD_EXISTS) {
            Object object2 = Logic.$EVALUATIONMODE$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
                Proposition proposition2 = Proposition.copyProposition(proposition, keyValueList);
                return proposition2;
            }
            finally {
                Logic.$EVALUATIONMODE$.set(object2);
            }
        }
        if (object == Logic.KWD_FUNCTION) {
            Stella_Object stella_Object = Logic.inheritPropositionArgument(proposition.arguments.theArray[proposition.arguments.length() - 1], proposition, keyValueList);
            Proposition proposition3 = null;
            if (stella_Object == null) {
                return null;
            }
            proposition3 = Proposition.findSimilarProposition(proposition, keyValueList);
            if (proposition3 == null) {
                proposition3 = Proposition.inheritFunctionProposition(proposition, keyValueList);
                proposition3 = Proposition.eradicateHoldsProposition(proposition3);
            }
            proposition3 = Stella_Object.eqlP((Stella_Object)proposition3.arguments.theArray[proposition3.arguments.length() - 1], (Stella_Object)stella_Object) ? Logic.TRUE_PROPOSITION : Skolem.inheritEquivalentProposition((Skolem)proposition3.arguments.theArray[proposition3.arguments.length() - 1], stella_Object);
            keyValueList.insertAt((Stella_Object)proposition, (Stella_Object)proposition3);
            return proposition3;
        }
        object = (Proposition)keyValueList.lookup((Stella_Object)proposition);
        if (object != null) {
            return object;
        }
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.variableTypeP()) && (list = keyValueList.lookup(proposition.arguments.theArray[0])) != null && !Logic.skolemP((Stella_Object)list)) {
            return Logic.TRUE_PROPOSITION;
        }
        if (object != null) {
            keyValueList.insertAt((Stella_Object)proposition, (Stella_Object)object);
            return object;
        }
        object = proposition.operator;
        list = List.newList();
        Proposition proposition4 = null;
        Stella_Object stella_Object = null;
        Stella_Object stella_Object2 = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        Cons cons = null;
        for (int i = 0; i < n; ++i) {
            stella_Object2 = vector.theArray[i];
            stella_Object = Logic.inheritPropositionArgument(stella_Object2, proposition, keyValueList);
            if (stella_Object == null) {
                return null;
            }
            if (cons == null) {
                cons = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                if (list.theConsList == Stella.NIL) {
                    list.theConsList = cons;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)list.theConsList, (Cons)cons);
                continue;
            }
            cons = cons.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
        }
        proposition4 = Logic.createProposition(Logic.SYM_LOGIC_CONSTANT, 0);
        proposition4.kind = proposition.kind;
        proposition4.operator = object;
        proposition4.arguments = Logic.copyListToArgumentsVector(list);
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.variableTypeP())) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition4.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, (Stella_Object)Stella.TRUE_WRAPPER, null);
        }
        proposition4 = Proposition.eradicateHoldsProposition(proposition4);
        keyValueList.insertAt((Stella_Object)proposition, (Stella_Object)proposition4);
        return proposition4;
    }

    public static Proposition eradicateHoldsProposition(Proposition proposition) {
        if (proposition.operator == Logic.SGT_PL_KERNEL_KB_HOLDS && !Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[0], (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
            Proposition.normalizePredicateProposition(proposition);
            Proposition proposition2 = Proposition.findSimilarProposition(proposition, null);
            if (proposition2 != null) {
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                int n2 = Integer.MIN_VALUE;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    stella_Object = vector.theArray[i];
                    n2 = n3++;
                    proposition2.arguments.theArray[n2] = stella_Object;
                }
                proposition.free();
                return proposition2;
            }
        }
        return proposition;
    }

    public static Proposition findSimilarProposition(Proposition proposition, KeyValueList keyValueList) {
        int n;
        if (proposition.kind == Logic.KWD_CONSTANT) {
            return null;
        }
        Keyword keyword = proposition.kind;
        GeneralizedSymbol generalizedSymbol = proposition.operator;
        Stella_Object stella_Object = null;
        SequenceIndex sequenceIndex = null;
        boolean bl = false;
        Object object = null;
        Vector vector = proposition.arguments;
        int n2 = vector.length();
        for (n = 0; n < n2; ++n) {
            object = vector.theArray[n];
            Stella_Object stella_Object2 = Logic.mappedValueOf(object, keyValueList, false);
            if (stella_Object2 == null || !Logic.instanceHasBacklinksP(stella_Object2)) continue;
            stella_Object = stella_Object2;
            break;
        }
        if (stella_Object == null && bl) {
            object = null;
            vector = proposition.arguments;
            n2 = vector.length();
            for (n = 0; n < n2; ++n) {
                object = vector.theArray[n];
            }
        }
        if (stella_Object == null) {
            return null;
        }
        if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType(stella_Object), (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
            object = (LogicObject)stella_Object;
            sequenceIndex = Logic.unfilteredDependentPropositions(object, (Surrogate)generalizedSymbol);
            if (keyword == Logic.KWD_FUNCTION) {
                vector = null;
                Object object2 = null;
                Iterator iterator = sequenceIndex.allocateIterator();
                while (iterator.nextP()) {
                    object2 = (Proposition)iterator.value;
                    boolean bl2 = false;
                    boolean bl3 = bl2 = object2.kind == keyword;
                    if (bl2) {
                        boolean bl4 = bl2 = object2.operator == generalizedSymbol;
                        if (bl2) {
                            boolean bl5 = true;
                            Stella_Object stella_Object3 = null;
                            Iterator iterator2 = proposition.arguments.butLast();
                            Stella_Object stella_Object4 = null;
                            Iterator iterator3 = object2.arguments.butLast();
                            while (iterator2.nextP() && iterator3.nextP()) {
                                stella_Object3 = iterator2.value;
                                stella_Object4 = iterator3.value;
                                if (Logic.equalUpToSkolemIdentityP(stella_Object3, stella_Object4, keyValueList)) continue;
                                bl5 = false;
                                break;
                            }
                            bl2 = bl5;
                        }
                    }
                    if (!bl2) continue;
                    vector = object2;
                    break;
                }
                object2 = vector;
                return object2;
            }
            vector = null;
            Object object3 = null;
            Iterator iterator = sequenceIndex.allocateIterator();
            while (iterator.nextP()) {
                object3 = (Proposition)iterator.value;
                boolean bl6 = false;
                boolean bl7 = bl6 = object3.kind == keyword;
                if (bl6) {
                    boolean bl8 = bl6 = object3.operator == generalizedSymbol;
                    if (bl6) {
                        boolean bl9 = true;
                        Stella_Object stella_Object5 = null;
                        Vector vector2 = proposition.arguments;
                        int n3 = 0;
                        int n4 = vector2.length();
                        Stella_Object stella_Object6 = null;
                        Vector vector3 = object3.arguments;
                        int n5 = vector3.length();
                        for (int i = 0; n3 < n4 && i < n5; ++n3, ++i) {
                            stella_Object5 = vector2.theArray[n3];
                            stella_Object6 = vector3.theArray[i];
                            if (Logic.equalUpToSkolemIdentityP(stella_Object5, stella_Object6, keyValueList)) continue;
                            bl9 = false;
                            break;
                        }
                        bl6 = bl9;
                    }
                }
                if (!bl6) continue;
                vector = object3;
                break;
            }
            object3 = vector;
            return object3;
        }
        return null;
    }

    public static Proposition inheritFunctionProposition(Proposition proposition, KeyValueList keyValueList) {
        Proposition proposition2 = null;
        Cons cons = Stella.NIL;
        int n = proposition.arguments.length() - 1;
        Stella_Object stella_Object = null;
        Stella_Object stella_Object2 = null;
        Vector vector = proposition.arguments;
        int n2 = 0;
        int n3 = vector.length();
        int n4 = Integer.MIN_VALUE;
        int n5 = 1;
        Cons cons2 = null;
        while (n2 < n3) {
            stella_Object2 = vector.theArray[n2];
            n4 = n5;
            if (n4 <= n) {
                stella_Object = Logic.mappedValueOf(stella_Object2, keyValueList, false);
                if (stella_Object == null) {
                    return null;
                }
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                    if (cons == Stella.NIL) {
                        cons = cons2;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                    }
                } else {
                    cons2 = cons2.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                }
            }
            ++n2;
            ++n5;
        }
        proposition2 = Logic.createFunctionProposition((GeneralizedSymbol)((Surrogate)proposition.operator), cons);
        return proposition2;
    }

    public static boolean binaryPropositionP(Proposition proposition) {
        return proposition.arguments.length() == 2;
    }

    public static boolean singleValuedPredicateP(Proposition proposition) {
        return proposition.kind == Logic.KWD_PREDICATE && Logic.singleValuedTermP((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)));
    }

    public static Proposition copyProposition(Proposition proposition, KeyValueList keyValueList) {
        Proposition proposition2 = (Proposition)keyValueList.lookup((Stella_Object)proposition);
        if (proposition2 != null) {
            return proposition2;
        }
        if (proposition.kind == Logic.KWD_CONSTANT) {
            return proposition;
        }
        proposition2 = Logic.createProposition(Logic.SYM_STELLA_PREDICATE, proposition.arguments.length());
        proposition2.homeContext = (Module)Stella.$MODULE$.get();
        proposition2.kind = proposition.kind;
        proposition2.operator = (GeneralizedSymbol)Logic.copyPropositionArgument((Stella_Object)proposition.operator, keyValueList);
        Proposition proposition3 = proposition2;
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        Stella_Object stella_Object = proposition3.truthValue;
        Stella_Object stella_Object2 = Stella_Object.updateInContext((Stella_Object)stella_Object, (Stella_Object)truthValue, (Context)proposition3.homeContext, (boolean)false);
        if (stella_Object == null || stella_Object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
            proposition3.truthValue = stella_Object2;
        }
        if (((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue != Double.NEGATIVE_INFINITY) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        }
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.variableTypeP())) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, (Stella_Object)Stella.TRUE_WRAPPER, null);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        if ((PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null) != null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, (Stella_Object)((PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null)).copy(), null);
            Proposition.finalizePropositionAnnotations(proposition2);
        }
        keyValueList.insertAt((Stella_Object)proposition, (Stella_Object)proposition2);
        proposition3 = proposition.kind;
        if (proposition3 == Logic.KWD_FORALL || proposition3 == Logic.KWD_EXISTS) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyVariablesVector((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null), keyValueList), null);
        }
        proposition3 = null;
        truthValue = proposition.arguments;
        int n = truthValue.length();
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            proposition3 = ((Vector)truthValue).theArray[i];
            n2 = n3++;
            proposition2.arguments.theArray[n2] = Logic.copyPropositionArgument((Stella_Object)proposition3, keyValueList);
        }
        return proposition2;
    }

    public static void simplifyProposition(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword != Logic.KWD_FORALL) {
            if (keyword == Logic.KWD_AND) {
                Proposition.simplifyConjunction(proposition);
            } else {
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    ContextSensitiveObject contextSensitiveObject;
                    stella_Object = vector.theArray[i];
                    Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
                    if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                        contextSensitiveObject = (Proposition)stella_Object;
                        Proposition.simplifyProposition((Proposition)contextSensitiveObject);
                        continue;
                    }
                    if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) continue;
                    contextSensitiveObject = (Description)stella_Object;
                    Description.simplifyDescription((Description)contextSensitiveObject, (Boolean)Logic.$POSTOPTIMIZATIONp$.get());
                }
            }
        }
    }

    public static void simplifyConjunction(Proposition proposition) {
        int n;
        List list = List.newList();
        Cons cons = null;
        int n2 = 0;
        Object object = null;
        Vector vector = proposition.arguments;
        int n3 = vector.length();
        for (n = 0; n < n3; ++n) {
            object = vector.theArray[n];
            list.push((Stella_Object)((Proposition)((Object)object)));
        }
        cons = list.theConsList;
        while (cons != Stella.NIL) {
            object = (Proposition)cons.value;
            vector = object.kind;
            if (vector == Logic.KWD_EQUIVALENT) {
                if (Stella_Object.eqlP((Stella_Object)object.arguments.theArray[0], (Stella_Object)object.arguments.theArray[1]) || Stella_Object.eqlP((Stella_Object)Logic.valueOf(object.arguments.theArray[0]), (Stella_Object)Logic.valueOf(object.arguments.theArray[1])) && Stella_Object.isaP((Stella_Object)object.arguments.theArray[0], (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE) && Stella_Object.isaP((Stella_Object)object.arguments.theArray[1], (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    Stella_Object stella_Object = null;
                    Vector vector2 = object.arguments;
                    int n4 = vector2.length();
                    for (int i = 0; i < n4; ++i) {
                        stella_Object = vector2.theArray[i];
                        Logic.removeDependentPropositionLink(stella_Object, (Proposition)((Object)object));
                    }
                    cons.value = Logic.TRUE_PROPOSITION;
                }
            } else if (vector == Logic.KWD_ISA) {
                Proposition proposition2 = null;
                Proposition proposition3 = null;
                Cons cons2 = list.theConsList;
                int n5 = Integer.MIN_VALUE;
                int n6 = 0;
                while (cons2 != Stella.NIL) {
                    proposition3 = (Proposition)cons2.value;
                    n5 = n6;
                    if (n5 != n2 && Proposition.conjunctCancelsIsaPropositionP((Proposition)((Object)object), proposition3)) {
                        proposition2 = proposition3;
                        break;
                    }
                    cons2 = cons2.rest;
                    ++n6;
                }
                proposition3 = proposition2;
                if ((Surrogate)object.operator == Logic.SGT_STELLA_THING || proposition3 != null) {
                    if (object != proposition3) {
                        cons2 = null;
                        Vector vector3 = object.arguments;
                        int n7 = vector3.length();
                        for (n6 = 0; n6 < n7; ++n6) {
                            cons2 = vector3.theArray[n6];
                            Logic.removeDependentPropositionLink((Stella_Object)cons2, (Proposition)((Object)object));
                        }
                    }
                    cons.value = Logic.TRUE_PROPOSITION;
                }
            } else if (vector == Logic.KWD_AND) {
                Proposition.simplifyConjunction((Proposition)cons.value);
            }
            cons = cons.rest;
            ++n2;
        }
        if (list.memberP((Stella_Object)Logic.TRUE_PROPOSITION)) {
            list.remove((Stella_Object)Logic.TRUE_PROPOSITION);
            list.reverse();
            switch (list.length()) {
                case 0: {
                    Proposition.overlayWithConstantProposition(proposition, Logic.TRUE_PROPOSITION);
                    break;
                }
                case 1: {
                    Proposition.overlayProposition(proposition, (Proposition)list.first());
                    object = null;
                    vector = proposition.arguments;
                    n3 = vector.length();
                    for (n = 0; n < n3; ++n) {
                        object = vector.theArray[n];
                        Logic.addDependentPropositionLink(object, proposition);
                    }
                    break;
                }
                default: {
                    proposition.arguments = Logic.copyListToArgumentsVector(list);
                }
            }
            list.free();
        }
    }

    public static boolean conjunctCancelsIsaPropositionP(Proposition proposition, Proposition proposition2) {
        Keyword keyword = proposition2.kind;
        if (keyword == Logic.KWD_ISA) {
            return Stella_Object.eqlP((Stella_Object)proposition2.arguments.theArray[0], (Stella_Object)proposition.arguments.theArray[0]) && ((Boolean)Logic.$POSTOPTIMIZATIONp$.get() != false ? Logic.relationrefSpecializesRelationrefP((Surrogate)proposition2.operator, (Surrogate)proposition.operator) : (Surrogate)proposition2.operator == (Surrogate)proposition.operator);
        }
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            boolean bl;
            Stella_Object stella_Object = proposition.arguments.theArray[0];
            Surrogate surrogate = (Surrogate)proposition.operator;
            boolean bl2 = false;
            bl2 = (Boolean)Logic.$POSTOPTIMIZATIONp$.get();
            if (bl2 && (bl2 = Stella_Object.typeP((Stella_Object)surrogate)) && (bl2 = Stella_Object.surrogateP((Stella_Object)((Surrogate)proposition2.operator)))) {
                bl = false;
                Stella_Object stella_Object2 = null;
                Vector vector = proposition2.arguments;
                int n = vector.length();
                Surrogate surrogate2 = null;
                Cons cons = Logic.getDescription((Stella_Object)((Surrogate)proposition2.operator)).ioVariableTypes.theConsList;
                for (int i = 0; i < n && cons != Stella.NIL; ++i) {
                    stella_Object2 = vector.theArray[i];
                    surrogate2 = (Surrogate)cons.value;
                    if (Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)stella_Object) && Logic.logicalSubtypeOfP(surrogate2, surrogate)) {
                        bl = true;
                        break;
                    }
                    cons = cons.rest;
                }
                bl2 = bl;
            }
            bl = bl2;
            return bl;
        }
        return false;
    }

    public static double dynamicallyEstimateUnboundVariablePenalty(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_NOT || keyword == Logic.KWD_FAIL) {
            return Proposition.dynamicallyEstimateUnboundVariablePenalty((Proposition)proposition.arguments.theArray[0]);
        }
        if (keyword == Logic.KWD_AND) {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                d = Proposition.dynamicallyEstimateUnboundVariablePenalty((Proposition)stella_Object);
                if (d2 != Double.NEGATIVE_INFINITY && !(d < d2)) continue;
                d2 = d;
            }
            return d2;
        }
        if (keyword == Logic.KWD_OR) {
            double d = 0.0;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                d += Proposition.dynamicallyEstimateUnboundVariablePenalty((Proposition)stella_Object);
            }
            return d;
        }
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_EQUIVALENT || keyword == Logic.KWD_ISA) {
            boolean bl;
            Vector vector = proposition.arguments;
            GeneralizedSymbol generalizedSymbol = proposition.operator;
            boolean bl2 = generalizedSymbol == Logic.SGT_PL_KERNEL_KB_HOLDS;
            boolean bl3 = proposition.kind == Logic.KWD_FUNCTION || bl2 && !Logic.unboundVariableP(vector.theArray[0]) && Logic.functionP(Logic.argumentBoundTo(vector.theArray[0]));
            int n = bl2 ? 1 : 0;
            int n2 = bl3 ? vector.length() - 2 : vector.length() - 1;
            int n3 = bl2 && Logic.unboundVariableP(vector.theArray[0]) ? 10 : 0;
            int n4 = Integer.MIN_VALUE;
            int n5 = n2;
            boolean bl4 = bl = n5 == Integer.MIN_VALUE;
            for (int i = n; bl || i <= n5; ++i) {
                n4 = i;
                if (!Logic.unboundVariableP(vector.theArray[n4])) continue;
                ++n3;
            }
            if (Proposition.computedPredicateP(proposition)) {
                switch (n3) {
                    case 0: {
                        return 0.0;
                    }
                    case 1: {
                        if (!Description.computedConstraintP(Logic.getDescription((Stella_Object)generalizedSymbol)) || bl3 && Logic.unboundVariableP(vector.theArray[n2 + 1])) break;
                        return 0.0;
                    }
                }
                return 10000.0;
            }
            return 1.0 + (double)n3 * ((double)n3 / (double)(n2 - n - -1));
        }
        return 3.0;
    }

    public static double dynamicallyEstimateInstanceOfGoalFanout(Proposition proposition) {
        Stella_Object stella_Object = Logic.argumentBoundTo(proposition.arguments.theArray[0]);
        Stella_Object stella_Object2 = Logic.argumentBoundTo(proposition.arguments.theArray[1]);
        if (stella_Object != null) {
            return Logic.allTypes(stella_Object).length();
        }
        if (stella_Object2 != null) {
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object2);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
                Description description = (Description)stella_Object2;
                return Stella_Object.isaP((Stella_Object)description, (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION) ? NamedDescription.dynamicallyEstimateExtensionSize((NamedDescription)description) : 20.0;
            }
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_COLLECTION)) {
                Collection collection = (Collection)stella_Object2;
                return collection.length();
            }
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double dynamicallyEstimatePredicateGoalFanout(Proposition proposition) {
        GeneralizedSymbol generalizedSymbol = proposition.operator;
        if (generalizedSymbol == Logic.SGT_PL_KERNEL_KB_MEMBER_OF) {
            return Proposition.estimateMemberOfGoalFanout(proposition);
        }
        if (generalizedSymbol == Logic.SGT_PL_KERNEL_KB_INSTANCE_OF) {
            return Proposition.dynamicallyEstimateInstanceOfGoalFanout(proposition);
        }
        Cons cons = Stella.NIL;
        GeneralizedSymbol generalizedSymbol2 = proposition.operator;
        Vector vector = proposition.arguments;
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        Stella_Object stella_Object = null;
        boolean bl = true;
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)generalizedSymbol2);
        if (generalizedSymbol2 == Logic.SGT_PL_KERNEL_KB_HOLDS) {
            if (Stella_Object.isaP((Stella_Object)Logic.argumentBoundTo(vector.theArray[0]), (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION)) {
                namedDescription = (NamedDescription)Logic.argumentBoundTo(vector.theArray[0]);
                n = 1;
            } else {
                namedDescription = null;
            }
        }
        if (namedDescription == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int n4 = Integer.MIN_VALUE;
        int n5 = vector.length() - 1;
        Cons cons2 = null;
        for (int i = n; i <= n5; ++i) {
            n4 = i;
            stella_Object = Logic.argumentBoundTo(vector.theArray[n4]);
            if (stella_Object != null) {
                if (Logic.instanceHasBacklinksP(stella_Object)) {
                    bl = false;
                }
            } else {
                ++n2;
                n3 = n4;
            }
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
        }
        if (Description.computedTermP(namedDescription)) {
            switch (n2) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    if (n3 == vector.length() - 1) {
                        return 1.0;
                    }
                    if (!Description.computedConstraintP(namedDescription)) break;
                    return 1.0;
                }
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (Logic.testPropertyP((Stella_Object)namedDescription, Logic.SGT_PL_KERNEL_KB_TOTAL) && n2 > 1 && n3 == vector.length() - 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (bl) {
            return NamedDescription.dynamicallyEstimateExtensionSize(namedDescription);
        }
        return Logic.selectPropositions(Stella_Object.cons((Stella_Object)Logic.KWD_RELATION, (Cons)Stella_Object.cons((Stella_Object)(Stella.NIL == null ? Stella.NIL : Stella.NIL), (Cons)Stella_Object.cons((Stella_Object)generalizedSymbol2, (Cons)cons)))).estimatedLength();
    }

    public static double dynamicallyEstimateGoalFanout(Proposition proposition) {
        if (Proposition.allArgumentsBoundP(proposition)) {
            return 1.0;
        }
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA) {
            return NamedDescription.dynamicallyEstimateExtensionSize(Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)));
        }
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            if (proposition.operator == Logic.SGT_PL_KERNEL_KB_HOLDS) {
                if (!Logic.argumentBoundP(proposition.arguments.theArray[0])) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Proposition.dynamicallyEstimatePredicateGoalFanout(proposition);
            }
            if (Proposition.allKeyArgumentsBoundP(proposition)) {
                return 1.0;
            }
            return Proposition.dynamicallyEstimatePredicateGoalFanout(proposition);
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return 40.0;
        }
        if (keyword == Logic.KWD_EQUIVALENT) {
            if (Logic.argumentBoundP(proposition.arguments.theArray[0]) || Logic.argumentBoundP(proposition.arguments.theArray[1])) {
                return 1.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (keyword == Logic.KWD_NOT || keyword == Logic.KWD_FAIL || keyword == Logic.KWD_FORALL) {
            return Double.NEGATIVE_INFINITY;
        }
        if (keyword == Logic.KWD_AND) {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                d = Proposition.dynamicallyEstimateGoalFanout((Proposition)stella_Object);
                if (d2 != Double.NEGATIVE_INFINITY && !(d < d2)) continue;
                d2 = d;
            }
            return d2;
        }
        if (keyword == Logic.KWD_OR) {
            double d = Double.NEGATIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                d = Proposition.dynamicallyEstimateGoalFanout((Proposition)stella_Object);
                if (d == Double.NEGATIVE_INFINITY) continue;
                if (d3 == Double.NEGATIVE_INFINITY) {
                    d3 = 0.0;
                }
                d3 += d;
            }
            return d3;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double dynamicallyEstimateGoalCost(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            GeneralizedSymbol generalizedSymbol = proposition.operator;
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)generalizedSymbol);
            Stella_Object stella_Object = null;
            if (generalizedSymbol == Logic.SGT_PL_KERNEL_KB_HOLDS) {
                stella_Object = Logic.argumentBoundTo(proposition.arguments.theArray[0]);
                if (stella_Object != null) {
                    namedDescription = Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION) ? (NamedDescription)stella_Object : null;
                } else {
                    return 7.0;
                }
            }
            if (namedDescription == null || !Description.inferableP(namedDescription)) {
                return 1.0;
            }
            return 7.0;
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return 20.0;
        }
        return 1.0;
    }

    public static boolean staticallyOptimizePropositionP(Proposition proposition) {
        return Logic.$QUERY_OPTIMIZATION_STRATEGY$ != Logic.KWD_NONE && Logic.$QUERY_OPTIMIZATION_STRATEGY$ != Logic.KWD_DYNAMIC && Logic.$QUERY_OPTIMIZATION_STRATEGY$ != Logic.KWD_DYNAMIC_WITH_CLUSTERING && !((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue;
    }

    public static boolean dynamicallyOptimizePropositionP(Proposition proposition) {
        return (Logic.$QUERY_OPTIMIZATION_STRATEGY$ == Logic.KWD_DYNAMIC || Logic.$QUERY_OPTIMIZATION_STRATEGY$ == Logic.KWD_DYNAMIC_WITH_CLUSTERING) && !((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulateAndOptimizeQuery(Proposition proposition) {
        Vector vector = proposition.arguments;
        Keyword keyword = proposition.kind;
        if (((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
            if (keyword == Logic.KWD_AND) {
                keyword = Logic.KWD_OR;
            } else if (keyword == Logic.KWD_OR) {
                keyword = Logic.KWD_AND;
            } else if (keyword == Logic.KWD_IMPLIES) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("REVERSE POLARITY NOT YET IMPLEMENTED FOR :IMPLIES WITHIN QUERY OPTIMIZER");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_EQUIVALENT) {
            Proposition.simulateGoalEvaluation(proposition);
            Stella_Object stella_Object = null;
            Vector vector2 = vector;
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector2.theArray[i];
                Logic.simulateAndOptimizeArgument(stella_Object);
            }
        } else if (keyword == Logic.KWD_AND) {
            int n = Logic.simulateCreateChoicePoint();
            Logic.initializeOptimizerMemory(-1);
            Proposition.optimizeOrderingOfConjuncts(proposition);
            PatternRecord.unbindVariablesBeginningAt(((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord, n);
            Stella_Object stella_Object = null;
            Vector vector3 = proposition.arguments;
            int n2 = vector3.length();
            for (int i = 0; i < n2; ++i) {
                stella_Object = vector3.theArray[i];
                Proposition.simulateAndOptimizeQuery((Proposition)stella_Object);
            }
        } else if (keyword == Logic.KWD_OR) {
            Stella_Object stella_Object = null;
            Vector vector4 = vector;
            int n = vector4.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector4.theArray[i];
                int n3 = Logic.simulateCreateChoicePoint();
                Proposition.simulateAndOptimizeQuery((Proposition)stella_Object);
                PatternRecord.unbindVariablesBeginningAt(((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord, n3);
            }
        } else if (keyword == Logic.KWD_NOT) {
            boolean bl = (Boolean)Logic.$REVERSEPOLARITYp$.get();
            Object object = Logic.$REVERSEPOLARITYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (!bl ? 1 : 0) != 0);
                if (((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                    Proposition.warnOfUnboundVariableArgument(proposition);
                }
                Proposition.simulateAndOptimizeQuery((Proposition)vector.theArray[0]);
            }
            finally {
                Logic.$REVERSEPOLARITYp$.set(object);
            }
        } else if (keyword == Logic.KWD_IMPLIES) {
            Proposition.warnOfUnboundVariableArgument(proposition);
            Stella_Object stella_Object = null;
            Vector vector5 = vector;
            int n = vector5.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector5.theArray[i];
                Logic.simulateAndOptimizeArgument(stella_Object);
            }
        } else if (keyword == Logic.KWD_EXISTS) {
            Proposition.simulateAndOptimizeQuery((Proposition)vector.theArray[0]);
        } else if (keyword == Logic.KWD_FORALL) {
            int n = Logic.simulateCreateChoicePoint();
            Stella_Object stella_Object = null;
            Vector vector6 = vector;
            int n4 = vector6.length();
            for (int i = 0; i < n4; ++i) {
                stella_Object = vector6.theArray[i];
                Logic.simulateAndOptimizeArgument(stella_Object);
            }
            PatternRecord.unbindVariablesBeginningAt(((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord, n);
        }
    }

    public static void simulateGoalEvaluation(Proposition proposition) {
        int n;
        int n2;
        Vector vector;
        Stella_Object stella_Object;
        int n3;
        int n4;
        Vector vector2 = proposition.arguments;
        int n5 = 0;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FUNCTION) {
            n4 = 0;
            if (Proposition.computedPredicateP(proposition)) {
                n3 = 1;
                stella_Object = null;
                vector = vector2.butLast();
                while (vector.nextP()) {
                    stella_Object = vector.value;
                    if (Logic.argumentBoundP(stella_Object)) continue;
                    n3 = 0;
                    break;
                }
                n4 = n3;
            } else {
                n3 = 0;
                stella_Object = null;
                vector = vector2;
                n2 = vector.length();
                for (n = 0; n < n2; ++n) {
                    stella_Object = vector.theArray[n];
                    if (!Logic.argumentBoundP(stella_Object) || !Logic.typeHasBacklinksP(Logic.ensureDeferredDescription(Logic.logicalType(stella_Object)))) continue;
                    n3 = 1;
                    break;
                }
                n4 = n3;
            }
            n5 = n4;
        } else if (keyword == Logic.KWD_PREDICATE) {
            if (proposition.operator == Logic.SGT_PL_KERNEL_KB_MEMBER_OF) {
                n5 = Logic.argumentBoundP(vector2.theArray[1]);
            } else {
                n4 = 0;
                if (Proposition.computedPredicateP(proposition)) {
                    n3 = 1;
                    stella_Object = null;
                    vector = vector2;
                    n2 = vector.length();
                    for (n = 0; n < n2; ++n) {
                        stella_Object = vector.theArray[n];
                        if (Logic.argumentBoundP(stella_Object)) continue;
                        n3 = 0;
                        break;
                    }
                    n4 = n3;
                } else {
                    n3 = 0;
                    stella_Object = null;
                    vector = vector2;
                    n2 = vector.length();
                    for (n = 0; n < n2; ++n) {
                        stella_Object = vector.theArray[n];
                        if (!Logic.argumentBoundP(stella_Object) || !Logic.typeHasBacklinksP(Logic.ensureDeferredDescription(Logic.logicalType(stella_Object)))) continue;
                        n3 = 1;
                        break;
                    }
                    n4 = n3;
                }
                n5 = n4;
            }
        } else if (keyword == Logic.KWD_ISA) {
            n5 = 1;
        } else if (keyword == Logic.KWD_EQUIVALENT) {
            n5 = Logic.argumentBoundP(vector2.theArray[0]) || Logic.argumentBoundP(vector2.theArray[1]) ? 1 : 0;
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (n5 == 0) {
            Proposition.warnOfUnboundVariableArgument(proposition);
        }
        keyword = null;
        Vector vector3 = vector2;
        int n6 = vector3.length();
        for (n3 = 0; n3 < n6; ++n3) {
            keyword = vector3.theArray[n3];
            Logic.simulateBindVariableToValue((Stella_Object)keyword);
        }
    }

    public static void warnOfUnboundVariableArgument(Proposition proposition) {
    }

    public static void reorderGoals(Proposition proposition, List list, List list2, List list3) {
        Vector vector = proposition.arguments;
        int n = vector.length();
        int n2 = 0;
        Proposition proposition2 = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            proposition2 = (Proposition)cons.value;
            vector.theArray[n2] = proposition2;
            ++n2;
            cons = cons.rest;
        }
        proposition2 = null;
        cons = list2.theConsList;
        while (cons != Stella.NIL) {
            proposition2 = (Proposition)cons.value;
            list3.remove((Stella_Object)proposition2);
            vector.theArray[n2] = proposition2;
            ++n2;
            cons = cons.rest;
        }
        proposition2 = null;
        cons = list3.theConsList;
        while (cons != Stella.NIL) {
            proposition2 = (Proposition)cons.value;
            vector.theArray[n2] = proposition2;
            ++n2;
            cons = cons.rest;
        }
        if (n2 < n) {
            proposition.arguments = Vector.newVector((int)n2);
            proposition2 = null;
            cons = vector;
            int n3 = cons.length();
            int n4 = Integer.MIN_VALUE;
            int n5 = 0;
            int n6 = n2 - 1;
            for (int i = 0; i < n3 && n5 <= n6; ++i) {
                proposition2 = cons.theArray[i];
                n4 = n5++;
                proposition.arguments.theArray[n4] = proposition2;
            }
        }
    }

    public static void optimizeOrderingOfConjuncts(Proposition proposition) {
        int n;
        List list = List.newList();
        List list2 = List.newList();
        List list3 = List.newList();
        Object object = null;
        Vector vector = proposition.arguments;
        int n2 = vector.length();
        for (n = 0; n < n2; ++n) {
            object = vector.theArray[n];
            if (Proposition.allArgumentsBoundP((Proposition)((Object)object))) {
                list.insert((Stella_Object)((Proposition)((Object)object)));
                continue;
            }
            if (Proposition.hasDisjunctionP((Proposition)((Object)object)) || ((Proposition)((Object)object)).kind == Logic.KWD_FORALL) {
                ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).residueGoals().insert((Stella_Object)((Proposition)((Object)object)));
                continue;
            }
            list2.insert((Stella_Object)((Proposition)((Object)object)));
        }
        object = null;
        vector = list2.theConsList;
        while (vector != Stella.NIL) {
            object = (Proposition)vector.value;
            Proposition.distributeOpenGoal((Proposition)((Object)object));
            vector = vector.rest;
        }
        object = null;
        vector = list2.theConsList;
        while (vector != Stella.NIL) {
            object = (Proposition)vector.value;
            n = 0;
            Stella_Object stella_Object = null;
            Vector vector2 = object.arguments;
            int n3 = vector2.length();
            for (int i = 0; i < n3; ++i) {
                stella_Object = vector2.theArray[i];
                if (!Logic.argumentBoundP(stella_Object)) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                Proposition.propagateSingleValuedConstraints((Proposition)((Object)object), list3);
            }
            vector = vector.rest;
        }
        Proposition.computeOpenGoalOrdering(proposition, list2, list3);
        Proposition.reorderGoals(proposition, list.reverse(), ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).bestGoalSequence().reverse(), ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).residueGoals());
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_OPTIMIZER)) {
            System.out.println("Optimized goal: " + (Object)((Object)proposition));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void computeOpenGoalOrdering(Proposition proposition, List list, List list2) {
        Cons cons;
        Object object;
        List list3 = List.newList();
        List list4 = Stella.NIL_LIST;
        List list5 = List.newList();
        Cons cons2 = null;
        Cons cons3 = null;
        if (Logic.$QUERY_OPTIMIZATION_STRATEGY$ == Logic.KWD_STATIC_WITH_CLUSTERING) {
            Logic.extractOpenGoalClusters(list, list3);
        }
        if (list3.nonEmptyP()) {
            Cons cons4;
            list4 = List.newList();
            object = Logic.$EVALUATIONMODE$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
                cons = null;
                cons4 = list3.theConsList;
                Cons cons5 = null;
                while (cons4 != Stella.NIL) {
                    cons = (List)cons4.value;
                    if (cons5 == null) {
                        cons5 = Stella_Object.cons((Stella_Object)(cons.length() > 1 ? Proposition.fastenDownOneProposition(Logic.conjoinPropositions(cons.theConsList), true) : (Proposition)cons.first()), (Cons)Stella.NIL);
                        if (list4.theConsList == Stella.NIL) {
                            list4.theConsList = cons5;
                        } else {
                            Cons.addConsToEndOfConsList((Cons)list4.theConsList, (Cons)cons5);
                        }
                    } else {
                        cons5 = cons5.rest = Stella_Object.cons((Stella_Object)(cons.length() > 1 ? Proposition.fastenDownOneProposition(Logic.conjoinPropositions(cons.theConsList), true) : (Proposition)cons.first()), (Cons)Stella.NIL);
                    }
                    cons4 = cons4.rest;
                }
            }
            finally {
                Logic.$EVALUATIONMODE$.set(object);
            }
            object = null;
            cons = list4.theConsList;
            cons4 = null;
            while (cons != Stella.NIL) {
                object = (Proposition)cons.value;
                if (((Proposition)((Object)object)).kind != Logic.KWD_AND) {
                    if (cons4 == null) {
                        cons4 = Stella_Object.cons((Stella_Object)object, (Cons)Stella.NIL);
                        if (list.theConsList == Stella.NIL) {
                            list.theConsList = cons4;
                        } else {
                            Cons.addConsToEndOfConsList((Cons)list.theConsList, (Cons)cons4);
                        }
                    } else {
                        cons4 = cons4.rest = Stella_Object.cons((Stella_Object)object, (Cons)Stella.NIL);
                    }
                }
                cons = cons.rest;
            }
            object = (ListIterator)list2.allocateIterator();
            while (object.nextP()) {
                if (list.memberP((Stella_Object)((Proposition)((ListIterator)object).value))) continue;
                object.valueSetter(null);
            }
            list2.remove(null);
        }
        list3.free();
        cons2 = list2.theConsList;
        cons3 = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).residueGoals().theConsList;
        object = null;
        cons = list.theConsList;
        while (cons != Stella.NIL) {
            object = (Proposition)cons.value;
            Proposition.collectOptimizerVariables((Proposition)((Object)object), list5);
            cons = cons.rest;
        }
        object = Logic.$OPTIMALGOALORDERINGRECURSIONS$.get();
        try {
            Native.setIntSpecial((ThreadLocal)Logic.$OPTIMALGOALORDERINGRECURSIONS$, (int)0);
            Logic.computeOptimalOpenGoalOrdering(list5, list.length(), list2, 1.0, 1.0);
            if ((Integer)Logic.$OPTIMALGOALORDERINGRECURSIONS$.get() >= Logic.$OPTIMAL_GOAL_ORDERING_CUTOFF$) {
                list2.theConsList = cons2;
                ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).residueGoals().theConsList = cons3;
                ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).bestGoalSequence().clear();
                KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_BEST_COST, (Stella_Object)FloatWrapper.wrapFloat((double)Double.NEGATIVE_INFINITY), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                Logic.computeGreedyOpenGoalOrdering(list5, list.length(), list2, 1.0, 1.0);
            }
        }
        finally {
            Logic.$OPTIMALGOALORDERINGRECURSIONS$.set(object);
        }
        if (((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).bestGoalSequence().emptyP() && !list.emptyP()) {
            Logic.computeBackupOpenGoalOrdering(list.reverse());
            if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_OPTIMIZER)) {
                System.out.println("Using backup goal ordering:");
                System.out.println("Original Goal: " + (Object)((Object)proposition));
            }
        }
        object = null;
        cons = list4.sort((Method)Native.find_java_method((String)"edu.isi.powerloom.logic.Proposition", (String)"biggerConjunctionP", (Class[])new Class[]{Native.find_java_class((String)"edu.isi.powerloom.logic.Proposition"), Native.find_java_class((String)"edu.isi.powerloom.logic.Proposition")})).theConsList;
        while (cons != Stella.NIL) {
            object = (Proposition)cons.value;
            if (((Proposition)((Object)object)).kind == Logic.KWD_AND) {
                ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).bestGoalSequence().push((Stella_Object)object);
            }
            cons = cons.rest;
        }
    }

    public static boolean biggerConjunctionP(Proposition proposition, Proposition proposition2) {
        return proposition.arguments.length() > proposition2.arguments.length();
    }

    public static void collectOptimizerVariables(Proposition proposition, List list) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_EQUIVALENT || keyword == Logic.KWD_IMPLIES) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Logic.unboundVariableP(stella_Object)) continue;
                PatternVariable patternVariable = (PatternVariable)stella_Object;
                if (patternVariable != Logic.innermostOf((Stella_Object)patternVariable)) {
                    Logic.simulateBindVariableToValue((Stella_Object)patternVariable);
                    continue;
                }
                if (patternVariable.definingProposition != null || Skolem.anonymousVariableP(patternVariable)) continue;
                list.insertNew((Stella_Object)patternVariable);
            }
        }
    }

    public static void collectUnboundGoalVariables(Proposition proposition, List list) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            ContextSensitiveObject contextSensitiveObject;
            stella_Object = vector.theArray[i];
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                contextSensitiveObject = (PatternVariable)stella_Object;
                if (!Logic.unboundVariableP((Stella_Object)contextSensitiveObject)) continue;
                list.insertNew((Stella_Object)contextSensitiveObject);
                continue;
            }
            if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            contextSensitiveObject = (Proposition)stella_Object;
            Proposition.collectUnboundGoalVariables((Proposition)contextSensitiveObject, list);
            Keyword keyword = contextSensitiveObject.kind;
            if (keyword != Logic.KWD_FORALL && keyword != Logic.KWD_EXISTS) continue;
            PatternVariable patternVariable = null;
            Vector vector2 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)contextSensitiveObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n2 = vector2.length();
            for (int j = 0; j < n2; ++j) {
                patternVariable = (PatternVariable)vector2.theArray[j];
                list.remove((Stella_Object)patternVariable);
            }
        }
    }

    public static void bindAllVariablesInGeneratorGoal(Proposition proposition, List list) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE) || !Logic.unboundVariableP(stella_Object)) continue;
            PatternVariable.simulateBindVariableAndPropagateConstraints((PatternVariable)stella_Object, list);
        }
    }

    public static void propagateSingleValuedConstraints(Proposition proposition, List list) {
        Vector vector = proposition.arguments;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            if (Logic.singleValuedTermP((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)))) {
                boolean bl = false;
                boolean bl2 = true;
                Stella_Object stella_Object = null;
                Iterator iterator = vector.butLast();
                while (iterator.nextP()) {
                    stella_Object = iterator.value;
                    if (Logic.argumentBoundP(stella_Object)) continue;
                    bl2 = false;
                    break;
                }
                if (bl = bl2) {
                    bl = Logic.unboundVariableP(vector.last());
                }
                if (bl) {
                    if (!list.memberP((Stella_Object)proposition)) {
                        list.push((Stella_Object)proposition);
                    }
                    PatternVariable.simulateBindVariableAndPropagateConstraints((PatternVariable)vector.last(), list);
                }
            }
        } else if (keyword != Logic.KWD_ISA && keyword != Logic.KWD_IMPLIES) {
            if (keyword == Logic.KWD_EQUIVALENT) {
                if (Logic.unboundVariableP(vector.theArray[0])) {
                    list.push((Stella_Object)proposition);
                    PatternVariable.simulateBindVariableAndPropagateConstraints((PatternVariable)vector.theArray[0], list);
                } else if (Logic.unboundVariableP(vector.theArray[1])) {
                    list.push((Stella_Object)proposition);
                    PatternVariable.simulateBindVariableAndPropagateConstraints((PatternVariable)vector.theArray[1], list);
                }
            } else if (keyword != Logic.KWD_NOT && keyword != Logic.KWD_FAIL) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
    }

    public static double estimateGoalFanout(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA) {
            return NamedDescription.estimateCardinalityOfExtension(Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)));
        }
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            return Proposition.estimatePredicateGoalFanout(proposition);
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return 40.0;
        }
        if (keyword == Logic.KWD_EQUIVALENT) {
            if (Logic.argumentBoundP(proposition.arguments.theArray[0]) || Logic.argumentBoundP(proposition.arguments.theArray[1])) {
                return 1.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (keyword == Logic.KWD_NOT || keyword == Logic.KWD_FAIL) {
            return Double.NEGATIVE_INFINITY;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static double estimateGoalCost(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            if (namedDescription == null || !Description.inferableP(namedDescription)) {
                return 1.0;
            }
            return 7.0;
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return 20.0;
        }
        return 1.0;
    }

    public static double estimatePredicateGoalFanout(Proposition proposition) {
        if (proposition.operator == Logic.SGT_PL_KERNEL_KB_MEMBER_OF) {
            return Proposition.estimateMemberOfGoalFanout(proposition);
        }
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        BooleanVector booleanVector = Logic.argumentsVectorToBooleanVector(proposition.arguments);
        if (namedDescription == null) {
            return Double.NEGATIVE_INFINITY;
        }
        boolean bl = false;
        boolean bl2 = false;
        BooleanWrapper booleanWrapper = null;
        BooleanVector booleanVector2 = booleanVector;
        int n = 0;
        int n2 = booleanVector2.length();
        BooleanWrapper booleanWrapper2 = null;
        BooleanVector booleanVector3 = NamedDescription.getIndexingVector(namedDescription);
        int n3 = booleanVector3.length();
        for (int i = 0; n < n2 && i < n3; ++n, ++i) {
            booleanWrapper = (BooleanWrapper)booleanVector2.theArray[n];
            booleanWrapper2 = (BooleanWrapper)booleanVector3.theArray[i];
            if (booleanWrapper2 != Stella.TRUE_WRAPPER || booleanWrapper != Stella.TRUE_WRAPPER) continue;
            bl2 = true;
            break;
        }
        boolean bl3 = bl = !(bl = bl2);
        if (bl) {
            return NamedDescription.estimateCardinalityOfExtension(Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)));
        }
        bl = false;
        BooleanVector booleanVector4 = null;
        booleanWrapper = NamedDescription.getUniquenessVectors((NamedDescription)namedDescription).theConsList;
        while (booleanWrapper != Stella.NIL) {
            booleanVector4 = (BooleanVector)booleanWrapper.value;
            bl = true;
            booleanVector2 = null;
            BooleanVector booleanVector5 = booleanVector4;
            n2 = 0;
            int n4 = booleanVector5.length();
            booleanVector3 = null;
            BooleanVector booleanVector6 = booleanVector;
            int n5 = booleanVector6.length();
            for (n3 = 0; n2 < n4 && n3 < n5; ++n2, ++n3) {
                booleanVector2 = (BooleanWrapper)booleanVector5.theArray[n2];
                booleanVector3 = (BooleanWrapper)booleanVector6.theArray[n3];
                if (booleanVector2 != Stella.TRUE_WRAPPER || booleanVector3 != Stella.FALSE_WRAPPER) continue;
                bl = false;
                break;
            }
            if (bl) {
                return 1.0;
            }
            booleanWrapper = booleanWrapper.rest;
        }
        return 6.0;
    }

    public static double estimateMemberOfGoalFanout(Proposition proposition) {
        Stella_Object stella_Object = Logic.argumentBoundTo(proposition.arguments.theArray[0]);
        Stella_Object stella_Object2 = Logic.argumentBoundTo(proposition.arguments.theArray[1]);
        if (stella_Object != null) {
            return 30.0;
        }
        if (stella_Object2 != null) {
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object2);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
                Description description = (Description)stella_Object2;
                return Stella_Object.isaP((Stella_Object)description, (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION) ? NamedDescription.estimateCardinalityOfExtension((NamedDescription)description) : 20.0;
            }
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_COLLECTION)) {
                Collection collection = (Collection)stella_Object2;
                return collection.length();
            }
            return 4.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void distributeOpenGoal(Proposition proposition) {
        Object object = Logic.$DISTRIBUTEDOPENGOALp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Logic.$DISTRIBUTEDOPENGOALp$, (boolean)false);
            Keyword keyword = proposition.kind;
            if (keyword == Logic.KWD_FUNCTION) {
                Stella_Object stella_Object = null;
                Iterator iterator = proposition.arguments.butLast();
                while (iterator.nextP()) {
                    stella_Object = iterator.value;
                    Logic.helpDistributeGoal(stella_Object, proposition, !Proposition.computedPredicateP(proposition));
                }
                Logic.helpDistributeGoal(proposition.arguments.theArray[proposition.arguments.length() - 1], proposition, false);
            } else if (keyword == Logic.KWD_EQUIVALENT) {
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    stella_Object = vector.theArray[i];
                    Logic.helpDistributeGoal(stella_Object, proposition, false);
                }
            } else if (keyword == Logic.KWD_ISA) {
                Logic.helpDistributeGoal(proposition.arguments.theArray[0], proposition, Logic.generatorCollectionP((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator))));
            } else if (keyword == Logic.KWD_PREDICATE) {
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    stella_Object = vector.theArray[i];
                    Logic.helpDistributeGoal(stella_Object, proposition, !Proposition.computedPredicateP(proposition));
                }
            } else if (keyword == Logic.KWD_NOT || keyword == Logic.KWD_FAIL) {
                Logic.helpDistributeGoal(proposition.arguments.theArray[0], proposition, false);
            } else if (keyword == Logic.KWD_IMPLIES) {
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    stella_Object = vector.theArray[i];
                    Logic.helpDistributeGoal(stella_Object, proposition, true);
                }
            }
            if (!((Boolean)Logic.$DISTRIBUTEDOPENGOALp$.get()).booleanValue()) {
                ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).residueGoals().insert((Stella_Object)proposition);
            }
        }
        finally {
            Logic.$DISTRIBUTEDOPENGOALp$.set(object);
        }
    }

    public static boolean computedPredicateP(Proposition proposition) {
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        return namedDescription != null && (Description.computedTermP(namedDescription) || Stella.getQuotedTree((String)"((/PL-KERNEL-KB/@LISTOF /PL-KERNEL-KB/@SETOF) \"/LOGIC\")", (String)"/LOGIC").memberP((Stella_Object)namedDescription.surrogateValueInverse));
    }

    public static boolean hasInversionsP(Proposition proposition) {
        return (KeyValueList)KeyValueList.dynamicSlotValue((KeyValueList)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_PERMUTATION_TABLE, null) != null;
    }

    public static boolean modalGoalP(Proposition proposition) {
        boolean bl = false;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            bl = true;
            break;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean hasDisjunctionP(Proposition proposition) {
        if (proposition.kind == Logic.KWD_OR) {
            return true;
        }
        boolean bl = false;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION) || !Proposition.hasDisjunctionP((Proposition)stella_Object)) continue;
            bl = true;
            break;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static Iterator allClashingPropositions(Proposition proposition) {
        Vector vector = proposition.arguments;
        Stella_Object stella_Object = vector.last();
        Stella_Object stella_Object2 = null;
        vector.lastSetter(null);
        stella_Object2 = Proposition.selectArgumentWithBacklinks(proposition, new Object[1]);
        vector.lastSetter(stella_Object);
        if (stella_Object2 == null) {
            return Logic.EMPTY_PROPOSITIONS_ITERATOR;
        }
        Cons cons = Stella_Object.cons((Stella_Object)Logic.KWD_RELATION, (Cons)Stella_Object.cons((Stella_Object)(Stella.NIL == null ? Stella.NIL : Stella.NIL), (Cons)Stella_Object.cons((Stella_Object)((Surrogate)proposition.operator), (Cons)Stella_Object.cons((Stella_Object)Logic.valueOf(stella_Object2), (Cons)Stella.NIL))));
        SequenceIndex sequenceIndex = Logic.selectPropositions(cons);
        if (SequenceIndex.emptyPropositionsIndexP(sequenceIndex, stella_Object2, false)) {
            return Logic.EMPTY_PROPOSITIONS_ITERATOR;
        }
        ClashingPropositionsIterator clashingPropositionsIterator = ClashingPropositionsIterator.newClashingPropositionsIterator();
        clashingPropositionsIterator.selectionPattern = cons;
        clashingPropositionsIterator.propositionCursor = sequenceIndex.allocateIterator();
        clashingPropositionsIterator.referenceProposition = proposition;
        ClashingPropositionsIterator clashingPropositionsIterator2 = clashingPropositionsIterator;
        return clashingPropositionsIterator2;
    }

    public static boolean clashesWithFunctionPropositionP(Proposition proposition, Proposition proposition2) {
        boolean bl = true;
        Stella_Object stella_Object = null;
        Iterator iterator = proposition2.arguments.butLast();
        Stella_Object stella_Object2 = null;
        Iterator iterator2 = proposition.arguments.butLast();
        while (iterator.nextP() && iterator2.nextP()) {
            stella_Object = iterator.value;
            stella_Object2 = iterator2.value;
            if (Stella_Object.eqlP((Stella_Object)Logic.argumentBoundTo(stella_Object), (Stella_Object)Logic.valueOf(stella_Object2))) continue;
            bl = false;
            break;
        }
        if (bl) {
            stella_Object = Logic.argumentBoundTo(proposition2.arguments.last());
            iterator = Logic.valueOf(proposition.arguments.last());
            if (stella_Object != null && iterator != null) {
                if (Stella_Object.isaP((Stella_Object)iterator, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                        return false;
                    }
                    return Skolem.valueClashesWithSkolemP((Skolem)iterator, stella_Object);
                }
                if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    return Skolem.valueClashesWithSkolemP((Skolem)stella_Object, (Stella_Object)iterator);
                }
                return !Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)iterator);
            }
        }
        return false;
    }

    public static Iterator allMatchingPropositions(Proposition proposition) {
        Stella_Object stella_Object = null;
        boolean bl = false;
        Cons cons = new Object[1];
        stella_Object = Proposition.selectArgumentWithBacklinks(proposition, (Object[])cons);
        bl = ((BooleanWrapper)cons[0]).wrapperValue;
        if (bl) {
            return Logic.EMPTY_PROPOSITIONS_ITERATOR;
        }
        if (stella_Object == null) {
            if (Logic.$CYC_KLUDGES_ENABLEDp$) {
                boolean bl2 = false;
                boolean bl3 = false;
                Stella_Object stella_Object2 = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    stella_Object2 = vector.theArray[i];
                    if (Logic.argumentBoundTo(stella_Object2) == null) continue;
                    bl3 = true;
                    break;
                }
                if (bl2 = bl3) {
                    boolean bl4 = bl2 = NamedDescription.dynamicallyEstimateExtensionSize(Logic.getDescription((Stella_Object)proposition.operator)) > 500.0;
                }
                if (bl2) {
                    return Logic.EMPTY_PROPOSITIONS_ITERATOR;
                }
            }
            return Proposition.allMatchingExtensionMembers(proposition, true);
        }
        cons = Stella.NIL;
        Stella_Object stella_Object3 = null;
        Stella_Object stella_Object4 = null;
        Object object = proposition.arguments;
        int n = object.length();
        Cons cons2 = null;
        for (int i = 0; i < n; ++i) {
            stella_Object4 = object.theArray[i];
            stella_Object3 = Logic.argumentBoundTo(stella_Object4);
            if (stella_Object3 != null && Stella_Object.isaP((Stella_Object)stella_Object3, (Surrogate)Logic.SGT_LOGIC_PROPOSITION) && !Proposition.allArgumentsBoundP((Proposition)stella_Object3)) {
                stella_Object3 = null;
            }
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)Logic.valueOf(stella_Object3), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)Logic.valueOf(stella_Object3), (Cons)Stella.NIL);
        }
        if (cons.rest == Stella.NIL) {
            return Logic.allTrueDependentPropositions(stella_Object, (Surrogate)proposition.operator, true);
        }
        stella_Object4 = Stella_Object.cons((Stella_Object)Logic.KWD_RELATION, (Cons)Stella_Object.cons((Stella_Object)(Stella.NIL == null ? Stella.NIL : Stella.NIL), (Cons)Stella_Object.cons((Stella_Object)proposition.operator, (Cons)cons)));
        object = SpecializingPropositionsIterator.newSpecializingPropositionsIterator();
        object.selectionPattern = stella_Object4;
        object.propositionCursor = Logic.selectPropositions((Cons)stella_Object4).allocateIterator();
        Object object2 = object;
        return object2;
    }

    public static boolean prefixArgumentsEqualArgumentsP(Proposition proposition, Proposition proposition2) {
        boolean bl = false;
        boolean bl2 = true;
        Stella_Object stella_Object = null;
        Vector vector = proposition2.arguments;
        int n = 0;
        int n2 = vector.length();
        Stella_Object stella_Object2 = null;
        Vector vector2 = proposition.arguments;
        int n3 = vector2.length();
        for (int i = 0; n < n2 && i < n3; ++n, ++i) {
            stella_Object = vector.theArray[n];
            stella_Object2 = vector2.theArray[i];
            if (Stella_Object.eqlP((Stella_Object)Logic.valueOf(stella_Object), (Stella_Object)Logic.valueOf(stella_Object2))) continue;
            bl2 = false;
            break;
        }
        bl2 = bl = bl2;
        return bl2;
    }

    public static boolean argumentsMatchArgumentsP(Proposition proposition, Proposition proposition2) {
        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null) {
            return Proposition.argumentsUnifyWithArgumentsP(proposition, proposition2);
        }
        return Proposition.argumentsEqualArgumentsP(proposition, proposition2);
    }

    public static boolean argumentsEqualArgumentsP(Proposition proposition, Proposition proposition2) {
        boolean bl = false;
        boolean bl2 = true;
        Stella_Object stella_Object = null;
        Vector vector = proposition2.arguments;
        int n = 0;
        int n2 = vector.length();
        Stella_Object stella_Object2 = null;
        Vector vector2 = proposition.arguments;
        int n3 = vector2.length();
        for (int i = 0; n < n2 && i < n3; ++n, ++i) {
            stella_Object = vector.theArray[n];
            stella_Object2 = vector2.theArray[i];
            if (Stella_Object.eqlP((Stella_Object)Logic.valueOf(stella_Object), (Stella_Object)Logic.valueOf(stella_Object2))) continue;
            bl2 = false;
            break;
        }
        if (bl = bl2) {
            bl = proposition2.arguments.length() == proposition.arguments.length();
        }
        bl2 = bl;
        return bl2;
    }

    public static boolean argumentsUnifyWithArgumentsP(Proposition proposition, Proposition proposition2) {
        PatternRecord patternRecord = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord;
        int n = patternRecord.topUnbindingStackOffset;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Stella_Object stella_Object = null;
        Vector vector = proposition2.arguments;
        int n2 = 0;
        int n3 = vector.length();
        Stella_Object stella_Object2 = null;
        Vector vector2 = proposition.arguments;
        int n4 = vector2.length();
        for (int i = 0; n2 < n3 && i < n4; ++n2, ++i) {
            stella_Object = vector.theArray[n2];
            stella_Object2 = vector2.theArray[i];
            if (!Logic.nullInstanceP(stella_Object2) && Logic.bindArgumentToValueP(stella_Object, Logic.valueOf(stella_Object2), false)) continue;
            bl3 = false;
            break;
        }
        if (bl2 = bl3) {
            boolean bl4 = bl2 = proposition2.arguments.length() == proposition.arguments.length();
        }
        if (!(bl = bl2)) {
            PatternRecord.unbindVariablesBeginningAt(patternRecord, n + 1);
        }
        return bl;
    }

    public static boolean truePropositionP(Proposition proposition) {
        return !proposition.deletedP() && ((Boolean)Logic.$REVERSEPOLARITYp$.get() != false ? Proposition.falseP(proposition) : Proposition.trueP(proposition) || Proposition.functionWithDefinedValueP(proposition));
    }

    public static TruthValue propositionTruthValue(Proposition proposition) {
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        if (truthValue != null) {
            return truthValue;
        }
        if (!((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue() && Proposition.functionWithDefinedValueP(proposition)) {
            return Logic.TRUE_TRUTH_VALUE;
        }
        return null;
    }

    public static void helpCollectSinglyBoundVariables(Proposition proposition, List list, boolean bl) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.helpCollectSinglyBoundVariables((Proposition)stella_Object, list, bl);
            }
        } else if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE) {
            if (proposition.arguments.length() > 0) {
                Stella_Object stella_Object = proposition.arguments.theArray[proposition.arguments.length() - 1];
                boolean bl2 = false;
                bl2 = Logic.variableP(stella_Object);
                if (bl2) {
                    boolean bl3 = bl2 = !list.memberP(stella_Object);
                    if (bl2) {
                        boolean bl4 = bl2 = proposition.kind == Logic.KWD_FUNCTION || bl && Logic.singleValuedTermP((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator))) || !bl && Logic.nonRecursiveSingleValuedTermP((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)));
                        if (bl2) {
                            boolean bl5 = true;
                            Stella_Object stella_Object2 = null;
                            Iterator iterator = proposition.arguments.butLast();
                            while (iterator.nextP()) {
                                stella_Object2 = iterator.value;
                                if (!Logic.variableP(stella_Object2) || list.memberP(stella_Object2)) continue;
                                bl5 = false;
                                break;
                            }
                            bl2 = bl5;
                        }
                    }
                }
                if (bl2) {
                    list.push((Stella_Object)((PatternVariable)stella_Object));
                }
            }
        } else if (keyword == Logic.KWD_EQUIVALENT) {
            Cons cons = Stella.NIL;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Logic.variableP(stella_Object) || list.memberP(stella_Object)) continue;
                cons = Stella_Object.cons((Stella_Object)stella_Object, (Cons)cons);
            }
            if (cons.length() == 1) {
                list.push((Stella_Object)((PatternVariable)cons.value));
            }
        }
    }

    public static boolean helpSingleValuedGoalP(Proposition proposition, Cons cons, Cons cons2, boolean bl) {
        List list = cons2.listify();
        int n = list.length();
        int n2 = Integer.MIN_VALUE;
        while (true) {
            Proposition.helpCollectSinglyBoundVariables(proposition, list, bl);
            n2 = list.length();
            if (n == n2) break;
            n = n2;
        }
        boolean bl2 = true;
        PatternVariable patternVariable = null;
        Cons cons3 = cons;
        while (cons3 != Stella.NIL) {
            patternVariable = (PatternVariable)cons3.value;
            if (!list.memberP((Stella_Object)patternVariable)) {
                bl2 = false;
                break;
            }
            cons3 = cons3.rest;
        }
        boolean bl3 = bl2;
        return bl3;
    }

    public static boolean singleValuedGoalP(Proposition proposition, Cons cons, Cons cons2) {
        return Proposition.helpSingleValuedGoalP(proposition, cons, cons2, true);
    }

    public static boolean helpClosedPropositionP(Proposition proposition, Cons cons) {
        if (cons.membP((Stella_Object)proposition)) {
            return false;
        }
        cons = Stella_Object.cons((Stella_Object)proposition, (Cons)cons);
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND || keyword == Logic.KWD_OR || keyword == Logic.KWD_NOT || keyword == Logic.KWD_FORALL || keyword == Logic.KWD_EXISTS) {
            boolean bl = true;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (Proposition.helpClosedPropositionP((Proposition)stella_Object, cons)) continue;
                bl = false;
                break;
            }
            boolean bl2 = bl;
            return bl2;
        }
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA) {
            if ((Surrogate)proposition.operator == Logic.SGT_PL_KERNEL_KB_MEMBER_OF) {
                return Logic.helpClosedTermP(proposition.arguments.theArray[1], cons);
            }
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            return Logic.helpClosedTermP((Stella_Object)namedDescription, cons) || Logic.singleValuedTermP((Stella_Object)namedDescription) && Logic.testPropertyP((Stella_Object)namedDescription, Logic.SGT_PL_KERNEL_KB_TOTAL);
        }
        return keyword == Logic.KWD_FAIL;
    }

    public static boolean closedPropositionP(Proposition proposition) {
        MemoizationTable memoizationTable = null;
        Cons cons = null;
        BooleanWrapper booleanWrapper = null;
        if (Stella.$MEMOIZATION_ENABLEDp$) {
            memoizationTable = (MemoizationTable)Logic.SGT_LOGIC_F_CLOSED_PROPOSITIONp_MEMO_TABLE_000.surrogateValue;
            if (memoizationTable == null) {
                Surrogate.initializeMemoizationTable((Surrogate)Logic.SGT_LOGIC_F_CLOSED_PROPOSITIONp_MEMO_TABLE_000, (String)"(:MAX-VALUES 500 :TIMESTAMPS (:META-KB-UPDATE))");
                memoizationTable = (MemoizationTable)Logic.SGT_LOGIC_F_CLOSED_PROPOSITIONp_MEMO_TABLE_000.surrogateValue;
            }
            cons = MruMemoizationTable.lookupMruMemoizedValue((MruMemoizationTable)((MruMemoizationTable)memoizationTable), (Stella_Object)proposition, (Stella_Object)((Context)Stella.$CONTEXT$.get()), (Stella_Object)Stella.MEMOIZED_NULL_VALUE, null, (int)-1);
            booleanWrapper = cons.value;
        }
        if (booleanWrapper != null) {
            if (booleanWrapper == Stella.MEMOIZED_NULL_VALUE) {
                booleanWrapper = null;
            }
        } else {
            BooleanWrapper booleanWrapper2 = booleanWrapper = Proposition.helpClosedPropositionP(proposition, Stella.NIL) ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            if (Stella.$MEMOIZATION_ENABLEDp$) {
                cons.value = booleanWrapper == null ? Stella.MEMOIZED_NULL_VALUE : booleanWrapper;
            }
        }
        BooleanWrapper booleanWrapper3 = booleanWrapper;
        return BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)booleanWrapper3);
    }

    public static Cons generateImpliesProposition(Proposition proposition) {
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        if (Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
            return Description.generateDescriptionsAsRule((Description)stella_Object2, (Description)stella_Object, proposition, false);
        }
        return Stella_Object.cons((Stella_Object)Logic.SYM_PL_KERNEL_KB_SUBSET_OF, (Cons)Logic.generateArguments(proposition.arguments).concatenate(Stella.NIL, Stella.NIL));
    }

    public static Cons generateFunctionAsTerm(Proposition proposition) {
        Cons cons = Stella.NIL;
        Stella_Object stella_Object = null;
        Iterator iterator = proposition.arguments.butLast();
        Cons cons2 = null;
        while (iterator.nextP()) {
            stella_Object = iterator.value;
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)Logic.generateTerm(stella_Object), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)Logic.generateTerm(stella_Object), (Cons)Stella.NIL);
        }
        return Stella_Object.cons((Stella_Object)Proposition.generateOperator(proposition), (Cons)cons.concatenate(Stella.NIL, Stella.NIL));
    }

    public static Stella_Object generateProposition(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA || keyword == Logic.KWD_AND || keyword == Logic.KWD_OR || keyword == Logic.KWD_NOT) {
            Symbol symbol = Proposition.generateOperator(proposition);
            return Stella_Object.cons((Stella_Object)symbol, (Cons)Logic.generateArguments(proposition.arguments).concatenate(Stella.NIL, Stella.NIL));
        }
        if (keyword == Logic.KWD_EQUIVALENT) {
            return Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_e, (Cons)Logic.generateArguments(proposition.arguments).concatenate(Stella.NIL, Stella.NIL));
        }
        if (keyword == Logic.KWD_EXISTS) {
            return Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_EXISTS, (Cons)Stella_Object.cons((Stella_Object)Logic.generateVariables((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null), false), (Cons)Stella_Object.cons((Stella_Object)Stella_Object.cons((Stella_Object)Proposition.generateProposition((Proposition)proposition.arguments.theArray[0]), (Cons)Stella.NIL), (Cons)Stella.NIL))));
        }
        if (keyword == Logic.KWD_FORALL) {
            boolean bl = !((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue;
            Symbol symbol = Surrogate.symbolize((Surrogate)Proposition.chooseImplicationOperator(proposition, bl));
            return Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_FORALL, (Cons)Stella_Object.cons((Stella_Object)Logic.generateVariables((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null), false), (Cons)Stella_Object.cons((Stella_Object)Stella_Object.cons((Stella_Object)Stella_Object.cons((Stella_Object)symbol, (Cons)Stella_Object.cons((Stella_Object)Proposition.generateProposition((Proposition)proposition.arguments.theArray[bl ? 0 : 1]), (Cons)Stella_Object.cons((Stella_Object)Proposition.generateProposition((Proposition)proposition.arguments.theArray[bl ? 1 : 0]), (Cons)Stella.NIL))), (Cons)Stella.NIL), (Cons)Stella.NIL))));
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return Proposition.generateImpliesProposition(proposition);
        }
        if (keyword == Logic.KWD_FAIL) {
            return Stella_Object.cons((Stella_Object)Logic.SYM_LOGIC_FAIL, (Cons)Logic.generateArguments(proposition.arguments).concatenate(Stella.NIL, Stella.NIL));
        }
        if (keyword == Logic.KWD_CONSTANT) {
            return Proposition.generateOperator(proposition);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Symbol generateOperator(Proposition proposition) {
        GeneralizedSymbol generalizedSymbol = proposition.operator;
        if (generalizedSymbol == null) {
            return Logic.SYM_STELLA_NULL;
        }
        Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)generalizedSymbol);
        if (Surrogate.subtypeOfSurrogateP((Surrogate)surrogate)) {
            Surrogate surrogate2 = (Surrogate)generalizedSymbol;
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)surrogate2);
            Symbol symbol = Stella.internSymbolInModule((String)surrogate2.symbolName, (Module)((Module)surrogate2.homeContext), (boolean)false);
            if (namedDescription != null) {
                return Logic.internalStellaOperatorToKif(symbol);
            }
            return symbol;
        }
        if (Surrogate.subtypeOfSymbolP((Surrogate)surrogate)) {
            Symbol symbol = (Symbol)generalizedSymbol;
            return symbol;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    /*
     * Unable to fully structure code
     */
    public static void printProposition(Proposition var0, OutputStream var1_1, boolean var2_2) {
        block8: {
            block9: {
                var3_3 = null;
                if (var0.deletedP()) {
                    var1_1.nativeStream.print("|dElEtEd-proposition|");
                    return;
                }
                if (!var2_2 || ((Boolean)Stella.$PRINTREADABLYp$.get()).booleanValue()) break block8;
                if (!Proposition.defaultTrueP(var0) && !Proposition.defaultFalseP(var0)) break block9;
                var3_3 = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue != false ? "|pd|" : "|p|";
                break block8;
            }
            if (!var0.deletedP() && ((Boolean)Logic.$REVERSEPOLARITYp$.get() == false ? Proposition.trueP(var0) != false || Proposition.functionWithDefinedValueP(var0) != false : Proposition.falseP(var0) != false)) ** GOTO lbl-1000
            if (Proposition.falseP(var0)) lbl-1000:
            // 2 sources

            {
                var3_3 = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue != false ? "|Pd|" : "|P|";
            } else if (Proposition.inconsistentP(var0)) {
                var3_3 = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue != false ? "|Pd#|" : "|P#|";
            } else {
                v0 = var3_3 = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue != false ? "|Pd?|" : "|P?|";
            }
        }
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)var0.unfastenedP())) {
            v1 = var3_3 = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue != false ? "|uPd|" : "|uP|";
        }
        if ((Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null) != null && ((Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)var0.dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null)).surrogateValue != var0) {
            var3_3 = "|BAD surrogate|";
        }
        if (var3_3 != null) {
            var1_1.nativeStream.print(var3_3);
        }
        Logic.printLogicalForm((Stella_Object)var0, var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prettyPrintAssertion(Proposition proposition, OutputStream outputStream) {
        Symbol symbol = TruthValue.defaultTruthValueP((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)) ? Logic.SYM_LOGIC_PRESUME : Logic.SYM_STELLA_ASSERT;
        Surrogate surrogate = (Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null);
        if (surrogate != null) {
            Logic.prettyPrintNamedRule(surrogate, outputStream);
            return;
        }
        Object object = Logic.$PRINTMODE$.get();
        Object object2 = Logic.$PRINTLOGICALFORMSTREAM$.get();
        Object object3 = Logic.$INDENTCOUNTER$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_ORIGINAL);
            Native.setSpecial((ThreadLocal)Logic.$PRINTLOGICALFORMSTREAM$, (Object)outputStream);
            Native.setIntSpecial((ThreadLocal)Logic.$INDENTCOUNTER$, (int)8);
            outputStream.nativeStream.print("(" + symbol + " ");
            Logic.prettyPrintLogicalForm((Stella_Object)proposition, outputStream);
            outputStream.nativeStream.println(")");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Logic.$INDENTCOUNTER$.set(object3);
            Logic.$PRINTLOGICALFORMSTREAM$.set(object2);
            Logic.$PRINTMODE$.set(object);
            throw throwable;
        }
        Logic.$INDENTCOUNTER$.set(object3);
        Logic.$PRINTLOGICALFORMSTREAM$.set(object2);
        Logic.$PRINTMODE$.set(object);
    }

    public static boolean excludedPropositionP(Proposition proposition) {
        Stella_Object stella_Object;
        if (Proposition.unknownP(proposition) || (BooleanWrapper)((HashTable)Logic.$EXCLUDEDPROPOSITIONS$.get()).lookup((Stella_Object)proposition) != null || (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null) != null) {
            return true;
        }
        Keyword keyword = proposition.kind;
        return keyword == Logic.KWD_ISA ? Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[0], (Surrogate)Logic.SGT_STELLA_LITERAL_WRAPPER) || Logic.functionOutputSkolemP(proposition.arguments.theArray[0]) || Logic.hiddenRelationP((Surrogate)proposition.operator) : (keyword == Logic.KWD_FUNCTION ? Logic.skolemP(stella_Object = proposition.arguments.last()) && Stella_Object.eqlP((Stella_Object)Logic.valueOf(stella_Object), (Stella_Object)stella_Object) && !Proposition.topLevelExistsPropositionP(proposition) || Logic.hiddenRelationP((Surrogate)proposition.operator) : keyword == Logic.KWD_PREDICATE && Logic.hiddenRelationP((Surrogate)proposition.operator));
    }

    public static Surrogate chooseImplicationOperator(Proposition proposition, boolean bl) {
        Surrogate surrogate;
        Surrogate surrogate2 = surrogate = bl ? Logic.SGT_PL_KERNEL_KB_eg : Logic.SGT_PL_KERNEL_KB_le;
        if ((Keyword)Logic.$PRINTMODE$.get() != Logic.KWD_REALISTIC) {
            if (bl && ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
                surrogate = Logic.SGT_PL_KERNEL_KB_egg;
            } else if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && !bl) {
                surrogate = Logic.SGT_PL_KERNEL_KB_lle;
            }
        }
        if (Proposition.defaultTrueP(proposition) && (Keyword)Logic.$PRINTMODE$.get() != Logic.KWD_REALISTIC) {
            if (surrogate == Logic.SGT_PL_KERNEL_KB_le) {
                surrogate = Logic.SGT_PL_KERNEL_KB_lt;
            } else if (surrogate == Logic.SGT_PL_KERNEL_KB_eg) {
                surrogate = Logic.SGT_PL_KERNEL_KB_tg;
            } else if (surrogate == Logic.SGT_PL_KERNEL_KB_lle) {
                surrogate = Logic.SGT_PL_KERNEL_KB_llt;
            } else if (surrogate == Logic.SGT_PL_KERNEL_KB_egg) {
                surrogate = Logic.SGT_PL_KERNEL_KB_tgg;
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        return surrogate;
    }

    public static void printKifTopLevelExistsProposition(Proposition proposition) {
        OutputStream outputStream = (OutputStream)Logic.$PRINTLOGICALFORMSTREAM$.get();
        outputStream.nativeStream.print("(" + Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_EXISTS) + " ");
        Logic.printKifQuantifiedVariables(Proposition.collectSkolemizedExistsVariables(proposition), false);
        outputStream.nativeStream.println();
        Logic.increaseIndent(Integer.MIN_VALUE);
        Logic.printIndent(outputStream, Integer.MIN_VALUE);
        Proposition.printKifProposition(proposition);
        Logic.decreaseIndent(Integer.MIN_VALUE);
        outputStream.nativeStream.print(")");
    }

    public static void printKifQuantification(Proposition proposition) {
        Object object;
        Surrogate surrogate;
        OutputStream outputStream = (OutputStream)Logic.$PRINTLOGICALFORMSTREAM$.get();
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[0];
        Proposition proposition3 = proposition.arguments.length() == 2 ? (Proposition)proposition.arguments.theArray[1] : null;
        boolean bl = proposition3 != null;
        Surrogate surrogate2 = surrogate = bl ? Proposition.chooseImplicationOperator(proposition, ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) : (Surrogate)null;
        if (surrogate != null && ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && surrogate != Logic.SGT_PL_KERNEL_KB_le) {
            object = proposition2;
            proposition2 = proposition3;
            proposition3 = object;
        }
        if ((object = proposition.kind) == Logic.KWD_FORALL) {
            outputStream.nativeStream.print("(" + Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_FORALL) + " ");
        } else if (object == Logic.KWD_EXISTS) {
            outputStream.nativeStream.print("(" + Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_EXISTS) + " ");
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + object + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        Logic.printKifQuantifiedVariables((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null), false);
        outputStream.nativeStream.println();
        Logic.increaseIndent(Integer.MIN_VALUE);
        Logic.printIndent(outputStream, Integer.MIN_VALUE);
        if (bl) {
            outputStream.nativeStream.print("(" + Logic.stringifiedSurrogate(surrogate) + " ");
            Logic.increaseIndent(surrogate.symbolName.length() + 2);
            Proposition.printKifProposition(proposition3);
            outputStream.nativeStream.println();
            Logic.printIndent(outputStream, Integer.MIN_VALUE);
        }
        Proposition.printKifProposition(proposition2);
        if (bl) {
            outputStream.nativeStream.print(")");
            Logic.decreaseIndent(surrogate.symbolName.length() + 2);
        }
        Logic.decreaseIndent(Integer.MIN_VALUE);
        outputStream.nativeStream.print(")");
    }

    public static void printKifImpliesProposition(Proposition proposition) {
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        if (Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
            Description.printDescriptionsAsKifRule((Description)stella_Object2, (Description)stella_Object, proposition, false);
        } else {
            Logic.printKifOperatorWithArguments("subset-of", proposition.arguments, true, false);
        }
    }

    public static void printKifFunctionExpression(Proposition proposition) {
        String string = Proposition.stringifiedKifOperator(proposition);
        Logic.printKifOperatorWithArguments(string, proposition.arguments, false, true);
    }

    public static void printKifFunctionProposition(Proposition proposition) {
        OutputStream outputStream = (OutputStream)Logic.$PRINTLOGICALFORMSTREAM$.get();
        String string = Proposition.stringifiedKifOperator(proposition);
        Stella_Object stella_Object = proposition.arguments.theArray[proposition.arguments.length() - 1];
        outputStream.nativeStream.print("(= ");
        Logic.printKifOperatorWithArguments(string, proposition.arguments, false, true);
        outputStream.nativeStream.print(" ");
        if (stella_Object != null) {
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                PatternVariable patternVariable = (PatternVariable)stella_Object;
                PatternVariable.printKifVariable(patternVariable);
            } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                Skolem skolem = (Skolem)stella_Object;
                Skolem.printKifSkolem(skolem, true);
            } else {
                Logic.printAsKifInternal(stella_Object);
            }
        }
        outputStream.nativeStream.print(")");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void helpPrintKifProposition(Proposition proposition) {
        OutputStream outputStream = (OutputStream)Logic.$PRINTLOGICALFORMSTREAM$.get();
        String string = null;
        boolean bl = false;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND || keyword == Logic.KWD_OR) {
            string = proposition.kind == Logic.KWD_AND ? Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_AND) : Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_OR);
            bl = true;
            if (Logic.visibleArgumentsCount(proposition.arguments) == 1 && ((Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_REALISTIC || (Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_ORIGINAL)) {
                Logic.printKifArguments(proposition.arguments, false, false);
                return;
            }
        } else if (keyword == Logic.KWD_NOT) {
            string = Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_NOT);
        } else if (keyword == Logic.KWD_EQUIVALENT) {
            string = "=";
        } else if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE) {
            string = Proposition.stringifiedKifOperator(proposition);
        } else if (keyword == Logic.KWD_FUNCTION) {
            if (!((Boolean)Logic.$PRINTFUNCTIONSASRELATIONSp$.get()).booleanValue()) {
                Proposition.printKifFunctionProposition(proposition);
                return;
            }
            string = Proposition.stringifiedKifOperator(proposition);
        } else {
            if (keyword == Logic.KWD_IMPLIES) {
                Proposition.printKifImpliesProposition(proposition);
                return;
            }
            if (keyword == Logic.KWD_FORALL || keyword == Logic.KWD_EXISTS) {
                Proposition.printKifQuantification(proposition);
                return;
            }
            if (keyword == Logic.KWD_CONSTANT) {
                outputStream.nativeStream.print(((Surrogate)proposition.operator).symbolName);
                return;
            }
            string = keyword == Logic.KWD_CONTAINED_BY ? ":CONTAINED-BY" : (keyword == Logic.KWD_DELETED ? ":DELETED" : proposition.kind.symbolName);
        }
        Logic.printKifOperatorWithArguments(string, proposition.arguments, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printKifProposition(Proposition proposition) {
        if (proposition == null) {
            return;
        }
        boolean bl = (Boolean)Logic.$TOPLEVELPRINTKIFPROPOSITIONp$.get();
        OutputStream outputStream = (OutputStream)Logic.$PRINTLOGICALFORMSTREAM$.get();
        boolean bl2 = bl && (Proposition.falseP(proposition) || Proposition.defaultFalseP(proposition)) && proposition.operator != Logic.SGT_STELLA_FALSE;
        Object object = Logic.$TOPLEVELPRINTKIFPROPOSITIONp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Logic.$TOPLEVELPRINTKIFPROPOSITIONp$, (boolean)false);
            if (bl2) {
                outputStream.nativeStream.print("(" + Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_NOT) + " ");
                Logic.increaseIndent(5);
            }
            if (((Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_REALISTIC || (Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_ORIGINAL) && bl && Proposition.topLevelExistsPropositionP(proposition)) {
                Proposition.printKifTopLevelExistsProposition(proposition);
            } else {
                Proposition.helpPrintKifProposition(proposition);
            }
            if (bl2) {
                outputStream.nativeStream.print(")");
                Logic.decreaseIndent(5);
            }
        }
        finally {
            Logic.$TOPLEVELPRINTKIFPROPOSITIONp$.set(object);
        }
    }

    public static String stringifiedKifOperator(Proposition proposition) {
        GeneralizedSymbol generalizedSymbol = proposition.operator;
        if (generalizedSymbol == null) {
            return "NULL";
        }
        Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)generalizedSymbol);
        if (Surrogate.subtypeOfSurrogateP((Surrogate)surrogate)) {
            Surrogate surrogate2 = (Surrogate)generalizedSymbol;
            return Logic.stringifiedSurrogate(surrogate2);
        }
        if (Surrogate.subtypeOfSymbolP((Surrogate)surrogate)) {
            Symbol symbol = (Symbol)generalizedSymbol;
            return Logic.maybeDowncase(symbol.symbolName);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static boolean auxiliaryEquivalencePropositionP(Proposition proposition) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl2 = proposition.kind == Logic.KWD_EQUIVALENT;
        if (bl2) {
            bl = false;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Logic.variableP(stella_Object) || Stella_Object.accessInContext((Stella_Object)((PatternVariable)stella_Object).variableValue, (Context)((PatternVariable)stella_Object).homeContext, (boolean)false) == null) continue;
                bl = true;
                break;
            }
            bl2 = bl;
        }
        bl = bl2;
        return bl;
    }

    public static void recordForwardJustification(Proposition proposition, Proposition proposition2, Cons cons) {
        if (!((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
            return;
        }
        List list = proposition.forwardJustifications();
        ForwardJustification forwardJustification = null;
        Cons cons2 = list.theConsList;
        while (cons2 != Stella.NIL) {
            forwardJustification = (ForwardJustification)cons2.value;
            if (forwardJustification.forwardRule == proposition2) {
                forwardJustification.antecedents = cons;
                return;
            }
            cons2 = cons2.rest;
        }
        if (list == Stella.NIL_LIST) {
            list = Stella.list((Cons)Stella.NIL);
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_JUSTIFICATIONS, (Stella_Object)list, null);
        }
        cons = Stella_Object.cons((Stella_Object)proposition2, (Cons)cons);
        list.push((Stella_Object)Proposition.createForwardJustification(proposition, proposition2, cons));
    }

    public static ForwardJustification createForwardJustification(Proposition proposition, Proposition proposition2, Cons cons) {
        ForwardJustification forwardJustification = ForwardJustification.newForwardJustification();
        forwardJustification.consequent = proposition;
        forwardJustification.forwardRule = proposition2;
        forwardJustification.antecedents = cons;
        return forwardJustification;
    }

    public List forwardJustifications() {
        Proposition proposition = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_JUSTIFICATIONS, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    public static List getForwardGoals(Proposition proposition) {
        List list = proposition.forwardChainingGoals().removeDeletedMembers();
        if (list.emptyP() && (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null) != null) {
            list = ((Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null)).forwardChainingGoals().removeDeletedMembers();
        }
        return list;
    }

    public static boolean elaborationRuleP(Proposition proposition, Proposition proposition2, Vector vector) {
        boolean bl;
        boolean bl2 = false;
        bl2 = Proposition.predicationP(proposition);
        if (bl2 && (bl2 = Proposition.assertedAsTrueP(proposition2))) {
            bl = true;
            Stella_Object stella_Object = null;
            Vector vector2 = proposition.arguments;
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector2.theArray[i];
                if (vector.memberP(stella_Object)) continue;
                bl = false;
                break;
            }
            bl2 = bl;
        }
        bl = bl2;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean assertedAsTrueP(Proposition proposition) {
        Object object = Stella.$MODULE$.get();
        Object object2 = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)((Module)Stella.$MODULE$.get()));
            boolean bl = !proposition.deletedP() && ((Boolean)Logic.$REVERSEPOLARITYp$.get() != false ? Proposition.falseP(proposition) : Proposition.trueP(proposition) || Proposition.functionWithDefinedValueP(proposition));
            return bl;
        }
        finally {
            Stella.$CONTEXT$.set(object2);
            Stella.$MODULE$.set(object);
        }
    }

    public static boolean predicationP(Proposition proposition) {
        return Stella.getQuotedTree((String)"((:PREDICATE :FUNCTION :ISA :EQUIVALENT) \"/LOGIC\")", (String)"/LOGIC").memberP((Stella_Object)proposition.kind);
    }

    public static void recordForwardGoal(Proposition proposition, Vector vector, Proposition proposition2) {
        int n;
        int n2;
        Proposition proposition3;
        Object object = null;
        Object object2 = proposition2.forwardChainingGoals().theConsList;
        while (object2 != Stella.NIL) {
            object = (ForwardGoalRecord)object2.value;
            if (!object.deletedP()) {
                proposition3 = object.forwardGoal;
                boolean bl = false;
                boolean bl2 = bl = object.forwardRule == proposition;
                if (bl) {
                    boolean bl3 = true;
                    Stella_Object stella_Object = null;
                    Vector vector2 = vector;
                    n2 = vector2.length();
                    int n3 = Integer.MIN_VALUE;
                    int n4 = 1;
                    for (n = 0; n < n2; ++n) {
                        stella_Object = vector2.theArray[n];
                        if (Stella_Object.eqlP((Stella_Object)proposition3.arguments.theArray[n3 = n4++], (Stella_Object)stella_Object)) continue;
                        bl3 = false;
                        break;
                    }
                    bl = bl3;
                }
                if (bl) {
                    return;
                }
            }
            object2 = object2.rest;
        }
        if (Proposition.elaborationRuleP(proposition2, proposition, vector)) {
            return;
        }
        object = Logic.createProposition(Logic.SYM_STELLA_PREDICATE, vector.length() + 1);
        object2 = ForwardGoalRecord.newForwardGoalRecord();
        object2.forwardGoal = object;
        object2.forwardRule = proposition;
        proposition3 = object2;
        ((Proposition)((Object)object)).operator = Logic.SGT_PL_KERNEL_KB_HOLDS;
        ((Proposition)((Object)object)).arguments.theArray[0] = proposition.arguments.theArray[0];
        Stella_Object stella_Object = null;
        Vector vector3 = vector;
        int n5 = vector3.length();
        n = Integer.MIN_VALUE;
        n2 = 1;
        for (int i = 0; i < n5; ++i) {
            stella_Object = vector3.theArray[i];
            n = n2++;
            ((Proposition)((Object)object)).arguments.theArray[n] = stella_Object;
        }
        if (proposition2.forwardChainingGoals().emptyP()) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_CHAINING_GOALS, (Stella_Object)Stella.list((Cons)Stella_Object.cons((Stella_Object)proposition3, (Cons)Stella.NIL)), null);
        } else {
            proposition2.forwardChainingGoals().insertNew((Stella_Object)proposition3);
        }
    }

    public List forwardChainingGoals() {
        Proposition proposition = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_CHAINING_GOALS, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    public static boolean justificationPropositionsEqlP(Proposition proposition, Justification justification, Proposition proposition2, Justification justification2) {
        if (proposition.operator == proposition2.operator && proposition.arguments.length() == proposition2.arguments.length()) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = 0;
            int n2 = vector.length();
            Stella_Object stella_Object2 = null;
            Vector vector2 = proposition2.arguments;
            int n3 = vector2.length();
            for (int i = 0; n < n2 && i < n3; ++n, ++i) {
                ContextSensitiveObject contextSensitiveObject;
                stella_Object = vector.theArray[n];
                stella_Object2 = vector2.theArray[i];
                if (Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2) && !Logic.variableP(stella_Object)) continue;
                Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
                if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                    contextSensitiveObject = (Proposition)stella_Object;
                    if (Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_LOGIC_PROPOSITION) && Proposition.justificationPropositionsEqlP((Proposition)contextSensitiveObject, justification, (Proposition)stella_Object2, justification2)) continue;
                    return false;
                }
                if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    contextSensitiveObject = (PatternVariable)stella_Object;
                    if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object2), (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                        PatternVariable patternVariable = (PatternVariable)stella_Object2;
                        Stella_Object stella_Object3 = Logic.justificationArgumentBoundTo((Stella_Object)contextSensitiveObject, justification);
                        Stella_Object stella_Object4 = Logic.justificationArgumentBoundTo((Stella_Object)patternVariable, justification2);
                        if (stella_Object3 != null && stella_Object4 != null && Stella_Object.eqlP((Stella_Object)stella_Object3, (Stella_Object)stella_Object4)) continue;
                        return false;
                    }
                    if (Stella_Object.eqlP((Stella_Object)Logic.justificationArgumentBoundTo((Stella_Object)contextSensitiveObject, justification), (Stella_Object)stella_Object2)) continue;
                    return false;
                }
                if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object2), (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    contextSensitiveObject = (PatternVariable)stella_Object2;
                    if (Stella_Object.eqlP((Stella_Object)Logic.justificationArgumentBoundTo((Stella_Object)contextSensitiveObject, justification2), (Stella_Object)stella_Object)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static NamedDescription extractCollectionArgument(Proposition proposition) {
        if (proposition.kind == Logic.KWD_ISA) {
            return Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        }
        return (NamedDescription)Logic.argumentBoundTo(proposition.arguments.theArray[1]);
    }

    public static AtomicGoalCache setGoalCacheList(Proposition proposition, AtomicGoalCache atomicGoalCache) {
        NamedDescription namedDescription;
        Surrogate surrogate = Proposition.cachedGoalOperator(proposition);
        NamedDescription namedDescription2 = namedDescription = surrogate != null ? Logic.getDescription((Stella_Object)surrogate) : null;
        if (namedDescription != null && !namedDescription.deletedP()) {
            return (AtomicGoalCache)KeyValueList.setDynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE_LIST, (Stella_Object)atomicGoalCache, null);
        }
        return null;
    }

    public static AtomicGoalCache getGoalCacheList(Proposition proposition) {
        NamedDescription namedDescription;
        Surrogate surrogate = Proposition.cachedGoalOperator(proposition);
        NamedDescription namedDescription2 = namedDescription = surrogate != null ? Logic.getDescription((Stella_Object)surrogate) : null;
        if (namedDescription != null && !namedDescription.deletedP()) {
            return (AtomicGoalCache)KeyValueList.dynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE_LIST, null);
        }
        return null;
    }

    public static Surrogate cachedGoalOperator(Proposition proposition) {
        GeneralizedSymbol generalizedSymbol;
        Keyword keyword = proposition.kind;
        if ((keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) && (generalizedSymbol = proposition.operator) != null && Stella_Object.isaP((Stella_Object)generalizedSymbol, (Surrogate)Logic.SGT_STELLA_SURROGATE) && generalizedSymbol.symbolId != -1) {
            return (Surrogate)generalizedSymbol;
        }
        return null;
    }

    public static KeyValueList findGoalCacheTable(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            if (((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                return (KeyValueList)KeyValueList.dynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEGATED_GOAL_CACHE_TABLE, null);
            }
            return (KeyValueList)KeyValueList.dynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE_TABLE, null);
        }
        return null;
    }

    public static Cons yieldGoalBindings(Proposition proposition) {
        Cons cons = Stella.NIL;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        Cons cons2 = null;
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)Logic.argumentBoundTo(stella_Object), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)Logic.argumentBoundTo(stella_Object), (Cons)Stella.NIL);
        }
        return cons;
    }

    public static Stella_Object buildNetworkTree(Proposition proposition, Cons cons) {
        if (cons.memberP((Stella_Object)proposition)) {
            return FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue);
        }
        if (proposition.support() != Stella.NIL) {
            Cons cons2 = proposition.support();
            Cons cons3 = Stella.NIL;
            PartialSupport partialSupport = null;
            Cons cons4 = cons2;
            while (cons4 != Stella.NIL) {
                partialSupport = (PartialSupport)cons4.value;
                Proposition proposition2 = partialSupport.fact;
                Cons cons5 = Stella.NIL;
                Stella_Object stella_Object = null;
                Vector vector = proposition2.arguments;
                int n = vector.length();
                FloatWrapper floatWrapper = null;
                Cons cons6 = partialSupport.argumentScores;
                Cons cons7 = null;
                for (int i = 0; i < n && cons6 != Stella.NIL; ++i) {
                    stella_Object = vector.theArray[i];
                    floatWrapper = (FloatWrapper)cons6.value;
                    if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                        KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)stella_Object).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)floatWrapper.wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                        if (cons7 == null) {
                            cons7 = Stella_Object.cons((Stella_Object)Proposition.buildNetworkTree((Proposition)stella_Object, Stella_Object.cons((Stella_Object)proposition, (Cons)cons)), (Cons)Stella.NIL);
                            if (cons5 == Stella.NIL) {
                                cons5 = cons7;
                            } else {
                                Cons.addConsToEndOfConsList((Cons)cons5, (Cons)cons7);
                            }
                        } else {
                            cons7 = cons7.rest = Stella_Object.cons((Stella_Object)Proposition.buildNetworkTree((Proposition)stella_Object, Stella_Object.cons((Stella_Object)proposition, (Cons)cons)), (Cons)Stella.NIL);
                        }
                    }
                    cons6 = cons6.rest;
                }
                cons3 = (PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null) != null ? Stella_Object.cons((Stella_Object)Stella_Object.cons((Stella_Object)((PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null)), (Cons)cons5), (Cons)cons3) : Stella_Object.cons((Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue), (Cons)cons3);
                cons4 = cons4.rest;
            }
            if (cons3.rest == Stella.NIL && !Stella_Object.consP((Stella_Object)cons3.value)) {
                return cons3.value;
            }
            return cons3;
        }
        if ((PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null) != null) {
            Cons cons8 = Stella.NIL;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = 0;
            int n2 = vector.length();
            int n3 = Integer.MIN_VALUE;
            int n4 = 1;
            Cons cons9 = null;
            while (n < n2) {
                stella_Object = vector.theArray[n];
                n3 = n4;
                KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)stella_Object).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)((PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null)).input.theArray[n3]).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                if (cons9 == null) {
                    cons9 = Stella_Object.cons((Stella_Object)Proposition.buildNetworkTree((Proposition)stella_Object, Stella_Object.cons((Stella_Object)proposition, (Cons)cons)), (Cons)Stella.NIL);
                    if (cons8 == Stella.NIL) {
                        cons8 = cons9;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)cons8, (Cons)cons9);
                    }
                } else {
                    cons9 = cons9.rest = Stella_Object.cons((Stella_Object)Proposition.buildNetworkTree((Proposition)stella_Object, Stella_Object.cons((Stella_Object)proposition, (Cons)cons)), (Cons)Stella.NIL);
                }
                ++n;
                ++n4;
            }
            cons8 = Stella_Object.cons((Stella_Object)((PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null)), (Cons)cons8);
            return Stella.consList((Cons)Stella_Object.cons((Stella_Object)cons8, (Cons)Stella.NIL));
        }
        return FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue);
    }

    public static void quickpropagateError(Proposition proposition, double d) {
        block17: {
            double d2;
            double d3;
            block16: {
                Keyword keyword;
                int n;
                int n2;
                int n3;
                PropositionNeuralNetwork propositionNeuralNetwork = (PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null);
                d3 = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
                d2 = d;
                double d4 = 0.0;
                int n4 = 0;
                int n5 = 0;
                Vector vector = null;
                if (propositionNeuralNetwork != null) {
                    n4 = propositionNeuralNetwork.input.length();
                    n5 = propositionNeuralNetwork.hidden.length();
                    propositionNeuralNetwork.input.theArray[0] = FloatWrapper.wrapFloat((double)1.0);
                    int n6 = Integer.MIN_VALUE;
                    int n7 = 1;
                    int n8 = n4 - 1;
                    while (n7 <= n8) {
                        n6 = n7++;
                        propositionNeuralNetwork.input.theArray[n6] = FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)proposition.arguments.theArray[n6 - 1]).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue);
                    }
                    PropositionNeuralNetwork.activatePropositionalNeuralNetwork(propositionNeuralNetwork);
                    d *= Logic.$SIGMOID_PRIME_OFFSET$ + d3 * (1.0 - d3);
                    vector = Vector.newVector((int)n4);
                    Logic.zeroVector(vector);
                    n6 = Integer.MIN_VALUE;
                    n8 = n5 - 1;
                    for (n7 = 0; n7 <= n8; ++n7) {
                        n6 = n7;
                        propositionNeuralNetwork.hoSlope.theArray[n6] = FloatWrapper.wrapFloat((double)(((FloatWrapper)propositionNeuralNetwork.hoSlope.theArray[n6]).wrapperValue + d * ((FloatWrapper)propositionNeuralNetwork.hidden.theArray[n6]).wrapperValue));
                        d4 = d * ((FloatWrapper)propositionNeuralNetwork.ho.theArray[n6]).wrapperValue * (Logic.$SIGMOID_PRIME_OFFSET$ + ((FloatWrapper)propositionNeuralNetwork.hidden.theArray[n6]).wrapperValue * (1.0 - ((FloatWrapper)propositionNeuralNetwork.hidden.theArray[n6]).wrapperValue));
                        n3 = Integer.MIN_VALUE;
                        n2 = 0;
                        n = n4 - 1;
                        while (n2 <= n) {
                            n3 = n2++;
                            propositionNeuralNetwork.ihSlope.theArray[n3 * propositionNeuralNetwork.ihSlope.nofColumns + n6] = FloatWrapper.wrapFloat((double)(((FloatWrapper)propositionNeuralNetwork.ihSlope.theArray[n3 * propositionNeuralNetwork.ihSlope.nofColumns + n6]).wrapperValue + d4 * ((FloatWrapper)propositionNeuralNetwork.input.theArray[n3]).wrapperValue));
                            vector.theArray[n3] = FloatWrapper.wrapFloat((double)(((FloatWrapper)vector.theArray[n3]).wrapperValue + d4 * ((FloatWrapper)propositionNeuralNetwork.ih.theArray[n3 * propositionNeuralNetwork.ih.nofColumns + n6]).wrapperValue));
                        }
                    }
                }
                if ((keyword = proposition.kind) != Logic.KWD_AND && keyword != Logic.KWD_OR) break block16;
                Proposition proposition2 = null;
                Vector vector2 = proposition.arguments;
                n2 = vector2.length();
                n = Integer.MIN_VALUE;
                int n9 = 1;
                int n10 = n4 - 1;
                for (n3 = 0; n3 < n2 && n9 <= n10; ++n3) {
                    proposition2 = (Proposition)vector2.theArray[n3];
                    n = n9++;
                    Proposition.quickpropagateError(proposition2, ((FloatWrapper)vector.theArray[n]).wrapperValue);
                }
                break block17;
            }
            if (proposition.support() == Stella.NIL) break block17;
            Cons cons = proposition.support();
            Cons cons2 = Stella.NIL;
            if (Logic.$RULE_COMBINATION$ == Logic.KWD_MAX) {
                cons2 = Stella.consList((Cons)Stella_Object.cons((Stella_Object)((PartialSupport)cons.value), (Cons)Stella.NIL));
                PartialSupport partialSupport = null;
                Cons cons3 = cons.rest;
                while (cons3 != Stella.NIL) {
                    partialSupport = (PartialSupport)cons3.value;
                    if (partialSupport.score == d3) {
                        cons2 = Stella.consList((Cons)Stella_Object.cons((Stella_Object)partialSupport, (Cons)Stella.NIL));
                    }
                    cons3 = cons3.rest;
                }
            } else if (Logic.$RULE_COMBINATION$ == Logic.KWD_NOISY_OR) {
                cons2 = cons;
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + Logic.$RULE_COMBINATION$ + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            PartialSupport partialSupport = null;
            Cons cons4 = cons2;
            while (cons4 != Stella.NIL) {
                partialSupport = (PartialSupport)cons4.value;
                if (!Logic.$PARTIAL_SUPPORT_CACHE$.memberP((Stella_Object)IntegerWrapper.wrapInteger((int)partialSupport.id))) {
                    Proposition proposition3 = partialSupport.fact;
                    if (partialSupport.argumentScores.length() == 1) {
                        KeyValueList.setDynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)partialSupport.argumentScores.value).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                    } else {
                        FloatWrapper floatWrapper = null;
                        Cons cons5 = partialSupport.argumentScores;
                        Stella_Object stella_Object = null;
                        Vector vector = proposition3.arguments;
                        int n = vector.length();
                        for (int i = 0; cons5 != Stella.NIL && i < n; ++i) {
                            floatWrapper = (FloatWrapper)cons5.value;
                            stella_Object = vector.theArray[i];
                            KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)stella_Object).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)floatWrapper.wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                            cons5 = cons5.rest;
                        }
                    }
                    Logic.$PARTIAL_SUPPORT_CACHE$.push((Stella_Object)IntegerWrapper.wrapInteger((int)partialSupport.id));
                    Proposition.quickpropagateError(partialSupport.fact, d2 * partialSupport.score);
                    Logic.$PARTIAL_SUPPORT_CACHE$.pop();
                }
                cons4 = cons4.rest;
            }
        }
    }

    public static void backpropagateError(Proposition proposition, double d) {
        block26: {
            double d2;
            double d3;
            block25: {
                int n;
                Keyword keyword;
                int n2;
                int n3;
                PropositionNeuralNetwork propositionNeuralNetwork = (PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null);
                d3 = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
                int n4 = 0;
                double d4 = 0.0;
                Vector vector = null;
                Vector vector2 = null;
                Vector vector3 = null;
                Vector vector4 = null;
                int n5 = 0;
                boolean bl = false;
                d2 = d;
                if (propositionNeuralNetwork != null) {
                    n5 = propositionNeuralNetwork.input.length();
                    n4 = propositionNeuralNetwork.hidden.length();
                    vector = propositionNeuralNetwork.input;
                    vector2 = propositionNeuralNetwork.hidden;
                    propositionNeuralNetwork.input.theArray[0] = FloatWrapper.wrapFloat((double)1.0);
                    int n6 = Integer.MIN_VALUE;
                    int n7 = 1;
                    int n8 = n5 - 1;
                    while (n7 <= n8) {
                        n6 = n7++;
                        double d5 = ((FloatWrapper)propositionNeuralNetwork.input.theArray[n6]).wrapperValue;
                        if (d5 == ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)proposition.arguments.theArray[n6 - 1]).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        n6 = Integer.MIN_VALUE;
                        n7 = 1;
                        n8 = n5 - 1;
                        while (n7 <= n8) {
                            n6 = n7++;
                            propositionNeuralNetwork.input.theArray[n6] = FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)proposition.arguments.theArray[n6 - 1]).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue);
                        }
                        PropositionNeuralNetwork.activatePropositionalNeuralNetwork(propositionNeuralNetwork);
                    }
                    d = d * d3 * (1.0 - d3);
                    if (bl) {
                        vector = Vector.newVector((int)n5);
                        vector2 = Vector.newVector((int)n4);
                        n6 = Integer.MIN_VALUE;
                        n7 = 0;
                        n8 = n5 - 1;
                        while (n7 <= n8) {
                            n6 = n7++;
                            vector.theArray[n6] = (FloatWrapper)propositionNeuralNetwork.input.theArray[n6];
                        }
                        n6 = Integer.MIN_VALUE;
                        n7 = 0;
                        n8 = n4 - 1;
                        while (n7 <= n8) {
                            n6 = n7++;
                            vector2.theArray[n6] = (FloatWrapper)propositionNeuralNetwork.hidden.theArray[n6];
                        }
                    }
                    vector3 = Vector.newVector((int)n4);
                    vector4 = Vector.newVector((int)n5);
                    n6 = Integer.MIN_VALUE;
                    n7 = 0;
                    n8 = n4 - 1;
                    while (n7 <= n8) {
                        n6 = n7++;
                        vector3.theArray[n6] = FloatWrapper.wrapFloat((double)(d * ((FloatWrapper)propositionNeuralNetwork.ho.theArray[n6]).wrapperValue));
                        vector3.theArray[n6] = FloatWrapper.wrapFloat((double)(((FloatWrapper)vector3.theArray[n6]).wrapperValue * ((FloatWrapper)propositionNeuralNetwork.hidden.theArray[n6]).wrapperValue * (1.0 - ((FloatWrapper)propositionNeuralNetwork.hidden.theArray[n6]).wrapperValue)));
                    }
                    n6 = Integer.MIN_VALUE;
                    n8 = n5 - 1;
                    for (n7 = 0; n7 <= n8; ++n7) {
                        n6 = n7;
                        vector4.theArray[n6] = FloatWrapper.wrapFloat((double)0.0);
                        int n9 = Integer.MIN_VALUE;
                        n3 = 0;
                        n2 = n4 - 1;
                        while (n3 <= n2) {
                            n9 = n3++;
                            vector4.theArray[n6] = FloatWrapper.wrapFloat((double)(((FloatWrapper)vector4.theArray[n6]).wrapperValue + ((FloatWrapper)vector3.theArray[n9]).wrapperValue * ((FloatWrapper)propositionNeuralNetwork.ih.theArray[n6 * propositionNeuralNetwork.ih.nofColumns + n9]).wrapperValue));
                        }
                    }
                }
                if ((keyword = proposition.kind) != Logic.KWD_AND && keyword != Logic.KWD_OR) break block25;
                Proposition proposition2 = null;
                Vector vector5 = proposition.arguments;
                n3 = vector5.length();
                n2 = Integer.MIN_VALUE;
                int n10 = 1;
                int n11 = n5 - 1;
                for (n = 0; n < n3 && n10 <= n11; ++n) {
                    proposition2 = (Proposition)vector5.theArray[n];
                    n2 = n10++;
                    Proposition.backpropagateError(proposition2, ((FloatWrapper)vector4.theArray[n2]).wrapperValue);
                }
                int n12 = Integer.MIN_VALUE;
                int n13 = 0;
                n = n4 - 1;
                while (n13 <= n) {
                    n12 = n13++;
                    d4 = Logic.$MOMENTUM_TERM$ * ((FloatWrapper)propositionNeuralNetwork.hoDelta.theArray[n12]).wrapperValue + Logic.$LEARNING_RATE$ * d * ((FloatWrapper)vector2.theArray[n12]).wrapperValue;
                    propositionNeuralNetwork.ho.theArray[n12] = FloatWrapper.wrapFloat((double)(((FloatWrapper)propositionNeuralNetwork.ho.theArray[n12]).wrapperValue + d4));
                    propositionNeuralNetwork.hoDelta.theArray[n12] = FloatWrapper.wrapFloat((double)d4);
                }
                n12 = Integer.MIN_VALUE;
                n = n5 - 1;
                for (n13 = 0; n13 <= n; ++n13) {
                    n12 = n13;
                    n3 = Integer.MIN_VALUE;
                    n2 = 0;
                    n10 = n4 - 1;
                    while (n2 <= n10) {
                        n3 = n2++;
                        d4 = Logic.$MOMENTUM_TERM$ * ((FloatWrapper)propositionNeuralNetwork.ihDelta.theArray[n12 * propositionNeuralNetwork.ihDelta.nofColumns + n3]).wrapperValue + Logic.$LEARNING_RATE$ * ((FloatWrapper)vector3.theArray[n3]).wrapperValue * ((FloatWrapper)vector.theArray[n12]).wrapperValue;
                        propositionNeuralNetwork.ih.theArray[n12 * propositionNeuralNetwork.ih.nofColumns + n3] = FloatWrapper.wrapFloat((double)(((FloatWrapper)propositionNeuralNetwork.ih.theArray[n12 * propositionNeuralNetwork.ih.nofColumns + n3]).wrapperValue + d4));
                        propositionNeuralNetwork.ihDelta.theArray[n12 * propositionNeuralNetwork.ihDelta.nofColumns + n3] = FloatWrapper.wrapFloat((double)d4);
                    }
                }
                break block26;
            }
            if (proposition.support() == Stella.NIL) break block26;
            Cons cons = proposition.support();
            Cons cons2 = Stella.NIL;
            if (Logic.$RULE_COMBINATION$ == Logic.KWD_MAX) {
                cons2 = Stella.consList((Cons)Stella_Object.cons((Stella_Object)((PartialSupport)cons.value), (Cons)Stella.NIL));
                PartialSupport partialSupport = null;
                Cons cons3 = cons.rest;
                while (cons3 != Stella.NIL) {
                    partialSupport = (PartialSupport)cons3.value;
                    if (partialSupport.score == d3) {
                        cons2 = Stella.consList((Cons)Stella_Object.cons((Stella_Object)partialSupport, (Cons)Stella.NIL));
                    }
                    cons3 = cons3.rest;
                }
            } else if (Logic.$RULE_COMBINATION$ == Logic.KWD_NOISY_OR) {
                cons2 = cons;
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + Logic.$RULE_COMBINATION$ + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            PartialSupport partialSupport = null;
            Cons cons4 = cons2;
            while (cons4 != Stella.NIL) {
                partialSupport = (PartialSupport)cons4.value;
                if (!Logic.$PARTIAL_SUPPORT_CACHE$.memberP((Stella_Object)IntegerWrapper.wrapInteger((int)partialSupport.id))) {
                    Proposition proposition3 = partialSupport.fact;
                    if (partialSupport.argumentScores.length() == 1) {
                        KeyValueList.setDynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)partialSupport.argumentScores.value).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                    } else {
                        FloatWrapper floatWrapper = null;
                        Cons cons5 = partialSupport.argumentScores;
                        Stella_Object stella_Object = null;
                        Vector vector = proposition3.arguments;
                        int n = vector.length();
                        for (int i = 0; cons5 != Stella.NIL && i < n; ++i) {
                            floatWrapper = (FloatWrapper)cons5.value;
                            stella_Object = vector.theArray[i];
                            KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)stella_Object).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)floatWrapper.wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                            cons5 = cons5.rest;
                        }
                    }
                    Logic.$PARTIAL_SUPPORT_CACHE$.push((Stella_Object)IntegerWrapper.wrapInteger((int)partialSupport.id));
                    Proposition.backpropagateError(partialSupport.fact, d2 * partialSupport.score);
                    Logic.$PARTIAL_SUPPORT_CACHE$.pop();
                }
                cons4 = cons4.rest;
            }
        }
    }

    public static PropositionNeuralNetwork createNeuralNetwork(Proposition proposition) {
        PropositionNeuralNetwork propositionNeuralNetwork = null;
        int n = proposition.arguments.length() + 1;
        int n2 = Stella.min((int)(n + 0), (int)20);
        if (n > 100) {
            n2 = Native.floor((double)((double)n / 10.0)) + 10;
        }
        propositionNeuralNetwork = Logic.allocateNeuralNetwork(n, n2);
        Logic.$MASTER_NEURAL_NETWORK_LIST$.push((Stella_Object)propositionNeuralNetwork);
        propositionNeuralNetwork.proposition = proposition;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND || keyword == Logic.KWD_OR) {
            PropositionNeuralNetwork.randomizeNeuralNetwork(propositionNeuralNetwork);
        } else {
            PropositionNeuralNetwork.randomizeNeuralNetwork(propositionNeuralNetwork);
        }
        return propositionNeuralNetwork;
    }

    public static Cons propositionToCons(Proposition proposition) {
        Cons cons = Stella.NIL;
        Keyword keyword = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            keyword = vector.theArray[i];
            cons = Stella_Object.cons((Stella_Object)Logic.consifyArgument((Stella_Object)keyword), (Cons)cons);
        }
        keyword = proposition.kind;
        if (keyword == Logic.KWD_IN) {
            return cons;
        }
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            cons = Stella_Object.cons((Stella_Object)Surrogate.surrogateToSymbol((Surrogate)((Surrogate)proposition.operator)), (Cons)cons.reverse());
        } else if (keyword == Logic.KWD_EQUIVALENT) {
            cons = Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_e, (Cons)cons.reverse());
        } else if (keyword == Logic.KWD_FORALL || keyword == Logic.KWD_EXISTS) {
            cons = cons.rest != Stella.NIL ? Stella.consList((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_OR, (Cons)Stella_Object.cons((Stella_Object)Stella.consList((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_NOT, (Cons)Stella_Object.cons((Stella_Object)cons.rest.value, (Cons)Stella.NIL))), (Cons)Stella_Object.cons((Stella_Object)cons.value, (Cons)Stella.NIL)))) : (Cons)cons.value;
            vector = Stella.NIL;
            PatternVariable patternVariable = null;
            Vector vector2 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n2 = vector2.length();
            for (int i = 0; i < n2; ++i) {
                patternVariable = (PatternVariable)vector2.theArray[i];
                if (Logic.argumentBoundTo((Stella_Object)patternVariable) != null) continue;
                vector = Stella_Object.cons((Stella_Object)Stella.consList((Cons)Stella_Object.cons((Stella_Object)Stella.internSymbol((String)Skolem.getSkolemPrintName(patternVariable)), (Cons)Stella_Object.cons((Stella_Object)Stella.internSymbol((String)Logic.logicalType((Stella_Object)patternVariable).symbolName), (Cons)Stella.NIL))), (Cons)vector);
            }
            if (vector != Stella.NIL) {
                cons = Stella.consList((Cons)Stella_Object.cons((Stella_Object)Stella.internSymbol((String)proposition.kind.symbolName), (Cons)Stella_Object.cons((Stella_Object)vector, (Cons)Stella_Object.cons((Stella_Object)cons, (Cons)Stella.NIL))));
            }
        } else {
            cons = Stella_Object.cons((Stella_Object)Stella.internSymbol((String)((Surrogate)proposition.operator).symbolName), (Cons)cons.reverse());
        }
        if (Proposition.falseP(proposition)) {
            return Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_NOT, (Cons)Stella_Object.cons((Stella_Object)cons, (Cons)Stella_Object.cons((Stella_Object)Stella.NIL, (Cons)Stella.NIL))));
        }
        return cons;
    }

    public static boolean partialArgumentsUnifyWithArgumentsP(Proposition proposition, Proposition proposition2) {
        PatternRecord patternRecord = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord;
        int n = patternRecord.topUnbindingStackOffset;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Stella_Object stella_Object = null;
        Vector vector = proposition2.arguments;
        int n2 = 0;
        int n3 = vector.length();
        Stella_Object stella_Object2 = null;
        Vector vector2 = proposition.arguments;
        int n4 = vector2.length();
        for (int i = 0; n2 < n3 && i < n4; ++n2, ++i) {
            stella_Object = vector.theArray[n2];
            stella_Object2 = vector2.theArray[i];
            if (Logic.nullInstanceP(stella_Object2) || Logic.nullInstanceP(stella_Object) || Logic.bindArgumentToValueP(stella_Object, Logic.valueOf(stella_Object2), false)) continue;
            bl3 = false;
            break;
        }
        if (bl2 = bl3) {
            boolean bl4 = bl2 = proposition2.arguments.length() == proposition.arguments.length();
        }
        if (!(bl = bl2)) {
            PatternRecord.unbindVariablesBeginningAt(patternRecord, n + 1);
        }
        return bl;
    }

    public static Iterator allMatchingPartialPropositions(Proposition proposition) {
        Cons cons = Stella_Object.cons((Stella_Object)Logic.KWD_RELATION, (Cons)Stella_Object.cons((Stella_Object)(Stella.NIL == null ? Stella.NIL : Stella.NIL), (Cons)Stella_Object.cons((Stella_Object)((Surrogate)proposition.operator), (Cons)Stella_Object.cons((Stella_Object)Logic.getNullInstance(), (Cons)Stella.NIL))));
        SpecializingPropositionsIterator specializingPropositionsIterator = SpecializingPropositionsIterator.newSpecializingPropositionsIterator();
        specializingPropositionsIterator.selectionPattern = cons;
        specializingPropositionsIterator.propositionCursor = Logic.selectPropositions(cons).allocateIterator();
        SpecializingPropositionsIterator specializingPropositionsIterator2 = specializingPropositionsIterator;
        return specializingPropositionsIterator2;
    }

    public static boolean allVariablesUnboundP(Proposition proposition) {
        boolean bl = false;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (Logic.argumentBoundTo(stella_Object) == null) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    public static Cons getUnboundVariables(Proposition proposition) {
        Cons cons = Stella.NIL;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            Stella_Object stella_Object2 = Logic.argumentBoundTo(stella_Object);
            if (stella_Object2 != null) continue;
            cons = Stella_Object.cons((Stella_Object)stella_Object, (Cons)cons);
        }
        return cons;
    }

    public static Iterator allMatchingExtensionMembers(Proposition proposition, boolean bl) {
        DescriptionExtensionIterator descriptionExtensionIterator = NamedDescription.allTrueExtensionMembers(Logic.surrogateToDescription((Surrogate)proposition.operator), bl);
        descriptionExtensionIterator.referenceProposition = proposition;
        return descriptionExtensionIterator;
    }

    public static boolean collectionofPropositionP(Proposition proposition) {
        return Logic.logicalSubtypeOfP((Surrogate)proposition.operator, Logic.SGT_PL_KERNEL_KB_COLLECTIONOF);
    }

    public static boolean allKeyArgumentsBoundP(Proposition proposition) {
        if (proposition.kind == Logic.KWD_FUNCTION || Proposition.singleValuedPredicateP(proposition)) {
            if ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null) != null) {
                int n = 1;
                int n2 = Integer.MIN_VALUE;
                int n3 = 0;
                int n4 = proposition.arguments.length() - 2;
                while (n3 <= n4) {
                    if (Logic.quantifiedArgumentBoundP(proposition.arguments.theArray[n2 = n3++], null)) continue;
                    n = 0;
                    break;
                }
                n2 = n;
                return n2 != 0;
            }
            int n = 1;
            int n5 = Integer.MIN_VALUE;
            int n6 = 0;
            int n7 = proposition.arguments.length() - 2;
            while (n6 <= n7) {
                if (Logic.argumentBoundP(proposition.arguments.theArray[n5 = n6++])) continue;
                n = 0;
                break;
            }
            n5 = n;
            return n5 != 0;
        }
        return false;
    }

    public static boolean allArgumentsBoundP(Proposition proposition) {
        if ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null) != null) {
            return Logic.quantifiedArgumentBoundP((Stella_Object)proposition, null);
        }
        return Logic.argumentBoundP((Stella_Object)proposition);
    }

    public boolean clusteredConjunctionP() {
        Proposition proposition = this;
        boolean bl = false;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (((Proposition)stella_Object).kind != Logic.KWD_AND) continue;
            bl = true;
            break;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean containsOperatorP(Proposition proposition, Surrogate surrogate) {
        boolean bl;
        boolean bl2 = false;
        if (proposition.operator == surrogate) {
            bl2 = true;
        } else {
            bl = false;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION) || !Proposition.containsOperatorP((Proposition)stella_Object, surrogate)) continue;
                bl = true;
                break;
            }
            bl2 = bl;
        }
        bl = bl2;
        return bl;
    }

    public static void printSatellites(Proposition proposition) {
        Proposition proposition2 = null;
        Cons cons = proposition.satellitePropositions().theConsList;
        while (cons != Stella.NIL) {
            proposition2 = (Proposition)cons.value;
            System.out.println((Object)proposition2);
            cons = cons.rest;
        }
    }

    public static void deriveComplexForwardRule(Proposition proposition, Proposition proposition2) {
        NamedDescription namedDescription = proposition.kind == Logic.KWD_NOT ? NamedDescription.getComplementOfGoalDescription(Logic.surrogateToDescription((Surrogate)((Proposition)proposition.arguments.theArray[0]).operator)) : Logic.surrogateToDescription((Surrogate)proposition.operator);
        ForwardChainingIndex forwardChainingIndex = null;
        ForwardChainingIndex forwardChainingIndex2 = null;
        Cons cons = namedDescription.forwardChainingIndices().theConsList;
        while (cons != Stella.NIL) {
            forwardChainingIndex2 = (ForwardChainingIndex)cons.value;
            if (proposition == forwardChainingIndex2.forwardGoal) {
                forwardChainingIndex = forwardChainingIndex2;
            }
            cons = cons.rest;
        }
        if (forwardChainingIndex != null) {
            namedDescription.forwardChainingIndices().remove(forwardChainingIndex);
        }
        if (namedDescription.forwardChainingIndices() == Stella.NIL_LIST) {
            KeyValueList.setDynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_CHAINING_INDICES, (Stella_Object)Stella.list((Cons)Stella.NIL), null);
        }
        namedDescription.forwardChainingIndices().insert((Stella_Object)Proposition.createForwardChainingIndex(proposition, proposition2));
    }

    public static ForwardChainingIndex createForwardChainingIndex(Proposition proposition, Proposition proposition2) {
        ForwardChainingIndex forwardChainingIndex = ForwardChainingIndex.newForwardChainingIndex();
        KeyValueList keyValueList = KeyValueList.newKeyValueList();
        Proposition proposition3 = Proposition.copyProposition(proposition2, keyValueList);
        Stella_Object stella_Object = keyValueList.lookup((Stella_Object)proposition);
        proposition3 = Proposition.substituteProposition(proposition3, (Proposition)stella_Object, Logic.TRUE_PROPOSITION);
        Cons cons = null;
        List list = Stella.list((Cons)Stella.NIL);
        Cons cons2 = Stella.NIL;
        Cons cons3 = Stella.NIL;
        Cons cons4 = null;
        Cons cons5 = null;
        Cons cons6 = null;
        Stella_Object stella_Object2 = null;
        Cons cons7 = null;
        Cons cons8 = new Object[2];
        cons6 = Logic.deconstructForallTree((Cons)Proposition.generateProposition(proposition3), (Object[])cons8);
        stella_Object2 = (Stella_Object)cons8[0];
        cons7 = (Cons)cons8[1];
        cons = cons6;
        cons4 = (Cons)stella_Object2;
        cons5 = cons7;
        Logic.collectFreeVariables((Stella_Object)proposition, list, Stella.list((Cons)Stella.NIL), Stella.list((Cons)Stella.NIL));
        cons6 = Stella.NIL;
        stella_Object2 = null;
        cons7 = list.theConsList;
        cons8 = null;
        while (cons7 != Stella.NIL) {
            stella_Object2 = cons7.value;
            if (cons8 == null) {
                cons8 = Stella_Object.cons((Stella_Object)((PatternVariable)stella_Object2).skolemName, (Cons)Stella.NIL);
                if (cons6 == Stella.NIL) {
                    cons6 = cons8;
                } else {
                    Cons.addConsToEndOfConsList((Cons)cons6, (Cons)cons8);
                }
            } else {
                cons8 = cons8.rest = Stella_Object.cons((Stella_Object)((PatternVariable)stella_Object2).skolemName, (Cons)Stella.NIL);
            }
            cons7 = cons7.rest;
        }
        cons2 = cons6;
        cons6 = null;
        stella_Object2 = cons;
        cons7 = null;
        while (stella_Object2 != Stella.NIL) {
            cons6 = stella_Object2.value;
            if (!Stella_Object.searchConsTreeP((Stella_Object)cons5, (Stella_Object)cons6)) {
                if (cons7 == null) {
                    cons7 = Stella_Object.cons((Stella_Object)cons6, (Cons)Stella.NIL);
                    if (cons3 == Stella.NIL) {
                        cons3 = cons7;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)cons3, (Cons)cons7);
                    }
                } else {
                    cons7 = cons7.rest = Stella_Object.cons((Stella_Object)cons6, (Cons)Stella.NIL);
                }
            }
            stella_Object2 = stella_Object2.rest;
        }
        cons = cons.subtract(cons3);
        forwardChainingIndex.consequent = (Description)Logic.valueOf(Logic.conceiveTerm((Stella_Object)Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_LOGIC_KAPPA, (Cons)Stella_Object.cons((Stella_Object)((Cons)Stella_Object.copyConsTree((Stella_Object)cons)), (Cons)Stella_Object.cons((Stella_Object)Stella_Object.cons((Stella_Object)cons5, (Cons)Stella.NIL), (Cons)Stella.NIL))))));
        if ((cons3 = cons3.subtract(cons2)) != Stella.NIL) {
            cons4 = Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_EXISTS, (Cons)Stella_Object.cons((Stella_Object)cons3, (Cons)Stella_Object.cons((Stella_Object)Stella_Object.cons((Stella_Object)cons4, (Cons)Stella.NIL), (Cons)Stella.NIL))));
        }
        forwardChainingIndex.ioVariables = cons = cons2.concatenate(cons, Stella.NIL);
        forwardChainingIndex.queryBody = cons4;
        cons6 = Stella.NIL;
        stella_Object2 = null;
        cons7 = cons;
        cons8 = null;
        while (cons7 != Stella.NIL) {
            stella_Object2 = cons7.value;
            if (stella_Object2 != null) {
                if (cons8 == null) {
                    cons8 = Stella_Object.cons(null, (Cons)Stella.NIL);
                    if (cons6 == Stella.NIL) {
                        cons6 = cons8;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)cons6, (Cons)cons8);
                    }
                } else {
                    cons8 = cons8.rest = Stella_Object.cons(null, (Cons)Stella.NIL);
                }
            }
            cons7 = cons7.rest;
        }
        forwardChainingIndex.inputBindings = cons6;
        forwardChainingIndex.forwardGoal = proposition;
        forwardChainingIndex.masterRule = proposition2;
        forwardChainingIndex.cacheId = Stella.gensym((String)"FWD-QUERY");
        return forwardChainingIndex;
    }

    public static Proposition deriveImpliesFromForall(Proposition proposition) {
        List list = Proposition.findMatchableGoals(proposition, Logic.KWD_HEAD);
        List list2 = Proposition.findMatchableGoals(proposition, Logic.KWD_TAIL);
        Proposition proposition2 = (Proposition)list.first();
        Proposition proposition3 = (Proposition)list2.first();
        Proposition proposition4 = (Proposition)proposition.arguments.theArray[1];
        Proposition proposition5 = (Proposition)proposition.arguments.theArray[0];
        boolean bl = false;
        boolean bl2 = bl = list.length() == 1;
        if (bl) {
            boolean bl3 = bl = list2.length() == 1;
            if (bl) {
                boolean bl4 = true;
                Stella_Object stella_Object = null;
                Vector vector = proposition2.arguments;
                int n = 0;
                int n2 = vector.length();
                Stella_Object stella_Object2 = null;
                Vector vector2 = proposition3.arguments;
                int n3 = vector2.length();
                for (int i = 0; n < n2 && i < n3; ++n, ++i) {
                    stella_Object = vector.theArray[n];
                    stella_Object2 = vector2.theArray[i];
                    if (Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2) && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) continue;
                    bl4 = false;
                    break;
                }
                if (bl = bl4) {
                    boolean bl5 = bl = proposition2.arguments.length() == proposition3.arguments.length();
                    if (bl) {
                        boolean bl6 = bl = (Proposition)list.first() == proposition4;
                        if (bl) {
                            if ((Proposition)list2.first() == proposition5) {
                                bl = true;
                            } else {
                                boolean bl7 = bl = proposition5.kind == Logic.KWD_AND;
                                if (bl) {
                                    bl4 = true;
                                    stella_Object = null;
                                    vector = proposition5.arguments;
                                    n2 = vector.length();
                                    for (n = 0; n < n2; ++n) {
                                        stella_Object = vector.theArray[n];
                                        if (stella_Object == proposition3) continue;
                                        bl4 = false;
                                        break;
                                    }
                                    bl = bl4;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            return Logic.createImpliesProposition((Stella_Object)Proposition.extractGoalDescription(proposition3, null), (Stella_Object)Proposition.extractGoalDescription(proposition2, null));
        }
        return null;
    }

    public static void deriveSatelliteRules(Proposition proposition) {
        if (!Proposition.deriveSatelliteRulesForGoalP(proposition, null, Logic.naturalDeductionModeP() ? Logic.KWD_POSITIVE : Logic.KWD_POSITIVE_AND_CONTRAPOSITIVE, Logic.$LAZY_SATELLITE_RULESp$)) {
            if (Logic.$CYC_KLUDGES_ENABLEDp$ && Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[1], (Surrogate)Logic.SGT_LOGIC_PROPOSITION) && ((Proposition)proposition.arguments.theArray[1]).kind == Logic.KWD_EXISTS) {
                return;
            }
            Stella.STANDARD_WARNING.nativeStream.println("Warning: PowerLoom can't index the rule:");
            Stella.STANDARD_WARNING.nativeStream.println("   `" + (Object)((Object)proposition) + "'");
            Stella.STANDARD_WARNING.nativeStream.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deriveSatelliteRulesForGoalP(Proposition proposition, Description description, Keyword keyword, boolean bl) {
        Logic.finalizeObjects();
        boolean bl2 = false;
        Description description2 = null;
        boolean bl3 = keyword == Logic.KWD_POSITIVE;
        boolean bl4 = keyword == Logic.KWD_CONTRAPOSITIVE;
        Object object = Stella.$CONTEXT$.get();
        Object object2 = Stella.$MODULE$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)proposition.homeContext);
            Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
            Object object3 = null;
            Object object4 = Proposition.findMatchableGoals((Proposition)proposition, (Keyword)Logic.KWD_HEAD).theConsList;
            while (object4 != Stella.NIL) {
                object3 = (Proposition)object4.value;
                if (description == null || description == Proposition.extractGoalDescription(object3, Logic.KWD_HEAD)) {
                    bl2 = true;
                    if (bl) {
                        description2 = description == null ? Proposition.extractGoalDescription(object3, Logic.KWD_HEAD) : description;
                        if ((SequenceIndex)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RULES_WITH_DEFERRED_SATELLITES, null) == null) {
                            KeyValueList.setDynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RULES_WITH_DEFERRED_SATELLITES, (Stella_Object)Logic.createSequenceIndex((Stella_Object)Logic.KWD_NON_PAGING, Stella.NIL), null);
                        }
                        ((SequenceIndex)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RULES_WITH_DEFERRED_SATELLITES, null)).insert((Stella_Object)proposition);
                    } else if (!bl4) {
                        Proposition.deriveOneSatelliteRule(proposition, object3, Logic.KWD_HEAD, false);
                    }
                    if (!(bl3 || ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue || Proposition.atomicForallArgumentP(proposition, Logic.KWD_TAIL))) {
                        if (bl) {
                            KeyValueList.setDynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DEFERRED_CONTRAPOSITIVESp, (Stella_Object)Stella.TRUE_WRAPPER, null);
                        } else {
                            Proposition.deriveOneSatelliteRule(proposition, object3, Logic.KWD_HEAD, true);
                        }
                    }
                }
                object4 = object4.rest;
            }
            if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && (Proposition.atomicForallArgumentP(proposition, Logic.KWD_TAIL) || !Proposition.atomicForallArgumentP(proposition, Logic.KWD_HEAD) || ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue)) {
                object3 = null;
                object4 = Proposition.findMatchableGoals((Proposition)proposition, (Keyword)Logic.KWD_TAIL).theConsList;
                while (object4 != Stella.NIL) {
                    object3 = (Proposition)object4.value;
                    if (description == null || description == Proposition.extractGoalDescription(object3, Logic.KWD_TAIL)) {
                        bl2 = true;
                        if (bl) {
                            description2 = description == null ? Proposition.extractGoalDescription(object3, Logic.KWD_TAIL) : description;
                            if ((SequenceIndex)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RULES_WITH_DEFERRED_SATELLITES, null) == null) {
                                KeyValueList.setDynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RULES_WITH_DEFERRED_SATELLITES, (Stella_Object)Logic.createSequenceIndex((Stella_Object)Logic.KWD_NON_PAGING, Stella.NIL), null);
                            }
                            ((SequenceIndex)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RULES_WITH_DEFERRED_SATELLITES, null)).insert((Stella_Object)proposition);
                        } else if (!bl4) {
                            Proposition.deriveOneSatelliteRule(proposition, object3, Logic.KWD_TAIL, false);
                        }
                        if (!(bl3 || ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue || Proposition.atomicForallArgumentP(proposition, Logic.KWD_HEAD))) {
                            if (bl) {
                                KeyValueList.setDynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DEFERRED_CONTRAPOSITIVESp, (Stella_Object)Stella.TRUE_WRAPPER, null);
                            } else {
                                Proposition.deriveOneSatelliteRule(proposition, object3, Logic.KWD_TAIL, true);
                            }
                        }
                    }
                    object4 = object4.rest;
                }
            }
            if (bl2 && (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) != null) {
                object3 = Stella.$CONTEXT$.get();
                object4 = Stella.$MODULE$.get();
                try {
                    Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)proposition.homeContext);
                    Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
                    Object object5 = Logic.$INVISIBLEASSERTIONp$.get();
                    try {
                        Native.setBooleanSpecial((ThreadLocal)Logic.$INVISIBLEASSERTIONp$, (boolean)true);
                        Proposition proposition2 = null;
                        Cons cons = proposition.satellitePropositions().theConsList;
                        while (cons != Stella.NIL) {
                            proposition2 = (Proposition)cons.value;
                            Proposition.assignTruthValue(proposition2, (Stella_Object)((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)));
                            cons = cons.rest;
                        }
                    }
                    finally {
                        Logic.$INVISIBLEASSERTIONp$.set(object5);
                    }
                }
                finally {
                    Stella.$MODULE$.set(object4);
                    Stella.$CONTEXT$.set(object3);
                }
            }
            boolean bl5 = bl2;
            return bl5;
        }
        finally {
            Stella.$MODULE$.set(object2);
            Stella.$CONTEXT$.set(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deriveOneSatelliteRule(Proposition proposition, Proposition proposition2, Keyword keyword, boolean bl) {
        Proposition proposition3 = null;
        Description description = null;
        Description description2 = null;
        boolean bl2 = false;
        if (!(keyword != Logic.KWD_TAIL || Proposition.atomicGoalPropositionP((Proposition)proposition.arguments.theArray[0]) && !Proposition.variableArityGoalPropositionP((Proposition)proposition.arguments.theArray[0]) || bl)) {
            Proposition.deriveComplexForwardRule(proposition2, proposition);
            return;
        }
        Object object = Logic.$EVALUATIONMODE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
            proposition3 = Proposition.invertForallAroundGoal(proposition, proposition2, keyword, bl);
        }
        finally {
            Logic.$EVALUATIONMODE$.set(object);
        }
        if (proposition3 == null) {
            return;
        }
        if (bl) {
            if (keyword == Logic.KWD_HEAD) {
                keyword = Logic.KWD_TAIL;
            } else if (keyword == Logic.KWD_TAIL) {
                keyword = Logic.KWD_HEAD;
            } else {
                object = OutputStringStream.newOutputStringStream();
                ((OutputStringStream)object).nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)object.theStringReader()).fillInStackTrace();
            }
        }
        if (keyword == Logic.KWD_HEAD) {
            description = Proposition.extractGoalDescription((Proposition)proposition3.arguments.theArray[1], null);
            description2 = (Description)Proposition.constructDescriptionFromForallProposition(proposition3, Logic.KWD_TAIL);
        } else if (keyword == Logic.KWD_TAIL) {
            description2 = Proposition.extractGoalDescription((Proposition)proposition3.arguments.theArray[0], null);
            description = (Description)Proposition.constructDescriptionFromForallProposition(proposition3, Logic.KWD_HEAD);
        } else {
            object = OutputStringStream.newOutputStringStream();
            ((OutputStringStream)object).nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)object.theStringReader()).fillInStackTrace();
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && keyword == Logic.KWD_HEAD) {
            boolean bl3 = bl2 = Description.namedDescriptionP(description) && Description.namedDescriptionP(description2) && description.arity() == description2.arity();
            if (!bl2) {
                return;
            }
        }
        object = Logic.createImpliesProposition((Stella_Object)description2, (Stella_Object)description);
        Object object2 = Logic.$EVALUATIONMODE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_EXTENSIONAL_ASSERTION);
            Proposition proposition4 = Proposition.recursivelyFastenDownPropositions((Proposition)((Object)object), false);
            if (proposition4 != object) {
                object = proposition4;
            } else if (keyword == Logic.KWD_TAIL) {
                Proposition.markAsForwardRule((Proposition)((Object)object));
            }
        }
        finally {
            Logic.$EVALUATIONMODE$.set(object2);
        }
        if (proposition.satellitePropositions().emptyP()) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SATELLITE_PROPOSITIONS, (Stella_Object)List.newList(), null);
        }
        proposition.satellitePropositions().insertNew((Stella_Object)object);
        KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)((Object)object)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, (Stella_Object)proposition, null);
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && !bl2) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)((Object)object)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            } else {
                KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)((Object)object)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            }
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)((Object)object)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            } else {
                KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)((Object)object)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            }
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)((Proposition)((Object)object)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            description2 = (Description)((Proposition)((Object)object)).arguments.theArray[0];
            if (description2.nativeRelation() == null) {
                KeyValueList.setDynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            }
            if ((description = (Description)((Proposition)((Object)object)).arguments.theArray[1]).nativeRelation() == null) {
                KeyValueList.setDynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            }
        }
    }

    public static void markAsForwardRule(Proposition proposition) {
        Description description = (Description)proposition.arguments.theArray[1];
        if (!Description.namedDescriptionP(description) && (Description)KeyValueList.dynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_COMPLEMENT_DESCRIPTION, null) == null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stella_Object constructDescriptionFromForallProposition(Proposition proposition, Keyword keyword) {
        Description description = Description.newDescription();
        description.proposition = (Proposition)proposition.arguments.theArray[keyword == Logic.KWD_HEAD ? 1 : 0];
        description.ioVariables = ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null)).copy();
        Object object = Logic.$EVALUATIONMODE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
            Description description2 = Description.finishBuildingDescription(description, true);
            return description2;
        }
        finally {
            Logic.$EVALUATIONMODE$.set(object);
        }
    }

    public static Proposition invertForallAroundGoal(Proposition proposition, Proposition proposition2, Keyword keyword, boolean bl) {
        Object object;
        Stella_Object stella_Object;
        KeyValueList keyValueList = KeyValueList.newKeyValueList();
        Proposition proposition3 = Proposition.copyProposition(proposition, keyValueList);
        Object object2 = proposition3.arguments.theArray[1];
        Object object3 = proposition3.arguments.theArray[0];
        Proposition proposition4 = (Proposition)keyValueList.lookup((Stella_Object)proposition2);
        Cons cons = Proposition.extractGoalArguments(proposition4);
        Proposition proposition5 = null;
        Proposition proposition6 = null;
        Proposition proposition7 = null;
        Proposition proposition8 = null;
        if (bl) {
            object2 = Proposition.invertProposition((Proposition)((Object)object2));
            object3 = Proposition.invertProposition((Proposition)((Object)object3));
            proposition4 = Proposition.extractInvertedGoal(keyword == Logic.KWD_HEAD ? (Proposition)((Object)object2) : (Proposition)((Object)object3), proposition4);
            if (proposition4 == null) {
                System.out.println("Unable to generate contrapositive rule for goal `" + (Object)((Object)proposition2) + "'");
                System.out.println("in `" + (Object)((Object)proposition) + "'");
                return null;
            }
            proposition3.arguments.theArray[0] = object2;
            proposition3.arguments.theArray[1] = object3;
            object2 = object3;
            object3 = proposition3.arguments.theArray[0];
            keyword = keyword == Logic.KWD_HEAD ? Logic.KWD_TAIL : Logic.KWD_HEAD;
        }
        boolean bl2 = false;
        boolean bl3 = bl2 = proposition4 == (keyword == Logic.KWD_HEAD ? object2 : object3);
        if (bl2) {
            boolean bl4 = true;
            stella_Object = null;
            Cons cons2 = cons;
            PatternVariable patternVariable = null;
            object = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n = object.length();
            for (int i = 0; cons2 != Stella.NIL && i < n; ++i) {
                stella_Object = cons2.value;
                patternVariable = (PatternVariable)object.theArray[i];
                if (stella_Object != patternVariable) {
                    bl4 = false;
                    break;
                }
                cons2 = cons2.rest;
            }
            if (bl2 = bl4) {
                boolean bl5 = bl2 = cons.length() == ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null)).length();
            }
        }
        if (bl2) {
            return proposition3;
        }
        if (keyword == Logic.KWD_HEAD) {
            proposition5 = Proposition.substituteProposition((Proposition)((Object)object2), proposition4, Logic.FALSE_PROPOSITION);
            Proposition.normalizeProposition(proposition5);
            if (proposition5.operator == Logic.SGT_STELLA_FALSE) {
                proposition8 = (Proposition)((Object)object3);
            } else {
                object3 = Proposition.invertProposition((Proposition)((Object)object3));
                proposition8 = Logic.disjoinPropositions(Stella.consList((Cons)Stella_Object.cons((Stella_Object)object3, (Cons)Stella_Object.cons((Stella_Object)proposition5, (Cons)Stella.NIL))));
                proposition8 = Proposition.invertProposition(proposition8);
                Proposition.normalizeProposition(proposition8);
            }
            proposition3.arguments.theArray[0] = proposition8;
            proposition3.arguments.theArray[1] = proposition4;
        } else if (keyword == Logic.KWD_TAIL) {
            proposition6 = Proposition.substituteProposition((Proposition)((Object)object3), proposition4, Logic.TRUE_PROPOSITION);
            Proposition.normalizeProposition(proposition6);
            if (proposition6.operator == Logic.SGT_STELLA_TRUE) {
                proposition7 = (Proposition)((Object)object2);
            } else {
                Cons cons3 = Stella.NIL;
                proposition6 = Proposition.invertProposition(proposition6);
                proposition7 = Logic.disjoinPropositions(Stella.consList((Cons)Stella_Object.cons((Stella_Object)proposition6, (Cons)Stella_Object.cons((Stella_Object)object2, (Cons)Stella.NIL))));
                ContextSensitiveObject contextSensitiveObject = null;
                stella_Object = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
                int n = stella_Object.length();
                object = null;
                for (int i = 0; i < n; ++i) {
                    contextSensitiveObject = (PatternVariable)stella_Object.theArray[i];
                    if (cons.memberP((Stella_Object)contextSensitiveObject)) continue;
                    if (object == null) {
                        object = Stella_Object.cons((Stella_Object)contextSensitiveObject, (Cons)Stella.NIL);
                        if (cons3 == Stella.NIL) {
                            cons3 = object;
                            continue;
                        }
                        Cons.addConsToEndOfConsList((Cons)cons3, (Cons)object);
                        continue;
                    }
                    object.rest = Stella_Object.cons((Stella_Object)contextSensitiveObject, (Cons)Stella.NIL);
                    object = object.rest;
                }
                if (cons3 != Stella.NIL) {
                    contextSensitiveObject = Logic.createProposition(Logic.SYM_STELLA_FORALL, 2);
                    KeyValueList.setDynamicSlotValue((KeyValueList)contextSensitiveObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyConsListToVariablesVector(cons3), null);
                    contextSensitiveObject.arguments.theArray[0] = Logic.TRUE_PROPOSITION;
                    contextSensitiveObject.arguments.theArray[1] = proposition7;
                    proposition7 = contextSensitiveObject;
                }
                Proposition.normalizeProposition(proposition7);
            }
            proposition3.arguments.theArray[0] = proposition4;
            proposition3.arguments.theArray[1] = proposition7;
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        Cons cons4 = Proposition.extractGoalArguments(proposition4);
        Stella_Object stella_Object2 = null;
        stella_Object = cons4;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (stella_Object != Stella.NIL) {
            stella_Object2 = stella_Object.value;
            n = n2;
            if (!Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                object = Logic.createVariable(null, null, false);
                Skolem.updateSkolemType((Skolem)((Object)object), Logic.logicalType(stella_Object2));
                cons4.nthSetter((Stella_Object)object, n);
                if (keyword == Logic.KWD_HEAD) {
                    proposition3.arguments.theArray[0] = Proposition.conjoinTwoPropositions(Logic.createEquivalenceProposition((Stella_Object)object, stella_Object2), (Proposition)proposition3.arguments.theArray[0]);
                } else if (keyword == Logic.KWD_TAIL) {
                    Proposition proposition9 = Logic.createEquivalenceProposition((Stella_Object)object, stella_Object2);
                    Proposition.invertProposition(proposition9);
                    proposition3.arguments.theArray[1] = Logic.disjoinPropositions(Stella.consList((Cons)Stella_Object.cons((Stella_Object)proposition9, (Cons)Stella_Object.cons((Stella_Object)proposition3.arguments.theArray[1], (Cons)Stella.NIL))));
                } else {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
                }
                Proposition.normalizeProposition((Proposition)proposition3.arguments.theArray[0]);
            }
            stella_Object = stella_Object.rest;
            ++n2;
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyConsListToVariablesVector(cons4), null);
        Proposition.recursivelyFastenDownPropositions(proposition3, false);
        return proposition3;
    }

    public static Proposition extractInvertedGoal(Proposition proposition, Proposition proposition2) {
        if (proposition2.kind == Logic.KWD_NOT) {
            return Proposition.extractInvertedGoal(proposition, (Proposition)proposition2.arguments.theArray[0]);
        }
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_NOT) {
            if (Proposition.equivalentPropositionsP((Proposition)proposition.arguments.theArray[0], proposition2, null)) {
                return proposition;
            }
            return Proposition.extractInvertedGoal((Proposition)proposition.arguments.theArray[0], proposition2);
        }
        if (keyword == Logic.KWD_AND || keyword == Logic.KWD_OR) {
            Proposition proposition3 = null;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                proposition3 = Proposition.extractInvertedGoal((Proposition)stella_Object, proposition2);
                if (proposition3 == null) continue;
                return proposition3;
            }
        } else if (Proposition.equivalentPropositionsP(proposition, proposition2, null)) {
            return proposition;
        }
        return null;
    }

    public static Proposition substituteProposition(Proposition proposition, Proposition proposition2, Proposition proposition3) {
        if (proposition == proposition2) {
            return proposition3;
        }
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = 0;
        int n2 = vector.length();
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        while (n < n2) {
            stella_Object = vector.theArray[n];
            n3 = n4;
            if (stella_Object == proposition2) {
                proposition.arguments.theArray[n3] = proposition3;
            } else if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                Proposition.substituteProposition((Proposition)stella_Object, proposition2, proposition3);
            }
            ++n;
            ++n4;
        }
        return proposition;
    }

    public static Cons extractGoalArguments(Proposition proposition) {
        Vector vector = proposition.arguments;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_IMPLIES) {
            Cons cons = Stella.NIL;
            Stella_Object stella_Object = null;
            Vector vector2 = vector;
            int n = vector2.length();
            Cons cons2 = null;
            for (int i = 0; i < n; ++i) {
                stella_Object = vector2.theArray[i];
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                    if (cons == Stella.NIL) {
                        cons = cons2;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                    continue;
                }
                cons2 = cons2.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
            }
            return cons;
        }
        if (keyword == Logic.KWD_NOT) {
            return Proposition.extractGoalArguments((Proposition)vector.theArray[0]);
        }
        return Stella.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Description extractGoalDescription(Proposition proposition, Keyword keyword) {
        Description description;
        Vector vector = proposition.arguments;
        Keyword keyword2 = proposition.kind;
        if (keyword2 == Logic.KWD_ISA || keyword2 == Logic.KWD_PREDICATE || keyword2 == Logic.KWD_FUNCTION || keyword2 == Logic.KWD_IMPLIES) {
            if (Stella_Object.isaP((Stella_Object)proposition.operator, (Surrogate)Logic.SGT_STELLA_SURROGATE)) {
                NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
                if (namedDescription == null) {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    Object object = Stella.$PRINTREADABLYp$.get();
                    try {
                        Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                        outputStringStream.nativeStream.println("ERROR: Can't finalize relations because relation `" + ((Surrogate)proposition.operator).symbolName + "' is undefined..");
                        Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                    }
                    finally {
                        Stella.$PRINTREADABLYp$.set(object);
                    }
                    throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
                }
                if (NamedDescription.chainableRelationP(namedDescription, keyword)) {
                    return namedDescription;
                }
            }
        } else if (keyword2 == Logic.KWD_NOT && (description = Proposition.extractGoalDescription((Proposition)vector.theArray[0], keyword)) != null) {
            return NamedDescription.getComplementOfGoalDescription((NamedDescription)description);
        }
        return null;
    }

    public static boolean variableArityGoalPropositionP(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            Description description = Proposition.extractGoalDescription(proposition, null);
            return description != null && Description.variableArityP(description);
        }
        return false;
    }

    public static boolean atomicGoalPropositionP(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_IMPLIES) {
            return Proposition.extractGoalDescription(proposition, null) != null;
        }
        if (keyword == Logic.KWD_NOT) {
            return Proposition.extractGoalDescription((Proposition)proposition.arguments.theArray[0], null) != null;
        }
        if (keyword == Logic.KWD_AND) {
            int n = 0;
            Proposition proposition2 = null;
            Vector vector = proposition.arguments;
            int n2 = vector.length();
            for (int i = 0; i < n2; ++i) {
                proposition2 = (Proposition)vector.theArray[i];
                if (proposition2.kind != Logic.KWD_AND && Proposition.atomicGoalPropositionP(proposition2)) {
                    ++n;
                    continue;
                }
                return false;
            }
            return n == 1;
        }
        return false;
    }

    public static boolean atomicForallArgumentP(Proposition proposition, Keyword keyword) {
        return Proposition.atomicGoalPropositionP(keyword == Logic.KWD_HEAD ? (Proposition)proposition.arguments.theArray[1] : (Proposition)proposition.arguments.theArray[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void collectMatchingRuleGoals(Proposition proposition, Cons cons, Keyword keyword, List list) {
        Keyword keyword2 = proposition.kind;
        if (keyword2 == Logic.KWD_AND || keyword2 == Logic.KWD_OR) {
            int n;
            if (keyword == Logic.KWD_HEAD) {
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n2 = 0;
                int n3 = vector.length();
                while (n2 < n3) {
                    stella_Object = vector.theArray[n2];
                    Proposition.collectMatchingRuleGoals((Proposition)stella_Object, cons, keyword, list);
                    ++n2;
                }
                return;
            }
            if (keyword != Logic.KWD_TAIL) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            int n4 = list.length();
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n5 = vector.length();
            for (n = 0; n < n5; ++n) {
                stella_Object = vector.theArray[n];
                Proposition.collectMatchingRuleGoals((Proposition)stella_Object, cons, keyword, list);
            }
            if (n4 != list.length()) return;
            stella_Object = null;
            vector = proposition.arguments;
            n = 0;
            n5 = vector.length();
            while (n < n5) {
                stella_Object = vector.theArray[n];
                Proposition.collectMatchingRuleGoals((Proposition)stella_Object, cons, keyword, list);
                ++n;
            }
            return;
        }
        if (keyword2 == Logic.KWD_EXISTS) {
            if (keyword == Logic.KWD_HEAD) {
                Proposition.collectMatchingRuleGoals((Proposition)proposition.arguments.theArray[0], cons, keyword, list);
                return;
            }
            if (keyword != Logic.KWD_TAIL) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            PatternVariable patternVariable = null;
            Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n = 0;
            int n6 = vector.length();
            while (true) {
                if (n >= n6) {
                    Proposition.collectMatchingRuleGoals((Proposition)proposition.arguments.theArray[0], cons, keyword, list);
                    return;
                }
                patternVariable = (PatternVariable)vector.theArray[n];
                cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
                ++n;
            }
        }
        if (keyword2 == Logic.KWD_FORALL) {
            if (keyword == Logic.KWD_HEAD) {
                PatternVariable patternVariable = null;
                Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
                int n = 0;
                int n7 = vector.length();
                while (true) {
                    if (n >= n7) {
                        Proposition.collectMatchingRuleGoals((Proposition)proposition.arguments.theArray[1], cons, keyword, list);
                        return;
                    }
                    patternVariable = (PatternVariable)vector.theArray[n];
                    cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
                    ++n;
                }
            }
            if (keyword == Logic.KWD_TAIL) {
                return;
            }
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (keyword2 != Logic.KWD_ISA && keyword2 != Logic.KWD_PREDICATE && keyword2 != Logic.KWD_FUNCTION && keyword2 != Logic.KWD_NOT) {
            if (keyword2 != Logic.KWD_IMPLIES) return;
        }
        boolean bl = false;
        boolean bl2 = true;
        Stella_Object stella_Object = null;
        Cons cons2 = Proposition.extractGoalArguments(proposition);
        while (cons2 != Stella.NIL) {
            stella_Object = cons2.value;
            if (!cons.memberP(stella_Object) && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                bl2 = false;
                break;
            }
            cons2 = cons2.rest;
        }
        if (bl = bl2) {
            bl = Proposition.extractGoalDescription(proposition, keyword) != null && proposition.operator != Logic.SGT_PL_KERNEL_KB_HOLDS;
        }
        if (!bl) return;
        list.insert((Stella_Object)proposition);
    }

    public static List findMatchableGoals(Proposition proposition, Keyword keyword) {
        int n = keyword == Logic.KWD_HEAD ? 1 : 0;
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[n];
        Cons cons = Stella.NIL;
        List list = List.newList();
        PatternVariable patternVariable = null;
        Object object = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
        int n2 = object.length();
        for (int i = 0; i < n2; ++i) {
            patternVariable = (PatternVariable)object.theArray[i];
            cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
        }
        if (cons.length() > 1 && keyword == Logic.KWD_TAIL) {
            patternVariable = proposition2.kind;
            if (patternVariable == Logic.KWD_AND) {
                object = null;
                Vector vector = proposition2.arguments;
                int n3 = vector.length();
                for (n2 = 0; n2 < n3; ++n2) {
                    object = vector.theArray[n2];
                    Proposition.collectMatchingRuleGoals((Proposition)((Object)object), cons, Logic.KWD_TAIL, list);
                }
                return list;
            }
            if (patternVariable == Logic.KWD_EXISTS) {
                object = (Proposition)proposition2.arguments.theArray[0];
                if (object.kind == Logic.KWD_AND) {
                    Stella_Object stella_Object = null;
                    Vector vector = object.arguments;
                    int n4 = vector.length();
                    for (int i = 0; i < n4; ++i) {
                        stella_Object = vector.theArray[i];
                        Proposition.collectMatchingRuleGoals((Proposition)stella_Object, cons, Logic.KWD_TAIL, list);
                    }
                }
                return list;
            }
        }
        Proposition.collectMatchingRuleGoals(proposition2, cons, keyword, list);
        return list;
    }

    public static Proposition safelyInvertProposition(Proposition proposition) {
        Proposition proposition2 = Proposition.shallowCopyProposition(proposition);
        Proposition.invertProposition(proposition2);
        return proposition2;
    }

    public static Proposition invertProposition(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_EQUIVALENT) {
            Proposition.invertAtomicProposition(proposition);
        } else if (keyword == Logic.KWD_AND) {
            int n = proposition.arguments.length();
            Proposition.simplifyProposition(proposition);
            if (proposition.arguments.length() < n) {
                return Proposition.invertProposition(proposition);
            }
            proposition.kind = Logic.KWD_OR;
            proposition.operator = Logic.SGT_LOGIC_OR;
            n = Integer.MIN_VALUE;
            int n2 = 0;
            int n3 = proposition.arguments.length() - 1;
            while (n2 <= n3) {
                n = n2++;
                proposition.arguments.theArray[n] = Proposition.safelyInvertProposition((Proposition)proposition.arguments.theArray[n]);
            }
        } else if (keyword == Logic.KWD_OR) {
            proposition.kind = Logic.KWD_AND;
            proposition.operator = Logic.SGT_LOGIC_AND;
            int n = Integer.MIN_VALUE;
            int n4 = 0;
            int n5 = proposition.arguments.length() - 1;
            while (n4 <= n5) {
                n = n4++;
                proposition.arguments.theArray[n] = Proposition.safelyInvertProposition((Proposition)proposition.arguments.theArray[n]);
            }
        } else if (keyword == Logic.KWD_NOT) {
            Proposition.overlayProposition(proposition, (Proposition)proposition.arguments.theArray[0]);
            Proposition.normalizeProposition(proposition);
        } else if (keyword == Logic.KWD_EXISTS) {
            if (Proposition.functionInducedExistsP(proposition)) {
                Proposition.embedNegationWithinFunctionInducedExists(proposition);
            } else {
                Proposition.invertExistsProposition(proposition);
            }
        } else if (keyword == Logic.KWD_FORALL) {
            Proposition.invertForallProposition(proposition);
        } else if (keyword == Logic.KWD_IMPLIES) {
            Proposition.invertImpliesProposition(proposition);
        } else {
            if (keyword == Logic.KWD_CONSTANT) {
                GeneralizedSymbol generalizedSymbol = proposition.operator;
                if (generalizedSymbol == Logic.SGT_STELLA_TRUE) {
                    return Logic.FALSE_PROPOSITION;
                }
                if (generalizedSymbol == Logic.SGT_STELLA_FALSE) {
                    return Logic.TRUE_PROPOSITION;
                }
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + generalizedSymbol + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            if (keyword == Logic.KWD_FAIL) {
                Proposition.invertAtomicProposition(proposition);
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        return proposition;
    }

    public static void invertImpliesProposition(Proposition proposition) {
        Stella_Object stella_Object;
        Vector vector = proposition.arguments;
        Stella_Object stella_Object2 = Stella_Object.surrogateP((Stella_Object)vector.theArray[0]) ? Logic.getDescription((Stella_Object)((Surrogate)vector.theArray[0])) : vector.theArray[0];
        Object object = stella_Object = Stella_Object.surrogateP((Stella_Object)vector.theArray[1]) ? Logic.getDescription((Stella_Object)((Surrogate)vector.theArray[1])) : vector.theArray[1];
        if (!Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) || !Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
            Proposition.invertAtomicProposition(proposition);
            return;
        }
        Description description = (Description)stella_Object2;
        Description description2 = (Description)stella_Object;
        Proposition proposition2 = null;
        Proposition proposition3 = null;
        KeyValueList keyValueList = KeyValueList.newKeyValueList();
        Vector vector2 = Vector.newVector((int)1);
        proposition.kind = Logic.KWD_EXISTS;
        proposition.operator = Logic.SGT_LOGIC_EXISTS;
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyVariablesVector(description.ioVariables, keyValueList), null);
        PatternVariable patternVariable = null;
        Vector vector3 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
        int n = 0;
        int n2 = vector3.length();
        PatternVariable patternVariable2 = null;
        Vector vector4 = description2.ioVariables;
        int n3 = vector4.length();
        for (int i = 0; n < n2 && i < n3; ++n, ++i) {
            patternVariable = (PatternVariable)vector3.theArray[n];
            patternVariable2 = (PatternVariable)vector4.theArray[i];
            keyValueList.insertAt((Stella_Object)patternVariable2, (Stella_Object)patternVariable);
        }
        proposition2 = Description.extractProposition(description, keyValueList);
        proposition3 = Description.extractProposition(description2, keyValueList);
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, null, null);
        Proposition.invertProposition(proposition3);
        vector2.theArray[0] = Proposition.conjoinTwoPropositions(proposition2, proposition3);
        proposition.arguments = vector2;
        Proposition.normalizeProposition(proposition);
    }

    public static void invertForallProposition(Proposition proposition) {
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[0];
        Proposition proposition3 = (Proposition)proposition.arguments.theArray[1];
        Vector vector = Vector.newVector((int)1);
        proposition.arguments.free();
        Proposition.normalizeProposition(proposition2);
        Proposition.normalizeProposition(proposition3);
        proposition3 = Proposition.safelyInvertProposition(proposition3);
        proposition.kind = Logic.KWD_EXISTS;
        proposition.operator = Logic.SGT_LOGIC_EXISTS;
        vector.theArray[0] = Proposition.conjoinTwoPropositions(proposition2, proposition3);
        proposition.arguments = vector;
        Proposition.normalizeProposition(proposition);
    }

    public static void invertExistsProposition(Proposition proposition) {
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[0];
        Vector vector = Vector.newVector((int)2);
        proposition.arguments.free();
        Proposition.normalizeProposition(proposition2);
        proposition2 = Proposition.safelyInvertProposition(proposition2);
        proposition.kind = Logic.KWD_FORALL;
        proposition.operator = Logic.SGT_LOGIC_FORALL;
        vector.theArray[0] = Logic.TRUE_PROPOSITION;
        vector.theArray[1] = proposition2;
        proposition.arguments = vector;
        Proposition.normalizeProposition(proposition);
    }

    public static void invertAtomicProposition(Proposition proposition) {
        Proposition proposition2 = Logic.createProposition(Logic.SYM_STELLA_NOT, 1);
        Vector vector = proposition2.arguments;
        Proposition proposition3 = proposition;
        vector.theArray[0] = proposition2;
        proposition2.kind = proposition.kind;
        proposition2.operator = proposition.operator;
        proposition2.arguments = proposition.arguments;
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.variableTypeP())) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, null, null);
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, (Stella_Object)Stella.TRUE_WRAPPER, null);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        proposition3.kind = Logic.KWD_NOT;
        proposition3.operator = Logic.SGT_LOGIC_NOT;
        proposition3.arguments = vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeTopLevelDescriptiveProposition(Proposition proposition, Vector vector) {
        if (vector == null && proposition.kind == Logic.KWD_FORALL) {
            Object object = Logic.$EVALUATIONMODE$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
                Proposition proposition2 = null;
                vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
                int n = Integer.MIN_VALUE;
                int n2 = 1;
                for (int i = 0; i <= n2; ++i) {
                    n = i;
                    proposition2 = (Proposition)proposition.arguments.theArray[n];
                    try {
                        Proposition.equateTopLevelEquivalences(proposition2);
                    }
                    catch (Clash clash) {
                        Stella.STANDARD_ERROR.nativeStream.println(Stella.exceptionMessage((Exception)((Object)clash)));
                    }
                    Proposition.tightenArgumentBindings(proposition2, vector);
                    Proposition.simplifyProposition(proposition2);
                }
            }
            finally {
                Logic.$EVALUATIONMODE$.set(object);
            }
            Logic.collapseValueOfChainsForIoVariables(vector);
        } else if (vector != null) {
            Object object = Logic.$EVALUATIONMODE$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
                try {
                    Proposition.equateTopLevelEquivalences(proposition);
                }
                catch (Clash clash) {
                    Stella.STANDARD_ERROR.nativeStream.println(Stella.exceptionMessage((Exception)((Object)clash)));
                }
                Proposition.tightenArgumentBindings(proposition, vector);
                Proposition.simplifyProposition(proposition);
                Logic.collapseValueOfChainsForIoVariables(vector);
            }
            finally {
                Logic.$EVALUATIONMODE$.set(object);
            }
        }
    }

    public static void normalizeTopLevelProposition(Proposition proposition, Vector vector) {
        Proposition.normalizeProposition(proposition);
        if (proposition.kind == Logic.KWD_FORALL || vector != null) {
            Proposition.normalizeTopLevelDescriptiveProposition(proposition, vector);
        }
    }

    public static void normalizeProposition(Proposition proposition) {
        Proposition proposition2;
        if (!BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.unfastenedP())) {
            return;
        }
        if (Proposition.containsNestedArgumentP(proposition)) {
            proposition2 = Proposition.shallowCopyProposition(proposition);
            proposition2 = Proposition.flattenNestedFunctionArguments(proposition2);
            Proposition.overlayProposition(proposition, proposition2);
        }
        if ((proposition2 = proposition.kind) == Logic.KWD_AND) {
            Proposition.normalizeAndProposition(proposition);
        } else if (proposition2 == Logic.KWD_OR) {
            Proposition.normalizeOrProposition(proposition);
        } else if (proposition2 == Logic.KWD_NOT) {
            Proposition.normalizeNotProposition(proposition);
        } else if (proposition2 == Logic.KWD_ISA || proposition2 == Logic.KWD_PREDICATE) {
            Proposition.normalizePredicateProposition(proposition);
        } else if (proposition2 == Logic.KWD_FUNCTION) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
                Proposition.normalizeProposition((Proposition)stella_Object);
            }
        } else if (proposition2 == Logic.KWD_EXISTS) {
            Proposition.normalizeExistsProposition(proposition);
        } else if (proposition2 == Logic.KWD_FORALL) {
            Proposition.normalizeForallProposition(proposition);
        } else if (proposition2 == Logic.KWD_EQUIVALENT) {
            Proposition.normalizeEquivalentProposition(proposition);
        } else if (proposition2 != Logic.KWD_IMPLIES && proposition2 != Logic.KWD_FAIL && proposition2 != Logic.KWD_COLLECT_INTO && proposition2 != Logic.KWD_CONSTANT) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Object)((Object)proposition2) + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static Proposition shallowCopyProposition(Proposition proposition) {
        Proposition proposition2 = Logic.createProposition(Logic.SYM_STELLA_AND, 0);
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        Proposition.overlayProposition(proposition2, proposition);
        return proposition2;
    }

    public static void normalizeEquivalentProposition(Proposition proposition) {
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        if (Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
            Proposition.overlayWithConstantProposition(proposition, Logic.TRUE_PROPOSITION);
        } else if (!(Logic.skolemP(stella_Object) || Logic.skolemP(stella_Object2) || Logic.collectionP(stella_Object) || Logic.collectionP(stella_Object2))) {
            Proposition.overlayWithConstantProposition(proposition, Logic.FALSE_PROPOSITION);
        }
    }

    public static Proposition normalizeValueFunction(Proposition proposition) {
        boolean bl;
        Surrogate surrogate = Logic.evaluateRelationTerm(proposition.arguments.theArray[0], proposition);
        int n = proposition.arguments.length() - 1;
        Proposition proposition2 = null;
        Proposition proposition3 = null;
        if (surrogate == null) {
            return proposition;
        }
        proposition2 = Logic.createProposition(Logic.SYM_STELLA_FUNCTION, n);
        proposition2.operator = surrogate;
        int n2 = Integer.MIN_VALUE;
        int n3 = 1;
        int n4 = n;
        boolean bl2 = bl = n4 == Integer.MIN_VALUE;
        while (bl || n3 <= n4) {
            n2 = n3++;
            proposition2.arguments.theArray[n2 - 1] = proposition.arguments.theArray[n2];
        }
        if (Logic.skolemP(proposition.arguments.theArray[proposition.arguments.length() - 1])) {
            ((Skolem)proposition.arguments.theArray[proposition.arguments.length() - 1]).definingProposition = proposition2;
        }
        if (!Logic.descriptionModeP() && (proposition3 = Proposition.findDuplicateFunctionProposition(proposition2)) != null) {
            proposition2 = proposition3;
        }
        return proposition2;
    }

    public static void normalizePredicateProposition(Proposition proposition) {
        if (proposition.operator == Logic.SGT_PL_KERNEL_KB_HOLDS) {
            Proposition.normalizeHoldsProposition(proposition);
            if (proposition.operator != Logic.SGT_PL_KERNEL_KB_HOLDS) {
                return;
            }
        }
        if (proposition.operator == Logic.SGT_STELLA_THING) {
            Proposition.overlayProposition(proposition, Logic.TRUE_PROPOSITION);
            return;
        }
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            Proposition.normalizeProposition((Proposition)stella_Object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeHoldsProposition(Proposition proposition) {
        boolean bl;
        Vector vector = proposition.arguments;
        Stella_Object stella_Object = vector.theArray[0];
        int n = vector.length() - 1;
        Surrogate surrogate = Logic.evaluateRelationTerm(stella_Object, proposition);
        Vector vector2 = Vector.newVector((int)n);
        Description description = null;
        if (surrogate == null && !Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
            return;
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = 1;
        int n4 = n;
        boolean bl2 = bl = n4 == Integer.MIN_VALUE;
        while (bl || n3 <= n4) {
            n2 = n3++;
            vector2.theArray[n2 - 1] = vector.theArray[n2];
        }
        if (surrogate != null) {
            description = (Description)Logic.evaluatePredicate((GeneralizedSymbol)surrogate, vector.theArray[1]);
            if (Logic.classP((Stella_Object)description)) {
                proposition.kind = Logic.KWD_ISA;
            } else if (Logic.functionP((Stella_Object)description)) {
                Proposition.helpNormalizePredicateProposition(proposition, description.surrogateValueInverse, vector2);
                return;
            }
            proposition.operator = description.surrogateValueInverse;
            proposition.arguments = vector2;
            Proposition.normalizeProposition(proposition);
            return;
        }
        description = (Description)stella_Object;
        if (description.arity() != n) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Arity violation in HOLDS proposition: `" + (Object)((Object)proposition) + "'.");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        Proposition.overlayProposition(proposition, Logic.conjoinPropositions(Logic.inheritDescriptionPropositions(vector2, description)));
        Proposition.normalizeProposition(proposition);
    }

    public static void helpNormalizePredicateProposition(Proposition proposition, Surrogate surrogate, Vector vector) {
        Stella_Object stella_Object = vector.last();
        Cons cons = Stella.NIL;
        Proposition proposition2 = null;
        Proposition proposition3 = null;
        int n = Integer.MIN_VALUE;
        int n2 = vector.length() - 2;
        Cons cons2 = null;
        for (int i = 0; i <= n2; ++i) {
            n = i;
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)vector.theArray[n], (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)vector.theArray[n], (Cons)Stella.NIL);
        }
        proposition2 = Logic.findOrCreateFunctionProposition((GeneralizedSymbol)surrogate, cons);
        proposition3 = Logic.createEquivalenceProposition(proposition2.arguments.last(), stella_Object);
        Proposition.overlayProposition(proposition, proposition3);
        Proposition.normalizeProposition(proposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeOrProposition(Proposition proposition) {
        Cons cons = Stella.NIL;
        boolean bl = false;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            stella_Object = vector.theArray[i];
            if (Logic.variableP(stella_Object)) {
                object2 = OutputStringStream.newOutputStringStream();
                object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    object2.nativeStream.println("ERROR: Can't yet handle propositional variables within disjunctions.");
                    Logic.helpSignalPropositionError((OutputStream)object2, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(object2.theStringReader()).fillInStackTrace());
            }
            object2 = (Proposition)stella_Object;
            Proposition.normalizeProposition((Proposition)((Object)object2));
            object = object2.kind;
            if (object == Logic.KWD_OR) {
                cons = Stella_Object.cons((Stella_Object)object2, (Cons)cons);
                bl = true;
                continue;
            }
            if (object == Logic.KWD_CONSTANT) {
                if (object2.operator == Logic.SGT_STELLA_FALSE) {
                    bl = true;
                    continue;
                }
                if (object2.operator == Logic.SGT_STELLA_TRUE) {
                    Proposition.overlayWithConstantProposition(proposition, Logic.TRUE_PROPOSITION);
                    return;
                }
                if (cons.memberP((Stella_Object)object2)) {
                    bl = true;
                    continue;
                }
                cons = Stella_Object.cons((Stella_Object)object2, (Cons)cons);
                continue;
            }
            boolean bl2 = false;
            boolean bl3 = bl2 = !bl;
            if (bl2) {
                boolean bl4 = false;
                Stella_Object stella_Object2 = null;
                Cons cons2 = cons;
                while (cons2 != Stella.NIL) {
                    stella_Object2 = cons2.value;
                    if (Proposition.duplicateAndOrArgumentsP((Proposition)stella_Object2, (Proposition)((Object)object2))) {
                        bl4 = true;
                        break;
                    }
                    cons2 = cons2.rest;
                }
                bl2 = bl4;
            }
            if (bl2) {
                bl = true;
                continue;
            }
            cons = Stella_Object.cons((Stella_Object)object2, (Cons)cons);
        }
        if (bl || cons.length() <= 1) {
            Proposition.overlayProposition(proposition, Logic.disjoinPropositions(cons));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeAndProposition(Proposition proposition) {
        Cons cons = Stella.NIL;
        boolean bl = false;
        Cons cons2 = Stella.NIL;
        Object object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            Object object2;
            Object object3;
            object = vector.theArray[i];
            if (Logic.variableP(object)) {
                object3 = OutputStringStream.newOutputStringStream();
                object2 = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    object3.nativeStream.println("ERROR: Can't yet handle propositional variables within conjunctions.");
                    Logic.helpSignalPropositionError((OutputStream)object3, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object2);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(object3.theStringReader()).fillInStackTrace());
            }
            object3 = (Proposition)((Object)object);
            Proposition.normalizeProposition((Proposition)((Object)object3));
            object2 = object3.kind;
            if (object2 == Logic.KWD_EXISTS) {
                PatternVariable patternVariable = null;
                Vector vector2 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)object3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
                int n2 = vector2.length();
                Cons cons3 = null;
                for (int j = 0; j < n2; ++j) {
                    patternVariable = (PatternVariable)vector2.theArray[j];
                    boolean bl2 = false;
                    PatternVariable patternVariable2 = null;
                    Cons cons4 = cons2;
                    while (cons4 != Stella.NIL) {
                        patternVariable2 = (PatternVariable)cons4.value;
                        if (Symbol.variableEqlP((Symbol)patternVariable2.skolemName, (Symbol)patternVariable.skolemName)) {
                            bl2 = true;
                            break;
                        }
                        cons4 = cons4.rest;
                    }
                    if (bl2) {
                        PatternVariable.renameLogicVariableApart(patternVariable, true);
                    }
                    if (cons3 == null) {
                        cons3 = Stella_Object.cons((Stella_Object)patternVariable, (Cons)Stella.NIL);
                        if (cons2 == Stella.NIL) {
                            cons2 = cons3;
                            continue;
                        }
                        Cons.addConsToEndOfConsList((Cons)cons2, (Cons)cons3);
                        continue;
                    }
                    cons3 = cons3.rest = Stella_Object.cons((Stella_Object)patternVariable, (Cons)Stella.NIL);
                }
                cons = Stella_Object.cons((Stella_Object)object3.arguments.theArray[0], (Cons)cons);
                bl = true;
                continue;
            }
            if (object2 == Logic.KWD_AND) {
                cons = Stella_Object.cons((Stella_Object)object3, (Cons)cons);
                bl = true;
                continue;
            }
            if (object2 == Logic.KWD_CONSTANT) {
                if (object3.operator == Logic.SGT_STELLA_TRUE) {
                    bl = true;
                    cons = Stella_Object.cons((Stella_Object)object3, (Cons)cons);
                    continue;
                }
                if (object3.operator != Logic.SGT_STELLA_FALSE) continue;
                Proposition.overlayWithConstantProposition(proposition, Logic.FALSE_PROPOSITION);
                return;
            }
            boolean bl3 = false;
            boolean bl4 = bl3 = !bl;
            if (bl3) {
                boolean bl5 = false;
                Stella_Object stella_Object = null;
                Cons cons5 = cons;
                while (cons5 != Stella.NIL) {
                    stella_Object = cons5.value;
                    if (Proposition.duplicateAndOrArgumentsP((Proposition)stella_Object, (Proposition)((Object)object3))) {
                        bl5 = true;
                        break;
                    }
                    cons5 = cons5.rest;
                }
                bl3 = bl5;
            }
            if (bl3) {
                bl = true;
                continue;
            }
            cons = Stella_Object.cons((Stella_Object)object3, (Cons)cons);
        }
        cons = cons.reverse();
        if (cons2 != Stella.NIL) {
            object = Logic.createProposition(Logic.SYM_STELLA_EXISTS, 1);
            KeyValueList.setDynamicSlotValue((KeyValueList)object.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyConsListToVariablesVector(cons2), null);
            object.arguments.theArray[0] = Logic.conjoinPropositions(cons);
            Proposition.overlayProposition(proposition, (Proposition)((Object)object));
            return;
        }
        if (bl || cons.length() <= 1) {
            Proposition.overlayProposition(proposition, Logic.conjoinPropositions(cons));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeNotProposition(Proposition proposition) {
        Keyword keyword;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Proposition proposition2 = null;
        if (Logic.variableP(stella_Object)) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Can't yet handle propositional variables within negations.");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        proposition2 = (Proposition)stella_Object;
        if (proposition2.kind == Logic.KWD_EQUIVALENT) {
            Proposition.normalizeProposition(proposition2);
        }
        if ((keyword = proposition2.kind) == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition2.variableTypeP())) {
                Proposition.overlayWithConstantProposition(proposition, Logic.FALSE_PROPOSITION);
            } else {
                Proposition.normalizeProposition(proposition2);
            }
        } else if (keyword == Logic.KWD_CONSTANT) {
            GeneralizedSymbol generalizedSymbol = proposition2.operator;
            if (generalizedSymbol == Logic.SGT_STELLA_TRUE) {
                Proposition.overlayWithConstantProposition(proposition, Logic.FALSE_PROPOSITION);
            } else if (generalizedSymbol == Logic.SGT_STELLA_FALSE) {
                Proposition.overlayWithConstantProposition(proposition, Logic.TRUE_PROPOSITION);
            }
        } else {
            Proposition.invertProposition(proposition2);
            Proposition.overlayProposition(proposition, proposition2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeForallProposition(Proposition proposition) {
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        Proposition proposition2 = null;
        Proposition proposition3 = null;
        if (Logic.variableP(stella_Object) || Logic.variableP(stella_Object2)) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Can't yet handle propositional variables within FORALL.");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        proposition2 = (Proposition)stella_Object;
        proposition3 = (Proposition)stella_Object2;
        Object object = Logic.$EVALUATIONMODE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
            Proposition.normalizeProposition(proposition2);
            Proposition.normalizeProposition(proposition3);
        }
        finally {
            Logic.$EVALUATIONMODE$.set(object);
        }
        if (proposition2.kind == Logic.KWD_CONSTANT) {
            object = proposition2.operator;
            if (object == Logic.SGT_STELLA_TRUE) {
                if (Proposition.migrateConsequentGoalsToAntecedentP(proposition)) {
                    return;
                }
            } else {
                if (object == Logic.SGT_STELLA_FALSE) {
                    Proposition.overlayWithConstantProposition(proposition, Logic.TRUE_PROPOSITION);
                    return;
                }
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + object + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        if ((object = proposition3.kind) == Logic.KWD_FORALL) {
            if (!Logic.naturalDeductionModeP()) {
                Proposition.flattenNestedForallProposition(proposition);
            }
        } else if (object == Logic.KWD_CONSTANT) {
            GeneralizedSymbol generalizedSymbol = proposition3.operator;
            if (generalizedSymbol == Logic.SGT_STELLA_FALSE) {
                Proposition.overlayProposition(proposition, proposition2);
                Proposition.invertProposition(proposition);
                return;
            }
            if (generalizedSymbol == Logic.SGT_STELLA_TRUE) {
                Proposition.overlayWithConstantProposition(proposition, Logic.TRUE_PROPOSITION);
                return;
            }
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + generalizedSymbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null)).arraySize == 0) {
            proposition2 = Proposition.invertProposition(proposition2);
            Proposition.overlayProposition(proposition, Logic.disjoinPropositions(Stella.consList((Cons)Stella_Object.cons((Stella_Object)proposition2, (Cons)Stella_Object.cons((Stella_Object)proposition3, (Cons)Stella.NIL)))));
            Proposition.normalizeProposition(proposition);
            return;
        }
        object = Proposition.deriveImpliesFromForall(proposition);
        if (object != null) {
            Proposition.overlayProposition(proposition, (Proposition)((Object)object));
        }
    }

    public static void flattenNestedForallProposition(Proposition proposition) {
        int n;
        Cons cons = Stella.NIL;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[1];
        Stella_Object stella_Object2 = proposition2.arguments.theArray[0];
        Stella_Object stella_Object3 = proposition2.arguments.theArray[1];
        PatternVariable patternVariable = null;
        Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
        int n2 = vector.length();
        for (n = 0; n < n2; ++n) {
            patternVariable = (PatternVariable)vector.theArray[n];
            cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
        }
        patternVariable = null;
        vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
        n2 = vector.length();
        for (n = 0; n < n2; ++n) {
            patternVariable = (PatternVariable)vector.theArray[n];
            cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyConsListToVariablesVector(cons.reverse()), null);
        proposition.arguments.theArray[0] = Proposition.conjoinTwoPropositions((Proposition)stella_Object, (Proposition)stella_Object2);
        proposition.arguments.theArray[1] = stella_Object3;
        Proposition.normalizeProposition((Proposition)proposition.arguments.theArray[0]);
    }

    public static boolean migrateConsequentGoalsToAntecedentP(Proposition proposition) {
        Proposition proposition2 = null;
        Proposition proposition3 = (Proposition)proposition.arguments.theArray[1];
        Cons cons = Stella.NIL;
        Cons cons2 = Stella.NIL;
        if (proposition3.kind != Logic.KWD_OR) {
            return false;
        }
        Stella_Object stella_Object = null;
        Vector vector = proposition3.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            Proposition proposition4 = (Proposition)stella_Object;
            if (proposition4.kind == Logic.KWD_NOT) {
                cons2 = Stella_Object.cons((Stella_Object)proposition4.arguments.theArray[0], (Cons)cons2);
                continue;
            }
            cons = Stella_Object.cons((Stella_Object)proposition4, (Cons)cons);
        }
        if (cons != Stella.NIL && cons2 != Stella.NIL) {
            proposition2 = Logic.conjoinPropositions(cons2.reverse());
            proposition3 = Logic.disjoinPropositions(cons.reverse());
            Proposition.normalizeProposition(proposition2);
            Proposition.normalizeProposition(proposition3);
            proposition.arguments.theArray[0] = proposition2;
            proposition.arguments.theArray[1] = proposition3;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalizeExistsProposition(Proposition proposition) {
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[0];
        Object object = Logic.$EVALUATIONMODE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
            Proposition.normalizeProposition(proposition2);
        }
        finally {
            Logic.$EVALUATIONMODE$.set(object);
        }
        if (proposition2.kind == Logic.KWD_EXISTS) {
            int n;
            object = Stella.NIL;
            PatternVariable patternVariable = null;
            Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n2 = vector.length();
            Cons cons = null;
            for (n = 0; n < n2; ++n) {
                patternVariable = (PatternVariable)vector.theArray[n];
                if (cons == null) {
                    cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)Stella.NIL);
                    if (object == Stella.NIL) {
                        object = cons;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)object, (Cons)cons);
                    continue;
                }
                cons = cons.rest = Stella_Object.cons((Stella_Object)patternVariable, (Cons)Stella.NIL);
            }
            patternVariable = null;
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            n2 = vector.length();
            cons = null;
            for (n = 0; n < n2; ++n) {
                patternVariable = (PatternVariable)vector.theArray[n];
                if (cons == null) {
                    cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)Stella.NIL);
                    if (object == Stella.NIL) {
                        object = cons;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)object, (Cons)cons);
                    continue;
                }
                cons = cons.rest = Stella_Object.cons((Stella_Object)patternVariable, (Cons)Stella.NIL);
            }
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyConsListToVariablesVector((Cons)object), null);
            proposition.arguments = proposition2.arguments;
            proposition2.deletedPSetter(true);
        }
        if (((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null)).arraySize == 0 || proposition2.kind == Logic.KWD_CONSTANT) {
            Proposition.overlayProposition(proposition, proposition2);
        }
    }

    public static void overlayProposition(Proposition proposition, Proposition proposition2) {
        proposition.kind = proposition2.kind;
        proposition.operator = proposition2.operator;
        Proposition proposition3 = proposition;
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition2.truthValue, (Context)proposition2.homeContext, (boolean)false);
        Stella_Object stella_Object = proposition3.truthValue;
        Stella_Object stella_Object2 = Stella_Object.updateInContext((Stella_Object)stella_Object, (Stella_Object)truthValue, (Context)proposition3.homeContext, (boolean)false);
        if (stella_Object == null || stella_Object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
            proposition3.truthValue = stella_Object2;
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, (Stella_Object)((PropositionNeuralNetwork)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEURAL_NETWORK, null)), null);
        proposition.arguments = proposition2.arguments.copy();
        if ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null) != null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null)).copy(), null);
        }
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition2.variableTypeP())) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, (Stella_Object)Stella.TRUE_WRAPPER, null);
        }
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
    }

    public static void collectFlatDisjuncts(Proposition proposition, List list) {
        if (proposition.kind == Logic.KWD_OR) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.collectFlatDisjuncts((Proposition)stella_Object, list);
            }
            proposition.free();
        } else {
            boolean bl = false;
            Proposition proposition2 = null;
            Cons cons = list.theConsList;
            while (cons != Stella.NIL) {
                proposition2 = (Proposition)cons.value;
                if (Proposition.duplicateAndOrArgumentsP(proposition2, proposition)) {
                    bl = true;
                    break;
                }
                cons = cons.rest;
            }
            if (!bl) {
                list.push((Stella_Object)proposition);
                proposition.dependentPropositions.clear();
            }
        }
    }

    public static Proposition conjoinTwoPropositions(Proposition proposition, Proposition proposition2) {
        if (proposition == null) {
            return proposition2;
        }
        if (proposition2 == null) {
            return proposition;
        }
        if (Proposition.duplicateAndOrArgumentsP(proposition, proposition2)) {
            return proposition;
        }
        Proposition proposition3 = Logic.createProposition(Logic.SYM_STELLA_AND, 2);
        proposition3.arguments.theArray[0] = proposition;
        proposition3.arguments.theArray[1] = proposition2;
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition3.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        return proposition3;
    }

    public static void overlayWithConstantProposition(Proposition proposition, Proposition proposition2) {
        Proposition proposition3 = Logic.createProposition(Logic.SYM_LOGIC_CONSTANT, 0);
        proposition3.operator = proposition2.operator;
        Proposition proposition4 = proposition3;
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition2.truthValue, (Context)proposition2.homeContext, (boolean)false);
        Stella_Object stella_Object = proposition4.truthValue;
        Stella_Object stella_Object2 = Stella_Object.updateInContext((Stella_Object)stella_Object, (Stella_Object)truthValue, (Context)proposition4.homeContext, (boolean)false);
        if (stella_Object == null || stella_Object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
            proposition4.truthValue = stella_Object2;
        }
        Proposition.overlayProposition(proposition, proposition3);
    }

    public static void collectFlatConjuncts(Proposition proposition, List list) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.collectFlatConjuncts((Proposition)stella_Object, list);
            }
            return;
        }
        if (keyword == Logic.KWD_CONSTANT) {
            if (proposition.operator == Logic.SGT_STELLA_TRUE) {
                return;
            }
        } else {
            proposition.dependentPropositions.clear();
        }
        boolean bl = false;
        Proposition proposition2 = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            proposition2 = (Proposition)cons.value;
            if (Proposition.duplicateAndOrArgumentsP(proposition2, proposition)) {
                bl = true;
                break;
            }
            cons = cons.rest;
        }
        if (!bl) {
            list.push((Stella_Object)proposition);
        }
    }

    public static boolean duplicateAndOrArgumentsP(Proposition proposition, Proposition proposition2) {
        return Proposition.equivalentPropositionsP(proposition, proposition2, null) && !Proposition.searchControlPropositionP(proposition) && !Proposition.searchControlPropositionP(proposition2);
    }

    public static boolean searchControlPropositionP(Proposition proposition) {
        GeneralizedSymbol generalizedSymbol = proposition.operator;
        return generalizedSymbol == Logic.SGT_PL_KERNEL_KB_CUT || generalizedSymbol == Logic.SGT_PL_KERNEL_KB_BOUND_VARIABLES || generalizedSymbol == Logic.SGT_PL_KERNEL_KB_FORK || generalizedSymbol == Logic.SGT_PL_KERNEL_KB_QUERY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void complainAboutUndeclaredReference(Proposition proposition) {
        if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Undeclared predicate or function reference: `" + proposition.operator + "'.");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        Object object = Stella.$PRINTREADABLYp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
            Stella.STANDARD_WARNING.nativeStream.println("WARNING: Undeclared predicate or function reference: " + proposition.operator);
            Logic.helpSignalPropositionError(Stella.STANDARD_WARNING, Logic.KWD_WARNING);
        }
        finally {
            Stella.$PRINTREADABLYp$.set(object);
        }
    }

    public static void createDummyRelation(Proposition proposition) {
        List list = List.newList();
        Symbol symbol = (Symbol)proposition.operator;
        Surrogate surrogate = Symbol.symbolToSurrogate((Symbol)symbol);
        NamedDescription namedDescription = null;
        IntegerIntervalIterator integerIntervalIterator = Stella.interval((int)1, (int)proposition.arguments.length());
        while (integerIntervalIterator.nextP()) {
            list.push((Stella_Object)Logic.SGT_STELLA_THING);
        }
        namedDescription = Logic.createPrimitiveDescription(Stella.NIL_LIST, list, false, proposition.kind == Logic.KWD_ISA, proposition.kind == Logic.KWD_FUNCTION, (Module)surrogate.homeContext);
        proposition.operator = surrogate;
        Logic.bindLogicObjectToSurrogate(symbol, (Stella_Object)namedDescription);
        KeyValueList.setDynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_UNDECLAREDp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
    }

    public static boolean resolveOneSlotReferenceP(Proposition proposition, KeyValueList keyValueList) {
        Object object;
        LogicObject logicObject;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = null;
        Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
            logicObject = (PatternVariable)stella_Object;
            object = (List)keyValueList.lookup((Stella_Object)logicObject);
            if (object != null) {
                stella_Object2 = Logic.inferPredicateFromOperatorAndTypes((Stella_Object)proposition.operator, (List)keyValueList.lookup((Stella_Object)logicObject));
            }
        } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT) && (object = Logic.safeLogicalType((Stella_Object)(logicObject = (LogicObject)stella_Object))) != null) {
            stella_Object2 = Logic.inferPredicateFromOperatorAndTypes((Stella_Object)proposition.operator, Stella.list((Cons)Stella_Object.cons((Stella_Object)object, (Cons)Stella.NIL)));
        }
        if (stella_Object2 != null && Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType(stella_Object2), (Surrogate)Logic.SGT_STELLA_SLOT)) {
            surrogate = (Slot)stella_Object2;
            logicObject = Logic.unwrapWrappedType(surrogate.slotBaseType);
            if (!Logic.booleanTypeP((Surrogate)logicObject)) {
                proposition.kind = Logic.KWD_FUNCTION;
                if (Logic.variableP(proposition.arguments.theArray[proposition.arguments.length() - 1])) {
                    object = (PatternVariable)proposition.arguments.theArray[proposition.arguments.length() - 1];
                    Skolem.updateSkolemType((Skolem)((Object)object), (Surrogate)logicObject);
                }
            }
            proposition.operator = Logic.mostGeneralEquivalentSlotref(surrogate.slotSlotref);
            Proposition.evaluateNewProposition(proposition);
            return true;
        }
        return false;
    }

    public static Cons collectUnresolvedSlotReferences(Proposition proposition) {
        Cons cons = Stella.NIL;
        if (Stella.getQuotedTree((String)"((:PREDICATE :FUNCTION) \"/LOGIC\")", (String)"/LOGIC").memberP((Stella_Object)proposition.kind) && Stella_Object.isaP((Stella_Object)proposition.operator, (Surrogate)Logic.SGT_STELLA_SYMBOL)) {
            cons = Stella_Object.cons((Stella_Object)proposition, (Cons)cons);
        }
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            Proposition proposition2 = null;
            Cons cons2 = Proposition.collectUnresolvedSlotReferences((Proposition)stella_Object);
            while (cons2 != Stella.NIL) {
                proposition2 = (Proposition)cons2.value;
                cons = Stella_Object.cons((Stella_Object)proposition2, (Cons)cons);
                cons2 = cons2.rest;
            }
        }
        return cons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyValueList inferVariableTypesInProposition(Proposition proposition, Cons cons) {
        KeyValueList keyValueList = KeyValueList.newKeyValueList();
        Object object = Logic.$ADDEDNEWTYPEp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Logic.$ADDEDNEWTYPEp$, (boolean)false);
            do {
                Native.setBooleanSpecial((ThreadLocal)Logic.$ADDEDNEWTYPEp$, (boolean)false);
                Proposition.inferTypesFromPropositions(proposition, keyValueList, cons);
            } while (((Boolean)Logic.$ADDEDNEWTYPEp$.get()).booleanValue());
            KeyValueList keyValueList2 = keyValueList;
            return keyValueList2;
        }
        finally {
            Logic.$ADDEDNEWTYPEp$.set(object);
        }
    }

    public static void inferTypesFromPropositions(Proposition proposition, KeyValueList keyValueList, Cons cons) {
        Vector vector = proposition.arguments;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector2 = vector;
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector2.theArray[i];
                Proposition.inferTypesFromPropositions((Proposition)stella_Object, keyValueList, cons);
            }
        } else if (keyword == Logic.KWD_OR) {
            Stella_Object stella_Object = null;
            Vector vector3 = vector;
            int n = vector3.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector3.theArray[i];
                Proposition.inferTypesFromPropositions((Proposition)stella_Object, keyValueList, Stella.NIL);
            }
        } else if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_EQUIVALENT) {
            Proposition.inferTypesFromOneProposition(proposition, keyValueList, cons);
        } else if (keyword == Logic.KWD_FORALL) {
            cons = Stella.NIL;
            PatternVariable patternVariable = null;
            Vector vector4 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n = vector4.length();
            for (int i = 0; i < n; ++i) {
                patternVariable = (PatternVariable)vector4.theArray[i];
                cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
            }
            Proposition.inferTypesFromPropositions((Proposition)vector.theArray[0], keyValueList, cons);
            Proposition.inferTypesFromPropositions((Proposition)vector.theArray[1], keyValueList, cons);
        } else if (keyword == Logic.KWD_EXISTS) {
            PatternVariable patternVariable = null;
            Vector vector5 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n = vector5.length();
            for (int i = 0; i < n; ++i) {
                patternVariable = (PatternVariable)vector5.theArray[i];
                cons = Stella_Object.cons((Stella_Object)patternVariable, (Cons)cons);
            }
            Proposition.inferTypesFromPropositions((Proposition)vector.theArray[0], keyValueList, cons);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void inferTypesFromOneProposition(Proposition proposition, KeyValueList keyValueList, Cons cons) {
        Cons cons2;
        List list;
        List list2;
        LogicObject logicObject;
        Surrogate surrogate;
        Stella_Object stella_Object;
        Vector vector;
        block25: {
            Cons cons3;
            NamedDescription namedDescription;
            block27: {
                Cons cons4;
                Stella_Object stella_Object2;
                Keyword keyword;
                Stella_Object stella_Object3;
                block23: {
                    block26: {
                        block24: {
                            if (proposition.arguments.length() == 0) {
                                return;
                            }
                            vector = proposition.arguments;
                            stella_Object3 = vector.theArray[0];
                            keyword = proposition.kind;
                            if (keyword == Logic.KWD_ISA) {
                                if (!Stella_Object.isaP((Stella_Object)stella_Object3, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) return;
                                PatternVariable.addVariableType((PatternVariable)stella_Object3, (Surrogate)proposition.operator, keyValueList, cons);
                                return;
                            }
                            if (keyword != Logic.KWD_PREDICATE && keyword != Logic.KWD_FUNCTION) break block23;
                            stella_Object = null;
                            surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                            if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) break block24;
                            logicObject = (PatternVariable)stella_Object3;
                            list2 = (List)keyValueList.lookup((Stella_Object)logicObject);
                            if (list2 != null) {
                                stella_Object = Logic.inferPredicateFromOperatorAndTypes((Stella_Object)proposition.operator, list2);
                            }
                            break block25;
                        }
                        if (!Surrogate.subtypeOfSurrogateP((Surrogate)surrogate)) break block26;
                        logicObject = (Surrogate)stella_Object3;
                        list2 = ((Surrogate)logicObject).surrogateValue;
                        list = List.newList();
                        if (list2 == null || !Stella_Object.isaP((Stella_Object)list2, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) break block25;
                        namedDescription = null;
                        cons3 = Logic.allAssertedTypes((Stella_Object)list2);
                        cons2 = null;
                        break block27;
                    }
                    logicObject = proposition.operator;
                    if (Stella_Object.isaP((Stella_Object)logicObject, (Surrogate)Logic.SGT_STELLA_SURROGATE) && Stella_Object.isaP((Stella_Object)((Surrogate)logicObject).surrogateValue, (Surrogate)Logic.SGT_STELLA_SLOT)) {
                        stella_Object = (Slot)((Surrogate)logicObject).surrogateValue;
                    }
                    break block25;
                }
                if (keyword != Logic.KWD_EQUIVALENT) return;
                Stella_Object stella_Object4 = vector.theArray[1];
                if (Stella_Object.isaP((Stella_Object)stella_Object3, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    if (Stella_Object.isaP((Stella_Object)stella_Object4, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                        stella_Object2 = null;
                        cons4 = List.mapNullToNilList((List)((List)keyValueList.lookup((Stella_Object)((PatternVariable)stella_Object4)))).theConsList;
                        while (cons4 != Stella.NIL) {
                            stella_Object2 = cons4.value;
                            PatternVariable.addVariableType((PatternVariable)stella_Object3, (Surrogate)stella_Object2, keyValueList, cons);
                            cons4 = cons4.rest;
                        }
                    } else {
                        PatternVariable.addVariableType((PatternVariable)stella_Object3, Logic.logicalType(stella_Object4), keyValueList, cons);
                    }
                }
                if (!Stella_Object.isaP((Stella_Object)stella_Object4, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) return;
                if (!Stella_Object.isaP((Stella_Object)stella_Object3, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    PatternVariable.addVariableType((PatternVariable)stella_Object4, Logic.logicalType(stella_Object3), keyValueList, cons);
                    return;
                }
                stella_Object2 = null;
                cons4 = List.mapNullToNilList((List)((List)keyValueList.lookup((Stella_Object)((PatternVariable)stella_Object3)))).theConsList;
                while (cons4 != Stella.NIL) {
                    stella_Object2 = cons4.value;
                    PatternVariable.addVariableType((PatternVariable)stella_Object4, (Surrogate)stella_Object2, keyValueList, cons);
                    cons4 = cons4.rest;
                }
                return;
            }
            while (cons3 != Stella.NIL) {
                namedDescription = (NamedDescription)cons3.value;
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)namedDescription.surrogateValueInverse, (Cons)Stella.NIL);
                    if (list.theConsList == Stella.NIL) {
                        list.theConsList = cons2;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)list.theConsList, (Cons)cons2);
                    }
                } else {
                    cons2 = cons2.rest = Stella_Object.cons((Stella_Object)namedDescription.surrogateValueInverse, (Cons)Stella.NIL);
                }
                cons3 = cons3.rest;
            }
            list = Logic.mostSpecificTypes(list);
            stella_Object = Logic.inferPredicateFromOperatorAndTypes((Stella_Object)proposition.operator, list);
        }
        if (stella_Object == null) return;
        surrogate = Stella_Object.safePrimaryType(stella_Object);
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION)) {
            logicObject = (NamedDescription)stella_Object;
            if (((NamedDescription)logicObject).ioVariableTypes == null) return;
            list2 = null;
            list = vector;
            int n = 0;
            int n2 = list.length();
            cons2 = null;
            Cons cons5 = ((NamedDescription)logicObject).ioVariableTypes.theConsList;
            while (n < n2) {
                if (cons5 == Stella.NIL) return;
                list2 = list.theArray[n];
                cons2 = (Surrogate)cons5.value;
                if (Stella_Object.isaP((Stella_Object)list2, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    PatternVariable.addVariableType((PatternVariable)list2, (Surrogate)cons2, keyValueList, cons);
                }
                ++n;
                cons5 = cons5.rest;
            }
            return;
        }
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_SLOT)) {
            logicObject = (Slot)stella_Object;
            list2 = null;
            list = vector;
            int n = 0;
            int n3 = list.length();
            cons2 = null;
            Cons cons6 = Logic.slotColumnTypes((Slot)logicObject, vector.length());
            while (n < n3) {
                if (cons6 == Stella.NIL) return;
                list2 = list.theArray[n];
                cons2 = (Surrogate)cons6.value;
                if (Stella_Object.isaP((Stella_Object)list2, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    PatternVariable.addVariableType((PatternVariable)list2, (Surrogate)cons2, keyValueList, cons);
                }
                ++n;
                cons6 = cons6.rest;
            }
            return;
        }
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
            logicObject = (LogicObject)stella_Object;
            return;
        }
        logicObject = OutputStringStream.newOutputStringStream();
        ((OutputStringStream)logicObject).nativeStream.print("`" + surrogate + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)logicObject.theStringReader()).fillInStackTrace();
    }

    public static Cons removeVariableTypePropositions(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND) {
            Cons cons = Stella.NIL;
            Proposition proposition2 = null;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((Proposition)stella_Object).variableTypeP())) {
                    cons = Stella_Object.cons((Stella_Object)stella_Object, (Cons)cons);
                    continue;
                }
                if (proposition2 != null) continue;
                proposition2 = (Proposition)stella_Object;
            }
            Proposition.overlayProposition(proposition, proposition2);
            return cons;
        }
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_NOT) {
            return Stella.NIL;
        }
        return Stella.NIL;
    }

    public static void collectExternalVariables(Proposition proposition) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            ContextSensitiveObject contextSensitiveObject;
            stella_Object = vector.theArray[i];
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                contextSensitiveObject = (PatternVariable)stella_Object;
                if (!((Cons)Logic.$LOGICVARIABLETABLE$.get()).memberP((Stella_Object)contextSensitiveObject) || ((Cons)Logic.$EXTERNALVARIABLES$.get()).memberP((Stella_Object)contextSensitiveObject)) continue;
                Native.setSpecial((ThreadLocal)Logic.$EXTERNALVARIABLES$, (Object)Stella_Object.cons((Stella_Object)contextSensitiveObject, (Cons)((Cons)Logic.$EXTERNALVARIABLES$.get())));
                continue;
            }
            if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            contextSensitiveObject = (Proposition)stella_Object;
            Proposition.collectExternalVariables((Proposition)contextSensitiveObject);
        }
    }

    public static void collectAllVariables(Proposition proposition, List list, List list2) {
        list2.insert((Stella_Object)proposition);
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            ContextSensitiveObject contextSensitiveObject;
            stella_Object = vector.theArray[i];
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                contextSensitiveObject = (PatternVariable)stella_Object;
                list.insertNew((Stella_Object)contextSensitiveObject);
                continue;
            }
            if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION) || list2.memberP((Stella_Object)(contextSensitiveObject = (Proposition)stella_Object))) continue;
            Proposition.collectAllVariables((Proposition)contextSensitiveObject, list, list2);
        }
    }

    public static void equateTopLevelEquivalences(Proposition proposition) {
        Vector vector = proposition.arguments;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_EQUIVALENT) {
            Logic.equateValues(Logic.innermostOf(vector.theArray[0]), Logic.innermostOf(vector.theArray[1]));
        } else if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector2 = vector;
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector2.theArray[i];
                Proposition.equateTopLevelEquivalences((Proposition)stella_Object);
            }
        } else if (keyword == Logic.KWD_EXISTS) {
            Proposition.equateTopLevelEquivalences((Proposition)vector.theArray[0]);
        } else if (keyword == Logic.KWD_FUNCTION) {
            Proposition.evaluateFunctionProposition(proposition);
        }
    }

    public static void tightenArgumentBindings(Proposition proposition, Vector vector) {
        Stella_Object stella_Object = null;
        Object object = proposition.arguments;
        int n = 0;
        int n2 = object.length();
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        while (n < n2) {
            ContextSensitiveObject contextSensitiveObject;
            stella_Object = object.theArray[n];
            n3 = n4;
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                Stella_Object stella_Object2;
                contextSensitiveObject = (PatternVariable)stella_Object;
                Object object2 = stella_Object2 = vector != null && vector.memberP((Stella_Object)contextSensitiveObject) ? PatternVariable.innermostVariableOf((PatternVariable)contextSensitiveObject) : Logic.innermostOf((Stella_Object)contextSensitiveObject);
                if (stella_Object2 != contextSensitiveObject) {
                    proposition.arguments.theArray[n3] = stella_Object2;
                }
            } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                contextSensitiveObject = (Proposition)stella_Object;
                Proposition.tightenArgumentBindings((Proposition)contextSensitiveObject, vector);
            }
            ++n;
            ++n4;
        }
        if ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null) != null) {
            stella_Object = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            object = null;
            Stella_Object stella_Object3 = stella_Object;
            n2 = 0;
            n3 = stella_Object3.length();
            n4 = Integer.MIN_VALUE;
            int n5 = 0;
            while (n2 < n3) {
                object = (PatternVariable)stella_Object3.theArray[n2];
                n4 = n5;
                if (object != PatternVariable.innermostVariableOf((PatternVariable)((Object)object))) {
                    stella_Object.theArray[n4] = null;
                }
                ++n2;
                ++n5;
            }
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.removeNullsInVariablesVector((Vector)stella_Object), null);
            Proposition.normalizeProposition(proposition);
        }
    }

    public static Proposition flattenNestedFunctionArguments(Proposition proposition) {
        Proposition proposition2 = Logic.createProposition(Logic.SYM_STELLA_EXISTS, 1);
        List list = List.newList();
        List list2 = Proposition.yieldFlattenedArguments(proposition, list);
        Proposition proposition3 = Logic.createProposition(Logic.SYM_STELLA_AND, list2.length());
        ContextSensitiveObject contextSensitiveObject = null;
        Cons cons = list2.theConsList;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (cons != Stella.NIL) {
            contextSensitiveObject = (Proposition)cons.value;
            n = n2++;
            proposition3.arguments.theArray[n] = contextSensitiveObject;
            cons = cons.rest;
        }
        contextSensitiveObject = null;
        cons = list.theConsList;
        while (cons != Stella.NIL) {
            contextSensitiveObject = (PatternVariable)cons.value;
            contextSensitiveObject.definingProposition = null;
            cons = cons.rest;
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, (Stella_Object)Logic.copyConsListToVariablesVector(list.theConsList), null);
        list.free();
        proposition2.arguments.theArray[0] = proposition3;
        return proposition2;
    }

    public static List yieldFlattenedArguments(Proposition proposition, List list) {
        List list2 = List.newList();
        Proposition.helpCollectFlattenedArguments(proposition, list2, list);
        list2.push((Stella_Object)proposition);
        list.reverse();
        return list2.reverse();
    }

    public static void helpCollectFlattenedArguments(Proposition proposition, List list, List list2) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object), (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) continue;
            PatternVariable patternVariable = (PatternVariable)stella_Object;
            Proposition proposition2 = patternVariable.definingProposition;
            if (proposition2 == null || list2.memberP((Stella_Object)patternVariable)) continue;
            list2.push((Stella_Object)patternVariable);
            Proposition.helpCollectFlattenedArguments(proposition2, list, list2);
            if (proposition2.operator == Logic.SGT_STELLA_PROPOSITIONdIF) {
                list.push((Stella_Object)Proposition.expandIfProposition(proposition2));
                continue;
            }
            list.push((Stella_Object)proposition2);
        }
    }

    public static Proposition expandIfProposition(Proposition proposition) {
        Vector vector = proposition.arguments;
        Stella_Object stella_Object = vector.theArray[0];
        Proposition proposition2 = Logic.createProposition(Logic.SYM_STELLA_NOT, 1);
        Stella_Object stella_Object2 = vector.theArray[1];
        Stella_Object stella_Object3 = vector.theArray[2];
        PatternVariable patternVariable = (PatternVariable)proposition.arguments.theArray[proposition.arguments.length() - 1];
        Proposition proposition3 = Logic.createEquivalenceProposition((Stella_Object)patternVariable, stella_Object2);
        Proposition proposition4 = stella_Object3 != null ? Logic.createEquivalenceProposition((Stella_Object)patternVariable, stella_Object3) : (Proposition)null;
        patternVariable.definingProposition = null;
        if (stella_Object3 != null) {
            proposition2.arguments.theArray[0] = Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE) ? stella_Object : Proposition.shallowCopyProposition((Proposition)stella_Object);
            return Logic.disjoinPropositions(Stella.consList((Cons)Stella_Object.cons((Stella_Object)Proposition.conjoinTwoPropositions((Proposition)stella_Object, proposition3), (Cons)Stella_Object.cons((Stella_Object)Proposition.conjoinTwoPropositions(proposition2, proposition4), (Cons)Stella.NIL))));
        }
        return Proposition.conjoinTwoPropositions((Proposition)stella_Object, proposition3);
    }

    public static boolean containsNestedArgumentP(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_EQUIVALENT || keyword == Logic.KWD_IMPLIES) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object), (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) continue;
                PatternVariable patternVariable = (PatternVariable)stella_Object;
                if (patternVariable.definingProposition == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unifyPropositionsP(Proposition proposition, Proposition proposition2, KeyValueList keyValueList) {
        Object object = Logic.$UNIFY_PROPOSITIONSp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Logic.$UNIFY_PROPOSITIONSp$, (boolean)true);
            boolean bl = Proposition.equivalentPropositionsP(proposition, proposition2, keyValueList);
            return bl;
        }
        finally {
            Logic.$UNIFY_PROPOSITIONSp$.set(object);
        }
    }

    public static boolean equivalentFunctionPropositionsP(Proposition proposition, Proposition proposition2, KeyValueList keyValueList) {
        if (proposition.kind == Logic.KWD_FUNCTION && proposition2.kind == Logic.KWD_FUNCTION) {
            if (keyValueList == null) {
                keyValueList = KeyValueList.newKeyValueList();
            }
            keyValueList.insertAt(proposition.arguments.theArray[proposition.arguments.length() - 1], proposition2.arguments.theArray[proposition2.arguments.length() - 1]);
            return Proposition.equivalentPropositionsP(proposition, proposition2, keyValueList);
        }
        return false;
    }

    public static boolean equivalentPropositionsP(Proposition proposition, Proposition proposition2, KeyValueList keyValueList) {
        int n;
        Object object;
        int n2;
        Object object2;
        Vector vector;
        if (proposition == proposition2) {
            return true;
        }
        if (proposition.kind != proposition2.kind) {
            return false;
        }
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND || keyword == Logic.KWD_OR || keyword == Logic.KWD_EQUIVALENT) {
            return Proposition.equivalentCommutativePropositionsP(proposition, proposition2, keyValueList);
        }
        Keyword keyword2 = proposition.kind;
        if (keyword2 == Logic.KWD_FORALL || keyword2 == Logic.KWD_EXISTS) {
            Vector vector2 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            if (vector2.length() != vector.length()) {
                return false;
            }
            if (keyValueList == null) {
                keyValueList = KeyValueList.newKeyValueList();
            }
            object2 = null;
            Vector vector3 = vector2;
            n2 = 0;
            int n3 = vector3.length();
            object = null;
            Vector vector4 = vector;
            int n4 = vector4.length();
            for (n = 0; n2 < n3 && n < n4; ++n2, ++n) {
                object2 = (PatternVariable)vector3.theArray[n2];
                object = (PatternVariable)vector4.theArray[n];
                keyValueList.insertAt((Stella_Object)object2, (Stella_Object)object);
            }
        }
        boolean bl = false;
        boolean bl2 = bl = proposition.operator == proposition2.operator;
        if (bl) {
            boolean bl3 = true;
            vector = null;
            object2 = proposition.arguments;
            int n5 = 0;
            n2 = object2.length();
            Stella_Object stella_Object = null;
            object = proposition2.arguments;
            n = object.length();
            for (int i = 0; n5 < n2 && i < n; ++n5, ++i) {
                vector = object2.theArray[n5];
                stella_Object = object.theArray[i];
                if (Logic.equivalentFormulaeP((Stella_Object)vector, stella_Object, keyValueList)) continue;
                bl3 = false;
                break;
            }
            if (bl = bl3) {
                boolean bl4 = bl = proposition.arguments.length() == proposition2.arguments.length();
            }
        }
        if (!bl) {
            bl = keyValueList != null && proposition.operator == Logic.SGT_PL_KERNEL_KB_HOLDS && Proposition.equivalentHoldsPropositionP(proposition, proposition2, keyValueList);
        }
        boolean bl5 = bl;
        return bl5;
    }

    public static boolean equivalentCommutativePropositionsP(Proposition proposition, Proposition proposition2, KeyValueList keyValueList) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl2 = proposition.operator == proposition2.operator;
        if (bl2) {
            boolean bl4 = bl2 = proposition.arguments.length() == proposition2.arguments.length();
            if (bl2) {
                bl = true;
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    stella_Object = vector.theArray[i];
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Stella_Object stella_Object2 = null;
                    Vector vector2 = proposition2.arguments;
                    int n2 = vector2.length();
                    for (int j = 0; j < n2; ++j) {
                        stella_Object2 = vector2.theArray[j];
                        if (!Logic.equivalentFormulaeP(stella_Object, stella_Object2, keyValueList)) continue;
                        bl6 = true;
                        break;
                    }
                    boolean bl7 = bl5 = !(bl5 = bl6);
                    if (!bl5) continue;
                    bl = false;
                    break;
                }
                bl2 = bl;
            }
        }
        bl = bl2;
        return bl;
    }

    public static boolean equivalentHoldsPropositionP(Proposition proposition, Proposition proposition2, KeyValueList keyValueList) {
        boolean bl;
        boolean bl2 = false;
        bl2 = Logic.equivalentFormulaeP(proposition.arguments.theArray[0], (Stella_Object)proposition2.operator, keyValueList);
        if (bl2) {
            boolean bl3 = bl2 = proposition.arguments.length() - 1 == proposition2.arguments.length();
            if (bl2) {
                bl = true;
                int n = Integer.MIN_VALUE;
                int n2 = 1;
                Stella_Object stella_Object = null;
                Vector vector = proposition2.arguments;
                int n3 = vector.length();
                for (int i = 0; i < n3; ++i) {
                    stella_Object = vector.theArray[i];
                    if (Logic.equivalentFormulaeP(proposition.arguments.theArray[n = n2++], stella_Object, keyValueList)) continue;
                    bl = false;
                    break;
                }
                bl2 = bl;
            }
        }
        bl = bl2;
        return bl;
    }

    public static void inheritTruthValueUpdate(Proposition proposition, World world) {
    }

    public static boolean metaPropositionP(Proposition proposition) {
        if (proposition == null) {
            return false;
        }
        boolean bl = false;
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            Description description;
            stella_Object = vector.theArray[i];
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
                description = (Description)stella_Object;
                bl = true;
                continue;
            }
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_LITERAL_WRAPPER)) {
                description = (LiteralWrapper)stella_Object;
                continue;
            }
            return false;
        }
        return bl;
    }

    public static String factToSentence(Proposition proposition, boolean bl) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA) {
            List list;
            NamedDescription namedDescription = (NamedDescription)((Surrogate)proposition.operator).surrogateValue;
            Stella_Object stella_Object = Logic.accessBinaryValue((Stella_Object)namedDescription, Logic.SGT_PL_KERNEL_KB_PHRASE);
            List list2 = list = stella_Object != null ? Logic.explodeVariablizedString(((StringWrapper)stella_Object).wrapperValue) : (List)null;
            if (list != null) {
                KeyValueList keyValueList = KeyValueList.newKeyValueList();
                String string = "";
                Symbol symbol = null;
                Cons cons = namedDescription.ioVariableNames.theConsList;
                Stella_Object stella_Object2 = null;
                Object object = proposition.arguments;
                int n = object.length();
                for (int i = 0; cons != Stella.NIL && i < n; ++i) {
                    symbol = (Symbol)cons.value;
                    stella_Object2 = object.theArray[i];
                    keyValueList.insertAt((Stella_Object)symbol, stella_Object2);
                    cons = cons.rest;
                }
                symbol = null;
                cons = list.theConsList;
                while (cons != Stella.NIL) {
                    Symbol symbol2;
                    symbol = cons.value;
                    stella_Object2 = null;
                    object = null;
                    Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)symbol);
                    if (Surrogate.subtypeOfSymbolP((Surrogate)surrogate)) {
                        symbol2 = symbol;
                        stella_Object2 = keyValueList.lookup((Stella_Object)symbol2);
                        if (stella_Object2 != null) {
                            Surrogate surrogate2;
                            LogicObject logicObject;
                            Surrogate surrogate3 = Stella_Object.safePrimaryType((Stella_Object)stella_Object2);
                            if (Surrogate.subtypeOfP((Surrogate)surrogate3, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                                logicObject = (Skolem)stella_Object2;
                                surrogate2 = logicObject.surrogateValueInverse;
                                Proposition proposition2 = logicObject.definingProposition;
                                object = proposition2 != null ? Proposition.factToSentence(proposition2, false) : (surrogate2 != null ? surrogate2.symbolName : logicObject.skolemName.symbolName);
                            } else if (Surrogate.subtypeOfP((Surrogate)surrogate3, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
                                logicObject = (LogicObject)stella_Object2;
                                surrogate2 = logicObject.surrogateValueInverse;
                                if (surrogate2 != null) {
                                    object = surrogate2.symbolName;
                                }
                            } else if (Surrogate.subtypeOfStringP((Surrogate)surrogate3)) {
                                logicObject = (StringWrapper)stella_Object2;
                                object = "'" + ((StringWrapper)logicObject).wrapperValue + "'";
                            } else if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate3)) {
                                logicObject = (IntegerWrapper)stella_Object2;
                                object = Native.integerToString((int)((IntegerWrapper)logicObject).wrapperValue);
                            } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate3)) {
                                logicObject = (FloatWrapper)stella_Object2;
                                object = Native.floatToString((double)((FloatWrapper)logicObject).wrapperValue);
                            }
                        }
                        string = object != null ? string + (String)object : string + symbol2.symbolName;
                    } else if (Surrogate.subtypeOfStringP((Surrogate)surrogate)) {
                        symbol2 = (StringWrapper)symbol;
                        string = string + symbol2.wrapperValue;
                    } else {
                        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                        outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
                        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
                    }
                    cons = cons.rest;
                }
                if (bl) {
                    string = string + ".";
                }
                return string;
            }
            return null;
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return "rules not yet implemented";
        }
        return "???";
    }

    public static void collectFunctionPropositionFacts(Proposition proposition, List list, List list2, boolean bl) {
        boolean bl2;
        list2.insert((Stella_Object)proposition);
        Stella_Object stella_Object = proposition.arguments.theArray[proposition.arguments.length() - 1];
        Stella_Object stella_Object2 = Logic.valueOf(stella_Object);
        boolean bl3 = bl2 = !Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)stella_Object);
        if (bl2 && !list.memberP((Stella_Object)proposition)) {
            list.insert((Stella_Object)proposition);
        }
        if (!bl2 || Logic.nativeValueP(stella_Object2) && !Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_STELLA_LITERAL_WRAPPER)) {
            Logic.helpCollectFacts(stella_Object, list, list2, bl);
        }
    }

    public static void elaborateSurrogatesInProposition(Proposition proposition) {
        block2: {
            Keyword keyword;
            block3: {
                if (!Logic.$JUST_IN_TIME_FORWARD_INFERENCEp$) break block2;
                keyword = proposition.kind;
                if (keyword != Logic.KWD_PREDICATE && keyword != Logic.KWD_FUNCTION && keyword != Logic.KWD_ISA) break block3;
                Logic.elaborateMetaInstance((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)));
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    Stella_Object stella_Object2;
                    stella_Object = vector.theArray[i];
                    if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_STELLA_SURROGATE) || (stella_Object2 = Logic.valueOf(stella_Object)) == null) continue;
                    Logic.elaborateInstance(stella_Object2);
                }
                break block2;
            }
            if (keyword != Logic.KWD_AND && keyword != Logic.KWD_OR && keyword != Logic.KWD_NOT && keyword != Logic.KWD_EXISTS && keyword != Logic.KWD_FORALL) break block2;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.elaborateSurrogatesInProposition((Proposition)stella_Object);
            }
        }
    }

    public static void recursivelyReactToInferenceUpdate(Proposition proposition) {
        proposition.reactToInferenceUpdate();
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            Proposition.recursivelyReactToInferenceUpdate((Proposition)stella_Object);
        }
    }

    public static void evaluateProposition(Proposition proposition) {
        Proposition.evaluationStateSetter(proposition, Logic.KWD_EVALUATED);
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND) {
            Proposition.evaluateAndProposition(proposition);
        } else if (keyword == Logic.KWD_OR) {
            Proposition.evaluateOrProposition(proposition);
        } else if (keyword == Logic.KWD_NOT) {
            Proposition.evaluateNotProposition(proposition);
        } else if (keyword == Logic.KWD_EQUIVALENT) {
            Proposition.evaluateEquivalentProposition(proposition);
        } else if (keyword != Logic.KWD_ISA && (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_PREDICATE)) {
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            Method method = NamedDescription.lookupEvaluator(namedDescription);
            if (method != null) {
                Native.funcall((Method)method, null, (Object[])new Object[]{proposition});
            } else if (proposition.kind == Logic.KWD_PREDICATE) {
                Proposition.evaluatePredicateProposition(proposition);
            } else {
                Proposition.evaluateFunctionProposition(proposition);
            }
        }
    }

    public static void evaluatePredicateProposition(Proposition proposition) {
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Method method = NamedDescription.lookupConstraint(namedDescription);
        Cons cons = Stella.NIL;
        boolean bl = false;
        if (method != null) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            Cons cons2 = null;
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (Stella_Object.isaP((Stella_Object)Logic.valueOf(stella_Object), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    return;
                }
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                    if (cons == Stella.NIL) {
                        cons = cons2;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                    continue;
                }
                cons2 = cons2.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
            }
            bl = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)Stella.apply((Method)method, (Cons)Stella_Object.cons((Stella_Object)IntegerWrapper.wrapInteger((int)-1), (Cons)cons))));
            Proposition.assignTruthValue(proposition, (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER));
            return;
        }
        method = NamedDescription.lookupComputation(namedDescription);
        if (method != null) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            Cons cons3 = null;
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (Stella_Object.isaP((Stella_Object)Logic.valueOf(stella_Object), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    return;
                }
                if (cons3 == null) {
                    cons3 = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                    if (cons == Stella.NIL) {
                        cons = cons3;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons3);
                    continue;
                }
                cons3 = cons3.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
            }
            bl = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)Stella.apply((Method)method, (Cons)cons)));
            Proposition.assignTruthValue(proposition, (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void evaluateFunctionProposition(Proposition proposition) {
        if (Stella_Object.isaP((Stella_Object)proposition.operator, (Surrogate)Logic.SGT_STELLA_SYMBOL)) {
            return;
        }
        Proposition.equateEquivalentFunctionPropositions(proposition);
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Method method = NamedDescription.lookupConstraint(namedDescription);
        Stella_Object stella_Object = null;
        Cons cons = Stella.NIL;
        Stella_Object stella_Object2 = null;
        Stella_Object stella_Object3 = null;
        int n = -1;
        if (method != null) {
            Stella_Object stella_Object4 = null;
            Vector vector = proposition.arguments;
            int n2 = 0;
            int n3 = vector.length();
            Stella_Object stella_Object5 = null;
            Iterator iterator = NamedDescription.allArgumentTypes(namedDescription);
            int n4 = Integer.MIN_VALUE;
            int n5 = 0;
            Cons cons2 = null;
            while (n2 < n3 && iterator.nextP()) {
                stella_Object4 = vector.theArray[n2];
                stella_Object5 = iterator.value;
                n4 = n5;
                stella_Object = Logic.valueOf(stella_Object4);
                if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    if (n != -1) return;
                    n = n4;
                    stella_Object = null;
                } else if (!Logic.checkStrictTypeP(stella_Object, (Surrogate)stella_Object5, true)) {
                    return;
                }
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                    if (cons == Stella.NIL) {
                        cons = cons2;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                    }
                } else {
                    cons2 = cons2.rest = Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL);
                }
                ++n2;
                ++n5;
            }
            if (n == -1) {
                return;
            }
            stella_Object2 = Stella.apply((Method)method, (Cons)Stella_Object.cons((Stella_Object)IntegerWrapper.wrapInteger((int)n), (Cons)cons));
            if (Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)(stella_Object3 = Logic.valueOf(proposition.arguments.theArray[n]))) || stella_Object2 == null) return;
            Logic.equateValues(stella_Object2, stella_Object3);
            return;
        }
        method = NamedDescription.lookupComputation(namedDescription);
        if (method == null) return;
        Stella_Object stella_Object6 = null;
        Iterator iterator = proposition.arguments.butLast();
        Cons cons3 = null;
        while (iterator.nextP()) {
            stella_Object6 = iterator.value;
            if (Stella_Object.isaP((Stella_Object)Logic.valueOf(stella_Object6), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                return;
            }
            if (cons3 == null) {
                cons3 = Stella_Object.cons((Stella_Object)Logic.valueOf(stella_Object6), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons3;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons3);
                continue;
            }
            cons3 = cons3.rest = Stella_Object.cons((Stella_Object)Logic.valueOf(stella_Object6), (Cons)Stella.NIL);
        }
        stella_Object2 = Stella.apply((Method)method, (Cons)cons);
        if (stella_Object2 != null) {
            stella_Object2 = Logic.evaluateTerm(stella_Object2);
        }
        if (Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)(stella_Object3 = Logic.valueOf(proposition.arguments.theArray[proposition.arguments.length() - 1]))) || stella_Object2 == null) return;
        Logic.equateValues(stella_Object2, stella_Object3);
    }

    public static void equateEquivalentFunctionPropositions(Proposition proposition) {
        Object object;
        LogicObject logicObject;
        Surrogate surrogate = (Surrogate)proposition.operator;
        int n = proposition.arguments.length();
        List list = List.newList();
        Object object2 = null;
        Vector vector = proposition.arguments;
        int n2 = 0;
        int n3 = vector.length();
        int n4 = Integer.MIN_VALUE;
        int n5 = 1;
        while (n2 < n3) {
            object2 = vector.theArray[n2];
            n4 = n5;
            if (n4 != n) {
                Iterator iterator;
                Proposition proposition2;
                Cons cons;
                Surrogate surrogate2 = Stella_Object.safePrimaryType((Stella_Object)object2);
                if (Surrogate.subtypeOfP((Surrogate)surrogate2, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    logicObject = (Skolem)((Object)object2);
                    if (Stella_Object.accessInContext((Stella_Object)((Skolem)logicObject).variableValue, (Context)((Skolem)logicObject).homeContext, (boolean)false) != null && Stella_Object.isaP((Stella_Object)Stella_Object.accessInContext((Stella_Object)((Skolem)logicObject).variableValue, (Context)((Skolem)logicObject).homeContext, (boolean)false), (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
                        object = null;
                        cons = Logic.unfilteredDependentPropositions(Stella_Object.accessInContext((Stella_Object)((Skolem)logicObject).variableValue, (Context)((Skolem)logicObject).homeContext, (boolean)false), surrogate).allocateIterator();
                        while (cons.nextP()) {
                            object = (Proposition)cons.value;
                            if ((Surrogate)object.operator != surrogate || object == proposition) continue;
                            list.insertNew((Stella_Object)object);
                        }
                    }
                    object = null;
                    cons = logicObject.variableValueInverse();
                    while (cons != Stella.NIL) {
                        object = (LogicObject)cons.value;
                        proposition2 = null;
                        iterator = Logic.unfilteredDependentPropositions((Stella_Object)object, surrogate).allocateIterator();
                        while (iterator.nextP()) {
                            proposition2 = (Proposition)iterator.value;
                            if ((Surrogate)proposition2.operator != surrogate || proposition2 == proposition) continue;
                            list.insertNew((Stella_Object)proposition2);
                        }
                        cons = cons.rest;
                    }
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate2, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
                    logicObject = (LogicObject)((Object)object2);
                    object = null;
                    cons = logicObject.variableValueInverse();
                    while (cons != Stella.NIL) {
                        object = (LogicObject)cons.value;
                        proposition2 = null;
                        iterator = Logic.unfilteredDependentPropositions((Stella_Object)object, surrogate).allocateIterator();
                        while (iterator.nextP()) {
                            proposition2 = (Proposition)iterator.value;
                            if ((Surrogate)proposition2.operator != surrogate || proposition2 == proposition) continue;
                            list.insertNew((Stella_Object)proposition2);
                        }
                        cons = cons.rest;
                    }
                }
            }
            ++n2;
            ++n5;
        }
        object2 = null;
        vector = list.theConsList;
        while (vector != Stella.NIL) {
            object2 = (Proposition)vector.value;
            n2 = 1;
            Stella_Object stella_Object = null;
            Vector vector2 = proposition.arguments;
            n5 = 0;
            int n6 = vector2.length();
            logicObject = null;
            object = object2.arguments;
            int n7 = 0;
            int n8 = object.length();
            int n9 = Integer.MIN_VALUE;
            int n10 = 1;
            while (n5 < n6 && n7 < n8) {
                stella_Object = vector2.theArray[n5];
                logicObject = object.theArray[n7];
                n9 = n10;
                if (n9 != n && !Stella_Object.eqlP((Stella_Object)Logic.innermostOf(stella_Object), (Stella_Object)Logic.innermostOf((Stella_Object)logicObject))) {
                    n2 = 0;
                    break;
                }
                ++n5;
                ++n7;
                ++n10;
            }
            if (n2 != 0) {
                Logic.equateValues(Logic.innermostOf(proposition.arguments.last()), Logic.innermostOf(object2.arguments.last()));
            }
            vector = vector.rest;
        }
        list.free();
    }

    public static void evaluateEquivalentProposition(Proposition proposition) {
        Vector vector = proposition.arguments;
        Stella_Object stella_Object = Logic.innermostOf(vector.theArray[0]);
        Stella_Object stella_Object2 = Logic.innermostOf(vector.theArray[1]);
        if (Proposition.trueP(proposition)) {
            if (Proposition.defaultTrueP(proposition)) {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: INTERNAL ERROR: DON'T KNOW YET HOW TO EQUATE THINGS BY DEFAULT.");
            }
            Logic.equateValues(stella_Object, stella_Object2);
        } else if (Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.TRUE_WRAPPER);
        } else if (!Logic.skolemP(stella_Object) && !Logic.skolemP(stella_Object2)) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.FALSE_WRAPPER);
        }
    }

    public static void evaluateNotProposition(Proposition proposition) {
        Proposition proposition2 = (Proposition)proposition.arguments.theArray[0];
        if (Proposition.trueP(proposition2) || Proposition.falseP(proposition2)) {
            Proposition.assignTruthValue(proposition, (Stella_Object)TruthValue.invertTruthValue((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition2.truthValue, (Context)proposition2.homeContext, (boolean)false)));
        }
        if (Proposition.trueP(proposition) || Proposition.falseP(proposition)) {
            Proposition.assignTruthValue(proposition2, (Stella_Object)TruthValue.invertTruthValue((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)));
        }
    }

    public static void evaluateOrProposition(Proposition proposition) {
        Vector vector = proposition.arguments;
        if (Proposition.falseP(proposition)) {
            Proposition proposition2 = null;
            Vector vector2 = vector;
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                proposition2 = (Proposition)vector2.theArray[i];
                Proposition.assignTruthValue(proposition2, (Stella_Object)((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)));
            }
        } else if (Proposition.trueP(proposition)) {
            Proposition proposition3 = null;
            boolean bl = Proposition.defaultTrueP(proposition);
            Proposition proposition4 = null;
            Vector vector3 = vector;
            int n = vector3.length();
            for (int i = 0; i < n; ++i) {
                proposition4 = (Proposition)vector3.theArray[i];
                if (Proposition.trueP(proposition4)) {
                    return;
                }
                if (Proposition.unknownP(proposition4)) {
                    if (proposition3 != null) {
                        return;
                    }
                    proposition3 = proposition4;
                    continue;
                }
                if (!Proposition.defaultFalseP(proposition4)) continue;
                bl = true;
            }
            if (proposition3 != null) {
                Proposition.assignTruthValue(proposition3, (Stella_Object)Logic.defaultifyTruthValue(true, bl));
            } else {
                Proposition.assignTruthValue(proposition, (Stella_Object)Logic.defaultifyTruthValue(false, bl));
            }
        } else {
            boolean bl = false;
            boolean bl2 = false;
            Proposition proposition5 = null;
            Vector vector4 = vector;
            int n = vector4.length();
            for (int i = 0; i < n; ++i) {
                proposition5 = (Proposition)vector4.theArray[i];
                if (Proposition.trueP(proposition5)) {
                    if (Proposition.defaultTrueP(proposition5)) {
                        Proposition.assignTruthValue(proposition, (Stella_Object)Logic.DEFAULT_TRUE_TRUTH_VALUE);
                        continue;
                    }
                    Proposition.assignTruthValue(proposition, (Stella_Object)Stella.TRUE_WRAPPER);
                    return;
                }
                if (Proposition.unknownP(proposition5)) {
                    bl = true;
                    continue;
                }
                if (!Proposition.defaultFalseP(proposition5)) continue;
                bl2 = true;
            }
            if (!bl && !Proposition.defaultTrueP(proposition)) {
                Proposition.assignTruthValue(proposition, (Stella_Object)Logic.defaultifyTruthValue(false, bl2));
            }
        }
    }

    public static void evaluateAndProposition(Proposition proposition) {
        Vector vector = proposition.arguments;
        if (Proposition.trueP(proposition)) {
            Proposition proposition2 = null;
            Vector vector2 = vector;
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                proposition2 = (Proposition)vector2.theArray[i];
                Proposition.assignTruthValue(proposition2, (Stella_Object)((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)));
            }
        } else if (Proposition.falseP(proposition)) {
            Proposition proposition3 = null;
            boolean bl = Proposition.defaultFalseP(proposition);
            Proposition proposition4 = null;
            Vector vector3 = vector;
            int n = vector3.length();
            for (int i = 0; i < n; ++i) {
                proposition4 = (Proposition)vector3.theArray[i];
                if (Proposition.falseP(proposition4)) {
                    return;
                }
                if (Proposition.unknownP(proposition4)) {
                    if (proposition3 != null) {
                        return;
                    }
                    proposition3 = proposition4;
                    continue;
                }
                if (!Proposition.defaultTrueP(proposition4)) continue;
                bl = true;
            }
            if (proposition3 != null) {
                Proposition.assignTruthValue(proposition3, (Stella_Object)Logic.defaultifyTruthValue(false, bl));
            } else {
                Proposition.assignTruthValue(proposition, (Stella_Object)Logic.defaultifyTruthValue(true, bl));
            }
        } else {
            boolean bl = false;
            boolean bl2 = false;
            Proposition proposition5 = null;
            Vector vector4 = vector;
            int n = vector4.length();
            for (int i = 0; i < n; ++i) {
                proposition5 = (Proposition)vector4.theArray[i];
                if (Proposition.falseP(proposition5)) {
                    if (Proposition.defaultFalseP(proposition5)) {
                        Proposition.assignTruthValue(proposition, (Stella_Object)Logic.DEFAULT_FALSE_TRUTH_VALUE);
                        continue;
                    }
                    Proposition.assignTruthValue(proposition, (Stella_Object)Stella.FALSE_WRAPPER);
                    return;
                }
                if (Proposition.unknownP(proposition5)) {
                    bl = true;
                    continue;
                }
                if (!Proposition.defaultTrueP(proposition5)) continue;
                bl2 = true;
            }
            if (!bl && !Proposition.defaultFalseP(proposition)) {
                Proposition.assignTruthValue(proposition, (Stella_Object)Logic.defaultifyTruthValue(true, bl2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateNewProposition(Proposition proposition) {
        if (Logic.descriptionModeP()) {
            return;
        }
        World world = Logic.lookupConstraintPropagationWorld((Context)Stella.$CONTEXT$.get());
        if (world != null) {
            Object object = Stella.$CONTEXT$.get();
            try {
                Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)world);
                Proposition.evaluateProposition(proposition);
                if (!Proposition.unknownP(proposition)) {
                    if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_PROPAGATE)) {
                        System.out.println("evaluate-new-proposition:  " + (Object)((Object)proposition));
                    }
                    Proposition proposition2 = null;
                    Iterator iterator = proposition.dependentPropositions.allocateIterator();
                    while (iterator.nextP()) {
                        proposition2 = (Proposition)iterator.value;
                        Proposition.evaluateProposition(proposition2);
                    }
                }
            }
            finally {
                Stella.$CONTEXT$.set(object);
            }
        }
    }

    public void reactToInferenceUpdate() {
        Proposition proposition = this;
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        if (truthValue != (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) && truthValue != null) {
            Proposition.signalTruthValueClash(proposition);
        }
        Proposition.postForEvaluation(proposition);
        Proposition proposition2 = null;
        Iterator iterator = proposition.dependentPropositions.allocateIterator();
        while (iterator.nextP()) {
            proposition2 = (Proposition)iterator.value;
            Proposition.postForEvaluation(proposition2);
        }
        if (((Boolean)Logic.$FILLINGCONSTRAINTPROPAGATIONQUEUESp$.get()).booleanValue()) {
            Proposition.postToForwardChainingQueue(proposition, (World)((Context)Stella.$CONTEXT$.get()));
        }
    }

    public static boolean applicableForwardRuleP(Proposition proposition, Vector vector) {
        Description description = (Description)proposition.arguments.theArray[0];
        return Proposition.trueP(proposition) && vector.length() == description.ioVariables.length();
    }

    public static void traceForwardRule(Proposition proposition, Proposition proposition2, Cons cons) {
        if (cons != null && cons != Stella.NIL) {
            int n = 11;
            System.out.println("RUNNING FORWARD RULE:");
            System.out.print("  TRIGGER: ");
            Logic.printFormula((Stella_Object)proposition2, n);
            if (Proposition.falseP(proposition2)) {
                System.out.print(")");
            }
            System.out.println();
            System.out.print("  RULE:    ");
            Logic.printFormula((Stella_Object)proposition, n);
            System.out.println();
            System.out.print("  RESULT:  ");
            if (cons.rest != Stella.NIL) {
                System.out.print("(" + Logic.stringifiedSurrogate(Logic.SGT_PL_KERNEL_KB_AND) + " ");
                n += 5;
            }
            Proposition proposition3 = null;
            Cons cons2 = cons;
            int n2 = Integer.MIN_VALUE;
            int n3 = 1;
            while (cons2 != Stella.NIL) {
                proposition3 = (Proposition)cons2.value;
                n2 = n3;
                if (n2 > 1) {
                    boolean bl;
                    System.out.println();
                    int n4 = Integer.MIN_VALUE;
                    int n5 = n;
                    boolean bl2 = bl = n5 == Integer.MIN_VALUE;
                    for (int i = 1; bl || i <= n5; ++i) {
                        n4 = i;
                        System.out.print(" ");
                    }
                }
                Logic.printFormula((Stella_Object)proposition3, n);
                cons2 = cons2.rest;
                ++n3;
            }
            if (cons.rest != Stella.NIL) {
                System.out.print(")");
                n -= 5;
            }
            System.out.println();
        }
    }

    public static void postToForwardChainingQueue(Proposition proposition, World world) {
        if (Proposition.unknownP(proposition) && proposition.kind != Logic.KWD_FUNCTION) {
            return;
        }
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)world.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_CHAINING_QUEUE, null);
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            boolean bl = false;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_SKOLEM) || ((Skolem)stella_Object).definingProposition != null || ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Skolem)stella_Object).dynamicSlots, (Symbol)Logic.SYM_LOGIC_HYPOTHESIZED_INSTANCEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) continue;
                bl = true;
                break;
            }
            if (bl && (Cons)Logic.$COLLECTFORWARDPROPOSITIONS$.get() != null) {
                return;
            }
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            if (namedDescription != null && Description.hasForwardChainingRulesP(namedDescription, proposition)) {
                list.push((Stella_Object)proposition);
            }
        }
    }

    public static void postForEvaluation(Proposition proposition) {
        if (!((Boolean)Logic.$FILLINGCONSTRAINTPROPAGATIONQUEUESp$.get()).booleanValue()) {
            Proposition.evaluateProposition(proposition);
            return;
        }
        if (Proposition.evaluationState(proposition) == Logic.KWD_POSTED) {
            return;
        }
        ((List)KeyValueList.dynamicSlotValue((KeyValueList)((Context)Stella.$CONTEXT$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_EVALUATION_QUEUE, null)).insert((Stella_Object)proposition);
        Proposition.evaluationStateSetter(proposition, Logic.KWD_POSTED);
    }

    public static void evaluationStateSetter(Proposition proposition, Keyword keyword) {
        HashTable hashTable = (HashTable)KeyValueList.dynamicSlotValue((KeyValueList)((Context)Stella.$CONTEXT$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_EVALUATION_STATE_TABLE, null);
        if (hashTable == null) {
            return;
        }
        hashTable.insertAt((Stella_Object)proposition, (Stella_Object)keyword);
    }

    public static Keyword evaluationState(Proposition proposition) {
        HashTable hashTable = (HashTable)KeyValueList.dynamicSlotValue((KeyValueList)((Context)Stella.$CONTEXT$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_EVALUATION_STATE_TABLE, null);
        if (hashTable == null) {
            return null;
        }
        return (Keyword)hashTable.lookup((Stella_Object)proposition);
    }

    public static void updateDescriptionExtension(Proposition proposition) {
        if (Logic.descriptionModeP()) {
            return;
        }
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            SequenceIndex sequenceIndex = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                LogicObject logicObject;
                sequenceIndex = vector.theArray[i];
                Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)sequenceIndex);
                if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    logicObject = (PatternVariable)((Object)sequenceIndex);
                    return;
                }
                if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    logicObject = (Skolem)((Object)sequenceIndex);
                    if ((!NamedDescription.classDescriptionP(namedDescription) || !Logic.literalTypeP(namedDescription.surrogateValueInverse)) && !((Boolean)Logic.$SUPPRESSINSERTIONINTOCLASSEXTENSIONp$.get()).booleanValue() && !((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)logicObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_HYPOTHESIZED_INSTANCEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) continue;
                    return;
                }
                if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) continue;
                logicObject = (LogicObject)((Object)sequenceIndex);
                if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)logicObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_HYPOTHESIZED_INSTANCEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) continue;
                return;
            }
            sequenceIndex = NamedDescription.getDescriptionExtension(namedDescription, true);
            if (!((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue()) {
                sequenceIndex.insert((Stella_Object)proposition);
            }
        }
    }

    public static Proposition findMatchingConceivedProposition(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA || keyword == Logic.KWD_EQUIVALENT) {
            Stella_Object stella_Object = Proposition.selectArgumentWithBacklinks(proposition, new Object[1]);
            if (stella_Object == null) {
                return null;
            }
            Proposition proposition2 = null;
            Proposition proposition3 = null;
            Iterator iterator = Logic.unfilteredDependentPropositions(stella_Object, (Surrogate)proposition.operator).allocateIterator();
            while (iterator.nextP()) {
                proposition3 = (Proposition)iterator.value;
                if ((Surrogate)proposition3.operator != proposition.operator || !Proposition.argumentsMatchArgumentsP(proposition3, proposition)) continue;
                proposition2 = proposition3;
                break;
            }
            proposition3 = proposition2;
            return proposition3;
        }
        return proposition;
    }

    public static SequenceIndex findSimilarPropositions(Proposition proposition) {
        int n;
        int n2;
        Vector vector;
        Stella_Object stella_Object;
        if (proposition.kind == Logic.KWD_FUNCTION) {
            stella_Object = null;
            vector = proposition.arguments.butLast();
            while (vector.nextP()) {
                stella_Object = vector.value;
                if (!Logic.instanceHasBacklinksP(Logic.valueOf(stella_Object))) continue;
                return Logic.unfilteredDependentPropositions(Logic.valueOf(stella_Object), (Surrogate)proposition.operator);
            }
        } else {
            stella_Object = null;
            vector = proposition.arguments;
            n2 = vector.length();
            for (n = 0; n < n2; ++n) {
                stella_Object = vector.theArray[n];
                if (!Logic.instanceHasBacklinksP(stella_Object)) continue;
                return Logic.unfilteredDependentPropositions(stella_Object, (Surrogate)proposition.operator);
            }
        }
        Proposition.rewrapPropositionArguments(proposition);
        stella_Object = null;
        vector = proposition.arguments;
        n2 = vector.length();
        for (n = 0; n < n2; ++n) {
            stella_Object = vector.theArray[n];
            if (stella_Object == null || !Logic.instanceHasBacklinksP(stella_Object)) continue;
            return Logic.unfilteredDependentPropositions(stella_Object, (Surrogate)proposition.operator);
        }
        return Logic.NIL_NON_PAGING_INDEX;
    }

    public static Stella_Object selectArgumentWithBacklinks(Proposition proposition, Object[] objectArray) {
        int n;
        Surrogate surrogate = (Surrogate)proposition.operator;
        Keyword keyword = proposition.kind;
        Stella_Object stella_Object = null;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        Stella_Object stella_Object2 = null;
        boolean bl = false;
        Stella_Object stella_Object3 = null;
        Vector vector = proposition.arguments;
        int n4 = vector.length();
        for (n = 0; n < n4; ++n) {
            stella_Object3 = vector.theArray[n];
            stella_Object = Logic.argumentBoundTo(stella_Object3);
            if (stella_Object == null || (n2 = Logic.countBacklinksOnRelation(stella_Object, keyword, surrogate)) == Integer.MIN_VALUE || n3 != Integer.MIN_VALUE && n2 >= n3) continue;
            n3 = n2;
            stella_Object2 = stella_Object;
        }
        if (n3 == Integer.MIN_VALUE && bl) {
            stella_Object3 = null;
            vector = proposition.arguments;
            n4 = vector.length();
            for (n = 0; n < n4; ++n) {
                stella_Object3 = vector.theArray[n];
                stella_Object = Logic.argumentBoundTo(stella_Object3);
                if (stella_Object == null) continue;
            }
        }
        if (n3 == Integer.MIN_VALUE) {
            stella_Object3 = null;
            objectArray[0] = BooleanWrapper.wrapBoolean((boolean)false);
            return stella_Object3;
        }
        stella_Object3 = stella_Object2;
        objectArray[0] = BooleanWrapper.wrapBoolean((boolean)false);
        return stella_Object3;
    }

    public static void surrogatifyDiscouragedArguments(Proposition proposition) {
    }

    public static boolean inheritsTruthFromMasterP(Proposition proposition) {
        Proposition proposition2 = (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null);
        if (proposition2 != null && Proposition.trueP(proposition2)) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.TRUE_WRAPPER);
            return true;
        }
        return false;
    }

    public static void rewrapPropositionArguments(Proposition proposition) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = 0;
        int n2 = vector.length();
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        while (n < n2) {
            stella_Object = vector.theArray[n];
            n3 = n4;
            if (stella_Object != null && Logic.rewrapIthArgumentP(stella_Object, proposition, n3)) {
                proposition.arguments.theArray[n3] = Logic.rewrapArgument(stella_Object);
            }
            ++n;
            ++n4;
        }
    }

    public static String propositionHeadSortString(Proposition proposition) {
        if (proposition.kind == Logic.KWD_IMPLIES) {
            if (Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[0], (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) && Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[1], (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
                return "FORALL";
            }
            return "SUBSET-OF";
        }
        return proposition.operator.symbolName;
    }

    public static boolean propositionLessThanP(Proposition proposition, Proposition proposition2) {
        if (Stella.stringLessP((String)proposition.operator.symbolName, (String)proposition2.operator.symbolName)) {
            return true;
        }
        if (Stella.stringLessP((String)proposition2.operator.symbolName, (String)proposition.operator.symbolName)) {
            return false;
        }
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = 0;
        int n2 = vector.length();
        Stella_Object stella_Object2 = null;
        Vector vector2 = proposition2.arguments;
        int n3 = vector2.length();
        for (int i = 0; n < n2 && i < n3; ++n, ++i) {
            stella_Object = vector.theArray[n];
            stella_Object2 = vector2.theArray[i];
            if (Logic.logicFormLessP(stella_Object, stella_Object2)) {
                return true;
            }
            if (!Logic.logicFormLessP(stella_Object2, stella_Object)) continue;
            return false;
        }
        return proposition.arguments.length() < proposition2.arguments.length();
    }

    public static Proposition destroyProposition(Proposition proposition) {
        if (proposition.deletedP()) {
            return proposition;
        }
        proposition.deletedPSetter(true);
        if ((Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null) != null) {
            ((Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null)).surrogateValue = null;
        }
        Object object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            object = vector.theArray[i];
            if (object == null || object.deletedP()) continue;
            if (Logic.skolemP(object) && ((Skolem)((Object)object)).definingProposition == proposition) {
                LogicObject.destroyTerm((LogicObject)((Object)object));
            }
            Logic.removeDependentPropositionLink(object, proposition);
        }
        object = null;
        vector = proposition.dependentPropositions.copy().allocateIterator();
        while (vector.nextP()) {
            object = vector.value;
            Proposition.destroyProposition((Proposition)((Object)object));
        }
        object = null;
        vector = proposition.satellitePropositions().copy().theConsList;
        while (vector != Stella.NIL) {
            object = (Proposition)vector.value;
            Proposition.destroyProposition((Proposition)((Object)object));
            vector = vector.rest;
        }
        if ((Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null) != null) {
            ((Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null)).satellitePropositions().remove((Stella_Object)proposition);
        }
        if (proposition.homeContext != null) {
            Logic.handleOutOfDateInferenceCache(Logic.KWD_RETRACT, proposition);
        }
        proposition.dependentPropositions = null;
        proposition.operator = null;
        proposition.arguments = null;
        proposition.homeContext = null;
        proposition.truthValue = null;
        proposition.dynamicSlots = null;
        return proposition;
    }

    public static boolean deletedPropositionP(Proposition proposition) {
        return proposition.kind == Logic.KWD_DELETED;
    }

    public boolean deletedPSetter(boolean bl) {
        Proposition proposition = this;
        if (bl) {
            proposition.kind = Logic.KWD_DELETED;
        }
        return bl;
    }

    public boolean deletedP() {
        Proposition proposition = this;
        return Proposition.deletedPropositionP(proposition);
    }

    public static void unassertProposition(Proposition proposition) {
        if (proposition != null) {
            boolean bl;
            boolean bl2 = bl = proposition.kind == Logic.KWD_EQUIVALENT;
            if (Proposition.trueP(proposition)) {
                if (bl) {
                    Proposition.updateEquivalenceProposition(proposition, Logic.KWD_RETRACT_TRUE);
                } else {
                    Proposition.updatePropositionTruthValue(proposition, Logic.KWD_RETRACT_TRUE);
                }
            } else if (Proposition.falseP(proposition)) {
                if (bl) {
                    Proposition.updateEquivalenceProposition(proposition, Logic.KWD_RETRACT_FALSE);
                } else {
                    Proposition.updatePropositionTruthValue(proposition, Logic.KWD_RETRACT_FALSE);
                }
            } else if (Proposition.inconsistentP(proposition)) {
                if (bl) {
                    Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_INCONSISTENT);
                    Proposition.updateEquivalenceProposition(proposition, Logic.KWD_RETRACT_TRUE);
                    Proposition.updateEquivalenceProposition(proposition, Logic.KWD_RETRACT_FALSE);
                } else {
                    Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_INCONSISTENT);
                    Proposition.updatePropositionTruthValue(proposition, Logic.KWD_RETRACT_TRUE);
                    Proposition.updatePropositionTruthValue(proposition, Logic.KWD_RETRACT_FALSE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cons helpUpdateTopLevelProposition(Proposition proposition, Keyword keyword) {
        if (proposition == null) {
            return null;
        }
        if (Proposition.lookupAnnotation(proposition, Logic.KWD_CONFIDENCE_LEVEL) == Logic.KWD_DEFAULT && ((keyword = Logic.defaultifyUpdateMode(keyword)) == Logic.KWD_PRESUME_TRUE || keyword == Logic.KWD_PRESUME_FALSE)) {
            Proposition.removeAnnotation(proposition, Logic.KWD_CONFIDENCE_LEVEL);
        }
        if (Proposition.nativeSlotPropositionP(proposition)) {
            return Proposition.updateNativeSlotProposition(proposition, keyword);
        }
        Object object = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)Logic.getTopLevelUpdateContext());
            Keyword keyword2 = proposition.kind;
            if (keyword2 == Logic.KWD_AND) {
                Cons cons = Stella.NIL;
                Cons cons2 = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    cons2 = vector.theArray[i];
                    Proposition proposition2 = null;
                    Cons cons3 = Proposition.helpUpdateTopLevelProposition((Proposition)cons2, keyword);
                    Cons cons4 = null;
                    while (cons3 != Stella.NIL) {
                        proposition2 = (Proposition)cons3.value;
                        if (proposition2 != null && !proposition2.deletedP()) {
                            if (cons4 == null) {
                                cons4 = Stella_Object.cons((Stella_Object)proposition2, (Cons)Stella.NIL);
                                if (cons == Stella.NIL) {
                                    cons = cons4;
                                } else {
                                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons4);
                                }
                            } else {
                                cons4 = cons4.rest = Stella_Object.cons((Stella_Object)proposition2, (Cons)Stella.NIL);
                            }
                        }
                        cons3 = cons3.rest;
                    }
                }
                Proposition.eraseProposition(proposition);
                cons2 = cons;
                return cons2;
            }
            if (keyword2 == Logic.KWD_EQUIVALENT) {
                if ((proposition = Proposition.updateEquivalenceProposition(proposition, keyword)) == null) {
                    Cons cons = Stella.NIL;
                    return cons;
                }
            } else if (keyword2 == Logic.KWD_NOT) {
                Stella_Object stella_Object = proposition.arguments.theArray[0];
                if (keyword == Logic.KWD_ASSERT_TRUE || keyword == Logic.KWD_ASSERT_FALSE || keyword == Logic.KWD_PRESUME_TRUE || keyword == Logic.KWD_PRESUME_FALSE || keyword == Logic.KWD_RETRACT_TRUE || keyword == Logic.KWD_RETRACT_FALSE) {
                    Proposition.updatePropositionTruthValue((Proposition)stella_Object, Logic.invertUpdateMode(keyword));
                    Proposition.eraseProposition(proposition);
                    if (stella_Object != null && !stella_Object.deletedP()) {
                        Cons cons = Stella.consList((Cons)Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL));
                        return cons;
                    }
                    Cons cons = Stella.NIL;
                    return cons;
                }
            } else if (keyword2 == Logic.KWD_EXISTS) {
                Cons cons = Proposition.helpUpdateTopLevelProposition(Proposition.skolemizeExistsProposition(proposition), keyword);
                return cons;
            }
            if (proposition.kind != Logic.KWD_FUNCTION) {
                Proposition.updatePropositionTruthValue(proposition, keyword);
            }
            if (proposition.deletedP()) {
                keyword2 = Stella.NIL;
                return keyword2;
            }
            keyword2 = Stella.consList((Cons)Stella_Object.cons((Stella_Object)proposition, (Cons)Stella.NIL));
            return keyword2;
        }
        finally {
            Stella.$CONTEXT$.set(object);
        }
    }

    public static Proposition skolemizeExistsProposition(Proposition proposition) {
        KeyValueList keyValueList = KeyValueList.newKeyValueList();
        Proposition proposition2 = null;
        PatternVariable patternVariable = null;
        Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            patternVariable = (PatternVariable)vector.theArray[i];
            PatternVariable.createSkolemForUnmappedVariable(patternVariable, keyValueList);
        }
        proposition2 = Proposition.recursivelyFastenDownPropositions(Proposition.inheritProposition((Proposition)proposition.arguments.theArray[0], keyValueList), false);
        Proposition.eraseProposition(proposition);
        return proposition2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proposition updateEquivalenceProposition(Proposition proposition, Keyword keyword) {
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        if (Logic.skolemP(stella_Object) && Logic.skolemP(stella_Object2)) {
            if (keyword == Logic.KWD_PRESUME_TRUE) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("ERROR: Equating two skolems by default is not yet supported.");
                    outputStringStream.nativeStream.println(".");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
            }
            return proposition;
        }
        if (keyword == Logic.KWD_ASSERT_TRUE || keyword == Logic.KWD_PRESUME_TRUE) {
            Proposition.updatePropositionTruthValue(proposition, keyword);
            if (!Logic.clipValueP(stella_Object, stella_Object2) && !Logic.clipValueP(stella_Object2, stella_Object)) {
                Logic.equateValues(Logic.valueOf(stella_Object), Logic.valueOf(stella_Object2));
            }
        } else if (keyword == Logic.KWD_RETRACT_TRUE) {
            if (!Logic.unequateValuesP(stella_Object, stella_Object2) && Logic.unequateValuesP(stella_Object2, stella_Object)) {
                // empty if block
            }
        } else {
            if (keyword == Logic.KWD_CONCEIVE) {
                return proposition;
            }
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (Logic.functionOutputSkolemP(stella_Object) && !Logic.functionOutputSkolemP(stella_Object2)) {
            Proposition.runUpdatePropositionDemon(proposition, keyword);
            return proposition.deletedP() ? null : ((Skolem)stella_Object).definingProposition;
        }
        if (Logic.functionOutputSkolemP(stella_Object2) && !Logic.functionOutputSkolemP(stella_Object)) {
            Proposition.runUpdatePropositionDemon(proposition, keyword);
            return proposition.deletedP() ? null : ((Skolem)stella_Object2).definingProposition;
        }
        return null;
    }

    public static void eraseProposition(Proposition proposition) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (stella_Object == null) continue;
            Logic.removeDependentPropositionLink(stella_Object, proposition);
        }
        proposition.arguments.free();
        proposition.arguments = null;
        proposition.deletedPSetter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean functionWithDefinedValueP(Proposition proposition) {
        boolean bl;
        if (proposition.kind != Logic.KWD_FUNCTION) {
            return false;
        }
        Stella_Object stella_Object = proposition.arguments.last();
        boolean bl2 = bl = Logic.testPropertyP((Stella_Object)Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)), Logic.SGT_PL_KERNEL_KB_TOTAL) || Logic.extensionalIndividualP(Logic.valueOf(stella_Object));
        if (bl && !Logic.worldStateP((Context)Stella.$CONTEXT$.get())) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.TRUE_WRAPPER);
            if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                Skolem skolem = (Skolem)stella_Object;
                if (skolem.skolemType != null) {
                    Object object = Logic.$EVALUATIONMODE$.get();
                    Object object2 = Logic.$INVISIBLEASSERTIONp$.get();
                    try {
                        Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_EXTENSIONAL_ASSERTION);
                        Native.setBooleanSpecial((ThreadLocal)Logic.$INVISIBLEASSERTIONp$, (boolean)true);
                        Logic.assertIsaProposition((Stella_Object)skolem, skolem.skolemType);
                    }
                    finally {
                        Logic.$INVISIBLEASSERTIONp$.set(object2);
                        Logic.$EVALUATIONMODE$.set(object);
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proposition finishCreatingFunctionProposition(Proposition proposition) {
        int n = proposition.arguments.length();
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)proposition.operator);
        Surrogate surrogate = null;
        Skolem skolem = null;
        if (namedDescription != null) {
            surrogate = Logic.unwrapWrappedType((Surrogate)namedDescription.ioVariableTypes.last());
        }
        Object object = Stella.$CONTEXT$.get();
        Object object2 = Stella.$MODULE$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)proposition.homeContext);
            Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
            skolem = Logic.createVariableOrSkolem(surrogate, null);
        }
        finally {
            Stella.$MODULE$.set(object2);
            Stella.$CONTEXT$.set(object);
        }
        proposition.arguments.theArray[n - 1] = skolem;
        skolem.definingProposition = proposition;
        if (surrogate != null) {
            Skolem.updateSkolemType(skolem, surrogate);
        }
        if (proposition.operator == Logic.SGT_PL_KERNEL_KB_VALUE) {
            proposition = Proposition.normalizeValueFunction(proposition);
        }
        Proposition.verifyArgumentTypesAndCount(proposition);
        if (Stella_Object.isaP((Stella_Object)proposition.operator, (Surrogate)Logic.SGT_STELLA_SURROGATE)) {
            Proposition.fastenDownOneProposition(proposition, true);
        }
        return proposition;
    }

    public static Proposition findDuplicateFunctionProposition(Proposition proposition) {
        if (((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue() || !Stella_Object.isaP((Stella_Object)proposition.operator, (Surrogate)Logic.SGT_STELLA_SURROGATE)) {
            return null;
        }
        return Proposition.findDuplicateProposition(proposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyForallPropositions(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FORALL) {
            Proposition proposition2 = (Proposition)proposition.arguments.theArray[0];
            Proposition proposition3 = (Proposition)proposition.arguments.theArray[1];
            List list = null;
            List list2 = null;
            if (proposition2.kind == Logic.KWD_CONSTANT) {
                return;
            }
            list = Stella.list((Cons)Stella.NIL);
            list2 = Stella.list((Cons)Stella.NIL);
            Logic.collectFreeVariables((Stella_Object)proposition2, list, Stella.list((Cons)Stella.NIL), Stella.list((Cons)Stella.NIL));
            Logic.collectFreeVariables((Stella_Object)proposition3, list2, Stella.list((Cons)Stella.NIL), Stella.list((Cons)Stella.NIL));
            if (!list2.nonEmptyP() || !list2.subsetP(list)) {
                Object object = Logic.$TERMSOURCEBEINGPARSED$.get();
                Object object2 = Logic.$TERMUNDERCONSTRUCTION$.get();
                Object object3 = Stella.$PRINTREADABLYp$.get();
                Object object4 = Logic.$PRINTMODE$.get();
                Object object5 = Logic.$PRETTYPRINTLOGICALFORMSp$.get();
                Object object6 = Logic.$PRETTYPRINTKIFp$.get();
                try {
                    Native.setSpecial((ThreadLocal)Logic.$TERMSOURCEBEINGPARSED$, null);
                    Native.setSpecial((ThreadLocal)Logic.$TERMUNDERCONSTRUCTION$, null);
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_REALISTIC);
                    Native.setBooleanSpecial((ThreadLocal)Logic.$PRETTYPRINTLOGICALFORMSp$, (boolean)true);
                    Native.setBooleanSpecial((ThreadLocal)Logic.$PRETTYPRINTKIFp$, (boolean)true);
                    list2 = list2.difference(list);
                    Object object7 = Stella.$PRINTREADABLYp$.get();
                    try {
                        Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                        Stella.STANDARD_WARNING.nativeStream.println("WARNING: Potentially problematic implication rule, consequent variable(s) " + Stella.replaceSubstrings((String)Native.stringify((Stella_Object)list2.theConsList), (String)"?", (String)"|V|?"));
                        Stella.STANDARD_WARNING.nativeStream.println("   are not restricted/used by the antecedent: ");
                        Stella.STANDARD_WARNING.nativeStream.println((Object)proposition);
                        Logic.helpSignalPropositionError(Stella.STANDARD_WARNING, Logic.KWD_WARNING);
                    }
                    finally {
                        Stella.$PRINTREADABLYp$.set(object7);
                    }
                    Object var15_18 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    Logic.$PRETTYPRINTKIFp$.set(object6);
                    Logic.$PRETTYPRINTLOGICALFORMSp$.set(object5);
                    Logic.$PRINTMODE$.set(object4);
                    Stella.$PRINTREADABLYp$.set(object3);
                    Logic.$TERMUNDERCONSTRUCTION$.set(object2);
                    Logic.$TERMSOURCEBEINGPARSED$.set(object);
                    throw throwable;
                }
                Logic.$PRETTYPRINTKIFp$.set(object6);
                Logic.$PRETTYPRINTLOGICALFORMSp$.set(object5);
                Logic.$PRINTMODE$.set(object4);
                Stella.$PRINTREADABLYp$.set(object3);
                Logic.$TERMUNDERCONSTRUCTION$.set(object2);
                Logic.$TERMSOURCEBEINGPARSED$.set(object);
                {
                }
            }
        } else if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.verifyForallPropositions((Proposition)stella_Object);
            }
        }
    }

    public static boolean helpCollectSkolemizedExistsVariablesP(Proposition proposition, List list) {
        boolean bl;
        Vector vector = proposition.arguments;
        int n = vector.length();
        if (proposition.kind == Logic.KWD_FUNCTION) {
            --n;
        }
        Stella_Object stella_Object = null;
        Vector vector2 = vector;
        int n2 = 0;
        int n3 = vector2.length();
        int n4 = Integer.MIN_VALUE;
        int n5 = n;
        boolean bl2 = bl = n5 == Integer.MIN_VALUE;
        for (int i = 1; n2 < n3 && (bl || i <= n5); ++n2, ++i) {
            ContextSensitiveObject contextSensitiveObject;
            stella_Object = vector2.theArray[n2];
            n4 = i;
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                contextSensitiveObject = (Proposition)stella_Object;
                if (!Proposition.helpCollectSkolemizedExistsVariablesP((Proposition)contextSensitiveObject, list) || list != null) continue;
                return true;
            }
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                contextSensitiveObject = (PatternVariable)stella_Object;
                continue;
            }
            if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) continue;
            contextSensitiveObject = (Skolem)stella_Object;
            boolean bl3 = false;
            Proposition proposition2 = null;
            Iterator iterator = Logic.unfilteredDependentIsaPropositions((Stella_Object)contextSensitiveObject).allocateIterator();
            while (iterator.nextP()) {
                proposition2 = (Proposition)iterator.value;
                if (proposition2.kind != Logic.KWD_ISA || !Proposition.trueP(proposition2) || !BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition2.variableTypeP())) continue;
                bl3 = true;
                break;
            }
            if (!bl3) continue;
            if (list != null) {
                list.insertNew((Stella_Object)contextSensitiveObject);
                continue;
            }
            return true;
        }
        if (list != null) {
            return list.nonEmptyP();
        }
        return false;
    }

    public static Vector collectSkolemizedExistsVariables(Proposition proposition) {
        List list = List.newList();
        Vector vector = null;
        Proposition.helpCollectSkolemizedExistsVariablesP(proposition, list);
        vector = list.emptyP() ? Logic.ZERO_VARIABLES_VECTOR : Vector.newVector((int)list.length());
        Skolem skolem = null;
        Cons cons = list.theConsList;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (cons != Stella.NIL) {
            skolem = (Skolem)cons.value;
            n = n2++;
            vector.theArray[n] = skolem;
            cons = cons.rest;
        }
        list.free();
        return vector;
    }

    public static boolean topLevelExistsPropositionP(Proposition proposition) {
        return !Proposition.unknownP(proposition) && Proposition.helpCollectSkolemizedExistsVariablesP(proposition, null);
    }

    public static void postToCheckTypesAgenda(Proposition proposition) {
        CheckTypesRecord checkTypesRecord = CheckTypesRecord.newCheckTypesRecord();
        checkTypesRecord.parentProposition = (Stella_Object)Logic.$TERMUNDERCONSTRUCTION$.get();
        checkTypesRecord.parentDescription = (Description)((Stella_Object)Logic.$DESCRIPTIONUNDERCONSTRUCTION$.get());
        checkTypesRecord.module = (Module)Stella.$MODULE$.get();
        Logic.$CHECK_TYPES_AGENDA$.insertAt((Stella_Object)proposition, (Stella_Object)checkTypesRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleArityViolation(Proposition proposition, int n) {
        if ((Keyword)Logic.$TYPECHECKMODE$.get() != Logic.KWD_POST_TYPE_VIOLATIONS) {
            if ((Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_SIGNAL_TYPE_VIOLATIONS || (Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_REPORT_TYPE_VIOLATIONS || (Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_AUTOMATICALLY_FIX_TYPE_VIOLATIONS) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("ERROR: Too `" + (proposition.arguments.length() > n ? "many" : "few") + "' arguments in the proposition");
                    outputStringStream.nativeStream.println("   `" + Logic.generateTerm((Stella_Object)proposition) + "'");
                    outputStringStream.nativeStream.println("   Expected `" + n + "' argument(s)..");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
            }
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Keyword)Logic.$TYPECHECKMODE$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        Proposition.postToCheckTypesAgenda(proposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleArgumentTypeViolation(Proposition proposition, Stella_Object stella_Object, Surrogate surrogate) {
        if ((Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_POST_TYPE_VIOLATIONS) {
            Proposition.postToCheckTypesAgenda(proposition);
        } else {
            if ((Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_REPORT_TYPE_VIOLATIONS) {
                Object object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    Stella.STANDARD_WARNING.nativeStream.println("WARNING: Type check violation on argument `" + stella_Object + "' in proposition");
                    Stella.STANDARD_WARNING.nativeStream.println("   " + (Object)((Object)proposition) + ".");
                    Stella.STANDARD_WARNING.nativeStream.println("   Argument must have type `" + surrogate.symbolName + "'.");
                    Logic.helpSignalPropositionError(Stella.STANDARD_WARNING, Logic.KWD_WARNING);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
            }
            if ((Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_SIGNAL_TYPE_VIOLATIONS) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("ERROR: Type check violation on argument ``" + stella_Object + "'' in proposition");
                    outputStringStream.nativeStream.println("   `" + (Object)((Object)proposition) + "'.");
                    outputStringStream.nativeStream.println("   Argument must have type ``" + surrogate.symbolName + "''..");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
            }
            if ((Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_AUTOMATICALLY_FIX_TYPE_VIOLATIONS) {
                Proposition proposition2 = Logic.assertIsaProposition(stella_Object, surrogate);
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ASSERTED_BY_TYPE_CHECKERp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + (Keyword)Logic.$TYPECHECKMODE$.get() + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyArgumentTypesAndCount(Proposition proposition) {
        if ((Keyword)Logic.$TYPECHECKMODE$.get() == Logic.KWD_IGNORE_TYPE_VIOLATIONS || !Logic.worldStateP((Context)Stella.$CONTEXT$.get()) || !Stella_Object.isaP((Stella_Object)proposition.operator, (Surrogate)Logic.SGT_STELLA_SURROGATE)) {
            return;
        }
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        int n = proposition.arguments.length();
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA) {
            boolean bl;
            if (namedDescription == null) {
                return;
            }
            int n2 = namedDescription.arity();
            boolean bl2 = n2 <= 0;
            boolean bl3 = bl = proposition.kind == Logic.KWD_FUNCTION;
            if (!bl2 && n != n2) {
                Proposition.handleArityViolation(proposition, n2);
            }
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n3 = vector.length();
            IntegerIntervalIterator integerIntervalIterator = Stella.interval((int)1, (int)(bl2 && bl ? n - 1 : n));
            Stella_Object stella_Object2 = null;
            Iterator iterator = NamedDescription.allDomainTypes(namedDescription);
            for (int i = 0; i < n3 && integerIntervalIterator.nextP() && iterator.nextP(); ++i) {
                stella_Object = vector.theArray[i];
                stella_Object2 = iterator.value;
                if (stella_Object2 == null || stella_Object2 == Logic.SGT_STELLA_THING || stella_Object == null) continue;
                Logic.verifyOneArgumentType(stella_Object, (Surrogate)stella_Object2, proposition, namedDescription);
            }
            if (bl) {
                Logic.verifyOneArgumentType(proposition.arguments.last(), (Surrogate)namedDescription.ioVariableTypes.last(), proposition, namedDescription);
            }
        } else if (keyword == Logic.KWD_EQUIVALENT) {
            Stella_Object stella_Object = proposition.arguments.theArray[0];
            Stella_Object stella_Object3 = proposition.arguments.theArray[1];
            Surrogate surrogate = null;
            Stella_Object stella_Object4 = null;
            Stella_Object stella_Object5 = null;
            boolean bl = false;
            Stella_Object stella_Object6 = null;
            surrogate = Logic.safeLogicalType(stella_Object3);
            Object[] objectArray = new Object[1];
            bl = Logic.checkCoercedTypeP(stella_Object, surrogate, false, objectArray);
            stella_Object6 = (Stella_Object)objectArray[0];
            if (!Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object6)) {
                proposition.arguments.theArray[0] = stella_Object6;
                return;
            }
            if (!bl) {
                stella_Object4 = stella_Object3;
                stella_Object5 = stella_Object;
            }
            if (bl) {
                surrogate = Logic.safeLogicalType(stella_Object);
                objectArray = new Object[1];
                bl = Logic.checkCoercedTypeP(stella_Object3, surrogate, false, objectArray);
                stella_Object6 = (Stella_Object)objectArray[0];
                if (!Stella_Object.eqlP((Stella_Object)stella_Object3, (Stella_Object)stella_Object6)) {
                    proposition.arguments.theArray[1] = stella_Object6;
                    return;
                }
                if (!bl) {
                    stella_Object4 = stella_Object;
                    stella_Object5 = stella_Object3;
                }
            }
            if (!bl) {
                objectArray = Logic.$TERMUNDERCONSTRUCTION$.get();
                try {
                    Native.setSpecial((ThreadLocal)Logic.$TERMUNDERCONSTRUCTION$, (Object)((Stella_Object)Logic.$TERMUNDERCONSTRUCTION$.get()));
                    if ((Stella_Object)Logic.$TERMUNDERCONSTRUCTION$.get() == null && Logic.skolemP(stella_Object4)) {
                        Native.setSpecial((ThreadLocal)Logic.$TERMUNDERCONSTRUCTION$, (Object)((Object)((Skolem)stella_Object4).definingProposition));
                    }
                    Proposition.handleArgumentTypeViolation(proposition, stella_Object5, surrogate);
                }
                finally {
                    Logic.$TERMUNDERCONSTRUCTION$.set((Object)objectArray);
                }
            }
        }
    }

    public static Proposition embedNegationWithinFunctionInducedExists(Proposition proposition) {
        Proposition.invertProposition(Proposition.predicateOfFunctionInducedExists(proposition));
        return proposition;
    }

    public static Proposition predicateOfFunctionInducedExists(Proposition proposition) {
        Proposition proposition2 = null;
        Proposition proposition3 = null;
        Vector vector = ((Proposition)proposition.arguments.theArray[0]).arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            proposition3 = (Proposition)vector.theArray[i];
            if (proposition3.kind == Logic.KWD_FUNCTION || BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition3.variableTypeP())) continue;
            proposition2 = proposition3;
            break;
        }
        proposition3 = proposition2;
        return proposition3;
    }

    public static boolean functionInducedExistsP(Proposition proposition) {
        Stella_Object stella_Object;
        if (proposition.kind == Logic.KWD_EXISTS && Stella_Object.isaP((Stella_Object)(stella_Object = proposition.arguments.theArray[0]), (Surrogate)Logic.SGT_LOGIC_PROPOSITION) && ((Proposition)stella_Object).kind == Logic.KWD_AND) {
            int n;
            Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            Proposition proposition2 = (Proposition)stella_Object;
            Vector vector2 = proposition2.arguments;
            int n2 = 0;
            boolean bl = true;
            ContextSensitiveObject contextSensitiveObject = null;
            Vector vector3 = vector;
            int n3 = vector3.length();
            for (n = 0; n < n3; ++n) {
                contextSensitiveObject = (PatternVariable)vector3.theArray[n];
                boolean bl2 = false;
                boolean bl3 = false;
                Proposition proposition3 = null;
                Vector vector4 = vector2;
                int n4 = vector4.length();
                for (int i = 0; i < n4; ++i) {
                    proposition3 = (Proposition)vector4.theArray[i];
                    if (proposition3.kind != Logic.KWD_FUNCTION || proposition3.arguments.last() != contextSensitiveObject) continue;
                    bl3 = true;
                    break;
                }
                boolean bl4 = bl2 = !(bl2 = bl3);
                if (!bl2) continue;
                bl = false;
                break;
            }
            if (bl) {
                contextSensitiveObject = null;
                vector3 = vector2;
                n3 = vector3.length();
                for (n = 0; n < n3; ++n) {
                    contextSensitiveObject = (Proposition)vector3.theArray[n];
                    if (contextSensitiveObject.kind == Logic.KWD_FUNCTION || BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)contextSensitiveObject.variableTypeP())) continue;
                    ++n2;
                }
                return n2 == 1;
            }
        }
        return false;
    }

    public static void clearPropositionAnnotations(Proposition proposition) {
        PropertyList propertyList = (PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null);
        if (propertyList != null) {
            Keyword keyword = null;
            Stella_Object stella_Object = null;
            Cons cons = propertyList.thePlist;
            while (cons != Stella.NIL) {
                keyword = (Keyword)cons.value;
                stella_Object = cons.rest.value;
                if (keyword == Logic.KWD_DIRECTION) {
                    KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                    KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.FALSE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                } else if (keyword == Logic.KWD_WEIGHT) {
                    KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)Double.NEGATIVE_INFINITY), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                } else {
                    Stella_Object.runOptionHandlerP((Stella_Object)proposition, (Keyword)keyword, null);
                }
                cons = cons.rest.rest;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void finalizePropositionAnnotations(Proposition proposition) {
        PropertyList propertyList = (PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null);
        if (propertyList == null) return;
        Keyword keyword = null;
        Stella_Object stella_Object = null;
        Cons cons = propertyList.thePlist;
        while (cons != Stella.NIL) {
            block22: {
                Object object;
                Surrogate surrogate;
                block25: {
                    block23: {
                        block24: {
                            keyword = (Keyword)cons.value;
                            stella_Object = cons.rest.value;
                            if (keyword != Logic.KWD_DIRECTION) break block23;
                            if (!Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object), (Surrogate)Logic.SGT_STELLA_GENERALIZED_SYMBOL)) break block24;
                            surrogate = (GeneralizedSymbol)stella_Object;
                            object = Native.stringUpcase((String)surrogate.symbolName);
                            if (Stella.stringEqlP((String)object, (String)"FORWARD")) {
                                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_FORWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                                break block22;
                            } else if (Stella.stringEqlP((String)object, (String)"BACKWARD")) {
                                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACKWARD_ONLYp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                                break block22;
                            } else {
                                propertyList.removeAt((Stella_Object)keyword);
                                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                Object object2 = Stella.$PRINTREADABLYp$.get();
                                try {
                                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                    outputStringStream.nativeStream.println("PARSING ERROR: Illegal value for :direction option: `" + surrogate + "'.");
                                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                    throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                }
                                finally {
                                    Stella.$PRINTREADABLYp$.set(object2);
                                }
                            }
                        }
                        propertyList.removeAt((Stella_Object)keyword);
                        surrogate = OutputStringStream.newOutputStringStream();
                        object = Stella.$PRINTREADABLYp$.get();
                        try {
                            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                            surrogate.nativeStream.println("PARSING ERROR: Illegal value for :direction option: `" + stella_Object + "'.");
                            Logic.helpSignalPropositionError((OutputStream)surrogate, Logic.KWD_ERROR);
                            throw (ParsingError)((Object)ParsingError.newParsingError(surrogate.theStringReader()).fillInStackTrace());
                        }
                        finally {
                            Stella.$PRINTREADABLYp$.set(object);
                        }
                    }
                    if (keyword != Logic.KWD_WEIGHT) break block25;
                    surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
                    if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                        object = (IntegerWrapper)stella_Object;
                        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)object.numberWrapperToFloat()), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                        break block22;
                    } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                        object = (FloatWrapper)stella_Object;
                        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)object).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                        break block22;
                    } else {
                        propertyList.removeAt((Stella_Object)keyword);
                        object = OutputStringStream.newOutputStringStream();
                        Object object3 = Stella.$PRINTREADABLYp$.get();
                        try {
                            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                            ((OutputStringStream)object).nativeStream.println("PARSING ERROR: Illegal value for :weight option: `" + stella_Object + "'.");
                            Logic.helpSignalPropositionError((OutputStream)object, Logic.KWD_ERROR);
                            throw (ParsingError)((Object)ParsingError.newParsingError(object.theStringReader()).fillInStackTrace());
                        }
                        finally {
                            Stella.$PRINTREADABLYp$.set(object3);
                        }
                    }
                }
                if (keyword != Logic.KWD_CONFIDENCE_LEVEL && !Stella_Object.runOptionHandlerP((Stella_Object)proposition, (Keyword)keyword, (Stella_Object)stella_Object)) {
                    propertyList.removeAt((Stella_Object)keyword);
                    surrogate = OutputStringStream.newOutputStringStream();
                    object = Stella.$PRINTREADABLYp$.get();
                    try {
                        Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                        surrogate.nativeStream.println("PARSING ERROR: Unrecognized annotation option: `" + keyword + "'.");
                        Logic.helpSignalPropositionError((OutputStream)surrogate, Logic.KWD_ERROR);
                        throw (ParsingError)((Object)ParsingError.newParsingError(surrogate.theStringReader()).fillInStackTrace());
                    }
                    finally {
                        Stella.$PRINTREADABLYp$.set(object);
                    }
                }
            }
            cons = cons.rest.rest;
        }
    }

    public static void removeAnnotation(Proposition proposition, Keyword keyword) {
        PropertyList propertyList = (PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null);
        if (propertyList == null) {
            return;
        }
        propertyList.removeAt((Stella_Object)keyword);
        if (propertyList.thePlist == Stella.NIL) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null, null);
        }
    }

    public static void insertAnnotation(Proposition proposition, Keyword keyword, Stella_Object stella_Object) {
        PropertyList propertyList = (PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null);
        if (propertyList == null) {
            propertyList = PropertyList.newPropertyList();
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, (Stella_Object)propertyList, null);
        }
        propertyList.insertAt((Stella_Object)keyword, stella_Object);
    }

    public static Stella_Object lookupAnnotation(Proposition proposition, Keyword keyword) {
        PropertyList propertyList = (PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null);
        if (propertyList != null) {
            return propertyList.lookup((Stella_Object)keyword);
        }
        return null;
    }

    public static boolean simpleSubrelationPropositionP(Proposition proposition) {
        return proposition.operator == Logic.SGT_PL_KERNEL_KB_SUBSET_OF && Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[0], (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION) && Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[1], (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION);
    }

    public static boolean subsetOfPropositionP(Proposition proposition) {
        return proposition.operator == Logic.SGT_PL_KERNEL_KB_SUBSET_OF;
    }

    public static boolean memberOfPropositionP(Proposition proposition) {
        return proposition.operator == Logic.SGT_PL_KERNEL_KB_MEMBER_OF;
    }

    public static void instantiateUndefinedSurrogates(Proposition proposition) {
        block3: {
            Keyword keyword;
            block2: {
                keyword = proposition.kind;
                if (keyword != Logic.KWD_AND && keyword != Logic.KWD_OR && keyword != Logic.KWD_NOT && keyword != Logic.KWD_EXISTS) break block2;
                Stella_Object stella_Object = null;
                Vector vector = proposition.arguments;
                int n = vector.length();
                for (int i = 0; i < n; ++i) {
                    stella_Object = vector.theArray[i];
                    Proposition.instantiateUndefinedSurrogates((Proposition)stella_Object);
                }
                break block3;
            }
            if (keyword != Logic.KWD_PREDICATE && keyword != Logic.KWD_FUNCTION && keyword != Logic.KWD_ISA) break block3;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                if (!Surrogate.subtypeOfSurrogateP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object))) continue;
                Surrogate surrogate = (Surrogate)stella_Object;
                if (surrogate.surrogateValue != null) continue;
                Logic.createLogicInstance(surrogate, null);
            }
        }
    }

    public static void unfastenProposition(Proposition proposition) {
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            Logic.removeDependentPropositionLink(stella_Object, proposition);
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_UNFASTENEDp, (Stella_Object)Stella.TRUE_WRAPPER, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proposition recursivelyFastenDownPropositions(Proposition proposition, boolean bl) {
        if (!BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.unfastenedP())) {
            return proposition;
        }
        Object object = Logic.$VISITEDUNFASTENEDDEFININGPROPOSITIONS$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$VISITEDUNFASTENEDDEFININGPROPOSITIONS$, (Object)Stella.list((Cons)Stella.NIL));
            Proposition proposition2 = Proposition.helpFastenDownPropositions(proposition, bl);
            return proposition2;
        }
        finally {
            Logic.$VISITEDUNFASTENEDDEFININGPROPOSITIONS$.set(object);
        }
    }

    public static Proposition helpFastenDownPropositions(Proposition proposition, boolean bl) {
        boolean bl2 = bl;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FORALL || keyword == Logic.KWD_EXISTS) {
            bl2 = true;
        } else if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            bl2 = true;
        }
        keyword = null;
        Vector vector = proposition.arguments;
        int n = 0;
        int n2 = vector.length();
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        while (n < n2) {
            ContextSensitiveObject contextSensitiveObject;
            keyword = vector.theArray[n];
            n3 = n4;
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)keyword);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                contextSensitiveObject = (Proposition)keyword;
                if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)contextSensitiveObject.unfastenedP())) {
                    proposition.arguments.theArray[n3] = Proposition.helpFastenDownPropositions((Proposition)contextSensitiveObject, bl2);
                }
            } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                contextSensitiveObject = (Skolem)keyword;
                Proposition proposition2 = contextSensitiveObject.definingProposition;
                if (proposition2 != null && BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition2.unfastenedP()) && !((List)Logic.$VISITEDUNFASTENEDDEFININGPROPOSITIONS$.get()).memberP((Stella_Object)proposition2)) {
                    ((List)Logic.$VISITEDUNFASTENEDDEFININGPROPOSITIONS$.get()).insert((Stella_Object)proposition2);
                    Proposition.helpFastenDownPropositions(proposition2, bl2);
                }
            }
            ++n;
            ++n4;
        }
        return Proposition.fastenDownOneProposition(proposition, bl);
    }

    public static Proposition fastenDownOneProposition(Proposition proposition, boolean bl) {
        if (Proposition.nativeSlotPropositionP(proposition)) {
            return proposition;
        }
        if (!((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue()) {
            Proposition.surrogatifyDiscouragedArguments(proposition);
        }
        Proposition proposition2 = null;
        if (!(bl || ((Boolean)Logic.$DONT_CHECK_FOR_DUPLICATE_PROPOSITIONSp$.get()).booleanValue() || ((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue())) {
            proposition2 = Proposition.findDuplicateProposition(proposition);
        }
        if (proposition2 != null) {
            if (!Stella_Object.equalP((Stella_Object)((PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null)), (Stella_Object)((PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null)))) {
                Proposition.clearPropositionAnnotations(proposition2);
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, (Stella_Object)((PropertyList)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANNOTATIONS, null)), null);
                Proposition.finalizePropositionAnnotations(proposition2);
                Proposition.evaluateNewProposition(proposition2);
            }
            return proposition2;
        }
        if (!(((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue || Logic.descriptionModeP() || ((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue())) {
            Logic.logNewlyConceivedProposition((Module)Stella.$MODULE$.get(), proposition);
        }
        if (!((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue()) {
            Proposition.rewrapPropositionArguments(proposition);
        }
        if (!((Boolean)Logic.$LOADINGREGENERABLEOBJECTSp$.get()).booleanValue()) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Logic.addDependentPropositionLink(stella_Object, proposition);
            }
        }
        Proposition.updateDescriptionExtension(proposition);
        KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_UNFASTENEDp, null, null);
        Proposition.finalizePropositionAnnotations(proposition);
        Proposition.evaluateNewProposition(proposition);
        return proposition;
    }

    public static Proposition findDuplicateProposition(Proposition proposition) {
        if (Logic.descriptionModeP() || ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            return null;
        }
        if (proposition.kind == Logic.KWD_DISABLED) {
            Proposition proposition2 = null;
            Proposition proposition3 = null;
            Iterator iterator = Proposition.findSimilarPropositions(proposition).allocateIterator();
            while (iterator.nextP()) {
                proposition3 = (Proposition)iterator.value;
                if (!Proposition.equivalentPropositionsP(proposition, proposition3, null) || !Context.subcontextP((Context)proposition.homeContext.baseModule, (Context)proposition3.homeContext.baseModule)) continue;
                proposition2 = proposition3;
                break;
            }
            proposition3 = proposition2;
            return proposition3;
        }
        return Proposition.findDuplicateComplexProposition(proposition);
    }

    public static Proposition findDuplicateComplexProposition(Proposition proposition) {
        boolean bl;
        IntegerWrapper integerWrapper = IntegerWrapper.wrapInteger((int)Proposition.propositionHashIndex(proposition));
        List list = (List)Logic.$STRUCTURED_OBJECTS_INDEX$.lookup((Stella_Object)integerWrapper);
        Module module = proposition.homeContext.baseModule;
        boolean bl2 = bl = proposition.kind == Logic.KWD_FUNCTION;
        if (list == null) {
            Logic.$STRUCTURED_OBJECTS_INDEX$.insertAt((Stella_Object)integerWrapper, (Stella_Object)Stella.list((Cons)Stella_Object.cons((Stella_Object)proposition, (Cons)Stella.NIL)));
            return null;
        }
        list.removeDeletedMembers();
        ContextSensitiveObject contextSensitiveObject = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            contextSensitiveObject = (ContextSensitiveObject)cons.value;
            if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)contextSensitiveObject), (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                Proposition proposition2 = (Proposition)contextSensitiveObject;
                if (bl) {
                    GeneralizedSymbol generalizedSymbol = proposition.operator;
                    Vector vector = proposition.arguments;
                    int n = vector.length();
                    boolean bl3 = false;
                    boolean bl4 = bl3 = generalizedSymbol == proposition2.operator;
                    if (bl3) {
                        boolean bl5;
                        boolean bl6 = true;
                        Stella_Object stella_Object = null;
                        Vector vector2 = vector;
                        int n2 = 0;
                        int n3 = vector2.length();
                        Stella_Object stella_Object2 = null;
                        Vector vector3 = proposition2.arguments;
                        int n4 = vector3.length();
                        int n5 = Integer.MIN_VALUE;
                        int n6 = 2;
                        int n7 = n;
                        boolean bl7 = bl5 = n7 == Integer.MIN_VALUE;
                        for (int i = 0; n2 < n3 && i < n4 && (bl5 || n6 <= n7); ++n2, ++i) {
                            stella_Object = vector2.theArray[n2];
                            stella_Object2 = vector3.theArray[i];
                            n5 = n6++;
                            if (Stella_Object.eqlP((Stella_Object)Logic.valueOf(stella_Object), (Stella_Object)Logic.valueOf(stella_Object2))) continue;
                            bl6 = false;
                            break;
                        }
                        if (bl3 = bl6) {
                            boolean bl8 = bl3 = n == proposition2.arguments.length() && Context.subcontextP((Context)module, (Context)proposition2.homeContext.baseModule);
                        }
                    }
                    if (bl3) {
                        return proposition2;
                    }
                } else if (Proposition.equivalentPropositionsP(proposition, proposition2, null) && Context.subcontextP((Context)module, (Context)proposition2.homeContext.baseModule)) {
                    return proposition2;
                }
            }
            cons = cons.rest;
        }
        list.push((Stella_Object)proposition);
        return null;
    }

    public static int propositionHashIndex(Proposition proposition) {
        int n = proposition.operator.hashCode();
        int n2 = 0;
        boolean bl = false;
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_AND || keyword == Logic.KWD_OR || keyword == Logic.KWD_EQUIVALENT) {
            bl = true;
        }
        n = (n & 1) == 0 ? n >>> 1 : n >> 1 | Integer.MIN_VALUE;
        keyword = null;
        Vector vector = proposition.arguments;
        int n3 = vector.length();
        for (int i = 0; i < n3; ++i) {
            Surrogate surrogate;
            keyword = vector.theArray[i];
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && Logic.variableP((Stella_Object)keyword)) {
                surrogate = PatternVariable.safeBoundTo((PatternVariable)keyword);
                Object object = keyword = surrogate != null ? surrogate : keyword;
            }
            if (keyword == null) {
                n2 = Logic.SGT_LOGIC_SKOLEM.hashCode();
            } else {
                ContextSensitiveObject contextSensitiveObject;
                surrogate = Stella_Object.safePrimaryType((Stella_Object)keyword);
                if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                    contextSensitiveObject = (Proposition)keyword;
                    n2 = Proposition.propositionHashIndex((Proposition)contextSensitiveObject);
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION)) {
                    contextSensitiveObject = (NamedDescription)keyword;
                    n2 = contextSensitiveObject.hashCode();
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
                    contextSensitiveObject = (Description)keyword;
                    n2 = Proposition.propositionHashIndex(contextSensitiveObject.proposition);
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    contextSensitiveObject = (PatternVariable)keyword;
                    n2 = Logic.SGT_LOGIC_PATTERN_VARIABLE.hashCode();
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    contextSensitiveObject = (Skolem)keyword;
                    Proposition proposition2 = contextSensitiveObject.definingProposition;
                    n2 = proposition2 != null && proposition2 != proposition ? Proposition.propositionHashIndex(proposition2) : Logic.SGT_LOGIC_SKOLEM.hashCode();
                } else if (Surrogate.subtypeOfWrapperP((Surrogate)surrogate)) {
                    contextSensitiveObject = (Wrapper)keyword;
                    n2 = contextSensitiveObject.hashCode_();
                } else {
                    n2 = keyword.hashCode();
                }
            }
            n ^= n2;
            if (bl) continue;
            n = (n & 1) == 0 ? n >>> 1 : n >> 1 | Integer.MIN_VALUE;
        }
        return n;
    }

    public static void updateSkolemTypeFromIsaAssertions(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA) {
            Stella_Object stella_Object = proposition.arguments.theArray[0];
            if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                Skolem.updateSkolemType((Skolem)stella_Object, (Surrogate)proposition.operator);
            }
        } else if (keyword == Logic.KWD_AND) {
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                stella_Object = vector.theArray[i];
                Proposition.updateSkolemTypeFromIsaAssertions((Proposition)stella_Object);
            }
        }
    }

    public static void reviseEquivalences(Proposition proposition, boolean bl) {
        LogicObject logicObject = (LogicObject)proposition.arguments.theArray[0];
        LogicObject logicObject2 = (LogicObject)proposition.arguments.theArray[1];
        if (!Logic.$EQUIVALENCE_COLLECTIONSp$) {
            return;
        }
        if (bl) {
            if (LogicObject.collectionImpliesCollectionP(logicObject, logicObject2) && LogicObject.collectionImpliesCollectionP(logicObject2, logicObject)) {
                LogicObject.equivalenceCollections(logicObject, logicObject2);
            }
        } else if ((Description)Stella_Object.accessInContext((Stella_Object)KeyValueList.dynamicSlotValue((KeyValueList)logicObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EQUIVALENT_VALUE, null), (Context)logicObject.homeContext, (boolean)false) != null || (Description)Stella_Object.accessInContext((Stella_Object)KeyValueList.dynamicSlotValue((KeyValueList)logicObject2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EQUIVALENT_VALUE, null), (Context)logicObject2.homeContext, (boolean)false) != null) {
            System.out.println("DIDN'T FINISH 'revise-equivalences' YET. DON'T KNOW HOW");
            System.out.println("   TO REMOVE AN 'equivalent-value' LINK");
        } else if (Stella_Object.isaP((Stella_Object)logicObject, (Surrogate)Logic.SGT_LOGIC_SKOLEM) && Stella_Object.accessInContext((Stella_Object)((Skolem)logicObject).variableValue, (Context)((Skolem)logicObject).homeContext, (boolean)false) != null || Stella_Object.isaP((Stella_Object)logicObject2, (Surrogate)Logic.SGT_LOGIC_SKOLEM) && Stella_Object.accessInContext((Stella_Object)((Skolem)logicObject2).variableValue, (Context)((Skolem)logicObject2).homeContext, (boolean)false) != null) {
            System.out.println("DIDN'T FINISH 'revise-equivalences' YET. DON'T KNOW HOW");
            System.out.println("   TO REMOVE AN 'equivalent-value' LINK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unequateConflictingDefaultValuesP(Proposition proposition) {
        Stella_Object stella_Object;
        Stella_Object stella_Object2;
        Stella_Object stella_Object3;
        Object object;
        Object object2;
        Vector vector = proposition.arguments;
        Stella_Object stella_Object4 = vector.theArray[0];
        boolean bl = Logic.skolemP(stella_Object4);
        Stella_Object stella_Object5 = Logic.innermostOf(stella_Object4);
        Stella_Object stella_Object6 = vector.theArray[1];
        boolean bl2 = Logic.skolemP(stella_Object6);
        Stella_Object stella_Object7 = Logic.innermostOf(stella_Object6);
        boolean bl3 = Proposition.defaultTrueP(proposition);
        Stella_Object stella_Object8 = null;
        Proposition proposition2 = null;
        if (Stella_Object.eqlP((Stella_Object)stella_Object5, (Stella_Object)stella_Object7)) {
            return true;
        }
        if (Logic.skolemP(stella_Object5)) {
            return ((Skolem)stella_Object5).conflictingDefaultValues() == Stella.NIL || !bl3;
        }
        if (Logic.skolemP(stella_Object7)) {
            return ((Skolem)stella_Object7).conflictingDefaultValues() == Stella.NIL || !bl3;
        }
        if (bl && bl2 && bl3) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object3 = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Equating two skolems `" + stella_Object4 + "' and `" + stella_Object6 + "' by default is not yet supported.");
                outputStringStream.nativeStream.println(".");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object3);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        stella_Object8 = proposition.truthValue;
        proposition.truthValue = null;
        if (bl) {
            object2 = Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)true);
                proposition2 = Logic.findEquatingProposition(stella_Object5, (LogicObject)stella_Object4);
            }
            finally {
                Logic.$DONTUSEDEFAULTKNOWLEDGEp$.set(object2);
            }
            if (proposition2 == null) {
                proposition2 = Logic.findEquatingProposition(stella_Object5, (LogicObject)stella_Object4);
                while (!Stella_Object.eqlP((Stella_Object)Logic.valueOf(stella_Object4), (Stella_Object)stella_Object5)) {
                    stella_Object4 = Logic.valueOf(stella_Object4);
                }
                object = object2 = (Skolem)stella_Object4;
                stella_Object3 = null;
                stella_Object2 = ((Skolem)((Object)object)).variableValue;
                stella_Object = Stella_Object.updateInContext((Stella_Object)stella_Object2, stella_Object3, (Context)((Skolem)((Object)object)).homeContext, (boolean)false);
                if (stella_Object2 == null || stella_Object2.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    ((Skolem)((Object)object)).variableValue = stella_Object;
                }
                KeyValueList.setDynamicSlotValue((KeyValueList)((Skolem)((Object)object2)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CONFLICTING_DEFAULT_VALUES, (Stella_Object)Stella_Object.cons((Stella_Object)proposition2, (Cons)((Skolem)((Object)object2)).conflictingDefaultValues()), null);
                if (bl3) {
                    KeyValueList.setDynamicSlotValue((KeyValueList)((Skolem)((Object)object2)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CONFLICTING_DEFAULT_VALUES, (Stella_Object)Stella_Object.cons((Stella_Object)proposition, (Cons)((Skolem)((Object)object2)).conflictingDefaultValues()), null);
                }
            }
        }
        if (bl2) {
            object2 = Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)true);
                proposition2 = Logic.findEquatingProposition(stella_Object7, (LogicObject)stella_Object6);
            }
            finally {
                Logic.$DONTUSEDEFAULTKNOWLEDGEp$.set(object2);
            }
            if (proposition2 == null) {
                proposition2 = Logic.findEquatingProposition(stella_Object5, (LogicObject)stella_Object4);
                while (!Stella_Object.eqlP((Stella_Object)Logic.valueOf(stella_Object6), (Stella_Object)stella_Object7)) {
                    stella_Object6 = Logic.valueOf(stella_Object6);
                }
                object = object2 = (Skolem)stella_Object6;
                stella_Object3 = null;
                stella_Object2 = ((Skolem)((Object)object)).variableValue;
                stella_Object = Stella_Object.updateInContext((Stella_Object)stella_Object2, stella_Object3, (Context)((Skolem)((Object)object)).homeContext, (boolean)false);
                if (stella_Object2 == null || stella_Object2.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    ((Skolem)((Object)object)).variableValue = stella_Object;
                }
                KeyValueList.setDynamicSlotValue((KeyValueList)((Skolem)((Object)object2)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CONFLICTING_DEFAULT_VALUES, (Stella_Object)Stella_Object.cons((Stella_Object)proposition2, (Cons)((Skolem)((Object)object2)).conflictingDefaultValues()), null);
                if (bl3) {
                    KeyValueList.setDynamicSlotValue((KeyValueList)((Skolem)((Object)object2)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CONFLICTING_DEFAULT_VALUES, (Stella_Object)Stella_Object.cons((Stella_Object)proposition, (Cons)((Skolem)((Object)object2)).conflictingDefaultValues()), null);
                }
            }
        }
        proposition.truthValue = (TruthValue)stella_Object8;
        return !bl && !bl2 || !bl3;
    }

    public static void signalTruthValueClash(Proposition proposition) {
        Proposition.assignTruthValue(proposition, (Stella_Object)Logic.INCONSISTENT_TRUTH_VALUE);
        if ((Context)Stella.$CONTEXT$.get() == (World)KeyValueList.dynamicSlotValue((KeyValueList)((Module)Stella.$MODULE$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_META_INFERENCE_CACHE, null)) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.println("Derived both TRUE and FALSE for the proposition `" + (Object)((Object)proposition) + "'.");
            outputStringStream.nativeStream.print("   Clash occurred in the meta inference cache for module `" + (Module)Stella.$MODULE$.get() + "'.");
            throw (Clash)((Object)Clash.newClash(outputStringStream.theStringReader()).fillInStackTrace());
        }
        if ((Context)Stella.$CONTEXT$.get() == (World)KeyValueList.dynamicSlotValue((KeyValueList)((Module)Stella.$MODULE$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_TRUTH_MAINTAINED_INFERENCE_CACHE, null)) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.println("Derived both TRUE and FALSE for the proposition `" + (Object)((Object)proposition) + "'.");
            outputStringStream.nativeStream.print("   Clash occurred in the default inference cache for module `" + (Module)Stella.$MODULE$.get() + "'.");
            throw (Clash)((Object)Clash.newClash(outputStringStream.theStringReader()).fillInStackTrace());
        }
        if ((Context)Stella.$CONTEXT$.get() == (Module)Stella.$MODULE$.get()) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.println("Derived both TRUE and FALSE for the proposition `" + (Object)((Object)proposition) + "'.");
            outputStringStream.nativeStream.print("   Clash occurred in module `" + (Module)Stella.$MODULE$.get() + "'.");
            throw (Clash)((Object)Clash.newClash(outputStringStream.theStringReader()).fillInStackTrace());
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.println("Derived both TRUE and FALSE for the proposition `" + (Object)((Object)proposition) + "'.");
        outputStringStream.nativeStream.print("   Clash occurred in the world `" + (Context)Stella.$CONTEXT$.get() + "' in module `" + (Module)Stella.$MODULE$.get() + "'.");
        throw (Clash)((Object)Clash.newClash(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public static boolean defaultFalseP(Proposition proposition) {
        return (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) == Logic.DEFAULT_FALSE_TRUTH_VALUE;
    }

    public static boolean defaultTrueP(Proposition proposition) {
        return (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) == Logic.DEFAULT_TRUE_TRUTH_VALUE;
    }

    public static boolean inconsistentP(Proposition proposition) {
        return (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) == Logic.INCONSISTENT_TRUTH_VALUE;
    }

    public static boolean unknownP(Proposition proposition) {
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        return truthValue == Logic.UNKNOWN_TRUTH_VALUE || truthValue == null || (Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get() != false && (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) || truthValue == Logic.INCONSISTENT_TRUTH_VALUE;
    }

    public static boolean falseP(Proposition proposition) {
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        if (truthValue == Logic.FALSE_TRUTH_VALUE) {
            return true;
        }
        return truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE ? (Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get() == false : truthValue != null && truthValue.polarity == Logic.KWD_FALSE && ((Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get() == false || truthValue.strength == Logic.KWD_STRICT);
    }

    public static boolean trueP(Proposition proposition) {
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        if (truthValue == Logic.TRUE_TRUTH_VALUE) {
            return true;
        }
        return truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE ? (Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get() == false : truthValue != null && truthValue.polarity == Logic.KWD_TRUE && ((Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get() == false || truthValue.strength == Logic.KWD_STRICT);
    }

    public static Cons updateNativeSlotProposition(Proposition proposition, Keyword keyword) {
        Relation relation = Logic.surrogateToDescription((Surrogate)proposition.operator).nativeRelation();
        Stella_Object stella_Object = Logic.valueOf(proposition.arguments.theArray[0]);
        Stella_Object stella_Object2 = Logic.valueOf(proposition.arguments.theArray[1]);
        if (keyword == Logic.KWD_ASSERT_TRUE) {
            if (((Boolean)Logic.$CLIPPINGENABLEDp$.get()).booleanValue()) {
                Logic.clearNativeSlotValue((Thing)stella_Object, (StorageSlot)relation);
            }
            Logic.assignNativeSlotValue((Thing)stella_Object, (StorageSlot)relation, stella_Object2);
        } else if (keyword == Logic.KWD_RETRACT_TRUE) {
            Logic.dropNativeSlotValue((Thing)stella_Object, (StorageSlot)relation, stella_Object2);
        } else {
            Stella.STANDARD_WARNING.nativeStream.println("Warning: Illegal update to native slot value.  Mode:  `" + keyword + "'");
            Stella.STANDARD_WARNING.nativeStream.println("   Proposition:  `" + (Object)((Object)proposition) + "'");
            Stella.STANDARD_WARNING.nativeStream.println();
        }
        return Stella.NIL;
    }

    public static boolean nativeSlotPropositionP(Proposition proposition) {
        NamedDescription namedDescription;
        Stella_Object stella_Object;
        Vector vector = proposition.arguments;
        if (vector.length() == 0) {
            return false;
        }
        Stella_Object stella_Object2 = stella_Object = vector.theArray[0] != null ? Logic.valueOf(vector.theArray[0]) : (Stella_Object)null;
        return stella_Object != null && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_STELLA_THING) && (namedDescription = Logic.getDescription((Stella_Object)proposition.operator)) != null && namedDescription.nativeRelation() != null && Stella_Object.isaP((Stella_Object)namedDescription.nativeRelation(), (Surrogate)Logic.SGT_STELLA_STORAGE_SLOT);
    }

    public static void assignPropositionWeight(Proposition proposition, double d) {
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        if (d == 1.0) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.TRUE_WRAPPER);
        } else if (d == 0.0) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.FALSE_WRAPPER);
        } else if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == null) {
            TruthValue truthValue2 = TruthValue.newTruthValue();
            truthValue2.positiveScore = d;
            Proposition proposition2 = proposition;
            TruthValue truthValue3 = truthValue2;
            Stella_Object stella_Object = proposition2.truthValue;
            Stella_Object stella_Object2 = Stella_Object.updateInContext((Stella_Object)stella_Object, (Stella_Object)truthValue3, (Context)proposition2.homeContext, (boolean)false);
            if (stella_Object == null || stella_Object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                proposition2.truthValue = stella_Object2;
            }
        } else {
            ((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)).positiveScore = d;
        }
    }

    public static void updatePropositionTruthValue(Proposition proposition, Keyword keyword) {
        if (keyword == Logic.KWD_ASSERT_TRUE) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.TRUE_WRAPPER);
        } else if (keyword == Logic.KWD_ASSERT_FALSE) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Stella.FALSE_WRAPPER);
        } else if (keyword == Logic.KWD_PRESUME_TRUE) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Logic.DEFAULT_TRUE_TRUTH_VALUE);
        } else if (keyword == Logic.KWD_PRESUME_FALSE) {
            Proposition.assignTruthValue(proposition, (Stella_Object)Logic.DEFAULT_FALSE_TRUTH_VALUE);
        } else if (keyword == Logic.KWD_RETRACT_TRUE) {
            if (Proposition.trueP(proposition) && proposition.kind != Logic.KWD_FUNCTION) {
                Proposition.deassignTruthValue(proposition, keyword);
            }
        } else if (keyword == Logic.KWD_RETRACT_FALSE) {
            if (Proposition.falseP(proposition)) {
                Proposition.deassignTruthValue(proposition, keyword);
            }
        } else if (keyword != Logic.KWD_CONCEIVE) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        Proposition.runUpdatePropositionDemon(proposition, keyword);
    }

    public static void deassignTruthValue(Proposition proposition, Keyword keyword) {
        Proposition proposition2 = proposition;
        Stella_Object stella_Object = null;
        Stella_Object stella_Object2 = proposition2.truthValue;
        Stella_Object stella_Object3 = Stella_Object.updateInContext((Stella_Object)stella_Object2, stella_Object, (Context)proposition2.homeContext, (boolean)false);
        if (stella_Object2 == null || stella_Object2.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
            proposition2.truthValue = stella_Object3;
        }
        if (keyword != Logic.KWD_RETRACT_INCONSISTENT) {
            Logic.handleOutOfDateInferenceCache(Logic.KWD_RETRACT, proposition);
            Proposition.updateLinksAndTimestamps(proposition, keyword);
        }
    }

    public static void assignTruthValue(Proposition proposition, Stella_Object stella_Object) {
        TruthValue truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        TruthValue truthValue2 = null;
        truthValue2 = stella_Object == Stella.TRUE_WRAPPER ? Logic.TRUE_TRUTH_VALUE : (stella_Object == Stella.FALSE_WRAPPER ? Logic.FALSE_TRUTH_VALUE : (TruthValue)stella_Object);
        if (truthValue != truthValue2) {
            if (truthValue != null) {
                if (proposition != Logic.TRUE_PROPOSITION && proposition != Logic.FALSE_PROPOSITION && truthValue != Logic.INCONSISTENT_TRUTH_VALUE) {
                    if (truthValue2 == Logic.TRUE_TRUTH_VALUE) {
                        if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                            Proposition proposition2 = proposition;
                            Stella_Object stella_Object2 = null;
                            Stella_Object stella_Object3 = proposition2.truthValue;
                            Stella_Object stella_Object4 = Stella_Object.updateInContext((Stella_Object)stella_Object3, stella_Object2, (Context)proposition2.homeContext, (boolean)false);
                            if (stella_Object3 == null || stella_Object3.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                                proposition2.truthValue = stella_Object4;
                            }
                            Proposition.assignTruthValue(proposition, (Stella_Object)truthValue2);
                        } else if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                            Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_FALSE);
                            Proposition.assignTruthValue(proposition, (Stella_Object)truthValue2);
                        } else if (truthValue == Logic.FALSE_TRUTH_VALUE) {
                            Proposition.signalTruthValueClash(proposition);
                        }
                    } else if (truthValue2 == Logic.FALSE_TRUTH_VALUE) {
                        if (truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                            Proposition proposition3 = proposition;
                            Stella_Object stella_Object5 = null;
                            Stella_Object stella_Object6 = proposition3.truthValue;
                            Stella_Object stella_Object7 = Stella_Object.updateInContext((Stella_Object)stella_Object6, stella_Object5, (Context)proposition3.homeContext, (boolean)false);
                            if (stella_Object6 == null || stella_Object6.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                                proposition3.truthValue = stella_Object7;
                            }
                            Proposition.assignTruthValue(proposition, (Stella_Object)truthValue2);
                        } else if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                            Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_TRUE);
                            Proposition.assignTruthValue(proposition, (Stella_Object)truthValue2);
                        } else if (truthValue == Logic.TRUE_TRUTH_VALUE) {
                            Proposition.signalTruthValueClash(proposition);
                        }
                    } else if (truthValue2 == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                        if (((Boolean)Logic.$DEFERINGDEFAULTFORWARDINFERENCESp$.get()).booleanValue()) {
                            Logic.deferredDefaultPropositionsSetter((Context)Stella.$CONTEXT$.get(), Stella_Object.cons((Stella_Object)proposition, (Cons)Logic.deferredDefaultPropositions((Context)Stella.$CONTEXT$.get())));
                            return;
                        }
                        if (truthValue != Logic.TRUE_TRUTH_VALUE && truthValue != Logic.FALSE_TRUTH_VALUE && truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                            Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_FALSE);
                        }
                    } else if (truthValue2 == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        if (((Boolean)Logic.$DEFERINGDEFAULTFORWARDINFERENCESp$.get()).booleanValue()) {
                            Logic.deferredDefaultPropositionsSetter((Context)Stella.$CONTEXT$.get(), Stella_Object.cons((Stella_Object)proposition, (Cons)Logic.deferredDefaultPropositions((Context)Stella.$CONTEXT$.get())));
                            return;
                        }
                        if (truthValue != Logic.FALSE_TRUTH_VALUE && truthValue != Logic.TRUE_TRUTH_VALUE && truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                            Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_TRUE);
                        }
                    } else if (truthValue2 == Logic.INCONSISTENT_TRUTH_VALUE) {
                        if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                            Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_TRUE);
                        } else if (truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                            Proposition.deassignTruthValue(proposition, Logic.KWD_RETRACT_FALSE);
                        }
                        Proposition.assignTruthValue(proposition, (Stella_Object)truthValue2);
                    } else {
                        Proposition.signalTruthValueClash(proposition);
                    }
                }
            } else if (proposition.kind == Logic.KWD_FUNCTION) {
                Proposition proposition4 = proposition;
                TruthValue truthValue3 = Logic.TRUE_TRUTH_VALUE;
                Stella_Object stella_Object8 = proposition4.truthValue;
                Stella_Object stella_Object9 = Stella_Object.updateInContext((Stella_Object)stella_Object8, (Stella_Object)truthValue3, (Context)proposition4.homeContext, (boolean)false);
                if (stella_Object8 == null || stella_Object8.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    proposition4.truthValue = stella_Object9;
                }
            } else if (truthValue2 == Logic.INCONSISTENT_TRUTH_VALUE) {
                Proposition proposition5 = proposition;
                TruthValue truthValue4 = truthValue2;
                Stella_Object stella_Object10 = proposition5.truthValue;
                Stella_Object stella_Object11 = Stella_Object.updateInContext((Stella_Object)stella_Object10, (Stella_Object)truthValue4, (Context)proposition5.homeContext, (boolean)false);
                if (stella_Object10 == null || stella_Object10.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    proposition5.truthValue = stella_Object11;
                }
            } else {
                Proposition proposition6 = proposition;
                TruthValue truthValue5 = truthValue2;
                Stella_Object stella_Object12 = proposition6.truthValue;
                Stella_Object stella_Object13 = Stella_Object.updateInContext((Stella_Object)stella_Object12, (Stella_Object)truthValue5, (Context)proposition6.homeContext, (boolean)false);
                if (stella_Object12 == null || stella_Object12.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    proposition6.truthValue = stella_Object13;
                }
                Logic.handleOutOfDateInferenceCache(Logic.KWD_ASSERT, proposition);
                if (truthValue2 == Logic.TRUE_TRUTH_VALUE) {
                    Proposition.updateLinksAndTimestamps(proposition, Logic.KWD_ASSERT_TRUE);
                } else if (truthValue2 == Logic.FALSE_TRUTH_VALUE) {
                    Proposition.updateLinksAndTimestamps(proposition, Logic.KWD_ASSERT_FALSE);
                } else if (truthValue2 == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                    Proposition.updateLinksAndTimestamps(proposition, Logic.KWD_PRESUME_TRUE);
                } else if (truthValue2 == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                    Proposition.updateLinksAndTimestamps(proposition, Logic.KWD_PRESUME_FALSE);
                }
                Logic.reactToKbUpdate((Context)Stella.$CONTEXT$.get(), (Stella_Object)proposition);
            }
        }
    }

    public static void updateLinksAndTimestamps(Proposition proposition, Keyword keyword) {
        if (proposition == null) {
            return;
        }
        Logic.updateNowTimestamp(Logic.KWD_UPDATE_PROPOSITION);
        if (keyword == Logic.KWD_ASSERT_TRUE || keyword == Logic.KWD_PRESUME_TRUE) {
            Proposition.runGoesTrueDemons(proposition);
        } else if (keyword == Logic.KWD_ASSERT_FALSE || keyword == Logic.KWD_PRESUME_FALSE) {
            Proposition.runGoesFalseDemons(proposition);
        } else if (keyword == Logic.KWD_RETRACT_TRUE) {
            Proposition.runGoesUnknownDemons(proposition);
        } else if (keyword == Logic.KWD_RETRACT_FALSE) {
            Proposition.runGoesUnknownDemons(proposition);
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static void runGoesUnknownDemons(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_ISA) {
            Stella_Object stella_Object = proposition.arguments.theArray[0];
            if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                Skolem skolem = (Skolem)stella_Object;
                Surrogate surrogate = skolem.skolemType;
                if (surrogate == (Surrogate)proposition.operator && surrogate != Logic.SGT_STELLA_THING) {
                    System.out.println("Can't retract skolem type of `" + (Object)((Object)skolem) + "' equaling `" + surrogate.symbolName + "'.");
                    System.out.println();
                }
            }
            Proposition.runTruthChangeDemon(proposition, Logic.SGT_PL_KERNEL_KB_GOES_UNKNOWN_DEMON);
        } else if (keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION) {
            Proposition.runTruthChangeDemon(proposition, Logic.SGT_PL_KERNEL_KB_GOES_UNKNOWN_DEMON);
        } else if (keyword == Logic.KWD_IMPLIES) {
            Description.dropTaxonomyImpliesSubsumesLink((Description)proposition.arguments.theArray[0], (Description)proposition.arguments.theArray[1]);
            Proposition.reviseEquivalences(proposition, false);
            Proposition proposition2 = (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null);
            if (proposition2 != null && Proposition.trueP(proposition2)) {
                Proposition.deassignTruthValue(proposition2, Logic.KWD_RETRACT_TRUE);
            }
        } else if (keyword == Logic.KWD_FORALL) {
            Proposition proposition3 = null;
            Cons cons = proposition.satellitePropositions().theConsList;
            while (cons != Stella.NIL) {
                proposition3 = (Proposition)cons.value;
                Proposition.deassignTruthValue(proposition3, Logic.KWD_RETRACT_TRUE);
                cons = cons.rest;
            }
        }
    }

    public static void runGoesFalseDemons(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE) {
            Proposition.runTruthChangeDemon(proposition, Logic.SGT_PL_KERNEL_KB_GOES_FALSE_DEMON);
        }
    }

    public static void runGoesTrueDemons(Proposition proposition) {
        Keyword keyword = proposition.kind;
        if (keyword == Logic.KWD_FUNCTION || keyword == Logic.KWD_ISA) {
            Proposition.runTruthChangeDemon(proposition, Logic.SGT_PL_KERNEL_KB_GOES_TRUE_DEMON);
        } else if (keyword == Logic.KWD_PREDICATE) {
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            if (Logic.singleValuedTermP((Stella_Object)namedDescription)) {
                Proposition.clipOrClashWithOldPredicateValue(proposition);
            }
            Proposition.runTruthChangeDemon(proposition, Logic.SGT_PL_KERNEL_KB_GOES_TRUE_DEMON);
        } else if (keyword == Logic.KWD_IMPLIES) {
            if (!Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[0], (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) || !Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[1], (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
                return;
            }
            if (!Logic.descriptionModeP()) {
                Description.addTaxonomyImpliesSubsumesLink((Description)proposition.arguments.theArray[0], (Description)proposition.arguments.theArray[1]);
            }
            Proposition.reviseEquivalences(proposition, true);
            if ((Module)Stella.$MODULE$.get() == (Context)Stella.$CONTEXT$.get()) {
                Logic.bumpInferableTimestamp();
            }
            Proposition.flushInferableDirectSubdescriptionsCache(proposition);
        } else if (keyword == Logic.KWD_FORALL) {
            if (proposition.satellitePropositions() == Stella.NIL_LIST) {
                Proposition.deriveSatelliteRules(proposition);
            }
            Logic.bumpInferableTimestamp();
        }
    }

    public static void runTruthChangeDemon(Proposition proposition, Surrogate surrogate) {
        Method method;
        Stella_Object stella_Object;
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Stella_Object stella_Object2 = stella_Object = namedDescription != null ? Logic.accessBinaryValue((Stella_Object)namedDescription, surrogate) : (Stella_Object)null;
        if (stella_Object != null && (method = Logic.functionCodeFromProcedure(stella_Object)) != null) {
            Native.funcall((Method)method, null, (Object[])new Object[]{proposition});
        }
    }

    public static void runUpdatePropositionDemon(Proposition proposition, Keyword keyword) {
        if ((ObjectStore)KeyValueList.dynamicSlotValue((KeyValueList)((Module)Stella.$MODULE$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_OBJECT_STORE, null) != null) {
            ((ObjectStore)KeyValueList.dynamicSlotValue((KeyValueList)((Module)Stella.$MODULE$.get()).dynamicSlots, (Symbol)Logic.SYM_LOGIC_OBJECT_STORE, null)).updatePropositionInStore(proposition, keyword);
        }
        if (proposition.kind == Logic.KWD_EQUIVALENT) {
            Proposition.runUpdateEquivalencePropositionDemon(proposition, keyword);
        } else {
            Proposition.helpRunUpdatePropositionDemon(proposition, keyword);
        }
    }

    public static void helpRunUpdatePropositionDemon(Proposition proposition, Keyword keyword) {
        Method method;
        Stella_Object stella_Object;
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Stella_Object stella_Object2 = stella_Object = namedDescription != null ? Logic.accessBinaryValue((Stella_Object)namedDescription, Logic.SGT_PL_KERNEL_KB_UPDATE_PROPOSITION_DEMON) : (Stella_Object)null;
        if (stella_Object != null && (method = Logic.functionCodeFromProcedure(stella_Object)) != null) {
            Native.funcall((Method)method, null, (Object[])new Object[]{proposition, keyword});
        }
    }

    public static void runUpdateEquivalencePropositionDemon(Proposition proposition, Keyword keyword) {
        Method method;
        Stella_Object stella_Object;
        Stella_Object stella_Object2 = proposition.arguments.theArray[0];
        Stella_Object stella_Object3 = proposition.arguments.theArray[1];
        NamedDescription namedDescription = Logic.functionOutputSkolemP(stella_Object2) ? Logic.getDescription((Stella_Object)((Surrogate)((Skolem)stella_Object2).definingProposition.operator)) : (Logic.functionOutputSkolemP(stella_Object3) ? Logic.getDescription((Stella_Object)((Surrogate)((Skolem)stella_Object3).definingProposition.operator)) : (NamedDescription)null);
        Stella_Object stella_Object4 = stella_Object = namedDescription != null ? Logic.accessBinaryValue((Stella_Object)namedDescription, Logic.SGT_PL_KERNEL_KB_UPDATE_PROPOSITION_DEMON) : (Stella_Object)null;
        if (stella_Object != null && (method = Logic.functionCodeFromProcedure(stella_Object)) != null) {
            Native.funcall((Method)method, null, (Object[])new Object[]{proposition, keyword});
        }
    }

    public static void clipOrClashWithOldPredicateValue(Proposition proposition) {
        Vector vector = proposition.arguments;
        int n = vector.length() - 2;
        Proposition proposition2 = null;
        Iterator iterator = Logic.allTrueDependentPropositions(vector.theArray[0], (Surrogate)proposition.operator, false);
        while (iterator.nextP()) {
            boolean bl;
            proposition2 = (Proposition)iterator.value;
            boolean bl2 = true;
            int n2 = Integer.MIN_VALUE;
            int n3 = 1;
            int n4 = n;
            boolean bl3 = bl = n4 == Integer.MIN_VALUE;
            while (bl || n3 <= n4) {
                if (Stella_Object.eqlP((Stella_Object)Logic.valueOf(vector.theArray[n2 = n3++]), (Stella_Object)Logic.valueOf(proposition2.arguments.theArray[n2]))) continue;
                bl2 = false;
                break;
            }
            if (!bl2 || Stella_Object.eqlP((Stella_Object)Logic.valueOf(proposition2.arguments.theArray[proposition2.arguments.length() - 1]), (Stella_Object)Logic.valueOf(vector.last()))) continue;
            if (((Boolean)Logic.$CLIPPINGENABLEDp$.get()).booleanValue() && Logic.worldStateP((Context)Stella.$CONTEXT$.get())) {
                Proposition.deassignTruthValue(proposition2, Logic.KWD_RETRACT_TRUE);
                continue;
            }
            Logic.signalUnificationClash(Logic.valueOf(proposition2.arguments.theArray[proposition2.arguments.length() - 1]), Logic.valueOf(vector.last()));
        }
    }

    public static Stella_Object lastArgument(Proposition proposition) {
        return proposition.arguments.theArray[proposition.arguments.length() - 1];
    }

    public void printObject(PrintStream printStream) {
        Proposition proposition = this;
        Logic.printTopLevelObject((Stella_Object)proposition, printStream);
    }

    public static Stella_Object accessPropositionSlotValue(Proposition proposition, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_STELLA_HOME_CONTEXT) {
            if (bl) {
                proposition.homeContext = (Context)object;
            } else {
                object = proposition.homeContext;
            }
        } else if (symbol == Logic.SYM_LOGIC_KIND) {
            if (bl) {
                proposition.kind = (Keyword)object;
            } else {
                object = proposition.kind;
            }
        } else if (symbol == Logic.SYM_LOGIC_TRUTH_VALUE) {
            if (bl) {
                Proposition proposition2 = proposition;
                TruthValue truthValue = (TruthValue)((Object)object);
                Stella_Object stella_Object = proposition2.truthValue;
                Stella_Object stella_Object2 = Stella_Object.updateInContext((Stella_Object)stella_Object, (Stella_Object)truthValue, (Context)proposition2.homeContext, (boolean)false);
                if (stella_Object == null || stella_Object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    proposition2.truthValue = stella_Object2;
                }
            } else {
                object = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
            }
        } else if (symbol == Logic.SYM_STELLA_ARGUMENTS) {
            if (bl) {
                proposition.arguments = (Vector)object;
            } else {
                object = proposition.arguments;
            }
        } else if (symbol == Logic.SYM_STELLA_OPERATOR) {
            if (bl) {
                proposition.operator = (GeneralizedSymbol)object;
            } else {
                object = proposition.operator;
            }
        } else if (symbol == Logic.SYM_LOGIC_RELATIONREF) {
            if (bl) {
                proposition.operator = (Surrogate)object;
            } else {
                object = (Surrogate)proposition.operator;
            }
        } else if (symbol == Logic.SYM_LOGIC_DEPENDENT_PROPOSITIONS) {
            if (bl) {
                proposition.dependentPropositions = (NonPagingIndex)((Object)object);
            } else {
                object = proposition.dependentPropositions;
            }
        } else if (symbol == Logic.SYM_LOGIC_VARIABLE_TYPEp) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, (Stella_Object)((BooleanWrapper)object), null);
            } else {
                object = proposition.variableTypeP();
            }
        } else if (symbol == Logic.SYM_LOGIC_SATELLITE_PROPOSITIONS) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SATELLITE_PROPOSITIONS, (Stella_Object)((List)object), null);
            } else {
                object = proposition.satellitePropositions();
            }
        } else if (symbol == Logic.SYM_LOGIC_PROPOSITION_ORIGINATED_PROPOSITIONS) {
            if (bl) {
                Logic.originatedPropositionsSetter((Stella_Object)proposition, (List)object);
            } else {
                object = Logic.originatedPropositions((Stella_Object)proposition);
            }
        } else if (symbol == Logic.SYM_LOGIC_PROPOSITION_STRINGIFIED_SOURCE) {
            if (bl) {
                Logic.stringifiedSourceSetter((Stella_Object)proposition, ((StringWrapper)object).wrapperValue);
            } else {
                object = StringWrapper.wrapString((String)Logic.stringifiedSource((Stella_Object)proposition));
            }
        } else if (symbol == Logic.SYM_LOGIC_UNFASTENEDp) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_UNFASTENEDp, (Stella_Object)((BooleanWrapper)object), null);
            } else {
                object = proposition.unfastenedP();
            }
        } else if (symbol == Logic.SYM_LOGIC_WEIGHT_DELTA) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT_DELTA, (Stella_Object)FloatWrapper.wrapFloat((double)((FloatWrapper)object).wrapperValue), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
            } else {
                object = FloatWrapper.wrapFloat((double)proposition.weightDelta());
            }
        } else if (symbol == Logic.SYM_LOGIC_SUPPORT) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SUPPORT, (Stella_Object)((Cons)object), null);
            } else {
                object = proposition.support();
            }
        } else if (bl) {
            KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)symbol, (Stella_Object)object, null);
        } else {
            object = proposition.dynamicSlots.lookup((Stella_Object)symbol);
        }
        return object;
    }

    public BooleanWrapper badP() {
        Proposition proposition = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_STELLA_BADp, null);
        if (booleanWrapper == null) {
            return Stella.FALSE_WRAPPER;
        }
        return booleanWrapper;
    }

    public Cons support() {
        Proposition proposition = this;
        Cons cons = (Cons)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SUPPORT, null);
        if (cons == null) {
            return Stella.NIL;
        }
        return cons;
    }

    public double weightDelta() {
        Proposition proposition = this;
        double d = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT_DELTA, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return d;
    }

    public BooleanWrapper unfastenedP() {
        Proposition proposition = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_UNFASTENEDp, null);
        if (booleanWrapper == null) {
            return Stella.FALSE_WRAPPER;
        }
        return booleanWrapper;
    }

    public List satellitePropositions() {
        Proposition proposition = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SATELLITE_PROPOSITIONS, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    public BooleanWrapper variableTypeP() {
        Proposition proposition = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_VARIABLE_TYPEp, null);
        if (booleanWrapper == null) {
            return Stella.FALSE_WRAPPER;
        }
        return booleanWrapper;
    }

    public Surrogate primaryType() {
        Proposition proposition = this;
        return Logic.SGT_LOGIC_PROPOSITION;
    }
}

