/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.PLI;
import edu.isi.powerloom.logic.PowerLoomServerThread;
import edu.isi.powerloom.logic.StartupLogicSystem;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;

public class PowerLoomServer {
    static void usage() {
        System.err.println("Usage: java edu.isi.powerloom.logic.PowerLoomServer [-port <n>] [-kb <filename>]* [-ontology <name>] [-password <password>] [-admin <password>]");
    }

    static void runStartupCode(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getDeclaredMethod(string3, new Class[0]);
            method.invoke(clazz, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Can't find class `" + string2 + "' for startup code.");
            System.exit(-1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Can't find method `" + string3 + "' on `" + string2 + "' for startup code.");
            System.exit(-1);
        }
        catch (Exception exception) {
            System.err.println("Error invoking method `" + string3 + "' on `" + string2 + "' for startup code.");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        ServerSocket serverSocket = null;
        boolean bl = true;
        String string = "PL-USER";
        String string2 = null;
        String string3 = null;
        int n = 4444;
        if (stringArray.length == 1) {
            if (stringArray[0].equals("-help")) {
                PowerLoomServer.usage();
                System.exit(0);
            } else {
                try {
                    n = Integer.parseInt(stringArray[0]);
                }
                catch (Exception exception) {
                    System.err.println("Problem parsing `" + stringArray[0] + "' as a port number");
                    PowerLoomServer.usage();
                    System.exit(-1);
                }
            }
        }
        System.out.print("Initializing PowerLoom ...");
        StartupLogicSystem.startupLogicSystem();
        System.out.println("  Done.");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].equals("-help")) {
                    PowerLoomServer.usage();
                    System.exit(0);
                    continue;
                }
                if (stringArray[i].equals("-ontology")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-kb")) {
                    System.out.println("Loading " + stringArray[++i] + " ...");
                    PLI.load(stringArray[i], null);
                    System.out.println("   Done.");
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-startup")) {
                    System.out.println("Executing " + stringArray[++i] + " ...");
                    PowerLoomServer.runStartupCode(stringArray[i]);
                    System.out.println("   Done.");
                    continue;
                }
                System.err.println("ERROR: Unrecognized option " + stringArray[i]);
                PowerLoomServer.usage();
                System.exit(1);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("Missing argument value for option " + stringArray[i - 1]);
                PowerLoomServer.usage();
                System.exit(1);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Numeric argument expected for option " + stringArray[i - 1] + " but " + stringArray[i] + " supplied");
                PowerLoomServer.usage();
                System.exit(1);
            }
        }
        try {
            serverSocket = new ServerSocket(n);
            System.out.println("Listening on port " + n);
        }
        catch (IOException iOException) {
            System.err.println("Could not listen on port: " + n + ".");
            System.exit(-1);
        }
        while (bl) {
            new PowerLoomServerThread(serverSocket.accept(), string2, string3).start();
            System.out.println("Accepted connection");
        }
        serverSocket.close();
    }
}

