/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.ObjectStore;
import edu.isi.powerloom.logic.PagingIndexIterator;
import edu.isi.powerloom.logic.SequenceIndex;
import edu.isi.stella.Cons;
import edu.isi.stella.Iterator;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import java.io.PrintStream;

public class PagingIndex
extends SequenceIndex {
    public Cons selectionPattern;
    public ObjectStore store;

    public static PagingIndex newPagingIndex() {
        PagingIndex pagingIndex = null;
        pagingIndex = new PagingIndex();
        pagingIndex.theSequenceLength = Integer.MIN_VALUE;
        pagingIndex.theSequence = Stella.NIL;
        pagingIndex.store = null;
        pagingIndex.selectionPattern = null;
        return pagingIndex;
    }

    public Iterator allocateIterator() {
        PagingIndex pagingIndex = this;
        PagingIndexIterator pagingIndexIterator = PagingIndexIterator.newPagingIndexIterator();
        pagingIndexIterator.listIteratorCursor = pagingIndex.theSequence;
        PagingIndexIterator pagingIndexIterator2 = pagingIndexIterator;
        return pagingIndexIterator2;
    }

    public static void printPagingIndex(PagingIndex pagingIndex, PrintStream printStream) {
        boolean bl;
        int n = 10;
        printStream.print("|PAGING-IDX|(" + pagingIndex.selectionPattern);
        Stella_Object stella_Object = null;
        Cons cons = pagingIndex.theSequence;
        int n2 = Integer.MIN_VALUE;
        int n3 = n;
        boolean bl2 = bl = n3 == Integer.MIN_VALUE;
        for (int i = 1; cons != Stella.NIL && (bl || i <= n3); ++i) {
            stella_Object = cons.value;
            n2 = i;
            printStream.print(" " + stella_Object);
            if (n2 == n) {
                printStream.print("...");
            }
            cons = cons.rest;
        }
        printStream.print(")");
    }

    public SequenceIndex remove(Stella_Object stella_Object) {
        Cons cons;
        PagingIndex pagingIndex = this;
        pagingIndex.theSequence = cons = pagingIndex.theSequence.remove(stella_Object);
        pagingIndex.theSequenceLength = Integer.MIN_VALUE;
        return pagingIndex;
    }

    public SequenceIndex removeDeletedMembers() {
        Cons cons;
        PagingIndex pagingIndex = this;
        pagingIndex.theSequence = cons = pagingIndex.theSequence.removeDeletedMembers();
        pagingIndex.theSequenceLength = Integer.MIN_VALUE;
        return pagingIndex;
    }

    public int estimatedLength() {
        PagingIndex pagingIndex = this;
        int n = pagingIndex.theSequenceLength;
        if (n == Integer.MIN_VALUE) {
            pagingIndex.theSequenceLength = n = pagingIndex.theSequence.length();
        }
        return n;
    }

    public void push(Stella_Object stella_Object) {
        PagingIndex pagingIndex = this;
        pagingIndex.insert(stella_Object);
    }

    public void insert(Stella_Object stella_Object) {
        PagingIndex pagingIndex = this;
        if (pagingIndex == Logic.NIL_PAGING_INDEX) {
            System.err.print("Safety violation: Attempt to insert into NIL-PAGING-INDEX");
        }
        pagingIndex.theSequence = Stella_Object.cons((Stella_Object)stella_Object, (Cons)pagingIndex.theSequence);
    }

    public void printObject(PrintStream printStream) {
        PagingIndex pagingIndex = this;
        PagingIndex.printPagingIndex(pagingIndex, printStream);
    }

    public static Stella_Object accessPagingIndexSlotValue(PagingIndex pagingIndex, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_SELECTION_PATTERN) {
            if (bl) {
                pagingIndex.selectionPattern = (Cons)object;
            } else {
                object = pagingIndex.selectionPattern;
            }
        } else if (symbol == Logic.SYM_LOGIC_STORE) {
            if (bl) {
                pagingIndex.store = (ObjectStore)((Object)object);
            } else {
                object = pagingIndex.store;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        PagingIndex pagingIndex = this;
        return Logic.SGT_LOGIC_PAGING_INDEX;
    }
}

