/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.TrainingExample;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.HashTable;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.List;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import java.io.PrintStream;

public class DecisionTree
extends StandardObject {
    public Symbol feature;
    public int featureIndex;
    public Proposition proposition;
    public boolean truthValue;
    public Symbol concept;
    public DecisionTree trueBranch;
    public DecisionTree falseBranch;

    public static DecisionTree newDecisionTree() {
        DecisionTree decisionTree = null;
        decisionTree = new DecisionTree();
        decisionTree.falseBranch = null;
        decisionTree.trueBranch = null;
        decisionTree.concept = null;
        decisionTree.truthValue = false;
        decisionTree.proposition = null;
        decisionTree.featureIndex = Integer.MIN_VALUE;
        decisionTree.feature = null;
        return decisionTree;
    }

    public static List getPropositionsFromDecisionTree(DecisionTree decisionTree) {
        if (decisionTree.feature == null) {
            return List.newList();
        }
        List list = DecisionTree.getPropositionsFromDecisionTree(decisionTree.trueBranch).concatenate(DecisionTree.getPropositionsFromDecisionTree(decisionTree.falseBranch), Stella.NIL);
        list.push((Stella_Object)decisionTree.proposition);
        return list;
    }

    public static void sortExamplesByTree(DecisionTree decisionTree, List list, List list2) {
        if (decisionTree.feature == null) {
            list2.push((Stella_Object)list);
            return;
        }
        List list3 = List.newList();
        List list4 = List.newList();
        TrainingExample trainingExample = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            trainingExample = (TrainingExample)cons.value;
            if (Stella_Object.eqlP((Stella_Object)trainingExample.input.theArray[decisionTree.featureIndex], (Stella_Object)Stella.ONE_WRAPPER)) {
                list3.push((Stella_Object)trainingExample);
            } else {
                list4.push((Stella_Object)trainingExample);
            }
            cons = cons.rest;
        }
        DecisionTree.sortExamplesByTree(decisionTree.trueBranch, list3, list2);
        DecisionTree.sortExamplesByTree(decisionTree.falseBranch, list4, list2);
    }

    public static void extractPathsFromTree(DecisionTree decisionTree, Cons cons, List list) {
        if (decisionTree.feature == null) {
            list.push((Stella_Object)Stella_Object.cons((Stella_Object)(decisionTree.truthValue ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER), (Cons)cons));
            return;
        }
        Cons cons2 = Proposition.propositionToCons(decisionTree.proposition);
        DecisionTree.extractPathsFromTree(decisionTree.trueBranch, Stella_Object.cons((Stella_Object)cons2, (Cons)cons), list);
        DecisionTree.extractPathsFromTree(decisionTree.falseBranch, Stella_Object.cons((Stella_Object)Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_LOGIC_FAIL, (Cons)Stella_Object.cons((Stella_Object)cons2, (Cons)Stella_Object.cons((Stella_Object)Stella.NIL, (Cons)Stella.NIL)))), (Cons)cons), list);
    }

    public static List buildRulesFromTree(DecisionTree decisionTree, List list) {
        List list2 = List.newList();
        Cons cons = Stella.NIL;
        Proposition proposition = null;
        Cons cons2 = list.theConsList;
        Cons cons3 = null;
        while (cons2 != Stella.NIL) {
            proposition = (Proposition)cons2.value;
            if (cons3 == null) {
                cons3 = Stella_Object.cons((Stella_Object)Proposition.propositionToCons(proposition), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons3;
                } else {
                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons3);
                }
            } else {
                cons3 = cons3.rest = Stella_Object.cons((Stella_Object)Proposition.propositionToCons(proposition), (Cons)Stella.NIL);
            }
            cons2 = cons2.rest;
        }
        Logic.$INDUCED_DECISION_RULES$ = List.newList();
        DecisionTree.extractPathsFromTree(decisionTree, Stella.NIL, list2);
        return list2;
    }

    public static void helpPrintDecisionTree(DecisionTree decisionTree, int n, PrintStream printStream) {
        int n2;
        boolean bl;
        if (decisionTree.feature == null) {
            if (decisionTree.truthValue) {
                printStream.println("True");
            } else {
                printStream.println("False");
            }
            return;
        }
        printStream.println();
        int n3 = Integer.MIN_VALUE;
        int n4 = n;
        boolean bl2 = bl = n4 == Integer.MIN_VALUE;
        for (n2 = 1; bl || n2 <= n4; ++n2) {
            n3 = n2;
            printStream.print("|   ");
        }
        printStream.print((Object)((Object)decisionTree.proposition) + " = 1: ");
        DecisionTree.helpPrintDecisionTree(decisionTree.trueBranch, n + 1, printStream);
        n3 = Integer.MIN_VALUE;
        n4 = n;
        boolean bl3 = bl = n4 == Integer.MIN_VALUE;
        for (n2 = 1; bl || n2 <= n4; ++n2) {
            n3 = n2;
            printStream.print("|   ");
        }
        printStream.print((Object)((Object)decisionTree.proposition) + " = 0: ");
        DecisionTree.helpPrintDecisionTree(decisionTree.falseBranch, n + 1, printStream);
    }

    public static void printDecisionTree(DecisionTree decisionTree, PrintStream printStream) {
        DecisionTree.helpPrintDecisionTree(decisionTree, 0, printStream);
    }

    public static void addPropositionsToDecisionTree(DecisionTree decisionTree, HashTable hashTable) {
        if (decisionTree.feature == null) {
            return;
        }
        decisionTree.proposition = (Proposition)hashTable.lookup((Stella_Object)decisionTree.feature);
        DecisionTree.addPropositionsToDecisionTree(decisionTree.trueBranch, hashTable);
        DecisionTree.addPropositionsToDecisionTree(decisionTree.falseBranch, hashTable);
    }

    public static boolean traverseDecisionTree(DecisionTree decisionTree, Vector vector) {
        if (decisionTree.feature == null) {
            return decisionTree.truthValue;
        }
        if (Stella_Object.eqlP((Stella_Object)((IntegerWrapper)vector.theArray[decisionTree.featureIndex]), (Stella_Object)Stella.ONE_WRAPPER)) {
            return DecisionTree.traverseDecisionTree(decisionTree.trueBranch, vector);
        }
        return DecisionTree.traverseDecisionTree(decisionTree.falseBranch, vector);
    }

    public static boolean askDecisionTree(DecisionTree decisionTree, Cons cons) {
        Vector vector = Logic.createInputSignature(cons);
        return DecisionTree.traverseDecisionTree(decisionTree, vector);
    }

    public void printObject(PrintStream printStream) {
        DecisionTree decisionTree = this;
        DecisionTree.printDecisionTree(decisionTree, printStream);
    }

    public static Stella_Object accessDecisionTreeSlotValue(DecisionTree decisionTree, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_FEATURE) {
            if (bl) {
                decisionTree.feature = (Symbol)object;
            } else {
                object = decisionTree.feature;
            }
        } else if (symbol == Logic.SYM_LOGIC_FEATURE_INDEX) {
            if (bl) {
                decisionTree.featureIndex = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)decisionTree.featureIndex);
            }
        } else if (symbol == Logic.SYM_LOGIC_PROPOSITION) {
            if (bl) {
                decisionTree.proposition = (Proposition)((Object)object);
            } else {
                object = decisionTree.proposition;
            }
        } else if (symbol == Logic.SYM_LOGIC_TRUTH_VALUE) {
            if (bl) {
                decisionTree.truthValue = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = decisionTree.truthValue ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_CONCEPT) {
            if (bl) {
                decisionTree.concept = (Symbol)object;
            } else {
                object = decisionTree.concept;
            }
        } else if (symbol == Logic.SYM_LOGIC_TRUE_BRANCH) {
            if (bl) {
                decisionTree.trueBranch = (DecisionTree)((Object)object);
            } else {
                object = decisionTree.trueBranch;
            }
        } else if (symbol == Logic.SYM_LOGIC_FALSE_BRANCH) {
            if (bl) {
                decisionTree.falseBranch = (DecisionTree)((Object)object);
            } else {
                object = decisionTree.falseBranch;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        DecisionTree decisionTree = this;
        return Logic.SGT_LOGIC_DECISION_TREE;
    }
}

