/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.SequenceIndex;
import edu.isi.stella.Cons;
import edu.isi.stella.HashTable;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;

public class BacklinksIndex
extends StandardObject {
    public SequenceIndex dependentPropositionsList;
    public SequenceIndex dependentIsaPropositionsList;
    public HashTable predicatePropositionsTable;

    public static BacklinksIndex newBacklinksIndex() {
        BacklinksIndex backlinksIndex = null;
        backlinksIndex = new BacklinksIndex();
        backlinksIndex.predicatePropositionsTable = null;
        backlinksIndex.dependentIsaPropositionsList = null;
        backlinksIndex.dependentPropositionsList = null;
        return backlinksIndex;
    }

    public static void helpRemoveDependentProposition(BacklinksIndex backlinksIndex, Proposition proposition) {
        SequenceIndex sequenceIndex = backlinksIndex.dependentPropositionsList;
        HashTable hashTable = backlinksIndex.predicatePropositionsTable;
        if (sequenceIndex != null) {
            sequenceIndex.remove((Stella_Object)proposition);
        }
        if (hashTable != null) {
            if (proposition.kind == Logic.KWD_ISA) {
                sequenceIndex = backlinksIndex.dependentIsaPropositionsList;
                if (sequenceIndex != null) {
                    sequenceIndex.remove((Stella_Object)proposition);
                }
            } else {
                sequenceIndex = (SequenceIndex)hashTable.lookup((Stella_Object)((Surrogate)proposition.operator));
                if (sequenceIndex != null) {
                    sequenceIndex.remove((Stella_Object)proposition);
                }
            }
        }
    }

    public static void helpAddDependentProposition(BacklinksIndex backlinksIndex, Proposition proposition, Stella_Object stella_Object) {
        SequenceIndex sequenceIndex = backlinksIndex.dependentPropositionsList;
        HashTable hashTable = backlinksIndex.predicatePropositionsTable;
        if (hashTable == null && SequenceIndex.sequenceIndexDestimatedLength(sequenceIndex) < Logic.$SPECIALIZED_BACKLINKS_CROSSOVER_POINT$) {
            sequenceIndex.insert((Stella_Object)proposition);
            return;
        }
        BacklinksIndex.addDependentPropositionToSpecializedIndex(backlinksIndex, proposition, stella_Object);
        sequenceIndex.insert((Stella_Object)proposition);
    }

    public static void addDependentPropositionToSpecializedIndex(BacklinksIndex backlinksIndex, Proposition proposition, Stella_Object stella_Object) {
        Object object;
        Object object2;
        HashTable hashTable = backlinksIndex.predicatePropositionsTable;
        if (hashTable == null) {
            backlinksIndex.predicatePropositionsTable = hashTable = HashTable.newHashTable();
            object2 = null;
            object = backlinksIndex.dependentPropositionsList.allocateIterator();
            while (object.nextP()) {
                object2 = (Proposition)object.value;
                BacklinksIndex.addDependentPropositionToSpecializedIndex(backlinksIndex, (Proposition)((Object)object2), stella_Object);
            }
        }
        if (proposition.kind == Logic.KWD_ISA) {
            if (backlinksIndex.dependentIsaPropositionsList == null) {
                backlinksIndex.dependentIsaPropositionsList = Logic.createSequenceIndex((Stella_Object)((Module)Stella.$MODULE$.get()), Stella_Object.cons((Stella_Object)Logic.KWD_ISA, (Cons)Stella_Object.cons((Stella_Object)(Stella.NIL == null ? Stella.NIL : Stella.NIL), (Cons)Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL))));
            }
            backlinksIndex.dependentIsaPropositionsList.insert((Stella_Object)proposition);
        } else {
            object2 = (Surrogate)proposition.operator;
            object = null;
            object = (SequenceIndex)hashTable.lookup((Stella_Object)object2);
            if (object == null) {
                object = Logic.createSequenceIndex((Stella_Object)((Module)Stella.$MODULE$.get()), Stella_Object.cons((Stella_Object)Logic.KWD_RELATION, (Cons)Stella_Object.cons((Stella_Object)(Stella.NIL == null ? Stella.NIL : Stella.NIL), (Cons)Stella_Object.cons((Stella_Object)object2, (Cons)Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella.NIL)))));
                hashTable.insertAt((Stella_Object)object2, (Stella_Object)object);
            }
            object.insert((Stella_Object)proposition);
        }
    }

    public static Stella_Object accessBacklinksIndexSlotValue(BacklinksIndex backlinksIndex, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_DEPENDENT_PROPOSITIONS_LIST) {
            if (bl) {
                backlinksIndex.dependentPropositionsList = (SequenceIndex)((Object)object);
            } else {
                object = backlinksIndex.dependentPropositionsList;
            }
        } else if (symbol == Logic.SYM_LOGIC_DEPENDENT_ISA_PROPOSITIONS_LIST) {
            if (bl) {
                backlinksIndex.dependentIsaPropositionsList = (SequenceIndex)((Object)object);
            } else {
                object = backlinksIndex.dependentIsaPropositionsList;
            }
        } else if (symbol == Logic.SYM_LOGIC_PREDICATE_PROPOSITIONS_TABLE) {
            if (bl) {
                backlinksIndex.predicatePropositionsTable = (HashTable)object;
            } else {
                object = backlinksIndex.predicatePropositionsTable;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        BacklinksIndex backlinksIndex = this;
        return Logic.SGT_LOGIC_BACKLINKS_INDEX;
    }
}

