/* Header file for programs using two-dimensional vectors. */

typedef struct {
    float x, y;
} vector2;

vector2 v2Add(vector2 a, vector2 b);    /* Sum of 2 vectors */
vector2 v2Sub(vector2 a, vector2 b);    /* Difference */
vector2 v2Neg(vector2 a);               /* Negative of vector */
vector2 sv2Mul(float f, vector2 v);     /* Multiply by a scalar */
vector2 v2Polar(float len, float angle);
                       /* Compute vector from its length and direction */
float v2Len(vector2 v);                 /* Length of vector */
float v2Arg(vector2 v);                 /* Angle of vector with x axis */
