/******** stack.h: Definition of the Abstract Data Type, stack.   ********/

typedef struct stacktype *stack;    /* The incomplete type - we haven't
                                       said what a 'struct stacktype' is */

/**** stack_init: ******
 On entry: size is the maximum number of elements to be stored in stack.
 On exit:  Returns a correctly initialised empty stack, or NULL if the
           initialisation fails.
*/
stack stack_init(int /*size*/);

/**** stack_free: ******
 On entry: stk is an empty stack.
 On exit:  Any space used by stk has been freed.  stk may no longer be used.
*/
void stack_free(stack /*stk*/);

/**** stack_push: ******
 On entry: stk is an initialised stack, item points to an item to be added
           to the stack.
 On exit:  If item has been added to the top of the stack, returns 1,
           If addition failed, returns 0.
*/
int stack_push(stack /*stk*/, void * /*item*/);

/**** stack_empty: ******
 On entry: stk is an initialised stack.
 On exit:  Returns 1 if stk is empty, 0 otherwise.
*/
int stack_empty(stack /*stk*/);

/**** stack_pop: ******
 On entry: stk is an initialised stack.
 On exit:  If stack not empty, returns top item and removes it from stk,
           otherwise returns NULL.
*/
void *stack_pop(stack /*stk*/);

/**** stack_top: ******
 On entry: stk is an initialised stack.
 On exit:  If stack not empty, returns top item (not removed from stk),
           otherwise returns NULL.
*/
void *stack_top(stack /*stk*/);

/**** stack_count: ******
 On entry: stk is an initialised stack.
 On exit:  Returns count of number of items in the stack.
*/
int stack_count(stack /*stk*/);
