/* Program to input, multiply, and print two matrices. */

#define MAX 5   /* maximum row & column sizes */
#include <stdio.h>
#include <stdlib.h>   /* for exit() */

int rowsizes[2], colsizes[2]; /* row and column sizes of the
                                 input matrices. */
char matrix_name[2][8] = {    /* names for the input matrices */
    "first",
    "second"
};

float A[MAX][MAX], B[MAX][MAX], C[MAX][MAX];  /* the matrices */

/* function definitions: */
void get_size_and_check(int which_matrix) ;
void input_matrix(int which_matrix, float mat[MAX][MAX]);
void form_product(void);
void display_result(void);

main() {
    int i;
    /* Ask and check sizes of matrices. */
    for (i=0; i<2; i++) {
        get_size_and_check(i /* which matrix */);
    }

    if (colsizes[0] != rowsizes[1]) {  /* Sizes compatible? */
        printf("Matrix sizes are not compatible.\n");
        exit(EXIT_FAILURE);
    }

    /* Input matrices. */
    input_matrix(0 /* which matrix */, A);
    input_matrix(1 /* which matrix */, B);

    form_product();      /* Multiply giving matrix C. */

    display_result();    /* Display matrix C. */
    return 0;
}

void get_size_and_check(int which_matrix) {
    printf (
        "Enter row and column sizes for the %s matrix: ",
        matrix_name[which_matrix]
    );
    scanf("%d%d", &rowsizes[which_matrix], &colsizes[which_matrix]);
    if (rowsizes[which_matrix] > MAX || colsizes[which_matrix] > MAX) {
        printf("Error: maximum %d rows and columns.\n", MAX);
        exit(EXIT_FAILURE);
    }
}

void input_matrix(int which_matrix, float mat[MAX][MAX]) {
    int row, col;
    printf("Enter %s matrix:\n", matrix_name[which_matrix]);
    for (row=0; row<rowsizes[which_matrix]; row++) {
        for (col=0; col<colsizes[which_matrix]; col++) {
            scanf("%f", &mat[row][col]);
        }
    }
}

void form_product(void) {
    int i, j, k;
    for (i=0; i<rowsizes[0]; i++) { /*for each row in the matrix C*/
        for (k=0; k<colsizes[1]; k++){ /*for each column in the matrix C*/
            /* sum the partial products */
            float sum = 0.0;
            for (j=0; j<colsizes[0]; j++) {
                sum += A[i][j] * B[j][k];
            }
            C[i][k] = sum;
        }
    }
}

void display_result(void) {
    int r, c;
    printf("Product:\n");
    for (r=0; r<rowsizes[0]; r++) {      /* for each row, */
        for (c=0; c<colsizes[1]; c++) {  /* print all columns, */
            printf("%6.2f ", C[r][c]);
        }
        putchar('\n');                  /* and go to a fresh line */
    }
}
