/* Histogram of student marks.
   Input:  integers representing student marks between 0 and 10.
   Output: A warning for any mark not between 0 and 10, and
           a histogram of number of students scoring each mark.
*/

#include <stdio.h>
#define MAXMARK 10      /* marks lie between 0 and MAXMARK */

void histogram(int mark_totals[]);   /* Display histogram of marks */

main() {
    int mark_totals[MAXMARK + 1];    /* note the "+1"! */
    int i, mark;

    /* Zero all array elements (ready for use as totals) */
    for (i=0; i<=MAXMARK; i++) {
        mark_totals[i] = 0;
    }

    /* Request input */
    printf("Enter the student marks, a negative value to end.\n");

    /* For each input number (no error check): */
    scanf("%d", &mark);
    while (mark >= 0) {
        /* Add one to the appropriate array element. */
        if (mark<=MAXMARK) {      /* Always guard against overflowing
                                     the array!! */
            mark_totals[mark]++;
        } else {
            printf("Warning: mark %d out of range.\n", mark);
        }
        /* Get next number */
        scanf("%d", &mark);
    }

    /* Display the histogram. */
    histogram(mark_totals);
    return 0;
}

/* histogram: prints a histogram of mark totals */
void histogram(int mark_totals[]) {
    int mark, student;
    printf("\nHistogram of Students scoring each mark.\n\n");
    printf("Mark   Number of Students -->>\n");

    /* Print a line for each mark. */
    for (mark=0; mark<=MAXMARK; mark++) {
        /* Print a line:
           print the mark, and an asterisk for each student. */
        printf("%4d   ", mark);
        for (student=0; student<mark_totals[mark]; student++) {
            putchar('*');
        }
        /* end the line */
        putchar('\n');
    }
}
