/* A program to print numbers less than average.
   Input:  a list of at most MAXNUM (see below) floats typed by the
           user.  The end is detected by testing for EOF.
   Output: A message giving the mean of the numbers, then a list of
           those values less than the mean.
*/

#include <stdio.h>
#define MAXNUM 500      /* maximum number of numbers */

float enter_and_sum(float nums[],int amount_used); /* Returns the sum of
                                                    the entered values */

void display_low_values(float numbers[], float mean, int amount_used);

main() {
    float numbers[MAXNUM];  /* The numbers entered by the user */
    float mean, sum;
    int amount_used;

    /* Ask the user how many numbers will be entered */
    printf("How many numbers do you wish to enter? ");
    scanf("%d", &amount_used);

    /* Check that the user's request is OK */
    while (amount_used > MAXNUM) {
        printf("Sorry, that's too many.  Try again: ");
        scanf("%d", &amount_used);
    }

    /* Read numbers into array, summing and counting as we go. */
    sum = enter_and_sum(numbers, amount_used);

    /* Divide the sum by the count to get the mean, and display. */
    mean = sum/amount_used;
    printf("The mean is %f\n\nNumbers below mean:\n", mean);

    /* Look for, and display, numbers less than the mean. */
    display_low_values(numbers, mean, amount_used);
    return 0;
}

/* enter_and_sum:
   Reads 'amount_to_read' input values, summing and counting the values.
   Does not check for erroneous input.
   Stores the values in its argument array, nums, and returns the sum
      as the function result.
*/
float enter_and_sum(float nums[], int amount_to_read) {
    int count;
    float sum;

    sum = 0.0;
    printf("Enter %d input numbers:\n", amount_to_read);
    for (count=0; count<amount_to_read; count++) {
        scanf("%f", &nums[count]);
        sum += nums[count];
    }

    return sum;
}

/* display_low_values:
   Looks at the first 'amount_used' numbers in the array 'numbers',
   displaying any that are less than the mean.
*/
void display_low_values(float numbers[], float mean, int amount_used) {
    int i;
    for (i=0; i<amount_used; i++) {
        if (numbers[i] < mean) {
            printf("%g\n", numbers[i]);
        }
    }
}
