#include <stdio.h>
#include <stdlib.h>    /* for abort() */

/* checked_float - Prints a prompt, and inputs a value.  Unless the
value is within a specified range, continues to object and ask for
the value to be re-input.  Returns the final legal value as the
function result. */

float checked_float (
    char question[],      /* the question to ask the user */
    float minval,         /* minimum legal response */
    float maxval          /* maximum legal response */
) {
    float in_value;

    /* First a quick check that the arguments make sense - stop
       the program if not. */
    if (maxval < minval) {
        printf("ERROR: Bad arguments to checked_float.\n");
        abort();
    }

    /* Display question, with valid range.  Read answer. */
    printf("%s (range %g to %g): ", question, minval, maxval);
    scanf("%f", &in_value);

    /* Repeatedly object until the answer is legitimate. */
    while (in_value<minval || in_value>maxval) {
        /* error message */
        printf (
            "Your answer must be between %g and %g. Try again: ",
            minval, maxval
        );
        /* input another value */
        scanf("%f", &in_value);
    }

    /* Here we have a legal input value; return it */
    return in_value;
}

/************** Simple test main function *************/

main() {
    float f;
    f = checked_float("Wazza numba?", 2.5, 10.7);
    printf("\nThe input number is %g\n", f);
}
