/* A program to print name tags with seat numbers.
   Asks how many tags will be needed, and then reads each
   name and prints its tag.
*/

#include <stdio.h>
#include <string.h>

int seat_num;   /* Holds the seat number to be put on the tag. */

void print_stars (void) {
    printf ("***********************************************\n");
}

void print_side_border (void) {
    printf ("**                                           **\n");
}

/* print_tag: Prints a name tag with seat number.
   On entry: Its parameter is a string with the name to be printed.
             The seat number must be in the global integer 'seat_num'.
   After printing tag, increments the seat number ready for the next tag.
*/

void print_tag (char name[]) {
    /* Top section:  */
    print_stars ();
    print_stars ();
    print_side_border ();

    /* Line containing the name and number:  */
    printf ("**       %20s    (seat %3d)  **\n", name, seat_num);

    /* Bottom section:  */
    print_side_border ();
    print_stars ();
    print_stars ();
    seat_num = seat_num + 1;
}

/* main: Prints the name tags, with a blank line between each. */

main () {
    int no_of_tags;                  /* How many tags to print */
    int i;
    char name[21];                   /* Holds the name for the tag */
    seat_num = 100;                  /* First seat is no. 100 */

    printf("How many tags are needed? ");
    scanf("%d%*c", &no_of_tags);

    for (i=0; i<no_of_tags; i++) {
        printf("Enter name for tag (max. 20 chars): ");
        gets(name);
        printf("\n");                /* blank line between tags */
        print_tag(name);             /* Print first tag */
        printf("\n");                /* blank line between tags */
    }
}
