/* A program to print name tags with seat numbers. */

#include <stdio.h>
#include <string.h>
void print_tag(char name[]); /* << Note how to write an array argument */
void print_stars(void);
void print_side_border(void);

int seat_num;   /* Holds the seat number to be put on the tag. */

/* main: Prints the name tags, with a blank line between each. */

main () {
    seat_num = 100;                  /* First seat is no. 100 */
    print_tag("John Smith");         /* Print first tag */
    printf("\n");                    /* blank line between tags */
    print_tag("Mary Peterson");      /* second tag */
    printf("\n");                    /* blank line */
    print_tag("Alison Gray");        /* third tag */
}

/* print_tag: Prints a name tag with seat number.
   On entry: Its parameter is a string with the name to be printed.
             The seat number must be in the global integer 'seat_num'.
   After printing tag, increments the seat number ready for the next tag.
*/

void print_tag (char name[]) {
    /* Top section:  */
    print_stars();
    print_stars();
    print_side_border();

    /* Line containing the name and number:  */
    printf("**       %20s    (seat %3d)  **\n", name, seat_num);

    /* Bottom section:  */
    print_side_border();
    print_stars();
    print_stars();
    seat_num = seat_num + 1;
}

void print_stars (void) {
    printf("***********************************************\n");
}

void print_side_border (void) {
    printf("**                                           **\n");
}
