/* display-date function with arguments, tested on input dates */
#include <stdio.h>

#define MDY_FORMAT 0         /* Explanatory names       (US)      */
#define DMY_FORMAT 1         /* for the                 (British) */
#define YMD_FORMAT 2         /* date format codes       (other)   */

int date_format;    /* Note: only one global now */
void display_date(int day, int month, int year);
                 /* Note: formal parameters listed in parentheses */

main() {
    int today_day, today_month, today_year;
    int then_day, then_month, then_year;

    /* First set the country code */
    printf("Enter the date code (0=US, 1=Europe, 2=year-first): ");
    scanf("%d", &date_format);

    printf("Date today (day month year)? ");
    scanf("%d %d %d", &today_day, &today_month, &today_year);
    printf("Date to be printed (day month year)? ");
    scanf("%d %d %d", &then_day, &then_month, &then_year);

    while (then_day != 0) {
        printf("Today is ");
        display_date(today_day, today_month, today_year);

        printf("     The other date is ");
        display_date(then_day, then_month, then_year);

        printf("\nDate to be printed (day month year)? ");
        scanf("%d %d %d", &then_day, &then_month, &then_year);
    }
}

void display_date(int day, int month, int year) {
    /* Select correct display method */
    switch (date_format) {
    case MDY_FORMAT:                        /* US format */
        printf("%d/%d/%d", month, day, year);
        break;
    case DMY_FORMAT:                        /* European format */
        printf("%d/%d/%d", day, month, year);
        break;
    case YMD_FORMAT:                        /* Year-first format */
        printf("%d/%d/%d", year, month, day);
    }
}
