/* A program for producing a telephone account.
   Input must consist of
   a)  A line containing a client name,
   b)  Multiple lines, each describing a phone call:
       a character (L, A, B or I indicating call type
       a fractional number representing call duration in minutes.
   c)  A line commencing with a Z

   Output is a phone account with a heading including the client name,
   an itemised list of calls showing individual cost,
   totals for all four call types,
   a grand total cost.
*/

#include <stdio.h>

/**** Function declarations ****/
void process_heading (void);
void Process_one_call_record (void);
void print_all_totals (void);

/**Globals**/
float total_L, total_A, total_B, total_I;
    /* Totals for Local, long dist A, l.d. B, International. */
char call_type_code;    /* letter specifying type of call */

main () {
    /* Zero variables for storing totals. */
    total_L = total_A = total_B = total_I = 0.0;

    /* Read client name, and print heading, including name. */
    process_heading();

    /* Get the letter starting the next line. */
    scanf(" %c", &call_type_code);

    while (call_type_code != 'Z') {
        /* Process one line of account (including updating totals) */
        Process_one_call_record();

        /* Get the letter starting the next line. */
        scanf(" %c", &call_type_code);
        /*     ^     That space is vital! */
    }
    print_all_totals();
}

/***** process_heading:
 On entry: The next line of input contains the name of the client.
 On Exit:  A heading for the bill is printed which includes the
           client's name.  Headings for the columns in the itemised
           part are printed.
*****/

void process_heading (void) {
    char client_name[81];   /* Assume no client name > 80 chars */
    gets(client_name);
    printf("\t\tSupa Phone Incorporated.\n");
    printf("Phone bill for\n%s\n\n", client_name);
    printf("Call Code   Duration   Cost($)\n");
    printf("=========   ========   =======\n");
}

/***** Process_one_call_record:
 On entry: call_type_code contains the identifying letter for the
           call type of the present call.
           Input contains the duration in fractional minutes.
           Totals contain summed costs for all previous calls.
 On exit:  An item line is printed showing call type code, duration,
           and cost of call.
           Totals contain summed costs for all previous, AND THIS, call.
*****/

void Process_one_call_record (void) {
    float call_duration, call_cost;
    scanf("%f", &call_duration);

    /* Evaluate call cost based on category & adjust total */
    switch (call_type_code) {
    case 'L':
        call_cost = 0.40;                        /* 40 cents */
        total_L += call_cost;
        break;
    case 'A':
        call_cost = 0.40 * call_duration;        /* 40c / minute */
        total_A += call_cost;
        break;
    case 'B':
        call_cost = 0.60 * call_duration;        /* 60c / minute */
        total_B += call_cost;
        break;
    case 'I':
        call_cost = 0.50 + 0.80 * call_duration; /* 50c + 80c/min */
        total_I += call_cost;
        break;
    default:
        printf("Warning: illegal call type code:\n");
        call_cost = 0;
    }

    /* Print bill detail line */
    printf (
        "%5c    %10.2f  %8.2f\n",
        call_type_code, call_duration, call_cost
    );
}

/***** print_all_totals:
 On entry: Totals contain summed costs for all calls.
 Operation:Totals are printed.  The grand total is computed and printed.
*****/

void print_all_totals (void) {
    /* Note the use of if statements to ensure that only those
       lines with nonzero totals are reported. */

    printf("================================\n");
    if (total_L != 0.0) {
        printf("Total cost of local calls:     $%6.2f\n", total_L);
    }
    if (total_A != 0.0) {
        printf("Total cost of long distance A: $%6.2f\n", total_A);
    }
    if (total_B != 0.0) {
        printf("Total cost of long distance B: $%6.2f\n", total_B);
    }
    if (total_I != 0.0) {
        printf("Total cost of international  : $%6.2f\n", total_I);
    }
    printf (
        "=================\nTotal amount due: $%4.2f\n\n",
        total_L + total_A + total_B + total_I
    );
}
