/* Given three input real numbers representing the coefficients of a
   quadratic equation (y = a*x*x + b*x + c), decides what sort of
   solution the equation has, and prints the solutions if any.  */
#include <stdio.h>
#include <math.h>

main () {
    float a, b, c, Z;
    /* Input coefficients: */
    printf("Enter the three coefficients of the quadratic,\n");
    printf("x-squared coefficient first: ");
    scanf("%f %f %f", &a, &b, &c);
    Z = b*b - 4*a*c;  /* to save recalculation */

    if (a == 0) {
        printf("The coefficients do not represent a quadratic.\n");

    } else if (Z < 0) {
        printf("The quadratic has no solutions.\n");

    } else if (Z == 0) {
        printf("There is one solution, x = %f\n", -b / (2.0 * a));

    } else {  /* b*b-4*a*c must here be greater than zero */
        printf (
            "There are two solutions, x = %f, and x = %f\n",
            (-b + sqrt(Z)) / (2.0 * a),
            (-b - sqrt(Z)) / (2.0 * a)
        );
    }
}
