/* A program to produce a progressive total cost listing for items
   supplied as input.
   The program first asks the amount of money available, and then
   inputs item names and purchase costs, and writes a progressive
   total cost listing.  The program stops when the progressive
   total exceeds the money available.  */

#include <stdio.h>

main() {
    char item_name[21];    /* To store the name of each item entered. */
    int progressive_cost_total;
    int money_available;

    /* Ask for and input the money available, in whole dollars. */
    printf("How many dollars are available? ");
    scanf("%d", &money_available);

    /* Set the cost total to zero. */
    progressive_cost_total = 0;

    /* While money remains */
    while (progressive_cost_total < money_available) {
        int item_cost;
        /* Read an item name and cost in whole dollars */
        scanf("%20s%d", item_name, &item_cost);

        /* Include the item cost in the cost total */
        progressive_cost_total = progressive_cost_total + item_cost;

        /* Print the name and progressive total cost */
        printf("%20s %5d\n", item_name, progressive_cost_total);
    }

    /* (The money has run out) Print a message explaining this. */
    printf("\nThat last item exceeded the amount available.\n");
}
