/* Program to produce an itemised income and expenses report for
   items in stock */
#include <stdio.h>

/*********** Globals: ***********/
int   commodity_code;
float total_expenses_to_date, total_income_to_date;

/***** Function Declaration *****/
void process_a_record (void);

/********** Functions ***********/

main () {
    /* Print the headings. */
    printf("Commodity      Code   Commodity  Commodity  Quantity\n");
    printf("  Name        Number   Cost ($)  Sales ($)  Remaining\n");
    printf("=========     ======  =========  =========  =========\n");

    /* Zero accumulators for the totals. */
    total_expenses_to_date = total_income_to_date = 0.0;

    scanf("%d", &commodity_code);

    while (commodity_code != 0) {
        process_a_record();      /* (including output and totalling) */
        scanf("%d", &commodity_code);
    }

    /* Print the total expenses and income so far. */
    printf("\nTotal expenses to date: $%4.2f\n", total_expenses_to_date);
    printf("Total income to date:   $%4.2f\n", total_income_to_date);
}

/********************************/
/** process_a_record:
    Processes one input record.

    On Entry: commodity_code must contain the record's code no.
              Other input values are waiting to be read.
              total_expenses_to_date & total_income_to_date must
              contain totals for all records prior to this one.
              Assumption: No commodity name exceeds 80 characters.

    On Exit:  Remaining input fields for this record have been read.
              One-line summary for this record has been printed.
              total_expenses_to_date & total_income_to_date have been
              updated to include this record.
**/

void process_a_record (void) {

    /* Input fields: */
    char commodity_name[81];
    float cost_per_item;      /* Amount paid for each item */
    float income_per_item;    /* Amount received for each item sold */
    int   num_sold_to_date;   /* number of items sold so far */
    int   num_bought_to_date; /* number bought (should be >= no. sold) */

    /* Working variables: */
    float full_cost, full_income;  /* for the items in this record */

    /* Input remaining fields for this item */
    scanf (
        "%80s%f%d%f%d",
        commodity_name,
        &cost_per_item,
        &num_bought_to_date,
        &income_per_item,
        &num_sold_to_date
    );

    /* Calculate totals for this item. */
    full_cost = cost_per_item * num_bought_to_date;
    full_income = income_per_item * num_sold_to_date;

    /* Print report line */
    printf (
        "%13s %5d %10.2f %10.2f     %5d\n",
        commodity_name,
        commodity_code,
        full_cost,
        full_income,
        num_bought_to_date - num_sold_to_date  /* qty remaining */
    );

    /* Update grand totals */
    total_expenses_to_date += full_cost;
    total_income_to_date   += full_income;
}
