/* Table of uranium radioactive decay remnant quantity. */

#include <stdio.h>
#include <math.h>

#define HALF_LIFE 4.5e9
#define TIME_GAP 1.0e9

main () {
    float mass, years, K;
    int epoch;

    mass = 1.0;  /* one pound, that is */
    K = log(2.0)/HALF_LIFE;

    for (epoch=0; epoch<=10; epoch=epoch+1) {
        years = TIME_GAP * epoch;
        printf (
            "After %11.0f years, %f pound of uranium remains.\n",
            years, mass * exp(-K*years)
        );
    }
}
