/* A program to print name tags with seat numbers.  Seats are allocated
 * consecutive numbers starting with 100
 * Prints a tag for each of the following names:
 *        John Smith
 *        Mary Peterson
 *        Alison Gray
 */

#include <stdio.h>
#include <string.h>

/*** Global variables: ***/
char name[21];  /* Holds the name to be put on the tag - max 20 chars */
int seat_num;   /* Holds the seat number to be put on the tag. */

/*** Function declarations: ***/
void print_tag (void);
void print_side_border (void);
void print_stars (void);

/* main: Prints the name tags, with a blank line between each. */

main () {
    seat_num = 100;                  /* First seat is no. 100 */
    strcpy(name, "John Smith");     /* Set up first name */
    print_tag();                    /* Print first tag */
    printf("\n");                   /* blank line between tags */
    strcpy(name, "Mary Peterson");  /* Second name */
    print_tag();                    /* second tag */
    printf("\n");                   /* blank line */
    strcpy(name, "Alison Gray");    /* third name */
    print_tag();                    /* third tag */
}

/* print_tag: Prints a name tag with seat number.
   On entry: The name (max. 20 chars) must be in the global array 'name'.
             The seat number must be in the global integer 'seat_num'.
   After printing tag, increments the seat number ready for the next tag.
*/

void print_tag (void) {
    /* Top section:  */
    print_stars();
    print_stars();
    print_side_border();

    /* Line containing the name and number:  */
    printf("**       %20s    (seat %3d)  **\n", name, seat_num);

    /* Bottom section:  */
    print_side_border();
    print_stars();
    print_stars();
    seat_num = seat_num + 1;
}

/* print_stars: Prints a row of stars to form a tag border. */

void print_stars (void) {
    printf("***********************************************\n");
}

/* print_side_border: Prints left and right parts of the vertical rows
                      of stars which form a tag border. */

void print_side_border (void) {
    printf("**                                           **\n");
}
