/* A program to print name tags.
 * Prints a tag for each of the following names:
 *        John Smith
 *        Mary Peterson
 *        Alison Gray
 */

#include <stdio.h>

/*** function declarations:  ***/
void print_top_section (void);
void print_bottom_section (void);
void print_side_border (void);
void print_stars (void);
void print_tag_for_John_Smith (void);
void print_tag_for_Mary_Peterson (void);
void print_tag_for_Alison_Gray (void);

/* main: Prints the name tags, with a blank line between each. */

main () {
    print_tag_for_John_Smith();
    printf("\n");
    print_tag_for_Mary_Peterson();
    printf("\n");
    print_tag_for_Alison_Gray();
}

void print_tag_for_John_Smith (void) {
    print_top_section();
    printf("**                 John Smith                **\n");
    print_bottom_section();
}

void print_tag_for_Mary_Peterson (void) {
    print_top_section();
    printf("**               Mary Peterson               **\n");
    print_bottom_section();
}

void print_tag_for_Alison_Gray (void) {
    print_top_section();
    printf("**                Alison Gray                **\n");
    print_bottom_section();
}

/* print_top_section: Prints the entire part of a tag above the line
                      with the name.  */

void print_top_section (void) {
    print_stars();
    print_stars();
    print_side_border();
}

/* print_bottom_section: Prints the entire part of a tag below the line
                         with the name.  */

void print_bottom_section (void) {
    print_side_border();
    print_stars();
    print_stars();
}

/* print_stars: Prints a row of stars to form a tag border. */

void print_stars (void) {
    printf("***********************************************\n");
}

/* print_side_border: Prints left and right parts of the vertical rows
                      of stars which form a tag border. */

void print_side_border (void) {
    printf("**                                           **\n");
}
