int partition(float A[], int first, int last);

void quicksort(float A[], int first, int last) {
    int pivindx; /* index of the element separating the two sub-arrays */
    if (last > first) {  /* More than one element to be sorted? */
        pivindx = partition(A, first, last);
        quicksort(A, first, pivindx - 1);
        quicksort(A, pivindx + 1, last);
    }
}

#include <stdlib.h>     /* for rand() */

int partition(float A[], int first, int last) {
    int pivindx, top, i; float pivot;

    /* Choose a pivot: select a random index between first and last. */
    i = rand() % (last - first + 1) + first;

    /* Put the pivot first, remember pivot, initialise ready for loop. */
    pivot = A[i];                     /* remember the pivot */
    A[i] = A[first];
    A[first] = pivot;                 /* pivot now first */
    pivindx = first;
    top = last;                       /* invariant established */

    while (top > pivindx) {           /* Still unknown elements */
        /* top indicates the highest unknown element; examine */
        if (A[top] >= pivot) {
            top--;                    /* where it belongs, count as >= */
        } else {
            A[pivindx] = A[top];      /* shift down */
            A[top] = A[pivindx + 1];  /* shift displaced element up */
            A[pivindx + 1] = pivot;   /* Put pivot back */
            pivindx++;                /* Alter record of pivot location */
        }
    }

    return pivindx;
}

#include <stdio.h>
float test[] = {9.9, 8.8, 8.5, 9.7, 8.8, 4.1, 9.9, 3.2, 4.6, 5.5};
#define size (10)

void info(void) {
    int i;
    for (i=0; i<size; i++) {
        printf("%3.1f ", test[i]);
    }
    putchar('\n');
}

main() {
    printf("Before: "); info();
    quicksort(test, 0, size - 1);
    printf("After:  "); info();
    return 0;
}
