#include <stddef.h>

void *oursearch(
    const void *key,       /* address of key to be found */
    const void *array,     /* address of start of array */
    size_t numb,           /* no. of elements of array to search */
    size_t elt_size,       /* size of each element */
    int (*compar)(const void *first, const void *second) /* comparison fn */
) {
    int L = 0, U = numb - 1, M, status;
    while (L <= U) {
        M = (L + U) / 2; /* M must be in range L...U (property of mean) */
        status = compar(key, ((char*)array) + M * elt_size);
        if (status > 0) {
            L = M + 1;
        } else if (status == 0) {
            return ((char*)array) + M * elt_size;   /* address of element */
        } else {
            U = M - 1;
        }
    }
    return NULL;                          /* Key not found */
}

#include <stdio.h>

int intcmp (const void *first, const void *second) {
    return (*(int*)first) - (*(int*)second);
}

int test[] = {1,1,3,5,5,6,8,9,9};
#define numb 9

main () {
    int i, *where;
    for (i=0; i<numb; i++) {
        printf("A[%d]=%d ", i, test[i]);
    }
    putchar('\n');
    for (i=0; i<=10; i++) {
        where = (int*)oursearch(&i, test, numb, sizeof(int), intcmp);
        if (where != NULL) {  /* Test for item i found. */
            printf("Seeking %2d, found at j=%2d:\n", i, where - test);
        } else {
            printf("Seeking %2d, NOT found\n", i);
        }
    }
}
