#include <stdio.h>

extern int glob;     /* This is the same glob declared in lst18-1.c.  The
                        word 'extern' tells the compiler that there is an
                        int called glob declared in another file. */
static int loc;      /* loc, being declared static, is only accessible from
                        this source file.  This is a DIFFERENT loc from
                        that in lst18-1.c.  It would be an error to try
                        to access the loc in lst18-1.c by using 'extern'. */

static void locfunc(void) {
                     /* We can also have a function locfunc in this source
                        file, because the word 'static' prevents any other
                        file knowing about or accessing this function. */
    printf("        Inside the locfunc in lst18-2.c\n");
    printf("        Storing 77 in loc and 99 in glob\n");
    loc = 77;
    glob = 99;
}

void globfunc(void) {
                     /* This is the globfunc called in lst18-1.c */
    printf("    Inside the globfunc in lst18-2.c\n");
    printf("    Calling locfunc...\n");
    locfunc();
    printf("    Leaving globfunc; loc = %d, glob = %d...\n", loc, glob);
}
