#include <stdio.h>

int glob;            /* glob is accessible from any source file that is part
                        of the program. */
static int loc;      /* loc, being declared static, is only accessible from
                        this source file. */

void globfunc(void); /* globfunc is external, as the word 'static' is not
                        given in the declaration.  As globfunc will be
                        defined in lst18-2.c, it is also correct to write
                        this declaration as:
                        extern void globfunc(void);
                        */
static void locfunc(void);
                     /* locfunc MUST be declared later in THIS file, as
                        'static' makes locfunc specific to this file. */

main() {
    printf("Calling locfunc from main in lst18-1.c...\n");
    locfunc();
    printf("Calling globfunc from main...\n");
    globfunc();
    printf("Back in main; loc = %d, glob = %d\n", loc, glob);
    return 0;
}

static void locfunc(void) {
    printf("    Inside locfunc in lst18-1.c\n    storing 88 in loc\n");
    loc = 88;
}
