/* Program to issue help.  Requests the names of the two help files, and
   then allows the user to enter help topic names, or '?' for a full topic
   listing.  A blank line or EOF terminates the program.
*/
#include "helpadt.h"                    /* This includes <stdio.h> */
#include <stdlib.h>
#include <string.h>

void getname(char message[], char answerbuf[], int bufsize);
void givehelp(HELPSYS *help, char topic[]);

main() {
    char indexname[FILENAME_MAX], fullname[FILENAME_MAX], item[NAMESIZE];
    HELPSYS *help;
    getname("Enter help index filename: ", indexname, FILENAME_MAX);
    getname("Enter help database filename: ", fullname, FILENAME_MAX);
    help = help_open(indexname, fullname, 10); /* Try to open help files */
    if (help == NULL) {                        /* Failed? */
        fprintf(stderr, "Can't open help database.\n"); exit(EXIT_FAILURE);
    }
    while (
        getname(
            "Enter topic name, or '?' for full list, or ENTER to finish.\n",
            item, NAMESIZE
        ),
        strcmp(item, "") != 0                   /* blank line entered? */
    ) {
        givehelp(help, item);
    }
    help_close(help);
    return 0;
}

/****** getname: Prompt user and accept answer ******
 On Entry: message is the question, bufsize is the size of answerbuf.
 On Exit:  The user's answer to the question is in answerbuf; if EOF
           is encountered, answerbuf is the empty string.
*/
void getname(char message[], char answerbuf[], int bufsize) {
    int i, j, ch;
    fputs(message, stderr);
    j = -1; i = 0; ch = getchar();
    while (ch != EOF && ch != '\n') {   /* input line */
        if (i < bufsize-1) {            /* i.e. up to 2nd-last character */
            answerbuf[i] = ch; j = i;   /* j is position of latest char */
        }
        ch = getchar(); i++;
    }
    answerbuf[j+1] = '\0';              /* terminating string nul */
}

void givehelp(HELPSYS *help, char topic[]) {
    helpndx *item; char *message;
    if (strcmp(topic, "?") == 0) {      /* Give list of topics? */
        help_reset(help);
        printf("\n    LIST OF TOPICS:\nNAME       DESCRIPTION\n");
        while ((item = help_next(help)) != NULL) { /* Got another topic? */
            printf("%-10s %s\n", item->name, item->descript);
        }
        putchar('\n');                  /* An extra blank line */
    } else {                            /* Help on a particular topic. */
        if ((item = help_name(help, topic)) == NULL) {  /* Cannot find? */
            printf("Sorry, that topic was not found.\n");
        } else {
            printf("\n%s: %s\n", item->name, item->descript);
            if ((message = help_message(help, item->loc)) == NULL) {
                printf("Error locating full help information.\n");
            } else {
                fputs(message, stdout); putchar('\n');
                free(message);   /* (See help_message postcondition) */
            }
        }
    }
}
