/* A Recursive function to add elements of an array, with diagnostic
   printouts and a short main function for testing. */

#include <stdio.h>
int level = 0;     /* This will tell us the nesting level of the
                      recursive function calls. */

float sumarray(float A[], int L, int H) {
    printf("%*.*sEntering sumarray level %d, L==%d, H==%d\n",
           level*4, level*4, " ", level, L, H);
    if (H < L) {                              /* nothing to sum */
        printf("%*.*sExiting sumarray level %d, result==0\n",
           level*4, level*4, " ", level);
        return 0;
    } else if (H == L) {                      /* one element in range */
        printf("%*.*sExiting sumarray level %d, result==%.1f\n",
           level*4, level*4, " ", level, A[L]);
        return A[L];
    } else {                                  /* Multiple elements */
        int M; float answer1, answer2, answer;
        M = (L+H)/2;
        level++;    /* Bump up the level for the recursive call */
        answer1 = sumarray(A, L, M);
        answer2 = sumarray(A, M + 1, H);
        answer = answer1 + answer2;
        level--;    /* Restore previous level */
        printf("%*.*sExiting sumarray level %d, result==%.1f+%.1f==%.1f\n",
           level*4, level*4, " ", level, answer1, answer2, answer);
        return answer;
    }
}

float arr[] = {1., 2., 3., 4., 5., 6.};

main() {
    float total;
    total = sumarray(arr, 0, 5);
    printf("\nThe total is %f\n", total);
    return 0;
}
