/* The following #ifdef includes the mat_create function; you may wish
   to delete it and link the two files separately.
*/
#ifdef __cplusplus
    #include "lst13-2.cpp"    /* or maybe "lst13-2.cxx" */
#else
    #include "lst13-2.c"
#endif

/*** Program to input two matrices and print their sum ***/
#include <stdio.h>

typedef struct {
    matrix m;
    int rows, cols;
} s_mat;

s_mat s_mat_create(int row, int column);
void read_matrix(s_mat m, FILE *f);
void sum_matrices(s_mat sum, s_mat a, s_mat b);

main() {
    s_mat a, b, c;
    int rows, columns, i, j;
    FILE * inf;
    inf = fopen("lst13-3.dat", "r");
    if (inf==NULL) {
        fprintf(stderr, "File open failure\n"); exit(EXIT_FAILURE);
    }
    fscanf(inf, "%d %d", &rows, &columns);
    a = s_mat_create(rows, columns);
    b = s_mat_create(rows, columns);
    c = s_mat_create(rows, columns);
    if (a.m==NULL || b.m==NULL || c.m==NULL) {
        fprintf(stderr, "Could not create matrices\n"); exit(EXIT_FAILURE);
    }
    read_matrix(b, inf);
    read_matrix(c, inf);
    fclose(inf);
    sum_matrices(a, b, c);
    /* Now print the sum matrix */
    for (i=0; i<a.rows; i++) {
        for (j=0; j<a.cols; j++) {
            printf("%8.4f ", a.m[i][j]);  /* Note use of field m */
        }
        printf("\n");
    }
    return 0;
}

void read_matrix(s_mat m, FILE *f) {
    int i, j;
    for (i=0; i<m.rows; i++) {
        for (j=0; j<m.cols; j++) {
            fscanf(f, "%f ", &m.m[i][j]);
        }
    }
}

void sum_matrices(s_mat sum, s_mat a, s_mat b) {
    /* N.B.: Assumes all three are the same size!! */
    int i, j;
    for (i=0; i<sum.rows; i++) {
        for (j=0; j<sum.cols; j++) {
            sum.m[i][j] = a.m[i][j] + b.m[i][j];
        }
    }
}

s_mat s_mat_create(int row, int column){
/* Failure is detected by checking the '.m' field for NULL */
    s_mat s;
    s.rows = row;
    s.cols = column;
    s.m = mat_create(row, column);
    return s;
}
