/* The following #ifdef includes the mat_create function; you may wish
   to delete it and link the two files separately.
*/
#ifdef __cplusplus
    #include "lst13-2.cpp"    /* or maybe "lst13-2.cxx" */
#else
    #include "lst13-2.c"
#endif

/*** Program to input two matrices and print their sum ***/
#include <stdio.h>

void read_matrix(matrix m, FILE *f, int rows, int columns);
void sum_matrices(matrix sum, matrix a, matrix b, int rows, int columns);

main() {
    matrix a, b, c;
    int rows, columns, i, j;
    FILE * inf;
    inf = fopen("lst13-3.dat", "r");
    if (inf==NULL) {
        fprintf(stderr, "File open failure\n"); exit(EXIT_FAILURE);
    }
    fscanf(inf, "%d %d", &rows, &columns);
    a = mat_create(rows, columns);
    b = mat_create(rows, columns);
    c = mat_create(rows, columns);
    if (a==NULL || b==NULL || c==NULL) {
        fprintf(stderr, "Could not create matrices\n"); exit(EXIT_FAILURE);
    }
    read_matrix(b, inf, rows, columns);
    read_matrix(c, inf, rows, columns);
    fclose(inf);
    sum_matrices(a, b, c, rows, columns);
    /* Now print the sum matrix */
    for (i=0; i<rows; i++) {
        for (j=0; j<columns; j++) {
            printf("%8.4f ", a[i][j]);
        }
        printf("\n");
    }
    return 0;
}

void read_matrix(matrix m, FILE *f, int rows, int columns) {
    int i, j;
    for (i=0; i<rows; i++) {
        for (j=0; j<columns; j++) {
            fscanf(f, "%f ", &m[i][j]);
        }
    }
}

void sum_matrices(matrix sum, matrix a, matrix b, int rows, int columns) {
    int i, j;
    for (i=0; i<rows; i++) {
        for (j=0; j<columns; j++) {
            sum[i][j] = a[i][j] + b[i][j];
        }
    }
}
