/* Program to perform a specified operation on all its command line args.
   First arg is the operation, '+' or '*', and the rest are the values.
   The program prints the result of operating on the listed values.
   This is Listing 13-7 in the text.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

double add(double, double);
double mul(double, double);
void process(double (*func)(double, double), int argc, char *argv[]);

main(int argc, char *argv[]) {
    double (*func)(double, double);
    /* Check the argument number */
    if (argc < 3) {
        fprintf(stderr, "To use, list the operation and at least ");
        fprintf(stderr, "one value:\n    calc +or* values...\n");
        exit(EXIT_FAILURE);
    }
    /* See whether + or * */
    if (strcmp(argv[1], "+") == 0) {            /* + */
        func = add;
    } else if (strcmp(argv[1], "*") == 0) {     /* * */
        func = mul;
    } else {
        fprintf(stderr, "First argument must be '+' or '*'\n");
        exit(EXIT_FAILURE);
    }
    /* Now process the other arguments */
    process(func, argc, argv);
    return 0;
}

double add(double a, double b) {
    return a + b;
}

double mul(double a, double b) {
    return a * b;
}

void process(double (*func)(double, double), int argc, char *argv[]) {
    /* Performs the specified func on all arguments from argv[2] onward,
       and prints the result.
    */
    double result1, result2;
    int i=2, count;  char dummy;

    count = sscanf(argv[2], "%lf%c", &result1, &dummy);
    /* argv[2] should contain a number & nothing else, so things are
       correct if the above call FAILS to assign to dummy or assigns '\0'.
    */

    for (i=3; i<argc && (count==1 || count == 2 && dummy == '\0'); i++) {
        count = sscanf(argv[i], "%lf%c", &result2, &dummy);
        result1 = func(result1, result2);  /* either add or mul */
    }

    if (count < 1 || count == 2 && dummy != '\0') {
        fprintf(stderr, "Error in argument %d\n", i - 1);
        exit(EXIT_FAILURE);
    }
    printf("%f\n", result1);
}
