/* Program to create a binary file of restaurant menu items from a list
   of items stored in a normal text file.

   Input:  File "anx17-02.asc": a list of menu items in an ASCII file,
           one item per line.  Format of each line is
             price in cents comma name comma description
   Output: Binary file "anx17-02.bin" containing one menu_item structure
           (see below) per line in the input file.
*/

typedef struct {
    char name[31];              /* item name */
    char description[51];       /* item description */
    int  price;                 /* price in cents */
} menu_item;

#include <stdio.h>
#include <stdlib.h>
#include "lst10-7.c"           /* for file_open function */

main() {
    FILE *infile, *outfile;
    menu_item item;
    int status, line=0;

    infile = file_open("anx17-02.asc", "r");    /* input file is text */
    outfile = file_open("anx17-02.bin", "wb");  /* output is binary */

    while (
        (status = fscanf(
            infile, "%d , %30[^,] , %50[^\n]", &item.price,
            item.name, item.description
        )) != EOF
    ) {
        line++;                                 /* The current line number */
        if (status != 3) {                      /* Error in input */
            fprintf(stderr, "Bad input on line %d\n", line);
            exit(EXIT_FAILURE);
        }
        if (fwrite(&item, sizeof item, 1, outfile) != 1) {
            fprintf(stderr, "Failure to write output record %d\n", line);
            exit(EXIT_FAILURE);
        }
    }

    fclose(infile);
    fclose(outfile);
    return 0;
}
