/* Include file for the 'array' Abstract Data Type: provides array
   facilities for floats, using malloc'ed storage.

   Provides expandable arrays.  All uninitialised elements are zero.
*/

typedef struct chunk {  /* Structure for an array chunk */
    float * elements;   /* Will be set to a suitable malloc'ed region */
    struct chunk *next;
} CHUNK;                /* the type name is CHUNK */

/* The following structure uses longs for total size and number of chunks,
   for maximum expandability.  The chunk_size is int, as the individual
   chunks should not be really huge, in order to save memory.
*/
typedef struct {
    CHUNK * chunk;      /* Pointer to the first chunk */
    long size;          /* number of elements so far in the array. */
    int chunk_size;     /* elements per chunk */
    long num_chunks;    /* no. of chunks allocated */
} ARRAY;

/**** array_create ****
 On entry: size is the number of elements initially needed in the array.
 On exit:  returns a pointer to an array, or NULL.
*/
ARRAY * array_create(int size);

/**** array_free ****
 On entry: arr is a pointer to an array.
 On exit:  The array has been freed.
*/
void array_free(ARRAY * arr);

/**** array ****
 On entry: arr is an ARRAY, n is the index of the required element.
 On exit:  Returns the value of the selected element.
*/
float array(ARRAY * arr, long n);

/**** array_set ****
 On entry: arr is an ARRAY, n is the positive index of an element.
 On exit:  Element n of arr has been assigned the value f.
           Returns 1 on failure (could not expand the array), 0 for success.
*/
int array_set(ARRAY * arr, long n, float f);
