/* Include file for the 'array' Abstract Data Type: provides array
   facilities for floats, using malloc'ed storage.

   Provides 'safe' arrays, that is, all memory accesses are checked for
   being within the array bounds.
*/

typedef struct {
    float * elements;   /* will be set to a suitable malloc'ed region */
    int size;           /* number of elements in the array. */
} ARRAY;

/**** array_create ****
 On entry: size is the number of elements needed in the array.
 On exit:  returns a pointer to an array, or NULL.
*/
ARRAY * array_create(int size);

/**** array_free ****
 On entry: arr is a pointer to an array.
 On exit:  The array has been freed.
*/
void array_free(ARRAY * arr);

/**** array ****
 On entry: arr is an ARRAY, n is the index of the required element.
 On exit:  Returns the value of the selected element.
*/
float array(ARRAY * arr, int n);

/**** array_set ****
 On entry: arr is an ARRAY, n is the index of an element.
 On exit:  Element n of arr has been assigned the value f.
*/
void array_set(ARRAY * arr, int n, float f);
