/* Towers of Hanoi: Solution to the well-known counter-shifting problem.
   Asks the user how many counters are on stack A, and then prints the
   instructions to shift them onto stack C, using stack B as intermediary.
*/

#include <stdio.h>

/* Hanoi: recursive function using the algorithm that shifting N counters
   from A to C is done by somehow shifting N-1 from A to B, then 1 from
   A to C, then N-1 from B to C.
*/

void Hanoi (int num_counters, char from, char using, char onto) {
    if (num_counters < 1) {
        return;                 /* no counters to shift */
    }
    /* Here, the number of counters is positive. */
    Hanoi(num_counters - 1, from, onto, using);
    printf("Move top counter from %c to %c.\n", from, onto);
    Hanoi(num_counters - 1, using, from, onto);
}

main () {
    int counters;
    printf("Towers of Hanoi: How many counters on stack A? ");
    scanf("%d", &counters);
    Hanoi(counters, 'A', 'B', 'C');
}
