/* Program to print a diagram of 2 to the n'th power, as an asterisk
   histogram. */

#include <stdio.h>

/* two_to_the: prints 2 to the n asterisks, for positive n.
   Uses the fact, recursively, that 2 to the n is 2 * (2 to the n-1).
*/

void two_to_the (int n) {
    if (n <= 0) {
        putchar('*');
    } else {
        two_to_the(n-1);
        two_to_the(n-1);
    }
}

/* histogram_to: Prints the histogram for i from 1 to n.  This is also
   written recursively.  It uses the recursive fact that the histogram
   from 1 to n is the histogram from 1 to n-1, plus a line containing
   2 to the n asterisks.
*/

void histogram_to (int n) {
    if (n >= 0) {
        histogram_to(n-1);
        two_to_the(n);
        putchar('\n');
    }
}

main () {
    /* Displays the histogram */
    histogram_to(6);
}
