/* Recursive and iterative factorial functions. */

/* Iterative: Develop from the observation that factorial(n) is the
   product of the integers from 1 to n.
*/

long faci (long n) {
    long i, fac;
    fac = 1;
    for (i=1; i<=n; i++) {
        fac *= i;
    }
    return fac;
}


/* Recursive: Develop from the definition: fac(0) == fac(1) ==1,
   and fac(n) = n * fac(n-1) for n > 1.
*/

long facr (long n) {
    if (n <= 1) {
        return 1L;
    } else {
        return n * facr(n-1);
    }
}

#include <stdio.h>

main () {
    /* Test both factorials by printing 0! to 6!. */
    long i;
    printf("   N   Iterative Factorial   Recursive Factorial\n");
    for (i=0; i<=6; i++) {
        printf("%4ld%14ld%22ld\n", i, faci(i), facr(i));
    }
}
