/* Program to copy floats from a file, stopping at end of file. */

#include <stdio.h>
#include <stdlib.h>

main () {
    FILE * fin;
    char fname[81];
    float f;
    int status;

    printf("Enter name of file to read: ");
    scanf("%80s", fname);

    fin = fopen(fname, "r");
    if (fin == NULL) {
        fprintf(stderr, "File cannot be opened.\n");
        exit(1);
    }

    printf("Numbers in the file are:\n");
    while ((status = fscanf(fin, "%f", &f)) >= 0) {   /* while not eof */
        if (status == 0) {   /* error? */
            fprintf(stderr, "Warning: input error, rest of input line is:\n");
            do {
                status = getc(fin);
                putchar(status);
            } while (status != '\n' && status >= 0);  /* until end of line or eof */
        } else {  /* OK */
            printf("%f\n", f);
        }
    }

    fclose(fin);
}
