/* Program to input normal text, and count letter frequencies.

Computes two totals per letter: occurrences overall, and occurrences at
the start of a word.  Prints a table of frequencies shown as percentages.
*/

#include <stdio.h>
#include <ctype.h>

/* The following line is needed if the computer does not use ASCII codes,
   as other systems have other characters mixed in among the letters.
*/

#define SIZE ('z' - 'a' + 1)

int totalletters=0,     /* overall letter total */
    totalwords=0;       /* number of words seen */

void process_letter (
    char latest, char previous, int lettercounts[SIZE],
    int initialcounts[SIZE]
);
void display_frequencies (int lettercounts[SIZE], int initialcounts[SIZE]);

main () {
    int lettercounts[SIZE],   /* occurrences of each letter [0]==A, [1]==B, etc. */
        initialcounts[SIZE];  /* occurrences of each letter at the start of words */
    char previous = '\n', latest;
    int i;

    /* Method: previous holds the 2nd-last char, latest holds the last one.
       previous lets one know when a word starts (i.e. previous is not
       alphabetic); it is initialised to '\n' so that an initial blank
       line terminates the program.
    */

    /* Now zero counts. */
    for (i=0; i<SIZE; i++) {
        lettercounts[i] = initialcounts[i] = 0;
    }

    printf("Enter text to be analysed (ending with a blank line):\n");
    latest = getchar();
    while (latest != '\n' || previous != '\n') {  /* Not both newlines */
        process_letter(latest, previous, lettercounts, initialcounts);
        previous = latest;
        latest = getchar();
    }

    display_frequencies(lettercounts, initialcounts);
}

void process_letter (
    char latest, char previous, int lettercounts[SIZE], int initialcounts[SIZE]
) {
    /* On entry: latest & previous are the two latest characters.
       On exit:  lettercounts, initialcounts, totalletters & totalwords
                 have been updated to include the latest character.
    */
    latest = tolower(latest);           /* Convert to lower case, if upper. */
    if (isalpha(latest)) {              /* alphabetic? */
        totalletters++;                 /* one more letter... */
        lettercounts[latest-'a']++;     /* Count letter individually. */
        if (!isalpha(previous)) {       /* letter starts a word? */
            totalwords++;               /* one more word... */
            initialcounts[latest-'a']++;/* Count letter individually. */
        }
    }
}

void display_frequencies (int lettercounts[SIZE], int initialcounts[SIZE]) {
    /* Displays table of percentage frequencies, or a message if no letters
       were encountered.
    */
    int which;
    if (totalletters == 0) {
        printf("No letters were encountered in the input text.\n");
        return;
    }
    printf("There were %d letters in %d words.\n\n", totalletters, totalwords);
    printf("Letter     Overall Frequency     Frequency Starting a Word\n");
    printf("======     =================     =========================\n");
    for (which=0; which <SIZE; which++) {
        if (isalpha(which+'a')) { /* This conditional not needed for ASCII */
            printf(
                "   %c%18.2f%26.2f\n", which+'a',
                100.0 * lettercounts[which] / totalletters,
                100.0 * initialcounts[which] / totalwords
            );
        }
    }
}
