/* Program to sort a list of up to 20 floats. */

#define MAXNUM (20)
#include <stdio.h>

void bubblesort (float values[MAXNUM], int num);

main () {
    int i, num;
    float values[MAXNUM];

    /* Find out how many numbers: */
    do {
        printf("How many numbers will be sorted (max %d)? ", MAXNUM);
        scanf("%d", &num);
    } while (num >MAXNUM);      /* Check for sanity */

    /* Input numbers */
    for (i=0; i<num; i++) {
        scanf("%f", &values[i]);
    }

    bubblesort(values, num);

    /* Output numbers */
    printf("Sorted numbers are:\n");
    for (i=0; i<num; i++) {
        printf("%f ", values[i]);
    }
    printf("\n");
}

void bubblesort (float values[MAXNUM], int num) {
    /* Performs num-1 sorting passes, each of which will place the
    largest remeining element at the last position.  Thus each pass
    can stop one element sooner than the previous pass. */

    int pass, element, num_passes = num - 1, upper_limit = num;

    for (pass = 0; pass < num_passes; pass++) {
        for (element = 1 /*NOT zero!!*/ ; element < upper_limit; element++) {
            if (values[element] < values[element-1]) {
                /* Swap elements */
                float temp;
                temp = values[element];
                values[element] = values[element - 1];
                values[element - 1] = temp;
            }
        }
        upper_limit--;  /* Reduce range by one for the next pass. */
    }
}
