/* impl(A,B): returns true (1) unless A is true and B is false.

Here are a few variations on the theme.  You will be able to work out
why each one works if you remember that in C, all non-zero values count
as true.  Nevertheless, the function always returns either 0 or 1. */

#define true (1)
#define false (0)

int impl_1(int A, int B) {
    if (A && ! B) {
        return false;
    } else {
        return true;
    }
}

int impl_2(int A, int B) {
    return ! (A && ! B);
}

int impl_3(int A, int B) {
    return !A || B;
}

int impl_4(int A, int B) {
    if (B) {
        return true;
    } else {
        return !A;
    }
}

/* Test main function.  Calls all four variants; should (naturally) get
the same results from all four.  */

#include <stdio.h>

main () {
    int A, B;
    printf(
        "A B impl_1 impl_2 impl_3 impl_4\n"
        "= = ====== ====== ====== ======\n"
    );
    for (A=0; A<=1; A++) {
        for (B=0; B<=1; B++) {
            printf(
                "%d %d%5d%7d%7d%7d\n", A, B, impl_1(A, B), impl_2(A, B),
                impl_3(A, B), impl_4(A, B)
            );
        }
    }
    printf("\nAll the above results should be 1 except where A==1 & B==0\n");
}
