/* Program to find average light intensity.
   Inputs intensity values, ending with a zero value.
   Alerts user if any value differs from the previous one by more than .1,
   allowing the user to accept the value, or discard either the latest or
   second-latest value.
*/

#include <stdio.h>
#include <math.h>

float intensity, previous_intensity, sum_intensity;
int number_of_readings;

void process_reading (void);

main () {
    /* The logic is tricky because we must maintain the previous value
       at all times in case it is cancelled due to error.  There are two
       reasonable plans: either add it in as we go, and subtract it out
       if necessary, or keep it separate until the following iteration,
       at which time it is only added into the total if it is not rejected.
       We shall use the former plan.  The plan will therefore be:

       Get first reading into previous_intensity, assign to sum_intensity.
       Set number_of readings to 1.

       If previous_intensity not zero,
           Get next reading,
           while not zero:
               process reading (a function: does all calculations),
               get next reading.
           Compute and print average.

       Note: if the first number is zero, there is no average, as one cannot
       average no numbers, so the averaging step is inside the outer 'if'.
    */

    printf("Enter light intensity (0 to finish): ");
    scanf("%f", &previous_intensity);   /* First reading. */
    sum_intensity = previous_intensity; /* After one reading, total is that
                                           first reading. */
    number_of_readings = 1;             /* counting the first reading. */

    if (previous_intensity != 0.) {
        printf("Enter light intensity (0 to finish): ");
        scanf("%f", &intensity);        /* Get next reading. */

        while (intensity != 0.) {
            process_reading();

            printf("Enter light intensity (0 to finish): ");
            scanf("%f", &intensity);    /* Get next reading. */
        }
        printf("Average intensity: %f\n", sum_intensity / number_of_readings);
    }
}

/*** process-reading ***
 On entry: previous_intensity contains the 2nd-last value, intensity
           contains the last one.  sum_intensity is the sum of all values
           up to and including the 2nd-last.
 On exit:  previous_intensity contains the last value.  sum_intensity is the
           sum of all values up to and including the last.  If the last
           differed from the 2nd-last by more than 0.1, the user was allowed
           to alter either or neither value.  number_of_readings is incremented.
*/

void process_reading (void) {
    /* Method: handle as if all is OK first, then if an error is detected,
       undo the damage.  Subtract out the wrong value, and add in its
       corrected value.
    */
    int which_action;

    /* handle correct values */
    sum_intensity += intensity;
    number_of_readings++;

    /* Check and fix wrong values */
    if (fabs(previous_intensity - intensity) > 0.1) {  /* wrong? */
        printf("Warning: value differs by more than 0.1 from previous value.\n");
        printf("Enter 0 to ignore, 1 to alter previous, 2 to alter latest: ");
        scanf("%d", &which_action);

        if (which_action == 1) {
            sum_intensity -= previous_intensity;    /* Undo wrong value */
            printf("Enter replacement previous value: ");
            scanf("%f", &previous_intensity);       /* Get fixed value */
            sum_intensity += previous_intensity;    /* Fix total */
        } else if (which_action == 2) {
            sum_intensity -= intensity;             /* Undo wrong value */
            printf("Enter replacement value: ");
            scanf("%f", &intensity);                /* Get fixed value */
            sum_intensity += intensity;             /* Fix total */
        }
    }

    /* Now turn latest into 2nd-latest, in preparation for next iteration. */
    previous_intensity = intensity;
}
