/* Bank account interest computation.
   Inputs initial balance, number of years, interest rate, and name and
   account number.  Outputs table showing balance and interest per year.
*/

#include <stdio.h>

float start_balance, interest_rate;
int number_of_years, year_no;       /* total no. of years, year counter */
char account_name[60];
int account_number;

void input_details(void);
void process_one_year(void);
void print_headings(void);

main () {
    input_details();
    print_headings();
    interest_rate = interest_rate/100; /* Convert from % to the fraction
                                          by which the capital grows per
                                          year, e.g. from 10% to 0.1 */
    for (year_no = 1; year_no <= number_of_years; year_no++) {
        process_one_year();
    }
}

void input_details (void) {
    /* Accepts all input data from user. */
    printf("Account name? ");
    gets(account_name);
    printf("Account number? ");
    scanf("%d", &account_number);
    printf("Initial balance? ");
    scanf("%f", &start_balance);
    printf("Interest rate (%)? ");
    scanf("%f", &interest_rate);
    printf("Number of years? ");
    scanf("%d", &number_of_years);
}

void print_headings (void) {
    printf("\n\tAccount Interest Projection\n\nName:\t\t%s\n", account_name);
    printf("Account_number:\t%d\n", account_number);
    printf("Interest rate:\t%.2f%%\n\n", interest_rate);
    printf(
        " Year    Starting   Interest     End\n"
        "Number   Balance     Earned    Balance\n"
        "======   ========   ========   ========\n"
    );
}

void process_one_year (void) {
    /* Computes the interest paid and the final balance for the year, prints
    a row of the table, and updates the figures ready for the next year. */
    float dollars_interest;
    float end_balance;                  /* at the end of the year */

    /* Compute interest and balance */
    dollars_interest = start_balance * interest_rate;
    end_balance = start_balance + dollars_interest;

    /* Generate table row */
    printf(
        "%5d  %10.2f %10.2f %10.2f\n",
        year_no, start_balance, dollars_interest, end_balance
    );

    /* Update figures ready for the next year */
    start_balance = end_balance;
}
